/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetupsPlugin;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class InventorySetupsCycleButton<T>
extends JLabel {
    private final InventorySetupsPlugin plugin;
    private final List<T> states;
    private final List<ImageIcon> icons;
    private final List<ImageIcon> hoverIcons;
    private final List<String> tooltips;
    private int currentIndex;
    private MouseAdapter runnableAdapter;

    InventorySetupsCycleButton(InventorySetupsPlugin plugin, List<T> states, List<ImageIcon> icons, List<ImageIcon> hoverIcons, List<String> tooltips) {
        this(plugin, states, icons, hoverIcons, tooltips, () -> {});
    }

    InventorySetupsCycleButton(InventorySetupsPlugin plugin, List<T> states, List<ImageIcon> icons, List<ImageIcon> hoverIcons, List<String> tooltips, Runnable runnable) {
        this.plugin = plugin;
        this.states = states;
        this.icons = icons;
        this.hoverIcons = hoverIcons;
        this.tooltips = tooltips;
        this.currentIndex = 0;
        assert (this.states.size() == this.icons.size());
        assert (this.icons.size() == this.hoverIcons.size());
        assert (this.hoverIcons.size() == this.tooltips.size());
        this.setRunnable(runnable);
    }

    public void setCurrentState(T state) {
        for (int i = 0; i < this.states.size(); ++i) {
            if (this.states.get(i) != state) continue;
            this.currentIndex = i;
            break;
        }
        this.setIcon(this.icons.get(this.currentIndex));
        this.setToolTipText(this.tooltips.get(this.currentIndex));
    }

    public void setRunnable(final Runnable r) {
        this.removeMouseListener(this.runnableAdapter);
        this.runnableAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    InventorySetupsCycleButton.this.currentIndex = (InventorySetupsCycleButton.this.currentIndex + 1) % InventorySetupsCycleButton.this.states.size();
                    r.run();
                    InventorySetupsCycleButton.this.setToolTipText(InventorySetupsCycleButton.this.tooltips.get(InventorySetupsCycleButton.this.currentIndex));
                    InventorySetupsCycleButton.this.setIcon(InventorySetupsCycleButton.this.icons.get(InventorySetupsCycleButton.this.currentIndex));
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                InventorySetupsCycleButton.this.setIcon(InventorySetupsCycleButton.this.hoverIcons.get(InventorySetupsCycleButton.this.currentIndex));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                InventorySetupsCycleButton.this.setIcon(InventorySetupsCycleButton.this.icons.get(InventorySetupsCycleButton.this.currentIndex));
            }
        };
        this.addMouseListener(this.runnableAdapter);
    }

    public T getCurrentState() {
        return this.states.get(this.currentIndex);
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }
}

