/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupsItem;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsStackCompareID;
import inventorysetups.InventorySetupsVariationMapping;
import inventorysetups.ui.InventorySetupsSlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.AsyncBufferedImage;

public abstract class InventorySetupsContainerPanel
extends JPanel {
    protected ItemManager itemManager;
    protected boolean isHighlighted;
    protected final InventorySetupsPlugin plugin;
    private final JPanel containerSlotsPanel;

    InventorySetupsContainerPanel(ItemManager itemManager, InventorySetupsPlugin plugin, String captionText) {
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.isHighlighted = false;
        JPanel containerPanel = new JPanel();
        this.containerSlotsPanel = new JPanel();
        this.setupContainerPanel(this.containerSlotsPanel);
        JLabel caption = new JLabel(captionText);
        caption.setHorizontalAlignment(0);
        caption.setVerticalAlignment(0);
        JPanel captionPanel = new JPanel();
        captionPanel.add(caption);
        containerPanel.setLayout(new BorderLayout());
        containerPanel.add((Component)captionPanel, "North");
        containerPanel.add((Component)this.containerSlotsPanel, "Center");
        this.add(containerPanel);
    }

    protected void addUpdateFromContainerMouseListenerToSlot(InventorySetupsSlot slot) {
        String updateContainerFrom = this.getContainerString(slot);
        JMenuItem updateFromContainer = new JMenuItem("Update Slot from " + updateContainerFrom);
        slot.getRightClickMenu().add(updateFromContainer);
        updateFromContainer.addActionListener(e -> this.plugin.updateSlotFromContainer(slot, false));
    }

    protected void addUpdateFromContainerToAllInstancesMouseListenerToSlot(InventorySetupsSlot slot) {
        String updateContainerFrom = this.getContainerString(slot);
        JMenuItem updateFromContainer = new JMenuItem("Update ALL Slots from " + updateContainerFrom);
        slot.getShiftRightClickMenu().add(updateFromContainer);
        updateFromContainer.addActionListener(e -> {
            int confirm = JOptionPane.showConfirmDialog(this, "Do you want to update ALL setups which have this item to the new item?", "Update ALL Setups", 2);
            if (confirm == 0) {
                this.plugin.updateSlotFromContainer(slot, true);
            }
        });
    }

    protected void addUpdateFromSearchMouseListenerToSlot(InventorySetupsSlot slot, boolean allowStackable) {
        JMenuItem updateFromSearch = new JMenuItem("Update Slot from Search");
        slot.getRightClickMenu().add(updateFromSearch);
        updateFromSearch.addActionListener(e -> this.plugin.updateSlotFromSearch(slot, allowStackable, false));
    }

    protected void addUpdateFromSearchToAllInstancesMouseListenerToSlot(InventorySetupsSlot slot, boolean allowStackable) {
        JMenuItem updateFromContainer = new JMenuItem("Update ALL Slots from Search");
        slot.getShiftRightClickMenu().add(updateFromContainer);
        updateFromContainer.addActionListener(e -> {
            int confirm = JOptionPane.showConfirmDialog(this, "Do you want to update ALL setups which have this item to the new item?", "Update ALL Setups", 2);
            if (confirm == 0) {
                this.plugin.updateSlotFromSearch(slot, allowStackable, true);
            }
        });
    }

    protected void addRemoveMouseListenerToSlot(InventorySetupsSlot slot) {
        JMenuItem removeSlot = new JMenuItem("Remove Item from Slot");
        slot.getRightClickMenu().add(removeSlot);
        removeSlot.addActionListener(e -> this.plugin.removeItemFromSlot(slot));
    }

    protected void addFuzzyMouseListenerToSlot(InventorySetupsSlot slot) {
        JMenuItem makeSlotFuzzy = new JMenuItem("Toggle Fuzzy");
        slot.getRightClickMenu().add(makeSlotFuzzy);
        makeSlotFuzzy.addActionListener(e -> this.plugin.toggleFuzzyOnSlot(slot));
    }

    protected void addStackMouseListenerToSlot(InventorySetupsSlot slot) {
        JMenuItem stackIndicatorNone = new JMenuItem("Stack Difference None");
        stackIndicatorNone.addActionListener(e -> this.plugin.setStackCompareOnSlot(slot, InventorySetupsStackCompareID.None));
        JMenuItem stackIndicatorStandard = new JMenuItem("Stack Difference Standard");
        stackIndicatorStandard.addActionListener(e -> this.plugin.setStackCompareOnSlot(slot, InventorySetupsStackCompareID.Standard));
        JMenuItem stackIndicatorGreaterThan = new JMenuItem("Stack Difference Greater Than");
        stackIndicatorGreaterThan.addActionListener(e -> this.plugin.setStackCompareOnSlot(slot, InventorySetupsStackCompareID.Greater_Than));
        JMenuItem stackIndicatorLessThan = new JMenuItem("Stack Difference Less Than");
        stackIndicatorLessThan.addActionListener(e -> this.plugin.setStackCompareOnSlot(slot, InventorySetupsStackCompareID.Less_Than));
        JMenu stackIndicatorMainMenu = new JMenu("Stack Indicator");
        stackIndicatorMainMenu.add(stackIndicatorNone);
        stackIndicatorMainMenu.add(stackIndicatorStandard);
        stackIndicatorMainMenu.add(stackIndicatorLessThan);
        stackIndicatorMainMenu.add(stackIndicatorGreaterThan);
        slot.getRightClickMenu().add(stackIndicatorMainMenu);
    }

    private String getContainerString(InventorySetupsSlot slot) {
        String updateContainerFrom = "";
        switch (slot.getSlotID()) {
            case INVENTORY: {
                updateContainerFrom = "Inventory";
                break;
            }
            case EQUIPMENT: {
                updateContainerFrom = "Equipment";
                break;
            }
            case RUNE_POUCH: {
                updateContainerFrom = "Rune Pouch";
                break;
            }
            case BOLT_POUCH: {
                updateContainerFrom = "Bolt Pouch";
                break;
            }
            default: {
                assert (false) : "Wrong slot ID!";
                break;
            }
        }
        return updateContainerFrom;
    }

    protected void setSlotImageAndText(InventorySetupsSlot containerSlot, InventorySetup setup, InventorySetupsItem item) {
        containerSlot.setParentSetup(setup);
        if (item.getId() == -1) {
            containerSlot.setImageLabel(null, null, item.isFuzzy(), item.getStackCompare());
            return;
        }
        int itemId = item.getId();
        int quantity = item.getQuantity();
        String itemName = item.getName();
        AsyncBufferedImage itemImg = this.itemManager.getImage(itemId, quantity, quantity > 1);
        Object toolTip = itemName;
        if (quantity > 1) {
            toolTip = (String)toolTip + " (" + quantity + ")";
        }
        containerSlot.setImageLabel((String)toolTip, (BufferedImage)itemImg, item.isFuzzy(), item.getStackCompare());
    }

    protected void highlightSlot(InventorySetup setup, InventorySetupsItem savedItemFromSetup, InventorySetupsItem currentItemFromContainer, InventorySetupsSlot containerSlot) {
        if (this.shouldHighlightSlotBasedOnStack(savedItemFromSetup.getStackCompare(), savedItemFromSetup.getQuantity(), currentItemFromContainer.getQuantity())) {
            containerSlot.setBackground(setup.getHighlightColor());
            return;
        }
        int currentItemId = currentItemFromContainer.getId();
        int savedItemId = savedItemFromSetup.getId();
        if (savedItemFromSetup.isFuzzy()) {
            currentItemId = InventorySetupsVariationMapping.map(currentItemId);
            savedItemId = InventorySetupsVariationMapping.map(savedItemId);
        }
        if (currentItemId != savedItemId) {
            containerSlot.setBackground(setup.getHighlightColor());
            return;
        }
        containerSlot.setBackground(ColorScheme.DARKER_GRAY_COLOR);
    }

    protected boolean shouldHighlightSlotBasedOnStack(InventorySetupsStackCompareID stackCompareType, Integer savedItemQty, Integer currItemQty) {
        int stackCompareResult = Integer.compare(currItemQty, savedItemQty);
        return stackCompareType == InventorySetupsStackCompareID.Less_Than && stackCompareResult < 0 || stackCompareType == InventorySetupsStackCompareID.Greater_Than && stackCompareResult > 0 || stackCompareType == InventorySetupsStackCompareID.Standard && stackCompareResult != 0;
    }

    public abstract boolean isStackCompareForSlotAllowed(int var1);

    public abstract void setupContainerPanel(JPanel var1);

    public abstract void highlightSlots(List<InventorySetupsItem> var1, InventorySetup var2);

    public abstract void updatePanelWithSetupInformation(InventorySetup var1);

    public abstract void resetSlotColors();

    protected JPanel getContainerSlotsPanel() {
        return this.containerSlotsPanel;
    }
}

