/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupsItem;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsSlotID;
import inventorysetups.ui.InventorySetupsContainerPanel;
import inventorysetups.ui.InventorySetupsSlot;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;

public abstract class InventorySetupsAmmunitionPanel
extends InventorySetupsContainerPanel {
    private List<InventorySetupsSlot> ammoSlots;
    private GridLayout gridLayout;
    private List<Boolean> ammoSlotsAddedToPanel;

    InventorySetupsAmmunitionPanel(ItemManager itemManager, InventorySetupsPlugin plugin, String captionText) {
        super(itemManager, plugin, captionText);
    }

    @Override
    public boolean isStackCompareForSlotAllowed(int id) {
        return true;
    }

    @Override
    public void setupContainerPanel(JPanel containerSlotsPanel) {
        this.ammoSlots = new ArrayList<InventorySetupsSlot>();
        this.ammoSlotsAddedToPanel = new ArrayList<Boolean>();
        for (int i = 0; i < this.getSlotsCount(); ++i) {
            this.ammoSlots.add(new InventorySetupsSlot(ColorScheme.DARKER_GRAY_COLOR, this.getSlotId(), i));
            this.ammoSlotsAddedToPanel.add(Boolean.TRUE);
        }
        this.gridLayout = new GridLayout(1, 4, 1, 1);
        containerSlotsPanel.setLayout(this.gridLayout);
        for (InventorySetupsSlot slot : this.ammoSlots) {
            containerSlotsPanel.add(slot);
            super.addStackMouseListenerToSlot(slot);
            super.addUpdateFromContainerMouseListenerToSlot(slot);
            super.addUpdateFromSearchMouseListenerToSlot(slot, true);
            super.addRemoveMouseListenerToSlot(slot);
        }
    }

    protected abstract InventorySetupsSlotID getSlotId();

    protected abstract int getSlotsCount();

    @Override
    public void highlightSlots(List<InventorySetupsItem> currentContainer, InventorySetup inventorySetup) {
        assert (this.getContainer(inventorySetup) != null) : "Container is null.";
        int slotsCount = this.getSlotsCount();
        assert (slotsCount == this.getSlotsCount()) : "Incorrect size";
        this.isHighlighted = true;
        List<InventorySetupsItem> ammoContainer = this.getContainer(inventorySetup);
        List<InventorySetupsItem> currentContainerReference = currentContainer;
        if (currentContainer.size() < ammoContainer.size()) {
            ArrayList<InventorySetupsItem> currentContainerCopy = new ArrayList<InventorySetupsItem>(currentContainer);
            for (int i = currentContainerCopy.size(); i < ammoContainer.size(); ++i) {
                currentContainerCopy.add(InventorySetupsItem.getDummyItem());
            }
            currentContainerReference = currentContainerCopy;
        }
        for (int i = 0; i < ammoContainer.size(); ++i) {
            boolean shouldHighlightSlot = false;
            boolean foundAmmo = false;
            int currentContainerIndex = -1;
            for (int j = 0; j < currentContainerReference.size(); ++j) {
                if (ammoContainer.get(i).getId() != currentContainerReference.get(j).getId()) continue;
                foundAmmo = true;
                currentContainerIndex = j;
                break;
            }
            if (foundAmmo) {
                int savedQuantity = ammoContainer.get(i).getQuantity();
                int currentQuantity = currentContainerReference.get(currentContainerIndex).getQuantity();
                if (this.shouldHighlightSlotBasedOnStack(ammoContainer.get(i).getStackCompare(), savedQuantity, currentQuantity)) {
                    shouldHighlightSlot = true;
                }
            } else {
                shouldHighlightSlot = true;
            }
            if (shouldHighlightSlot) {
                this.ammoSlots.get(i).setBackground(inventorySetup.getHighlightColor());
                continue;
            }
            this.ammoSlots.get(i).setBackground(ColorScheme.DARKER_GRAY_COLOR);
        }
    }

    protected abstract List<InventorySetupsItem> getContainer(InventorySetup var1);

    @Override
    public void updatePanelWithSetupInformation(InventorySetup setup) {
        List<InventorySetupsItem> container = this.getContainer(setup);
        if (container != null) {
            this.gridLayout.setColumns(container.size());
            for (int i = 0; i < this.ammoSlots.size(); ++i) {
                if (i >= container.size()) {
                    if (!this.ammoSlotsAddedToPanel.get(i).booleanValue()) continue;
                    this.ammoSlotsAddedToPanel.set(i, Boolean.FALSE);
                    this.getContainerSlotsPanel().remove(this.ammoSlots.get(i));
                    continue;
                }
                if (!this.ammoSlotsAddedToPanel.get(i).booleanValue()) {
                    this.ammoSlotsAddedToPanel.set(i, Boolean.TRUE);
                    this.getContainerSlotsPanel().add(this.ammoSlots.get(i));
                }
                super.setSlotImageAndText(this.ammoSlots.get(i), setup, container.get(i));
            }
        } else {
            for (int i = 0; i < this.ammoSlots.size(); ++i) {
                super.setSlotImageAndText(this.ammoSlots.get(i), setup, InventorySetupsItem.getDummyItem());
            }
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void resetSlotColors() {
        if (!this.isHighlighted) {
            return;
        }
        for (InventorySetupsSlot slot : this.ammoSlots) {
            slot.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        }
        this.isHighlighted = false;
    }

    public void highlightAllSlots(InventorySetup setup) {
        for (InventorySetupsSlot slot : this.ammoSlots) {
            slot.setBackground(setup.getHighlightColor());
        }
        this.isHighlighted = true;
    }
}

