/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.ui;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupsItem;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsSlotID;
import inventorysetups.ui.InventorySetupsContainerPanel;
import inventorysetups.ui.InventorySetupsSlot;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;

public class InventorySetupsAdditionalItemsPanel
extends InventorySetupsContainerPanel {
    private final List<InventorySetupsSlot> additionalFilteredSlots = new ArrayList<InventorySetupsSlot>();

    InventorySetupsAdditionalItemsPanel(ItemManager itemManager, InventorySetupsPlugin plugin) {
        super(itemManager, plugin, "Additional Filtered Items");
    }

    @Override
    public void setupContainerPanel(JPanel containerSlotsPanel) {
        containerSlotsPanel.setLayout(new GridLayout(0, 4, 1, 1));
    }

    @Override
    public void highlightSlots(List<InventorySetupsItem> currContainer, InventorySetup inventorySetup) {
    }

    @Override
    public void updatePanelWithSetupInformation(InventorySetup setup) {
        Map<Integer, InventorySetupsItem> setupAdditionalItems = setup.getAdditionalFilteredItems();
        JPanel containerSlotsPanel = this.getContainerSlotsPanel();
        int totalNumberOfSlots = setupAdditionalItems.size();
        int remainder = totalNumberOfSlots % 4;
        if (totalNumberOfSlots % 4 != 0) {
            totalNumberOfSlots = totalNumberOfSlots + 4 - remainder;
        }
        if (totalNumberOfSlots == setupAdditionalItems.size()) {
            totalNumberOfSlots += 4;
        }
        int totalNumberOfSlotsLambda = totalNumberOfSlots;
        SwingUtilities.invokeLater(() -> {
            int i;
            for (i = this.additionalFilteredSlots.size(); i < totalNumberOfSlotsLambda; ++i) {
                InventorySetupsSlot newSlot = new InventorySetupsSlot(ColorScheme.DARKER_GRAY_COLOR, InventorySetupsSlotID.ADDITIONAL_ITEMS, i);
                super.addFuzzyMouseListenerToSlot(newSlot);
                super.addUpdateFromSearchMouseListenerToSlot(newSlot, false);
                super.addRemoveMouseListenerToSlot(newSlot);
                this.additionalFilteredSlots.add(newSlot);
            }
            for (i = containerSlotsPanel.getComponentCount() - 1; i >= totalNumberOfSlotsLambda; --i) {
                containerSlotsPanel.remove(i);
            }
            for (i = totalNumberOfSlotsLambda - 1; i >= setupAdditionalItems.size(); --i) {
                this.setSlotImageAndText(this.additionalFilteredSlots.get(i), setup, InventorySetupsItem.getDummyItem());
            }
            for (i = containerSlotsPanel.getComponentCount(); i < totalNumberOfSlotsLambda; ++i) {
                containerSlotsPanel.add(this.additionalFilteredSlots.get(i));
            }
            int j = 0;
            for (Integer itemId : setupAdditionalItems.keySet()) {
                this.setSlotImageAndText(this.additionalFilteredSlots.get(j), setup, (InventorySetupsItem)setupAdditionalItems.get(itemId));
                ++j;
            }
            this.validate();
            this.repaint();
        });
    }

    @Override
    public void resetSlotColors() {
    }

    @Override
    public boolean isStackCompareForSlotAllowed(int id) {
        return false;
    }
}

