/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups.serialization;

import inventorysetups.InventorySetupsItem;
import inventorysetups.InventorySetupsStackCompareID;
import javax.annotation.Nullable;

public final class InventorySetupItemSerializable {
    private final int id;
    @Nullable
    private final Integer q;
    @Nullable
    private final Boolean f;
    @Nullable
    private final InventorySetupsStackCompareID sc;

    public static InventorySetupItemSerializable convertFromInventorySetupItem(InventorySetupsItem item) {
        if (item == null || InventorySetupsItem.itemIsDummy(item)) {
            return null;
        }
        Integer quantity = item.getQuantity() != 1 ? Integer.valueOf(item.getQuantity()) : null;
        Boolean fuzzy = item.isFuzzy() ? Boolean.TRUE : null;
        InventorySetupsStackCompareID sc = item.getStackCompare() != InventorySetupsStackCompareID.None ? item.getStackCompare() : null;
        return new InventorySetupItemSerializable(item.getId(), quantity, fuzzy, sc);
    }

    public static InventorySetupsItem convertToInventorySetupItem(InventorySetupItemSerializable is) {
        if (is == null) {
            return InventorySetupsItem.getDummyItem();
        }
        int id = is.getId();
        String name = "";
        int quantity = is.getQ() != null ? is.getQ() : 1;
        boolean fuzzy = is.getF() != null ? is.getF() : Boolean.FALSE;
        InventorySetupsStackCompareID sc = is.getSc() != null ? is.getSc() : InventorySetupsStackCompareID.None;
        return new InventorySetupsItem(id, name, quantity, fuzzy, sc);
    }

    public InventorySetupItemSerializable(int id, @Nullable Integer q, @Nullable Boolean f, @Nullable InventorySetupsStackCompareID sc) {
        this.id = id;
        this.q = q;
        this.f = f;
        this.sc = sc;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public Integer getQ() {
        return this.q;
    }

    @Nullable
    public Boolean getF() {
        return this.f;
    }

    @Nullable
    public InventorySetupsStackCompareID getSc() {
        return this.sc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventorySetupItemSerializable)) {
            return false;
        }
        InventorySetupItemSerializable other = (InventorySetupItemSerializable)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        Integer this$q = this.getQ();
        Integer other$q = other.getQ();
        if (this$q == null ? other$q != null : !((Object)this$q).equals(other$q)) {
            return false;
        }
        Boolean this$f = this.getF();
        Boolean other$f = other.getF();
        if (this$f == null ? other$f != null : !((Object)this$f).equals(other$f)) {
            return false;
        }
        InventorySetupsStackCompareID this$sc = this.getSc();
        InventorySetupsStackCompareID other$sc = other.getSc();
        return !(this$sc == null ? other$sc != null : !((Object)((Object)this$sc)).equals((Object)other$sc));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        Integer $q = this.getQ();
        result = result * 59 + ($q == null ? 43 : ((Object)$q).hashCode());
        Boolean $f = this.getF();
        result = result * 59 + ($f == null ? 43 : ((Object)$f).hashCode());
        InventorySetupsStackCompareID $sc = this.getSc();
        result = result * 59 + ($sc == null ? 43 : ((Object)((Object)$sc)).hashCode());
        return result;
    }

    public String toString() {
        return "InventorySetupItemSerializable(id=" + this.getId() + ", q=" + this.getQ() + ", f=" + this.getF() + ", sc=" + this.getSc() + ")";
    }
}

