/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import inventorysetups.Bolts;
import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupUtilities;
import inventorysetups.InventorySetupsBankSearch;
import inventorysetups.InventorySetupsCache;
import inventorysetups.InventorySetupsConfig;
import inventorysetups.InventorySetupsFilteringModeID;
import inventorysetups.InventorySetupsItem;
import inventorysetups.InventorySetupsPersistentDataManager;
import inventorysetups.InventorySetupsRunePouchType;
import inventorysetups.InventorySetupsSection;
import inventorysetups.InventorySetupsSlotID;
import inventorysetups.InventorySetupsSortingID;
import inventorysetups.InventorySetupsStackCompareID;
import inventorysetups.InventorySetupsVariationMapping;
import inventorysetups.ui.InventorySetupsBoltPouchPanel;
import inventorysetups.ui.InventorySetupsPluginPanel;
import inventorysetups.ui.InventorySetupsRunePouchPanel;
import inventorysetups.ui.InventorySetupsSlot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.ProfileChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.chatbox.ChatboxItemSearch;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.game.chatbox.ChatboxTextInput;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Inventory Setups", description="Save gear setups for specific activities")
public class InventorySetupsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(InventorySetupsPlugin.class);
    public static final String CONFIG_GROUP = "inventorysetups";
    public static final String CONFIG_KEY_SECTION_MODE = "sectionMode";
    public static final String CONFIG_KEY_PANEL_VIEW = "panelView";
    public static final String CONFIG_KEY_SORTING_MODE = "sortingMode";
    public static final String CONFIG_KEY_HIDE_BUTTON = "hideHelpButton";
    public static final String CONFIG_KEY_VERSION_STR = "version";
    public static final String CONFIG_KEY_UNASSIGNED_MAXIMIZED = "unassignedMaximized";
    public static final String CONFIG_KEY_MANUAL_BANK_FILTER = "manualBankFilter";
    public static final String CONFIG_KEY_PERSIST_HOTKEYS = "persistHotKeysOutsideBank";
    public static final String TUTORIAL_LINK = "https://github.com/dillydill123/inventory-setups#inventory-setups";
    public static final String SUGGESTION_LINK = "https://github.com/dillydill123/inventory-setups/issues";
    public static final int NUM_INVENTORY_ITEMS = 28;
    public static final int NUM_EQUIPMENT_ITEMS = 14;
    public static final int MAX_SETUP_NAME_LENGTH = 50;
    private static final String OPEN_SECTION_MENU_ENTRY = "Open Section";
    private static final String OPEN_SETUP_MENU_ENTRY = "Open setup";
    private static final String RETURN_TO_OVERVIEW_ENTRY = "Close current setup";
    private static final String FILTER_ADD_ITEMS_ENTRY = "Filter additional items";
    private static final String FILTER_EQUIPMENT_ENTRY = "Filter equipment";
    private static final String FILTER_INVENTORY_ENTRY = "Filter inventory";
    private static final String FILTER_ALL_ENTRY = "Filter all";
    private static final String ADD_TO_ADDITIONAL_ENTRY = "Add to Additional Filtered Items";
    private static final String UNASSIGNED_SECTION_SETUP_MENU_ENTRY = "Unassigned";
    private static final int SPELLBOOK_VARBIT = 4070;
    private static final int ITEMS_PER_ROW = 8;
    private static final int ITEM_VERTICAL_SPACING = 36;
    private static final int ITEM_HORIZONTAL_SPACING = 48;
    private static final int ITEM_ROW_START = 51;
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private InventorySetupsConfig config;
    @Inject
    private Gson gson;
    @Inject
    private ColorPickerManager colorPickerManager;
    private InventorySetupsPluginPanel panel;
    private List<InventorySetup> inventorySetups;
    private List<InventorySetupsSection> sections;
    private InventorySetupsCache cache;
    private NavigationButton navButton;
    @Inject
    private InventorySetupsBankSearch bankSearch;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ChatboxItemSearch itemSearch;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    private ChatboxTextInput searchInput;
    private boolean internalFilteringIsAllowed;
    private String currentVersion;
    private InventorySetupsPersistentDataManager dataManager;
    private InventorySetupsFilteringModeID bankFilteringMode;
    private final HotkeyListener returnToSetupsHotkeyListener = new HotkeyListener(() -> this.config.returnToSetupsHotkey()){

        public void hotkeyPressed() {
            InventorySetupsPlugin.this.panel.returnToOverviewPanel(false);
        }
    };
    private final HotkeyListener filterBankHotkeyListener = new HotkeyListener(() -> this.config.filterBankHotkey()){

        public void hotkeyPressed() {
            InventorySetupsPlugin.this.bankFilteringMode = InventorySetupsFilteringModeID.ALL;
            InventorySetupsPlugin.this.triggerBankSearchFromHotKey();
        }
    };
    private final HotkeyListener filterInventoryHotkeyListener = new HotkeyListener(() -> this.config.filterInventoryHotkey()){

        public void hotkeyPressed() {
            InventorySetupsPlugin.this.bankFilteringMode = InventorySetupsFilteringModeID.INVENTORY;
            InventorySetupsPlugin.this.triggerBankSearchFromHotKey();
        }
    };
    private final HotkeyListener filterEquipmentHotkeyListener = new HotkeyListener(() -> this.config.filterEquipmentHotkey()){

        public void hotkeyPressed() {
            InventorySetupsPlugin.this.bankFilteringMode = InventorySetupsFilteringModeID.EQUIPMENT;
            InventorySetupsPlugin.this.triggerBankSearchFromHotKey();
        }
    };
    private final HotkeyListener filterAddItemsHotkeyListener = new HotkeyListener(() -> this.config.filterAddItemsHotkey()){

        public void hotkeyPressed() {
            InventorySetupsPlugin.this.bankFilteringMode = InventorySetupsFilteringModeID.ADDITIONAL_FILTERED_ITEMS;
            InventorySetupsPlugin.this.triggerBankSearchFromHotKey();
        }
    };
    private final HotkeyListener sectionModeHotkeyListener = new HotkeyListener(() -> this.config.sectionModeHotkey()){

        public void hotkeyPressed() {
            InventorySetupsPlugin.this.panel.toggleSectionMode();
        }
    };

    private void registerHotkeys() {
        this.keyManager.registerKeyListener((KeyListener)this.returnToSetupsHotkeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.filterBankHotkeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.filterInventoryHotkeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.filterEquipmentHotkeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.filterAddItemsHotkeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.sectionModeHotkeyListener);
    }

    private void unregisterHotkeys() {
        this.keyManager.unregisterKeyListener((KeyListener)this.returnToSetupsHotkeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.filterBankHotkeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.filterInventoryHotkeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.filterEquipmentHotkeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.filterAddItemsHotkeyListener);
        this.keyManager.unregisterKeyListener((KeyListener)this.sectionModeHotkeyListener);
    }

    private void triggerBankSearchFromHotKey() {
        int gameTick = this.client.getTickCount();
        this.clientThread.invokeLater(() -> {
            int gameTick2 = this.client.getTickCount();
            if (gameTick2 <= gameTick) {
                return false;
            }
            this.doBankSearch();
            return true;
        });
    }

    @Provides
    InventorySetupsConfig getConfig(ConfigManager configManager) {
        return (InventorySetupsConfig)configManager.getConfig(InventorySetupsConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals(CONFIG_GROUP)) {
            if (event.getKey().equals(CONFIG_KEY_PANEL_VIEW) || event.getKey().equals(CONFIG_KEY_SECTION_MODE) || event.getKey().equals(CONFIG_KEY_SORTING_MODE) || event.getKey().equals(CONFIG_KEY_HIDE_BUTTON) || event.getKey().equals(CONFIG_KEY_UNASSIGNED_MAXIMIZED)) {
                SwingUtilities.invokeLater(() -> this.panel.redrawOverviewPanel(false));
            } else if (event.getKey().equals(CONFIG_KEY_MANUAL_BANK_FILTER)) {
                this.navButton.setOnClick(this.config.manualBankFilter() ? null : this::doBankSearch);
            } else if (event.getKey().equals(CONFIG_KEY_PERSIST_HOTKEYS)) {
                boolean bankOpen;
                boolean bl = bankOpen = this.client.getItemContainer(InventoryID.BANK) != null;
                if (this.config.persistHotKeysOutsideBank()) {
                    this.registerHotkeys();
                } else if (!bankOpen) {
                    this.unregisterHotkeys();
                }
            }
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        Widget bankWidget = this.client.getWidget(WidgetInfo.BANK_TITLE_BAR);
        if (bankWidget == null || bankWidget.isHidden()) {
            return;
        }
        if (event.getOption().equals("Show worn items")) {
            this.createMenuEntriesForWornItems();
        } else if (this.panel.getCurrentSelectedSetup() != null && event.getActionParam1() == WidgetInfo.BANK_ITEM_CONTAINER.getId() && this.client.isKeyPressed(81) && event.getOption().equals("Examine")) {
            this.createMenuEntryToAddAdditionalFilteredItem(event.getActionParam0());
        }
    }

    private void createMenuEntriesForWornItems() {
        List<InventorySetup> setupsToShowOnWornItemsList;
        List<InventorySetup> filteredSetups = this.panel.getFilteredInventorysetups();
        switch (this.config.showWornItemsFilter()) {
            case BANK_FILTERED: {
                setupsToShowOnWornItemsList = this.inventorySetups.stream().filter(InventorySetup::isFilterBank).collect(Collectors.toList());
                break;
            }
            case FAVORITED: {
                setupsToShowOnWornItemsList = this.inventorySetups.stream().filter(InventorySetup::isFavorite).collect(Collectors.toList());
                break;
            }
            default: {
                setupsToShowOnWornItemsList = filteredSetups;
            }
        }
        if (this.config.sectionMode() && this.config.wornItemSelectionSubmenu()) {
            ArrayList unassignedSetups = new ArrayList();
            HashMap sectionsToDisplay = new HashMap();
            if (this.config.sortingMode() == InventorySetupsSortingID.DEFAULT) {
                Set setupsToShowOnWornItemsListCache = setupsToShowOnWornItemsList.stream().map(InventorySetup::getName).collect(Collectors.toSet());
                this.sections.forEach(section -> {
                    List<String> setupsInSection = section.getSetups();
                    setupsInSection.forEach(setupName -> {
                        if (setupsToShowOnWornItemsListCache.contains(setupName)) {
                            if (!sectionsToDisplay.containsKey(section.getName())) {
                                sectionsToDisplay.put(section.getName(), new ArrayList());
                            }
                            InventorySetup inventorySetup = this.cache.getInventorySetupNames().get(setupName);
                            ((List)sectionsToDisplay.get(section.getName())).add(inventorySetup);
                        }
                    });
                });
                setupsToShowOnWornItemsList.forEach(setupToShow -> {
                    Map<String, InventorySetupsSection> sectionsOfSetup = this.cache.getSetupSectionsMap().get(setupToShow.getName());
                    if (sectionsOfSetup.isEmpty()) {
                        unassignedSetups.add(setupToShow);
                    }
                });
            } else {
                setupsToShowOnWornItemsList.forEach(setupToShow -> {
                    Map<String, InventorySetupsSection> sectionsOfSetup = this.cache.getSetupSectionsMap().get(setupToShow.getName());
                    if (sectionsOfSetup.isEmpty()) {
                        unassignedSetups.add(setupToShow);
                    } else {
                        for (InventorySetupsSection section : sectionsOfSetup.values()) {
                            if (!sectionsToDisplay.containsKey(section.getName())) {
                                sectionsToDisplay.put(section.getName(), new ArrayList());
                            }
                            ((List)sectionsToDisplay.get(section.getName())).add(setupToShow);
                        }
                    }
                });
            }
            this.sections.forEach(section -> {
                if (!sectionsToDisplay.containsKey(section.getName())) {
                    return;
                }
                Color sectionMenuTargetColor = section.getDisplayColor() == null ? JagexColors.MENU_TARGET : section.getDisplayColor();
                MenuEntry menuEntry = this.client.createMenuEntry(1).setOption(OPEN_SECTION_MENU_ENTRY).setTarget(ColorUtil.prependColorTag((String)section.getName(), (Color)sectionMenuTargetColor)).setType(MenuAction.RUNELITE_SUBMENU);
                for (InventorySetup inventorySetup : (List)sectionsToDisplay.get(section.getName())) {
                    this.createSectionSubMenuOnWornItems(inventorySetup, menuEntry);
                }
            });
            if (!unassignedSetups.isEmpty()) {
                MenuEntry unassignedSectionMenuEntry = this.client.createMenuEntry(1).setOption(OPEN_SECTION_MENU_ENTRY).setTarget(ColorUtil.prependColorTag((String)UNASSIGNED_SECTION_SETUP_MENU_ENTRY, (Color)JagexColors.MENU_TARGET)).setType(MenuAction.RUNELITE_SUBMENU);
                unassignedSetups.forEach(setup -> this.createSectionSubMenuOnWornItems((InventorySetup)setup, unassignedSectionMenuEntry));
            }
        } else {
            for (int i = 0; i < setupsToShowOnWornItemsList.size(); ++i) {
                InventorySetup setupToShow2 = setupsToShowOnWornItemsList.get(setupsToShowOnWornItemsList.size() - 1 - i);
                Color menuTargetColor = setupToShow2.getDisplayColor() == null ? JagexColors.MENU_TARGET : setupToShow2.getDisplayColor();
                this.client.createMenuEntry(-1).setOption(OPEN_SETUP_MENU_ENTRY).setTarget(ColorUtil.prependColorTag((String)setupToShow2.getName(), (Color)menuTargetColor)).setType(MenuAction.RUNELITE).onClick(e -> {
                    this.resetBankSearch(true);
                    this.panel.setCurrentInventorySetup(setupToShow2, true);
                });
            }
        }
        if (this.panel.getCurrentSelectedSetup() != null) {
            this.client.createMenuEntry(-1).setOption(FILTER_ADD_ITEMS_ENTRY).setType(MenuAction.RUNELITE).onClick(e -> this.doBankSearch(InventorySetupsFilteringModeID.ADDITIONAL_FILTERED_ITEMS));
            this.client.createMenuEntry(-1).setOption(FILTER_EQUIPMENT_ENTRY).setType(MenuAction.RUNELITE).onClick(e -> this.doBankSearch(InventorySetupsFilteringModeID.EQUIPMENT));
            this.client.createMenuEntry(-1).setOption(FILTER_INVENTORY_ENTRY).setType(MenuAction.RUNELITE).onClick(e -> this.doBankSearch(InventorySetupsFilteringModeID.INVENTORY));
            this.client.createMenuEntry(-1).setOption(FILTER_ALL_ENTRY).setType(MenuAction.RUNELITE).onClick(e -> this.doBankSearch(InventorySetupsFilteringModeID.ALL));
            this.client.createMenuEntry(-1).setOption(RETURN_TO_OVERVIEW_ENTRY).setType(MenuAction.RUNELITE).onClick(e -> this.panel.returnToOverviewPanel(false));
        }
    }

    private void createSectionSubMenuOnWornItems(InventorySetup setup, MenuEntry menuEntry) {
        Color setupMenuTargetColor = setup.getDisplayColor() == null ? JagexColors.MENU_TARGET : setup.getDisplayColor();
        this.client.createMenuEntry(1).setOption(OPEN_SETUP_MENU_ENTRY).setTarget(ColorUtil.prependColorTag((String)setup.getName(), (Color)setupMenuTargetColor)).setParent(menuEntry).setType(MenuAction.RUNELITE).onClick(e -> {
            this.resetBankSearch(true);
            this.panel.setCurrentInventorySetup(setup, true);
        });
    }

    private void createMenuEntryToAddAdditionalFilteredItem(int inventoryIndex) {
        this.client.createMenuEntry(-1).setOption(ADD_TO_ADDITIONAL_ENTRY).onClick(e -> {
            Item newItem = this.retrieveItemFromBankMenuEntry(inventoryIndex);
            if (newItem == null) {
                return;
            }
            Map<Integer, InventorySetupsItem> additionalFilteredItems = this.panel.getCurrentSelectedSetup().getAdditionalFilteredItems();
            if (!this.additionalFilteredItemsHasItem(newItem.getId(), additionalFilteredItems)) {
                this.addAdditionalFilteredItem(newItem.getId(), additionalFilteredItems);
            }
        });
    }

    private Item retrieveItemFromBankMenuEntry(int inventoryIndex) {
        if (this.panel.getCurrentSelectedSetup() == null) {
            return null;
        }
        ItemContainer bankContainer = this.client.getItemContainer(InventoryID.BANK);
        if (bankContainer == null) {
            return null;
        }
        Item[] items = bankContainer.getItems();
        if (inventoryIndex < 0 || inventoryIndex >= items.length) {
            return null;
        }
        return bankContainer.getItems()[inventoryIndex];
    }

    @Subscribe
    private void onWidgetClosed(WidgetClosed event) {
        if (event.getGroupId() == 12 && !this.config.persistHotKeysOutsideBank()) {
            this.unregisterHotkeys();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 12) {
            boolean bl = this.internalFilteringIsAllowed = !this.config.manualBankFilter();
            if (this.panel.getCurrentSelectedSetup() != null && this.panel.getCurrentSelectedSetup().isFilterBank() && this.isFilteringAllowed()) {
                this.doBankSearch();
            }
            if (!this.config.persistHotKeysOutsideBank()) {
                this.registerHotkeys();
            }
        }
    }

    public void setConfigValue(String key, boolean on) {
        this.configManager.setConfiguration(CONFIG_GROUP, key, (Object)on);
    }

    public void setConfigValue(String key, String value) {
        this.configManager.setConfiguration(CONFIG_GROUP, key, value);
    }

    public boolean getBooleanConfigValue(String key) {
        try {
            String value = this.configManager.getConfiguration(CONFIG_GROUP, key);
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            log.error("Couldn't retrieve config value with key " + key, (Throwable)e);
            return false;
        }
    }

    public void toggleAlphabeticalMode(InventorySetupsSortingID mode) {
        this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY_SORTING_MODE, (Object)mode);
    }

    public String getSavedVersionString() {
        String versionStr = this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY_VERSION_STR);
        return versionStr == null ? "" : versionStr;
    }

    public void setSavedVersionString(String newVersion) {
        this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY_VERSION_STR, newVersion);
    }

    public String getCurrentVersionString() {
        return this.currentVersion;
    }

    public void startUp() {
        try {
            Properties props = new Properties();
            InputStream is = InventorySetupsPlugin.class.getResourceAsStream("/invsetups_version.txt");
            props.load(is);
            this.currentVersion = props.getProperty(CONFIG_KEY_VERSION_STR);
        }
        catch (Exception e) {
            log.warn("Could not determine current plugin version", (Throwable)e);
            this.currentVersion = "";
        }
        this.internalFilteringIsAllowed = true;
        this.panel = new InventorySetupsPluginPanel(this, this.itemManager);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/inventorysetups_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Inventory Setups").icon(icon).priority(6).panel((PluginPanel)this.panel).build();
        this.navButton.setOnClick(this.config.manualBankFilter() ? null : this::doBankSearch);
        this.clientToolbar.addNavigation(this.navButton);
        this.bankFilteringMode = InventorySetupsFilteringModeID.ALL;
        this.cache = new InventorySetupsCache();
        this.inventorySetups = new ArrayList<InventorySetup>();
        this.sections = new ArrayList<InventorySetupsSection>();
        this.dataManager = new InventorySetupsPersistentDataManager(this, this.panel, this.configManager, this.cache, this.gson, this.inventorySetups, this.sections);
        this.clientThread.invokeLater(() -> {
            switch (this.client.getGameState()) {
                case STARTING: 
                case UNKNOWN: {
                    return false;
                }
            }
            this.clientThread.invokeLater(() -> {
                this.dataManager.loadConfig();
                SwingUtilities.invokeLater(() -> this.panel.redrawOverviewPanel(true));
            });
            return true;
        });
    }

    public void addInventorySetup() {
        String msg = "Enter the name of this setup (max 50 chars).";
        String name = JOptionPane.showInputDialog((Component)((Object)this.panel), "Enter the name of this setup (max 50 chars).", "Add New Setup", -1);
        if (name == null || name.isEmpty()) {
            return;
        }
        if (name.length() > 50) {
            name = name.substring(0, 50);
        }
        if (this.cache.getInventorySetupNames().containsKey(name)) {
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "A setup with the name " + name + " already exists", "Setup Already Exists", 0);
            return;
        }
        String newName = name;
        this.clientThread.invokeLater(() -> {
            List<InventorySetupsItem> inv = this.getNormalizedContainer(InventoryID.INVENTORY);
            List<InventorySetupsItem> eqp = this.getNormalizedContainer(InventoryID.EQUIPMENT);
            List<InventorySetupsItem> runePouchData = null;
            InventorySetupsRunePouchType inventoryRunePouchType = this.getRunePouchTypeFromContainer(inv);
            List<InventorySetupsItem> boltPouchData = null;
            boolean inventoryHasBoltPouch = this.containerContainsBoltPouch(inv);
            if (inventoryRunePouchType != InventorySetupsRunePouchType.NONE) {
                runePouchData = this.getRunePouchData(inventoryRunePouchType);
            }
            if (inventoryHasBoltPouch) {
                boltPouchData = this.getBoltPouchData();
            }
            int spellbook = this.getCurrentSpellbook();
            InventorySetup invSetup = new InventorySetup(inv, eqp, runePouchData, boltPouchData, new HashMap<Integer, InventorySetupsItem>(), newName, "", this.config.highlightColor(), this.config.highlightDifference(), this.config.enableDisplayColor() ? this.config.displayColor() : null, this.config.bankFilter(), this.config.highlightUnorderedDifference(), spellbook, false, -1);
            this.cache.addSetup(invSetup);
            this.inventorySetups.add(invSetup);
            this.dataManager.updateConfig(true, false);
            SwingUtilities.invokeLater(() -> this.panel.redrawOverviewPanel(false));
        });
    }

    public void addSection() {
        String msg = "Enter the name of this section (max 50 chars).";
        String name = JOptionPane.showInputDialog((Component)((Object)this.panel), "Enter the name of this section (max 50 chars).", "Add New Section", -1);
        if (name == null || name.isEmpty()) {
            return;
        }
        if (name.length() > 50) {
            name = name.substring(0, 50);
        }
        if (this.cache.getSectionNames().containsKey(name)) {
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "A section with the name " + name + " already exists", "Section Already Exists", 0);
            return;
        }
        String newName = name;
        InventorySetupsSection newSection = new InventorySetupsSection(newName);
        this.cache.addSection(newSection);
        this.sections.add(newSection);
        this.dataManager.updateConfig(false, true);
        SwingUtilities.invokeLater(() -> this.panel.redrawOverviewPanel(false));
    }

    public void addSetupToSections(InventorySetup setup, List<String> sectionNames) {
        for (String sectionName : sectionNames) {
            if (this.cache.getSectionSetupsMap().get(sectionName).containsKey(setup.getName())) continue;
            InventorySetupsSection section = this.cache.getSectionNames().get(sectionName);
            this.cache.addSetupToSection(section, setup);
            section.getSetups().add(setup.getName());
        }
        this.dataManager.updateConfig(false, true);
        this.panel.redrawOverviewPanel(false);
    }

    public void addSetupsToSection(InventorySetupsSection section, List<String> setupNames) {
        for (String setupName : setupNames) {
            if (this.cache.getSectionSetupsMap().get(section.getName()).containsKey(setupName)) continue;
            InventorySetup setup = this.cache.getInventorySetupNames().get(setupName);
            this.cache.addSetupToSection(section, setup);
            section.getSetups().add(setupName);
        }
        this.dataManager.updateConfig(false, true);
        this.panel.redrawOverviewPanel(false);
    }

    public void moveSetup(int invIndex, int newPosition) {
        if (this.isNewPositionInvalid(invIndex, newPosition, this.inventorySetups.size())) {
            return;
        }
        InventorySetup setup = this.inventorySetups.remove(invIndex);
        this.inventorySetups.add(newPosition, setup);
        this.panel.redrawOverviewPanel(false);
        this.dataManager.updateConfig(true, false);
    }

    public void moveSection(int sectionIndex, int newPosition) {
        if (this.isNewPositionInvalid(sectionIndex, newPosition, this.sections.size())) {
            return;
        }
        InventorySetupsSection section = this.sections.remove(sectionIndex);
        this.sections.add(newPosition, section);
        this.panel.redrawOverviewPanel(false);
        this.dataManager.updateConfig(false, true);
    }

    public void moveSetupWithinSection(InventorySetupsSection section, int invIndex, int newPosition) {
        if (this.isNewPositionInvalid(invIndex, newPosition, section.getSetups().size())) {
            return;
        }
        String setupName = section.getSetups().remove(invIndex);
        section.getSetups().add(newPosition, setupName);
        this.panel.redrawOverviewPanel(false);
        this.dataManager.updateConfig(false, true);
    }

    private boolean isNewPositionInvalid(int oldPosition, int newPosition, int size) {
        return oldPosition == newPosition || newPosition < 0 || newPosition >= size;
    }

    public List<InventorySetup> filterSetups(String textToFilter) {
        String textToFilterLower = textToFilter.toLowerCase();
        return this.inventorySetups.stream().filter(i -> i.getName().toLowerCase().contains(textToFilterLower)).collect(Collectors.toList());
    }

    public void doBankSearch(InventorySetupsFilteringModeID filteringModeID) {
        this.bankFilteringMode = filteringModeID;
        this.doBankSearch();
    }

    public void doBankSearch() {
        InventorySetup currentSelectedSetup = this.panel.getCurrentSelectedSetup();
        this.internalFilteringIsAllowed = true;
        if (currentSelectedSetup != null && currentSelectedSetup.isFilterBank()) {
            this.clientThread.invoke(() -> {
                this.client.setVarbit(4150, 0);
                this.bankSearch.layoutBank();
                Widget bankContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
                if (bankContainer != null && !bankContainer.isHidden()) {
                    Widget searchBackground = this.client.getWidget(WidgetInfo.BANK_SEARCH_BUTTON_BACKGROUND);
                    searchBackground.setSpriteId(170);
                }
            });
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() == MenuAction.RUNELITE) {
            return;
        }
        if (this.panel.getCurrentSelectedSetup() == null) {
            return;
        }
        if (event.getParam1() == WidgetInfo.BANK_ITEM_CONTAINER.getId() && event.getMenuOption().startsWith("View tab")) {
            if (this.config.disableBankTabBar()) {
                event.consume();
            }
        } else if (this.panel.getCurrentSelectedSetup() != null && (event.getMenuOption().startsWith("View tab") || event.getMenuOption().equals("View all items"))) {
            this.internalFilteringIsAllowed = false;
        }
    }

    private boolean additionalFilteredItemsHasItem(int itemId, Map<Integer, InventorySetupsItem> additionalFilteredItems) {
        int canonicalizedId = this.itemManager.canonicalize(itemId);
        for (Integer additionalItemKey : additionalFilteredItems.keySet()) {
            int finalItemId;
            boolean isFuzzy = additionalFilteredItems.get(additionalItemKey).isFuzzy();
            int addItemId = this.getProcessedID(isFuzzy, additionalFilteredItems.get(additionalItemKey).getId());
            if (addItemId != (finalItemId = this.getProcessedID(isFuzzy, canonicalizedId))) continue;
            return true;
        }
        return false;
    }

    private void addAdditionalFilteredItem(int itemId, Map<Integer, InventorySetupsItem> additionalFilteredItems) {
        int processedItemId = this.itemManager.canonicalize(itemId);
        this.clientThread.invokeLater(() -> {
            String name = this.itemManager.getItemComposition(processedItemId).getName();
            InventorySetupsStackCompareID stackCompareType = this.panel.isStackCompareForSlotAllowed(InventorySetupsSlotID.ADDITIONAL_ITEMS, 0) ? this.config.stackCompareType() : InventorySetupsStackCompareID.None;
            InventorySetupsItem setupItem = new InventorySetupsItem(processedItemId, name, 1, this.config.fuzzy(), stackCompareType);
            additionalFilteredItems.put(processedItemId, setupItem);
            this.dataManager.updateConfig(true, false);
            this.panel.refreshCurrentSetup();
        });
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getIndex() == 439 && this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invokeLater(() -> this.panel.highlightSpellbook());
        }
    }

    public void resetBankSearch(boolean closeChat) {
        if (this.isFilteringAllowed()) {
            this.bankSearch.reset(closeChat);
        }
    }

    public List<InventorySetupsItem> getRunePouchData(InventorySetupsRunePouchType runePouchType) {
        ArrayList<InventorySetupsItem> runePouchData = new ArrayList<InventorySetupsItem>();
        EnumComposition runepouchEnum = this.client.getEnum(982);
        for (int i = 0; i < runePouchType.getSize(); ++i) {
            int varbitVal = this.client.getVarbitValue(InventorySetupsRunePouchPanel.RUNE_POUCH_RUNE_VARBITS.get(i).intValue());
            if (varbitVal == 0) {
                runePouchData.add(InventorySetupsItem.getDummyItem());
                continue;
            }
            int runeId = runepouchEnum.getIntValue(varbitVal);
            int runeAmount = this.client.getVarbitValue(InventorySetupsRunePouchPanel.RUNE_POUCH_AMOUNT_VARBITS.get(i).intValue());
            String runeName = this.itemManager.getItemComposition(runeId).getName();
            InventorySetupsStackCompareID stackCompareType = this.panel.isStackCompareForSlotAllowed(InventorySetupsSlotID.RUNE_POUCH, i) ? this.config.stackCompareType() : InventorySetupsStackCompareID.None;
            runePouchData.add(new InventorySetupsItem(runeId, runeName, runeAmount, false, stackCompareType));
        }
        return runePouchData;
    }

    public List<InventorySetupsItem> getBoltPouchData() {
        ArrayList<InventorySetupsItem> boltPouchData = new ArrayList<InventorySetupsItem>();
        for (int i = 0; i < InventorySetupsBoltPouchPanel.BOLT_POUCH_BOLT_VARBIT_IDS.size(); ++i) {
            int boltItemId;
            int boltVarbitId = this.client.getVarbitValue(InventorySetupsBoltPouchPanel.BOLT_POUCH_BOLT_VARBIT_IDS.get(i).intValue());
            Bolts bolt = Bolts.getBolt(boltVarbitId);
            boolean boltNotFound = bolt == null;
            int boltAmount = boltNotFound ? 0 : this.client.getVarbitValue(InventorySetupsBoltPouchPanel.BOLT_POUCH_AMOUNT_VARBIT_IDS.get(i).intValue());
            String boltName = boltNotFound ? "" : this.itemManager.getItemComposition(bolt.getItemId()).getName();
            int n = boltItemId = boltNotFound ? -1 : bolt.getItemId();
            if (boltItemId == -1) {
                boltPouchData.add(InventorySetupsItem.getDummyItem());
                continue;
            }
            InventorySetupsStackCompareID stackCompareType = this.panel.isStackCompareForSlotAllowed(InventorySetupsSlotID.BOLT_POUCH, i) ? this.config.stackCompareType() : InventorySetupsStackCompareID.None;
            boltPouchData.add(new InventorySetupsItem(boltItemId, boltName, boltAmount, false, stackCompareType));
        }
        return boltPouchData;
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        String eventName = event.getEventName();
        int[] intStack = this.client.getIntStack();
        int intStackSize = this.client.getIntStackSize();
        switch (eventName) {
            case "bankSearchFilter": {
                boolean bankOpen;
                InventorySetup currentSetup = this.panel.getCurrentSelectedSetup();
                boolean bl = bankOpen = this.client.getItemContainer(InventoryID.BANK) != null;
                if (!bankOpen || currentSetup == null || !currentSetup.isFilterBank() || !this.isFilteringAllowed()) break;
                int itemId = intStack[intStackSize - 1];
                boolean containsItem = false;
                switch (this.bankFilteringMode) {
                    case ALL: {
                        containsItem = this.setupContainsItem(currentSetup, itemId);
                        break;
                    }
                    case INVENTORY: {
                        boolean runePouchContainsItem = false;
                        if (currentSetup.getRune_pouch() != null) {
                            runePouchContainsItem = this.containerContainsItem(itemId, currentSetup.getRune_pouch());
                        }
                        boolean boltPouchContainsItem = false;
                        if (currentSetup.getBoltPouch() != null) {
                            boltPouchContainsItem = this.containerContainsItem(itemId, currentSetup.getBoltPouch());
                        }
                        containsItem = runePouchContainsItem || boltPouchContainsItem || this.containerContainsItem(itemId, currentSetup.getInventory());
                        break;
                    }
                    case EQUIPMENT: {
                        containsItem = this.containerContainsItem(itemId, currentSetup.getEquipment());
                        break;
                    }
                    case ADDITIONAL_FILTERED_ITEMS: {
                        containsItem = this.additionalFilteredItemsHasItem(itemId, currentSetup.getAdditionalFilteredItems());
                    }
                }
                if (containsItem) {
                    intStack[intStackSize - 2] = 1;
                    break;
                }
                intStack[intStackSize - 2] = 0;
                break;
            }
            case "getSearchingTagTab": {
                InventorySetup currentSetup = this.panel.getCurrentSelectedSetup();
                intStack[intStackSize - 1] = currentSetup != null && currentSetup.isFilterBank() && this.isFilteringAllowed() ? 1 : 0;
            }
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        if (event.getScriptId() == 505) {
            if (this.panel.getCurrentSelectedSetup() != null && this.panel.getCurrentSelectedSetup().isFilterBank() && this.isFilteringAllowed()) {
                Object postTitle = " - ";
                switch (this.bankFilteringMode) {
                    case ALL: {
                        postTitle = (String)postTitle + "All Items";
                        break;
                    }
                    case INVENTORY: {
                        postTitle = (String)postTitle + "Inventory";
                        break;
                    }
                    case EQUIPMENT: {
                        postTitle = (String)postTitle + "Equipment";
                        break;
                    }
                    case ADDITIONAL_FILTERED_ITEMS: {
                        postTitle = (String)postTitle + "Additional Items";
                    }
                }
                Widget bankTitle = this.client.getWidget(WidgetInfo.BANK_TITLE_BAR);
                bankTitle.setText("Inventory Setup <col=ff0000>" + this.panel.getCurrentSelectedSetup().getName() + (String)postTitle + "</col>");
            }
        } else if (event.getScriptId() == 281) {
            this.resetBankSearch(true);
            this.internalFilteringIsAllowed = false;
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 514) {
            boolean bankOpen;
            boolean bl = bankOpen = this.client.getItemContainer(InventoryID.BANK) != null;
            if (bankOpen && this.panel.getCurrentSelectedSetup() != null && this.panel.getCurrentSelectedSetup().isFilterBank() && this.isFilteringAllowed()) {
                this.client.getIntStack()[this.client.getIntStackSize() - 1] = 1;
            }
        }
        if (event.getScriptId() != 277) {
            return;
        }
        int items = 0;
        Widget itemContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        if (itemContainer == null) {
            return;
        }
        if (this.panel.getCurrentSelectedSetup() != null && this.config.removeBankTabSeparator() && this.isFilteringAllowed()) {
            Widget[] containerChildren = itemContainer.getDynamicChildren();
            Arrays.sort(containerChildren, Comparator.comparing(Widget::getOriginalY).thenComparing(Widget::getOriginalX));
            for (Widget child : containerChildren) {
                if (child.getItemId() != -1 && !child.isHidden()) {
                    int adjYOffset = items / 8 * 36;
                    int adjXOffset = items % 8 * 48 + 51;
                    if (child.getOriginalY() != adjYOffset) {
                        child.setOriginalY(adjYOffset);
                        child.revalidate();
                    }
                    if (child.getOriginalX() != adjXOffset) {
                        child.setOriginalX(adjXOffset);
                        child.revalidate();
                    }
                    ++items;
                }
                if (child.getSpriteId() != 897 && !child.getText().contains("Tab")) continue;
                child.setHidden(true);
            }
        }
    }

    public void updateCurrentSetup(InventorySetup setup) {
        int confirm = JOptionPane.showConfirmDialog((Component)((Object)this.panel), "Are you sure you want update this inventory setup?", "Warning", 2);
        if (confirm != 0) {
            return;
        }
        this.clientThread.invokeLater(() -> {
            int i;
            List<InventorySetupsItem> inv = this.getNormalizedContainer(InventoryID.INVENTORY);
            List<InventorySetupsItem> eqp = this.getNormalizedContainer(InventoryID.EQUIPMENT);
            for (i = 0; i < inv.size(); ++i) {
                inv.get(i).setFuzzy(setup.getInventory().get(i).isFuzzy());
                inv.get(i).setStackCompare(setup.getInventory().get(i).getStackCompare());
            }
            for (i = 0; i < eqp.size(); ++i) {
                eqp.get(i).setFuzzy(setup.getEquipment().get(i).isFuzzy());
                eqp.get(i).setStackCompare(setup.getEquipment().get(i).getStackCompare());
            }
            List<InventorySetupsItem> runePouchData = null;
            InventorySetupsRunePouchType inventoryRunePouchType = this.getRunePouchTypeFromContainer(inv);
            if (inventoryRunePouchType != InventorySetupsRunePouchType.NONE) {
                runePouchData = this.getRunePouchData(inventoryRunePouchType);
            }
            List<InventorySetupsItem> boltPouchData = null;
            if (this.containerContainsItem(9433, inv)) {
                boltPouchData = this.getBoltPouchData();
            }
            setup.updateRunePouch(runePouchData);
            setup.updateBoltPouch(boltPouchData);
            setup.updateInventory(inv);
            setup.updateEquipment(eqp);
            setup.updateSpellbook(this.getCurrentSpellbook());
            this.dataManager.updateConfig(true, false);
            this.panel.refreshCurrentSetup();
        });
    }

    private void updateAllInstancesInContainerSetupWithNewItem(InventorySetup inventorySetup, List<InventorySetupsItem> containerToUpdate, InventorySetupsItem oldItem, InventorySetupsItem newItem, InventorySetupsSlotID id) {
        for (int i = 0; i < containerToUpdate.size(); ++i) {
            InventorySetupsItem item = containerToUpdate.get(i);
            if (item.getId() != oldItem.getId()) continue;
            boolean runePouchValid = this.checkAndUpdateSlotIfRunePouchWasSelected(inventorySetup, id, containerToUpdate.get(i), newItem, false);
            boolean boltPouchValid = this.checkAndUpdateSlotIfBoltPouchWasSelected(inventorySetup, id, containerToUpdate.get(i), newItem, false);
            if (!runePouchValid || !boltPouchValid) continue;
            containerToUpdate.set(i, newItem);
        }
    }

    private void updateAllInstancesInSetupWithNewItem(InventorySetupsItem oldItem, InventorySetupsItem newItem) {
        if (oldItem.getId() == -1 || newItem.getId() == -1) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog((Component)((Object)this.panel), "You cannot update empty slots or replace all slots with this item with an empty slot", "Cannot Update Setups", 0));
            return;
        }
        for (InventorySetup inventorySetup : this.inventorySetups) {
            this.updateAllInstancesInContainerSetupWithNewItem(inventorySetup, inventorySetup.getInventory(), oldItem, newItem, InventorySetupsSlotID.INVENTORY);
            this.updateAllInstancesInContainerSetupWithNewItem(inventorySetup, inventorySetup.getEquipment(), oldItem, newItem, InventorySetupsSlotID.EQUIPMENT);
        }
    }

    public void updateSlotFromContainer(InventorySetupsSlot slot, boolean updateAllInstances) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "You must be logged in to update from " + slot.getSlotID().toString().toLowerCase() + ".", "Cannot Update Item", 0);
            return;
        }
        InventorySetupsItem oldItem = this.getContainerFromSlot(slot).get(slot.getIndexInSlot());
        boolean isFuzzy = oldItem.isFuzzy();
        InventorySetupsStackCompareID stackCompareType = oldItem.getStackCompare();
        this.clientThread.invokeLater(() -> {
            List<InventorySetupsItem> playerContainer = this.getNormalizedContainer(slot.getSlotID());
            InventorySetupsItem newItem = playerContainer.get(slot.getIndexInSlot());
            newItem.setFuzzy(isFuzzy);
            newItem.setStackCompare(stackCompareType);
            if (updateAllInstances) {
                this.updateAllInstancesInSetupWithNewItem(oldItem, newItem);
            } else {
                List<InventorySetupsItem> containerToUpdate = this.getContainerFromID(slot.getParentSetup(), slot.getSlotID());
                boolean runePouchValid = this.checkAndUpdateSlotIfRunePouchWasSelected(slot.getParentSetup(), slot.getSlotID(), oldItem, newItem, true);
                boolean boltPouchValid = this.checkAndUpdateSlotIfBoltPouchWasSelected(slot.getParentSetup(), slot.getSlotID(), oldItem, newItem, true);
                if (runePouchValid && boltPouchValid) {
                    containerToUpdate.set(slot.getIndexInSlot(), newItem);
                }
            }
            this.dataManager.updateConfig(true, false);
            this.panel.refreshCurrentSetup();
        });
    }

    public void updateSlotFromSearch(InventorySetupsSlot slot, boolean allowStackable, boolean updateAllInstances) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "You must be logged in to search.", "Cannot Search for Item", 0);
            return;
        }
        this.itemSearch.tooltipText("Set slot to").onItemSelected(itemId -> this.clientThread.invokeLater(() -> {
            int finalId = this.itemManager.canonicalize(itemId.intValue());
            if (slot.getSlotID() == InventorySetupsSlotID.ADDITIONAL_ITEMS) {
                Map<Integer, InventorySetupsItem> additionalFilteredItems = this.panel.getCurrentSelectedSetup().getAdditionalFilteredItems();
                if (!this.additionalFilteredItemsHasItem(finalId, additionalFilteredItems)) {
                    this.removeAdditionalFilteredItem(slot, additionalFilteredItems);
                    this.addAdditionalFilteredItem(finalId, additionalFilteredItems);
                }
                return;
            }
            String itemName = this.itemManager.getItemComposition(finalId).getName();
            List<InventorySetupsItem> container = this.getContainerFromSlot(slot);
            InventorySetupsItem itemToBeReplaced = container.get(slot.getIndexInSlot());
            InventorySetupsItem newItem = new InventorySetupsItem(finalId, itemName, 1, itemToBeReplaced.isFuzzy(), itemToBeReplaced.getStackCompare());
            if (allowStackable && this.itemManager.getItemComposition(finalId).isStackable()) {
                this.searchInput = this.chatboxPanelManager.openTextInput("Enter amount").addCharValidator(this::validateCharFromItemSearch).onDone(input -> {
                    int quantity = InventorySetupUtilities.parseTextInputAmount(input);
                    newItem.setQuantity(quantity);
                    this.updateSlotFromSearchHelper(slot, itemToBeReplaced, newItem, container, updateAllInstances);
                }).build();
            } else {
                this.updateSlotFromSearchHelper(slot, itemToBeReplaced, newItem, container, updateAllInstances);
            }
        })).build();
    }

    private void updateSlotFromSearchHelper(InventorySetupsSlot slot, InventorySetupsItem itemToBeReplaced, InventorySetupsItem newItem, List<InventorySetupsItem> container, boolean updateAllInstances) {
        this.clientThread.invokeLater(() -> {
            if (updateAllInstances) {
                this.updateAllInstancesInSetupWithNewItem(itemToBeReplaced, newItem);
            } else {
                if (!this.checkAndUpdateSlotIfRunePouchWasSelected(slot.getParentSetup(), slot.getSlotID(), (InventorySetupsItem)container.get(slot.getIndexInSlot()), newItem)) {
                    return;
                }
                if (!this.checkAndUpdateSlotIfBoltPouchWasSelected(slot.getParentSetup(), slot.getSlotID(), (InventorySetupsItem)container.get(slot.getIndexInSlot()), newItem)) {
                    return;
                }
                container.set(slot.getIndexInSlot(), newItem);
            }
            SwingUtilities.invokeLater(() -> {
                this.dataManager.updateConfig(true, false);
                this.panel.refreshCurrentSetup();
            });
        });
    }

    private boolean validateCharFromItemSearch(int arg) {
        boolean stillInputtingNumbers = arg >= 48 && arg <= 57 && !this.searchInput.getValue().toLowerCase().contains("k") && !this.searchInput.getValue().toLowerCase().contains("m") && !this.searchInput.getValue().toLowerCase().contains("b");
        boolean letterIsInput = (arg == 98 || arg == 66 || arg == 107 || arg == 75 || arg == 109 || arg == 77) && this.searchInput.getValue().length() > 0 && !this.searchInput.getValue().toLowerCase().contains("k") && !this.searchInput.getValue().toLowerCase().contains("m") && !this.searchInput.getValue().toLowerCase().contains("b");
        return stillInputtingNumbers || letterIsInput;
    }

    public void updateInventorySetupIcon(InventorySetup setup) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "You must be logged in to search.", "Cannot Search for Item", 0);
            return;
        }
        this.itemSearch.tooltipText("Set slot to").onItemSelected(itemId -> {
            int finalId = this.itemManager.canonicalize(itemId.intValue());
            setup.setIconID(finalId);
            this.dataManager.updateConfig(true, false);
            SwingUtilities.invokeLater(() -> this.panel.redrawOverviewPanel(false));
        }).build();
    }

    public void removeItemFromSlot(InventorySetupsSlot slot) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "You must be logged in to remove item from the slot.", "Cannot Remove Item", 0);
            return;
        }
        this.clientThread.invokeLater(() -> {
            if (slot.getSlotID() == InventorySetupsSlotID.ADDITIONAL_ITEMS) {
                this.removeAdditionalFilteredItem(slot, this.panel.getCurrentSelectedSetup().getAdditionalFilteredItems());
                this.dataManager.updateConfig(true, false);
                this.panel.refreshCurrentSetup();
                return;
            }
            List<InventorySetupsItem> container = this.getContainerFromSlot(slot);
            InventorySetupsItem itemToBeReplaced = container.get(slot.getIndexInSlot());
            InventorySetupsItem dummyItem = new InventorySetupsItem(-1, "", 0, itemToBeReplaced.isFuzzy(), itemToBeReplaced.getStackCompare());
            if (!this.checkAndUpdateSlotIfRunePouchWasSelected(slot.getParentSetup(), slot.getSlotID(), container.get(slot.getIndexInSlot()), dummyItem)) {
                return;
            }
            if (!this.checkAndUpdateSlotIfBoltPouchWasSelected(slot.getParentSetup(), slot.getSlotID(), container.get(slot.getIndexInSlot()), dummyItem)) {
                return;
            }
            container.set(slot.getIndexInSlot(), dummyItem);
            this.dataManager.updateConfig(true, false);
            this.panel.refreshCurrentSetup();
        });
    }

    public void toggleFuzzyOnSlot(InventorySetupsSlot slot) {
        if (this.panel.getCurrentSelectedSetup() == null) {
            return;
        }
        if (slot.getSlotID() == InventorySetupsSlotID.ADDITIONAL_ITEMS) {
            if (slot.getIndexInSlot() >= slot.getParentSetup().getAdditionalFilteredItems().size()) {
                return;
            }
            Map<Integer, InventorySetupsItem> additionalFilteredItems = slot.getParentSetup().getAdditionalFilteredItems();
            int slotID = slot.getIndexInSlot();
            int j = 0;
            Integer keyToMakeFuzzy = null;
            for (Integer key : additionalFilteredItems.keySet()) {
                if (slotID == j) {
                    keyToMakeFuzzy = key;
                    break;
                }
                ++j;
            }
            additionalFilteredItems.get(keyToMakeFuzzy).toggleIsFuzzy();
        } else {
            List<InventorySetupsItem> container = this.getContainerFromSlot(slot);
            container.get(slot.getIndexInSlot()).toggleIsFuzzy();
        }
        this.dataManager.updateConfig(true, false);
        this.panel.refreshCurrentSetup();
    }

    public void setStackCompareOnSlot(InventorySetupsSlot slot, InventorySetupsStackCompareID newStackCompare) {
        if (this.panel.getCurrentSelectedSetup() == null) {
            return;
        }
        List<InventorySetupsItem> container = this.getContainerFromSlot(slot);
        container.get(slot.getIndexInSlot()).setStackCompare(newStackCompare);
        this.dataManager.updateConfig(true, false);
        this.panel.refreshCurrentSetup();
    }

    private void removeAdditionalFilteredItem(InventorySetupsSlot slot, Map<Integer, InventorySetupsItem> additionalFilteredItems) {
        assert (this.panel.getCurrentSelectedSetup() != null) : "Current setup is null";
        int slotID = slot.getIndexInSlot();
        if (slotID >= additionalFilteredItems.size()) {
            return;
        }
        int j = 0;
        Integer keyToDelete = null;
        for (Integer key : additionalFilteredItems.keySet()) {
            if (slotID == j) {
                keyToDelete = key;
                break;
            }
            ++j;
        }
        additionalFilteredItems.remove(keyToDelete);
    }

    public void updateSpellbookInSetup(int newSpellbook) {
        assert (this.panel.getCurrentSelectedSetup() != null) : "Setup is null";
        assert (newSpellbook >= 0 && newSpellbook < 5) : "New spellbook out of range";
        this.clientThread.invokeLater(() -> {
            this.panel.getCurrentSelectedSetup().updateSpellbook(newSpellbook);
            this.dataManager.updateConfig(true, false);
            this.panel.refreshCurrentSetup();
        });
    }

    public void updateNotesInSetup(InventorySetup setup, String text) {
        this.clientThread.invokeLater(() -> {
            setup.updateNotes(text);
            this.dataManager.updateConfig(true, false);
        });
    }

    public void removeInventorySetup(InventorySetup setup) {
        if (this.isDeletionConfirmed("Are you sure you want to permanently delete this inventory setup?", "Warning")) {
            for (InventorySetupsSection section : this.sections) {
                if (!this.cache.getSectionSetupsMap().get(section.getName()).containsKey(setup.getName())) continue;
                section.getSetups().remove(setup.getName());
            }
            this.cache.removeSetup(setup);
            this.inventorySetups.remove(setup);
            this.panel.redrawOverviewPanel(false);
            this.dataManager.updateConfig(true, true);
        }
    }

    public void removeSection(InventorySetupsSection section) {
        if (this.isDeletionConfirmed("Are you sure you want to permanently delete this section?", "Warning")) {
            this.cache.removeSection(section);
            this.sections.remove(section);
            this.panel.redrawOverviewPanel(false);
            this.dataManager.updateConfig(false, true);
        }
    }

    public void removeInventorySetupFromSection(InventorySetup setup, InventorySetupsSection section) {
        this.cache.removeSetupFromSection(section, setup);
        section.getSetups().remove(setup.getName());
        this.panel.redrawOverviewPanel(false);
        this.dataManager.updateConfig(false, true);
    }

    private boolean isDeletionConfirmed(String message, String title) {
        int confirm = JOptionPane.showConfirmDialog((Component)((Object)this.panel), message, title, 2);
        return confirm == 0;
    }

    @Subscribe
    public void onProfileChanged(ProfileChanged e) {
        this.switchProfile();
    }

    private void switchProfile() {
        this.clientThread.invokeLater(() -> {
            this.dataManager.loadConfig();
            SwingUtilities.invokeLater(() -> this.panel.redrawOverviewPanel(true));
            return true;
        });
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer container = event.getItemContainer();
        if (container == this.client.getItemContainer(InventoryID.INVENTORY)) {
            this.panel.highlightInventory();
        } else if (container == this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            this.panel.highlightEquipment();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.panel.highlightInventory();
        this.panel.highlightEquipment();
        this.panel.highlightSpellbook();
    }

    public int getCurrentSpellbook() {
        assert (this.client.isClientThread()) : "getCurrentSpellbook must be called on Client Thread";
        return this.client.getVarbitValue(4070);
    }

    public List<InventorySetupsItem> getNormalizedContainer(InventorySetupsSlotID id) {
        switch (id) {
            case INVENTORY: {
                return this.getNormalizedContainer(InventoryID.INVENTORY);
            }
            case EQUIPMENT: {
                return this.getNormalizedContainer(InventoryID.EQUIPMENT);
            }
            case RUNE_POUCH: {
                return this.getRunePouchData(InventorySetupsRunePouchType.DIVINE);
            }
            case BOLT_POUCH: {
                return this.getBoltPouchData();
            }
        }
        assert (false) : "Wrong slot ID!";
        return null;
    }

    public List<InventorySetupsItem> getNormalizedContainer(InventoryID id) {
        assert (id == InventoryID.INVENTORY || id == InventoryID.EQUIPMENT) : "invalid inventory ID";
        ItemContainer container = this.client.getItemContainer(id);
        ArrayList<InventorySetupsItem> newContainer = new ArrayList<InventorySetupsItem>();
        Item[] items = null;
        if (container != null) {
            items = container.getItems();
        }
        int size = id == InventoryID.INVENTORY ? 28 : 14;
        for (int i = 0; i < size; ++i) {
            InventorySetupsStackCompareID stackCompareType;
            InventorySetupsStackCompareID inventorySetupsStackCompareID = stackCompareType = this.panel != null && this.panel.isStackCompareForSlotAllowed(InventorySetupsSlotID.fromInventoryID(id), i) ? this.config.stackCompareType() : InventorySetupsStackCompareID.None;
            if (items == null || i >= items.length || items[i].getId() == -1) {
                newContainer.add(InventorySetupsItem.getDummyItem());
                continue;
            }
            Item item = items[i];
            String itemName = "";
            if (this.client.isClientThread()) {
                itemName = this.itemManager.getItemComposition(item.getId()).getName();
            }
            newContainer.add(new InventorySetupsItem(item.getId(), itemName, item.getQuantity(), this.config.fuzzy(), stackCompareType));
        }
        return newContainer;
    }

    public void exportSetup(InventorySetup setup) {
        String json = this.gson.toJson((Object)setup);
        StringSelection contents = new StringSelection(json);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
        JOptionPane.showMessageDialog((Component)((Object)this.panel), "Setup data was copied to clipboard.", "Export Setup Succeeded", -1);
    }

    public void exportSection(InventorySetupsSection section) {
        String json = this.gson.toJson((Object)section);
        StringSelection contents = new StringSelection(json);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
        JOptionPane.showMessageDialog((Component)((Object)this.panel), "Section data was copied to clipboard.", "Export Setup Succeeded", -1);
    }

    public <T> void massExport(List<T> data, String type, String file_prefix) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle("Choose Directory to Export " + type);
        fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        int returnValue = fileChooser.showSaveDialog((Component)((Object)this.panel));
        if (returnValue == 0) {
            File directory = fileChooser.getSelectedFile();
            String login_name = this.client.getLocalPlayer() != null ? "_" + this.client.getLocalPlayer().getName() : "";
            login_name = login_name.replace(" ", "_");
            Object newFileName = directory.getAbsolutePath() + "/" + file_prefix + login_name + ".json";
            newFileName = ((String)newFileName).replace("\\", "/");
            try {
                String json = this.gson.toJson(data);
                FileOutputStream outputStream = new FileOutputStream((String)newFileName);
                outputStream.write(json.getBytes());
                outputStream.close();
            }
            catch (Exception e) {
                log.error("Couldn't mass export " + type, (Throwable)e);
                JOptionPane.showMessageDialog((Component)((Object)this.panel), "Failed to export " + type + ".", "Mass Export Failed", -1);
                return;
            }
            JLabel messageLabel = new JLabel("<html><center>All " + type + " were exported successfully to<br>" + (String)newFileName);
            messageLabel.setHorizontalAlignment(0);
            JOptionPane.showMessageDialog((Component)((Object)this.panel), messageLabel, "Mass Export Succeeded", -1);
        }
    }

    public void importSetup() {
        try {
            String setup = JOptionPane.showInputDialog((Component)((Object)this.panel), "Enter setup data", "Import New Setup", -1);
            if (setup == null) {
                return;
            }
            Type type = new TypeToken<InventorySetup>(){}.getType();
            InventorySetup newSetup = (InventorySetup)this.gson.fromJson(setup, type);
            if (this.isImportedSetupInvalid(newSetup)) {
                throw new RuntimeException("Imported setup was missing required fields");
            }
            this.preProcessNewSetup(newSetup);
            this.cache.addSetup(newSetup);
            this.inventorySetups.add(newSetup);
            this.dataManager.updateConfig(true, false);
            SwingUtilities.invokeLater(() -> this.panel.redrawOverviewPanel(false));
        }
        catch (Exception e) {
            log.error("Couldn't import setup", (Throwable)e);
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "Invalid setup data.", "Import Setup Failed", 0);
        }
    }

    public void massImportSetups() {
        try {
            Path path = this.showMassImportFolderDialog();
            if (path == null) {
                return;
            }
            String json = new String(Files.readAllBytes(path));
            Type typeSetups = new TypeToken<ArrayList<InventorySetup>>(){}.getType();
            ArrayList newSetups = (ArrayList)this.gson.fromJson(json, typeSetups);
            for (InventorySetup setup : newSetups) {
                if (!this.isImportedSetupInvalid(setup)) continue;
                throw new RuntimeException("Mass import section file was missing required fields");
            }
            for (InventorySetup inventorySetup : newSetups) {
                this.preProcessNewSetup(inventorySetup);
                this.cache.addSetup(inventorySetup);
                this.inventorySetups.add(inventorySetup);
            }
            this.dataManager.updateConfig(true, false);
            SwingUtilities.invokeLater(() -> this.panel.redrawOverviewPanel(false));
        }
        catch (Exception e) {
            log.error("Couldn't mass import setups", (Throwable)e);
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "Invalid setup data.", "Mass Import Setup Failed", 0);
        }
    }

    private boolean isImportedSetupInvalid(InventorySetup setup) {
        return setup.getName() == null || setup.getInventory() == null || setup.getEquipment() == null || setup.getAdditionalFilteredItems() == null;
    }

    public void importSection() {
        try {
            String section = JOptionPane.showInputDialog((Component)((Object)this.panel), "Enter section data", "Import New Section", -1);
            if (section == null) {
                return;
            }
            Type type = new TypeToken<InventorySetupsSection>(){}.getType();
            InventorySetupsSection newSection = (InventorySetupsSection)this.gson.fromJson(section, type);
            if (this.isImportedSectionValid(newSection)) {
                throw new RuntimeException("Imported section was missing required fields");
            }
            this.preProcessNewSection(newSection);
            this.cache.addSection(newSection);
            this.sections.add(newSection);
            this.dataManager.updateConfig(false, true);
            SwingUtilities.invokeLater(() -> this.panel.redrawOverviewPanel(false));
        }
        catch (Exception e) {
            log.error("Couldn't import setup", (Throwable)e);
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "Invalid section data.", "Import section Failed", 0);
        }
    }

    public void massImportSections() {
        try {
            Path path = this.showMassImportFolderDialog();
            if (path == null) {
                return;
            }
            String json = new String(Files.readAllBytes(path));
            Type typeSetups = new TypeToken<ArrayList<InventorySetupsSection>>(){}.getType();
            ArrayList newSections = (ArrayList)this.gson.fromJson(json, typeSetups);
            for (InventorySetupsSection section : newSections) {
                if (!this.isImportedSectionValid(section)) continue;
                throw new RuntimeException("Mass import section file was missing required fields");
            }
            for (InventorySetupsSection section : newSections) {
                this.preProcessNewSection(section);
                this.cache.addSection(section);
                this.sections.add(section);
            }
            this.dataManager.updateConfig(false, true);
            SwingUtilities.invokeLater(() -> this.panel.redrawOverviewPanel(false));
        }
        catch (Exception e) {
            log.error("Couldn't mass import sections", (Throwable)e);
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "Invalid section data.", "Mass Import Section Failed", 0);
        }
    }

    private boolean isImportedSectionValid(InventorySetupsSection section) {
        return section.getName() == null || section.getSetups() == null;
    }

    private void preProcessNewSection(InventorySetupsSection newSection) {
        String newName = InventorySetupUtilities.findNewName(newSection.getName(), this.cache.getSectionNames().keySet());
        newSection.setName(newName);
        newSection.setSetups(newSection.getSetups().stream().distinct().collect(Collectors.toList()));
        newSection.getSetups().removeIf(s -> !this.cache.getInventorySetupNames().containsKey(s));
    }

    private void preProcessNewSetup(InventorySetup newSetup) {
        String newName = InventorySetupUtilities.findNewName(newSetup.getName(), this.cache.getInventorySetupNames().keySet());
        newSetup.setName(newName);
    }

    private Path showMassImportFolderDialog() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle("Choose Import File");
        FileNameExtensionFilter jsonFilter = new FileNameExtensionFilter("JSON files", "json");
        fileChooser.setFileFilter(jsonFilter);
        fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        int returnValue = fileChooser.showOpenDialog((Component)((Object)this.panel));
        if (returnValue == 0) {
            return Paths.get(fileChooser.getSelectedFile().getAbsolutePath(), new String[0]);
        }
        return null;
    }

    public void shutDown() {
        this.resetBankSearch(true);
        this.clientToolbar.removeNavigation(this.navButton);
    }

    public boolean isHighlightingAllowed() {
        return this.client.getGameState() == GameState.LOGGED_IN;
    }

    public boolean isFilteringAllowed() {
        boolean allowBasedOnActivePanel = this.navButton.isSelected() || !this.config.requireActivePanelFilter();
        return this.internalFilteringIsAllowed && allowBasedOnActivePanel;
    }

    private List<InventorySetupsItem> getContainerFromSlot(InventorySetupsSlot slot) {
        assert (slot.getParentSetup() == this.panel.getCurrentSelectedSetup()) : "Setup Mismatch";
        return this.getContainerFromID(slot.getParentSetup(), slot.getSlotID());
    }

    private List<InventorySetupsItem> getContainerFromID(InventorySetup inventorySetup, InventorySetupsSlotID ID) {
        switch (ID) {
            case INVENTORY: {
                return inventorySetup.getInventory();
            }
            case EQUIPMENT: {
                return inventorySetup.getEquipment();
            }
            case RUNE_POUCH: {
                return inventorySetup.getRune_pouch();
            }
            case BOLT_POUCH: {
                return inventorySetup.getBoltPouch();
            }
        }
        assert (false) : "Invalid ID given";
        return null;
    }

    public boolean setupContainsItem(InventorySetup setup, int itemID) {
        if (this.additionalFilteredItemsHasItem(itemID = this.itemManager.canonicalize(itemID), setup.getAdditionalFilteredItems())) {
            return true;
        }
        if (setup.getRune_pouch() != null && this.containerContainsItem(itemID, setup.getRune_pouch())) {
            return true;
        }
        if (setup.getBoltPouch() != null && this.containerContainsItem(itemID, setup.getBoltPouch())) {
            return true;
        }
        return this.containerContainsItem(itemID, setup.getInventory()) || this.containerContainsItem(itemID, setup.getEquipment());
    }

    private boolean containerContainsItem(int itemID, List<InventorySetupsItem> setupContainer) {
        return this.containerContainsItem(itemID, setupContainer, true);
    }

    private boolean containerContainsItem(int itemID, List<InventorySetupsItem> setupContainer, boolean allowFuzzy) {
        itemID = this.itemManager.canonicalize(itemID);
        for (InventorySetupsItem item : setupContainer) {
            int setupItemId = this.itemManager.canonicalize(item.getId());
            if (this.getProcessedID(item.isFuzzy() && allowFuzzy, itemID) != this.getProcessedID(item.isFuzzy() && allowFuzzy, setupItemId)) continue;
            return true;
        }
        return false;
    }

    private int getProcessedID(boolean isFuzzy, int itemId) {
        if (isFuzzy) {
            return InventorySetupsVariationMapping.map(itemId);
        }
        return itemId;
    }

    private boolean checkAndUpdateSlotIfRunePouchWasSelected(InventorySetup inventorySetup, InventorySetupsSlotID ID, InventorySetupsItem oldItem, InventorySetupsItem newItem) {
        return this.checkAndUpdateSlotIfRunePouchWasSelected(inventorySetup, ID, oldItem, newItem, true);
    }

    private boolean checkAndUpdateSlotIfRunePouchWasSelected(InventorySetup inventorySetup, InventorySetupsSlotID ID, InventorySetupsItem oldItem, InventorySetupsItem newItem, boolean showMessageDialogue) {
        InventorySetupsRunePouchType runePouchTypeNewItem = this.getRunePouchType(newItem.getId());
        InventorySetupsRunePouchType runePouchTypeOldItem = this.getRunePouchType(oldItem.getId());
        if (runePouchTypeNewItem != InventorySetupsRunePouchType.NONE) {
            if (ID != InventorySetupsSlotID.INVENTORY) {
                if (showMessageDialogue) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog((Component)((Object)this.panel), "You can't have a Rune Pouch there.", "Invalid Item", 0));
                }
                return false;
            }
            if (inventorySetup.getRune_pouch() != null && runePouchTypeOldItem == InventorySetupsRunePouchType.NONE) {
                if (showMessageDialogue) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog((Component)((Object)this.panel), "You can't have two Rune Pouches.", "Invalid Item", 0));
                }
                return false;
            }
            inventorySetup.updateRunePouch(this.getRunePouchData(runePouchTypeNewItem));
        } else if (runePouchTypeOldItem != InventorySetupsRunePouchType.NONE) {
            inventorySetup.updateRunePouch(null);
        }
        return true;
    }

    private boolean checkAndUpdateSlotIfBoltPouchWasSelected(InventorySetup inventorySetup, InventorySetupsSlotID ID, InventorySetupsItem oldItem, InventorySetupsItem newItem) {
        return this.checkAndUpdateSlotIfBoltPouchWasSelected(inventorySetup, ID, oldItem, newItem, true);
    }

    private boolean checkAndUpdateSlotIfBoltPouchWasSelected(InventorySetup inventorySetup, InventorySetupsSlotID ID, InventorySetupsItem oldItem, InventorySetupsItem newItem, boolean showMessageDialogue) {
        if (this.isItemBoltPouch(newItem.getId())) {
            if (ID != InventorySetupsSlotID.INVENTORY) {
                if (showMessageDialogue) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog((Component)((Object)this.panel), "You can't have a Bolt Pouch there.", "Invalid Item", 0));
                }
                return false;
            }
            if (inventorySetup.getBoltPouch() != null && !this.isItemBoltPouch(oldItem.getId())) {
                if (showMessageDialogue) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog((Component)((Object)this.panel), "You can't have two Bolt Pouches.", "Invalid Item", 0));
                }
                return false;
            }
            inventorySetup.updateBoltPouch(this.getBoltPouchData());
        } else if (this.isItemBoltPouch(oldItem.getId())) {
            inventorySetup.updateBoltPouch(null);
        }
        return true;
    }

    public InventorySetupsRunePouchType getRunePouchType(int itemId) {
        if (InventorySetupsRunePouchPanel.RUNE_POUCH_IDS.contains(itemId)) {
            return InventorySetupsRunePouchType.NORMAL;
        }
        if (InventorySetupsRunePouchPanel.RUNE_POUCH_DIVINE_IDS.contains(itemId)) {
            return InventorySetupsRunePouchType.DIVINE;
        }
        return InventorySetupsRunePouchType.NONE;
    }

    public boolean isItemBoltPouch(int itemId) {
        return itemId == 9433;
    }

    public InventorySetupsRunePouchType getRunePouchTypeFromContainer(List<InventorySetupsItem> container) {
        for (Integer id : InventorySetupsRunePouchPanel.RUNE_POUCH_IDS) {
            if (!this.containerContainsItem(id, container, false)) continue;
            return InventorySetupsRunePouchType.NORMAL;
        }
        for (Integer id : InventorySetupsRunePouchPanel.RUNE_POUCH_DIVINE_IDS) {
            if (!this.containerContainsItem(id, container, false)) continue;
            return InventorySetupsRunePouchType.DIVINE;
        }
        return InventorySetupsRunePouchType.NONE;
    }

    public boolean containerContainsBoltPouch(List<InventorySetupsItem> container) {
        return this.containerContainsItem(9433, container, false);
    }

    public void openColorPicker(String title, Color startingColor, Consumer<Color> onColorChange) {
        RuneliteColorPicker colorPicker = this.getColorPickerManager().create(SwingUtilities.windowForComponent((Component)((Object)this.panel)), startingColor, title, false);
        colorPicker.setLocation(this.panel.getLocationOnScreen());
        colorPicker.setOnColorChange(onColorChange);
        colorPicker.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                InventorySetupsPlugin.this.dataManager.updateConfig(true, true);
            }
        });
        colorPicker.setVisible(true);
    }

    public void updateSetupName(InventorySetup setup, String newName) {
        String originalName = setup.getName();
        for (InventorySetupsSection section : this.sections) {
            if (!this.cache.getSectionSetupsMap().get(section.getName()).containsKey(originalName)) continue;
            List<String> names = section.getSetups();
            int indexOf = names.indexOf(originalName);
            names.set(indexOf, newName);
        }
        this.cache.updateSetupName(setup, newName);
        setup.setName(newName);
    }

    public void updateSectionName(InventorySetupsSection section, String newName) {
        this.cache.updateSectionName(section, newName);
        section.setName(newName);
    }

    public Client getClient() {
        return this.client;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public SpriteManager getSpriteManager() {
        return this.spriteManager;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public InventorySetupsConfig getConfig() {
        return this.config;
    }

    public ColorPickerManager getColorPickerManager() {
        return this.colorPickerManager;
    }

    public List<InventorySetup> getInventorySetups() {
        return this.inventorySetups;
    }

    public List<InventorySetupsSection> getSections() {
        return this.sections;
    }

    public InventorySetupsCache getCache() {
        return this.cache;
    }

    public ChatboxItemSearch getItemSearch() {
        return this.itemSearch;
    }

    public InventorySetupsPersistentDataManager getDataManager() {
        return this.dataManager;
    }

    public void setBankFilteringMode(InventorySetupsFilteringModeID bankFilteringMode) {
        this.bankFilteringMode = bankFilteringMode;
    }

    public InventorySetupsFilteringModeID getBankFilteringMode() {
        return this.bankFilteringMode;
    }
}

