/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupUtilities;
import inventorysetups.InventorySetupsCache;
import inventorysetups.InventorySetupsItem;
import inventorysetups.InventorySetupsPlugin;
import inventorysetups.InventorySetupsRunePouchType;
import inventorysetups.InventorySetupsSection;
import inventorysetups.serialization.InventorySetupItemSerializable;
import inventorysetups.serialization.InventorySetupItemSerializableTypeAdapter;
import inventorysetups.serialization.InventorySetupSerializable;
import inventorysetups.serialization.LongTypeAdapter;
import inventorysetups.ui.InventorySetupsPluginPanel;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import joptsimple.internal.Strings;
import net.runelite.client.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventorySetupsPersistentDataManager {
    private static final Logger log = LoggerFactory.getLogger(InventorySetupsPersistentDataManager.class);
    private final InventorySetupsPlugin plugin;
    private final InventorySetupsPluginPanel panel;
    private final ConfigManager configManager;
    private final InventorySetupsCache cache;
    private Gson gson;
    private final List<InventorySetup> inventorySetups;
    private final List<InventorySetupsSection> sections;
    public static final String CONFIG_KEY_SETUPS_MIGRATED_V2 = "migratedV2";
    public static final String CONFIG_KEY_SETUPS = "setups";
    public static final String CONFIG_KEY_SETUPS_V2 = "setupsV2";
    public static final String CONFIG_KEY_SECTIONS = "sections";

    @Inject
    public InventorySetupsPersistentDataManager(InventorySetupsPlugin plugin, InventorySetupsPluginPanel panel, ConfigManager manager, InventorySetupsCache cache, Gson gson, List<InventorySetup> inventorySetups, List<InventorySetupsSection> sections) {
        this.plugin = plugin;
        this.panel = panel;
        this.configManager = manager;
        this.cache = cache;
        this.gson = gson;
        this.inventorySetups = inventorySetups;
        this.sections = sections;
        this.gson = this.gson.newBuilder().registerTypeAdapter(Long.TYPE, (Object)new LongTypeAdapter()).create();
        this.gson = this.gson.newBuilder().registerTypeAdapter(InventorySetupItemSerializable.class, (Object)new InventorySetupItemSerializableTypeAdapter()).create();
    }

    public void loadConfig() {
        this.inventorySetups.clear();
        this.sections.clear();
        this.cache.clearAll();
        this.handleMigrationOfOldData();
        Type setupTypeV2 = new TypeToken<ArrayList<InventorySetupSerializable>>(){}.getType();
        ArrayList issList = new ArrayList(this.loadData(CONFIG_KEY_SETUPS_V2, setupTypeV2));
        for (InventorySetupSerializable iss : issList) {
            this.inventorySetups.add(InventorySetupSerializable.convertToInventorySetup(iss));
        }
        this.processSetupsFromConfig();
        Type sectionType = new TypeToken<ArrayList<InventorySetupsSection>>(){}.getType();
        this.sections.addAll(this.loadData(CONFIG_KEY_SECTIONS, sectionType));
        for (InventorySetupsSection section : this.sections) {
            String newName = InventorySetupUtilities.findNewName(section.getName(), this.cache.getSectionNames().keySet());
            section.setName(newName);
            List<String> uniqueSetups = section.getSetups().stream().distinct().collect(Collectors.toList());
            section.setSetups(uniqueSetups);
            section.getSetups().removeIf(s -> !this.cache.getInventorySetupNames().containsKey(s));
            this.cache.addSection(section);
        }
    }

    public void updateConfig(boolean updateSetups, boolean updateSections) {
        if (updateSetups) {
            ArrayList<InventorySetupSerializable> issList = new ArrayList<InventorySetupSerializable>();
            for (InventorySetup setup : this.inventorySetups) {
                issList.add(InventorySetupSerializable.convertFromInventorySetup(setup));
            }
            String data = this.gson.toJson(issList);
            this.configManager.setConfiguration("inventorysetups", CONFIG_KEY_SETUPS_V2, data);
        }
        if (updateSections) {
            String jsonSections = this.gson.toJson(this.sections);
            this.configManager.setConfiguration("inventorysetups", CONFIG_KEY_SECTIONS, jsonSections);
        }
    }

    private <T> List<T> loadData(String configKey, Type type) {
        String storedData = this.configManager.getConfiguration("inventorysetups", configKey);
        if (Strings.isNullOrEmpty((String)storedData)) {
            return new ArrayList();
        }
        try {
            return (List)this.gson.fromJson(storedData, type);
        }
        catch (Exception e) {
            log.error("Exception occurred while loading data", (Throwable)e);
            return new ArrayList();
        }
    }

    private void processSetupsFromConfig() {
        for (InventorySetup setup : this.inventorySetups) {
            InventorySetupsRunePouchType runePouchType = this.plugin.getRunePouchTypeFromContainer(setup.getInventory());
            if (setup.getRune_pouch() == null && runePouchType != InventorySetupsRunePouchType.NONE) {
                setup.updateRunePouch(this.plugin.getRunePouchData(runePouchType));
            }
            if (setup.getBoltPouch() == null && this.plugin.containerContainsBoltPouch(setup.getInventory())) {
                setup.updateBoltPouch(this.plugin.getBoltPouchData());
            }
            if (setup.getNotes() == null) {
                setup.updateNotes("");
            }
            if (setup.getAdditionalFilteredItems() == null) {
                setup.updateAdditionalItems(new HashMap<Integer, InventorySetupsItem>());
            }
            String newName = InventorySetupUtilities.findNewName(setup.getName(), this.cache.getInventorySetupNames().keySet());
            setup.setName(newName);
            this.cache.addSetup(setup);
            this.addItemNames(setup.getInventory());
            this.addItemNames(setup.getEquipment());
            this.addItemNames(setup.getRune_pouch());
            this.addItemNames(setup.getBoltPouch());
            for (Integer key : setup.getAdditionalFilteredItems().keySet()) {
                this.addItemName(setup.getAdditionalFilteredItems().get(key));
            }
        }
    }

    private void addItemNames(List<InventorySetupsItem> items) {
        if (items != null) {
            for (InventorySetupsItem item : items) {
                this.addItemName(item);
            }
        }
    }

    private void addItemName(InventorySetupsItem item) {
        item.setName(this.plugin.getItemManager().getItemComposition(item.getId()).getName());
    }

    private void handleMigrationOfOldData() {
        String hasMigratedToV2 = this.configManager.getConfiguration("inventorysetups", CONFIG_KEY_SETUPS_MIGRATED_V2);
        if (Strings.isNullOrEmpty((String)hasMigratedToV2)) {
            log.info("Migrating data to V2");
            Type setupType = new TypeToken<ArrayList<InventorySetup>>(){}.getType();
            this.inventorySetups.addAll(this.loadData(CONFIG_KEY_SETUPS, setupType));
            this.updateConfig(true, false);
            this.inventorySetups.clear();
            this.configManager.setConfiguration("inventorysetups", CONFIG_KEY_SETUPS_MIGRATED_V2, "True");
        }
    }

    private String fixOldJSONData(String json) {
        JsonElement je = (JsonElement)this.gson.fromJson(json, JsonElement.class);
        JsonArray ja = je.getAsJsonArray();
        for (JsonElement elem : ja) {
            JsonObject jsonObject = elem.getAsJsonObject();
        }
        return je.toString();
    }
}

