/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups;

import inventorysetups.InventorySetup;
import inventorysetups.InventorySetupsSection;
import java.util.HashMap;
import java.util.Map;

public class InventorySetupsCache {
    private final Map<String, InventorySetup> inventorySetupNames = new HashMap<String, InventorySetup>();
    private final Map<String, InventorySetupsSection> sectionNames = new HashMap<String, InventorySetupsSection>();
    private final Map<String, Map<String, InventorySetupsSection>> setupSectionsMap = new HashMap<String, Map<String, InventorySetupsSection>>();
    private final Map<String, Map<String, InventorySetup>> sectionSetupsMap = new HashMap<String, Map<String, InventorySetup>>();

    public void addSetup(InventorySetup setup) {
        this.inventorySetupNames.put(setup.getName(), setup);
        this.setupSectionsMap.put(setup.getName(), new HashMap());
    }

    public void addSection(InventorySetupsSection section) {
        this.sectionNames.put(section.getName(), section);
        this.sectionSetupsMap.put(section.getName(), new HashMap());
        for (String setupName : section.getSetups()) {
            this.addSetupToSection(section, this.inventorySetupNames.get(setupName));
        }
    }

    public void updateSetupName(InventorySetup setup, String newName) {
        this.inventorySetupNames.remove(setup.getName());
        this.inventorySetupNames.put(newName, setup);
        for (String sectionName : this.sectionSetupsMap.keySet()) {
            if (!this.sectionSetupsMap.get(sectionName).containsKey(setup.getName())) continue;
            this.sectionSetupsMap.get(sectionName).remove(setup.getName());
            this.sectionSetupsMap.get(sectionName).put(newName, setup);
        }
        this.setupSectionsMap.put(newName, this.setupSectionsMap.remove(setup.getName()));
    }

    public void updateSectionName(InventorySetupsSection section, String newName) {
        this.sectionNames.remove(section.getName());
        this.sectionNames.put(newName, section);
        for (String setupName : this.setupSectionsMap.keySet()) {
            if (!this.setupSectionsMap.get(setupName).containsKey(section.getName())) continue;
            this.setupSectionsMap.get(setupName).remove(section.getName());
            this.setupSectionsMap.get(setupName).put(newName, section);
        }
        this.sectionSetupsMap.put(newName, this.sectionSetupsMap.remove(section.getName()));
    }

    public void removeSetup(InventorySetup setup) {
        this.inventorySetupNames.remove(setup.getName());
        this.setupSectionsMap.remove(setup.getName());
        for (String sectionName : this.sectionSetupsMap.keySet()) {
            this.sectionSetupsMap.get(sectionName).remove(setup.getName());
        }
    }

    public void removeSection(InventorySetupsSection section) {
        this.sectionNames.remove(section.getName());
        this.sectionSetupsMap.remove(section.getName());
        for (String setupName : section.getSetups()) {
            this.setupSectionsMap.get(setupName).remove(section.getName());
        }
    }

    public void addSetupToSection(InventorySetupsSection section, InventorySetup setup) {
        this.setupSectionsMap.get(setup.getName()).put(section.getName(), section);
        this.sectionSetupsMap.get(section.getName()).put(setup.getName(), setup);
    }

    public void removeSetupFromSection(InventorySetupsSection section, InventorySetup setup) {
        this.setupSectionsMap.get(setup.getName()).remove(section.getName());
        this.sectionSetupsMap.get(section.getName()).remove(setup.getName());
    }

    public void clearAll() {
        this.inventorySetupNames.clear();
        this.sectionNames.clear();
        this.setupSectionsMap.clear();
        this.sectionSetupsMap.clear();
    }

    public Map<String, InventorySetup> getInventorySetupNames() {
        return this.inventorySetupNames;
    }

    public Map<String, InventorySetupsSection> getSectionNames() {
        return this.sectionNames;
    }

    public Map<String, Map<String, InventorySetupsSection>> getSetupSectionsMap() {
        return this.setupSectionsMap;
    }

    public Map<String, Map<String, InventorySetup>> getSectionSetupsMap() {
        return this.sectionSetupsMap;
    }
}

