/*
 * Decompiled with CFR 0.152.
 */
package inventorysetups;

import java.awt.Component;
import java.awt.Container;
import java.util.Set;
import javax.swing.SwingUtilities;
import net.runelite.client.util.SwingUtil;

public class InventorySetupUtilities {
    private InventorySetupUtilities() {
    }

    public static int parseTextInputAmount(String input) {
        if (input.length() > 10) {
            return Integer.MAX_VALUE;
        }
        input = input.toLowerCase();
        char finalChar = input.charAt(input.length() - 1);
        int factor = 1;
        if (Character.isLetter(finalChar)) {
            input = input.substring(0, input.length() - 1);
            switch (finalChar) {
                case 'k': {
                    factor = 1000;
                    break;
                }
                case 'm': {
                    factor = 1000000;
                    break;
                }
                case 'b': {
                    factor = 1000000000;
                }
            }
        }
        long quantityLong = Long.parseLong(input) * (long)factor;
        int quantity = (int)Math.min(quantityLong, Integer.MAX_VALUE);
        quantity = Math.max(quantity, 1);
        return quantity;
    }

    public static String findNewName(String originalName, Set<String> objects) {
        if (originalName.length() > 50) {
            originalName = originalName.substring(0, 50);
        }
        Object newName = originalName;
        int i = 1;
        while (objects.contains(newName) || ((String)newName).isEmpty()) {
            String i_str = String.valueOf(i);
            if (originalName.length() + i_str.length() > 50) {
                int chars_to_cut_off = i_str.length() - (50 - originalName.length());
                newName = originalName.substring(0, 50 - chars_to_cut_off) + i++;
                continue;
            }
            newName = originalName + i++;
        }
        return newName;
    }

    public static void fastRemoveAll(Container c) {
        InventorySetupUtilities.fastRemoveAll(c, true);
    }

    private static void fastRemoveAll(Container c, boolean isMainParent) {
        assert (SwingUtilities.isEventDispatchThread());
        c.invalidate();
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component ic = c.getComponent(i);
            if (ic instanceof Container) {
                InventorySetupUtilities.fastRemoveAll((Container)ic, false);
            }
            SwingUtil.pumpPendingEvents();
            ic.removeNotify();
        }
        if (isMainParent) {
            c.removeAll();
        }
    }
}

