/*
 * Decompiled with CFR 0.152.
 */
package com.gauntletmap;

import com.gauntletmap.GauntletMapConfig;
import com.gauntletmap.GauntletMapPanel;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Gauntlet Map")
public class GauntletMapPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GauntletMapPlugin.class);
    @Inject
    private Client client;
    @Inject
    private GauntletMapConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton navButton;
    private GauntletMapPanel panel;
    private boolean firstLoad = true;
    private boolean corrupted;
    private boolean demiBoss;
    private String attackStyle;
    private Integer demiBossRoom;
    private Map<Integer, WorldPoint> centerTileMap;
    private Map<Integer, List<WorldPoint>> roomTilesMap;
    private Map<Integer, List<Integer>> connectedRoomsMap;
    private List<Integer> activeDemiBossRooms = new ArrayList<Integer>();
    private Integer startLocation;
    private Integer currentRoom;
    private static final int TILE_DISTANCE = 16;

    protected void startUp() throws Exception {
        this.panel = (GauntletMapPanel)((Object)this.injector.getInstance(GauntletMapPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(GauntletMapPlugin.class, (String)"hunllef_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Gauntlet Map").icon(icon).priority(99).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        if (!this.client.isInInstancedRegion()) {
            return;
        }
        if (npcSpawned.getNpc().getId() == 9035 || npcSpawned.getNpc().getId() == 9021) {
            if (npcSpawned.getNpc().getId() == 9035) {
                this.setCorrupted(true);
            }
            WorldPoint hunllef = npcSpawned.getActor().getWorldLocation();
            WorldPoint player = this.client.getLocalPlayer().getWorldLocation();
            this.setStartLocation(this.calculateActivatedRoom(player, hunllef));
            this.setCurrentRoom(this.getStartLocation());
            this.createInstanceMaps(player);
            this.panel.updateStartingTiles();
        }
        if (npcSpawned.getNpc().getId() == 9047 || npcSpawned.getNpc().getId() == 9033 || npcSpawned.getNpc().getId() == 9048 || npcSpawned.getNpc().getId() == 9034 || npcSpawned.getNpc().getId() == 9046 || npcSpawned.getNpc().getId() == 9032) {
            WorldPoint player = this.client.getLocalPlayer().getWorldLocation();
            this.setDemiBoss(true);
            this.setDemiBossRoom(this.calculateActivatedRoom(player, this.getCenterTileMap().get(this.getCurrentRoom())));
            this.getActiveDemiBossRooms().add(this.getDemiBossRoom());
            switch (npcSpawned.getNpc().getId()) {
                case 9033: 
                case 9047: {
                    this.setAttackStyle("magic");
                    break;
                }
                case 9034: 
                case 9048: {
                    this.setAttackStyle("ranged");
                    break;
                }
                case 9032: 
                case 9046: {
                    this.setAttackStyle("melee");
                }
            }
            this.panel.addNewActiveTile(this.calculateActivatedRoom(player, this.getCenterTileMap().get(this.getCurrentRoom())));
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        if (npcDespawned.getNpc().getId() == 9047 || npcDespawned.getNpc().getId() == 9033 || npcDespawned.getNpc().getId() == 9048 || npcDespawned.getNpc().getId() == 9034 || npcDespawned.getNpc().getId() == 9046 || npcDespawned.getNpc().getId() == 9032) {
            this.setDemiBoss(false);
            WorldPoint npc = npcDespawned.getNpc().getWorldLocation();
            for (int room : this.getActiveDemiBossRooms()) {
                if (!this.getRoomTilesMap().get(room).contains(npc) || this.getRoomTilesMap().get(room).contains(this.client.getLocalPlayer().getWorldLocation())) continue;
                this.panel.addNewActiveTile(room);
                return;
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOADING && !this.client.isInInstancedRegion() && !this.firstLoad) {
            this.setFirstLoad(true);
            this.setCorrupted(false);
            this.setStartLocation(null);
            this.setCurrentRoom(null);
            this.setCenterTileMap(null);
            this.setConnectedRoomsMap(null);
            this.setRoomTilesMap(null);
            this.setDemiBoss(false);
            this.setAttackStyle("");
            this.panel.clearMapTiles();
            return;
        }
        if (gameStateChanged.getGameState() == GameState.LOADING && this.client.isInInstancedRegion() && this.firstLoad) {
            this.setFirstLoad(false);
            return;
        }
        if (gameStateChanged.getGameState() == GameState.LOADING && this.client.isInInstancedRegion() && !this.firstLoad) {
            int activatedRoom = this.calculateActivatedRoom(this.client.getLocalPlayer().getWorldLocation(), this.getCenterTileMap().get(this.getCurrentRoom()));
            this.panel.addNewActiveTile(activatedRoom);
        }
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.panel.clearMapTiles();
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (!this.client.isInInstancedRegion()) {
            return;
        }
        this.updateCurrentRoom(this.client.getLocalPlayer().getWorldLocation());
    }

    private Integer calculateActivatedRoom(WorldPoint player, WorldPoint target) {
        Integer difference = Math.abs(player.getY() - target.getY()) > Math.abs(player.getX() - target.getX()) ? (player.getY() > target.getY() ? Integer.valueOf(-7) : Integer.valueOf(7)) : (player.getX() > target.getX() ? Integer.valueOf(1) : Integer.valueOf(-1));
        if (this.getCurrentRoom() == null) {
            this.setCurrentRoom(25);
        }
        return this.getCurrentRoom() + difference;
    }

    private void createInstanceMaps(WorldPoint playerLocation) {
        WorldPoint northWestCornerRoom = null;
        TreeMap<Integer, WorldPoint> centerTileMap = new TreeMap<Integer, WorldPoint>();
        TreeMap<Integer, List<WorldPoint>> roomTilesMap = new TreeMap<Integer, List<WorldPoint>>();
        TreeMap<Integer, List<Integer>> connectedRoomsMap = new TreeMap<Integer, List<Integer>>();
        switch (this.getStartLocation()) {
            case 18: {
                northWestCornerRoom = this.calculateNewPoint(playerLocation, -3, 2, -3, -2);
                break;
            }
            case 26: {
                northWestCornerRoom = this.calculateNewPoint(playerLocation, -4, 3, -3, -2);
                break;
            }
            case 32: {
                northWestCornerRoom = this.calculateNewPoint(playerLocation, -3, 4, -3, -2);
                break;
            }
            case 24: {
                northWestCornerRoom = this.calculateNewPoint(playerLocation, -2, 3, -3, -2);
            }
        }
        for (int i = 0; i <= 6; ++i) {
            for (int j = 0; j <= 6; ++j) {
                WorldPoint centerTile = this.calculateNewPoint(northWestCornerRoom, j, -i, 0, 0);
                WorldPoint northWestCornerTile = this.calculateNewPoint(centerTile, 0, 0, -6, 5);
                ArrayList<WorldPoint> roomTiles = new ArrayList<WorldPoint>();
                ArrayList<Integer> connectedRoomsList = new ArrayList<Integer>();
                int room = i * 7 + j + 1;
                for (int k = 0; k <= 11; ++k) {
                    for (int l = 0; l <= 11; ++l) {
                        roomTiles.add(this.calculateNewPoint(northWestCornerTile, 0, 0, l, -k));
                    }
                }
                for (int m = 0; m <= 1; ++m) {
                    for (int n = 0; n <= 1; ++n) {
                        roomTiles.add(this.calculateNewPoint(centerTile, 0, 0, -n, 7 - m));
                        roomTiles.add(this.calculateNewPoint(centerTile, 0, 0, 7 - n, -m));
                        roomTiles.add(this.calculateNewPoint(centerTile, 0, 0, -n, -7 - m));
                        roomTiles.add(this.calculateNewPoint(centerTile, 0, 0, -7 - n, -m));
                    }
                }
                if (room == 1 || room == 7 || room == 43 || room == 49) {
                    switch (room) {
                        case 1: {
                            connectedRoomsList.addAll(Arrays.asList(2, 8));
                            break;
                        }
                        case 7: {
                            connectedRoomsList.addAll(Arrays.asList(6, 14));
                            break;
                        }
                        case 43: {
                            connectedRoomsList.addAll(Arrays.asList(36, 44));
                            break;
                        }
                        case 49: {
                            connectedRoomsList.addAll(Arrays.asList(42, 48));
                        }
                    }
                } else if (room % 7 == 1) {
                    connectedRoomsList.addAll(Arrays.asList(room - 7, room + 1, room + 7));
                } else if (room % 7 == 0) {
                    connectedRoomsList.addAll(Arrays.asList(room - 7, room - 1, room + 7));
                } else if (room > 1 && room < 7) {
                    connectedRoomsList.addAll(Arrays.asList(room - 1, room + 1, room + 7));
                } else if (room > 43 && room < 49) {
                    connectedRoomsList.addAll(Arrays.asList(room - 7, room - 1, room + 1));
                } else {
                    connectedRoomsList.addAll(Arrays.asList(room - 7, room - 1, room + 1, room + 7));
                }
                centerTileMap.put(room, centerTile);
                roomTilesMap.put(room, roomTiles);
                connectedRoomsMap.put(room, connectedRoomsList);
            }
        }
        this.setCenterTileMap(centerTileMap);
        this.setRoomTilesMap(roomTilesMap);
        this.setConnectedRoomsMap(connectedRoomsMap);
    }

    private WorldPoint calculateNewPoint(WorldPoint startPoint, Integer roomsX, Integer roomsY, Integer tilesX, Integer tilesY) {
        WorldPoint newPoint = new WorldPoint(startPoint.getX() + roomsX * 16 + tilesX, startPoint.getY() + roomsY * 16 + tilesY, startPoint.getPlane());
        return newPoint;
    }

    private void updateCurrentRoom(WorldPoint playerLocation) {
        if (this.getRoomTilesMap().get(this.getCurrentRoom()).contains(playerLocation)) {
            return;
        }
        if (this.getRoomTilesMap().get(this.getStartLocation()).contains(playerLocation)) {
            int previousRoom = this.getCurrentRoom();
            this.setCurrentRoom(this.getStartLocation());
            this.panel.updatePlayerIcon(previousRoom);
            return;
        }
        for (Integer connectedRoom : this.getConnectedRoomsMap().get(this.getCurrentRoom())) {
            if (!this.getRoomTilesMap().get(connectedRoom).contains(playerLocation)) continue;
            int previousRoom = this.getCurrentRoom();
            this.setCurrentRoom(connectedRoom);
            this.panel.updatePlayerIcon(previousRoom);
        }
    }

    @Provides
    GauntletMapConfig provideConfig(ConfigManager configManager) {
        return (GauntletMapConfig)configManager.getConfig(GauntletMapConfig.class);
    }

    public boolean isFirstLoad() {
        return this.firstLoad;
    }

    public void setFirstLoad(boolean firstLoad) {
        this.firstLoad = firstLoad;
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }

    public void setCorrupted(boolean corrupted) {
        this.corrupted = corrupted;
    }

    public boolean isDemiBoss() {
        return this.demiBoss;
    }

    public void setDemiBoss(boolean demiBoss) {
        this.demiBoss = demiBoss;
    }

    public String getAttackStyle() {
        return this.attackStyle;
    }

    public void setAttackStyle(String attackStyle) {
        this.attackStyle = attackStyle;
    }

    public Integer getDemiBossRoom() {
        return this.demiBossRoom;
    }

    public void setDemiBossRoom(Integer demiBossRoom) {
        this.demiBossRoom = demiBossRoom;
    }

    public Map<Integer, WorldPoint> getCenterTileMap() {
        return this.centerTileMap;
    }

    public void setCenterTileMap(Map<Integer, WorldPoint> centerTileMap) {
        this.centerTileMap = centerTileMap;
    }

    public Map<Integer, List<WorldPoint>> getRoomTilesMap() {
        return this.roomTilesMap;
    }

    public void setRoomTilesMap(Map<Integer, List<WorldPoint>> roomTilesMap) {
        this.roomTilesMap = roomTilesMap;
    }

    public Map<Integer, List<Integer>> getConnectedRoomsMap() {
        return this.connectedRoomsMap;
    }

    public void setConnectedRoomsMap(Map<Integer, List<Integer>> connectedRoomsMap) {
        this.connectedRoomsMap = connectedRoomsMap;
    }

    public List<Integer> getActiveDemiBossRooms() {
        return this.activeDemiBossRooms;
    }

    public void setActiveDemiBossRooms(List<Integer> activeDemiBossRooms) {
        this.activeDemiBossRooms = activeDemiBossRooms;
    }

    public Integer getStartLocation() {
        return this.startLocation;
    }

    public void setStartLocation(Integer startLocation) {
        this.startLocation = startLocation;
    }

    public Integer getCurrentRoom() {
        return this.currentRoom;
    }

    public void setCurrentRoom(Integer currentRoom) {
        this.currentRoom = currentRoom;
    }
}

