/*
 * Decompiled with CFR 0.152.
 */
package com.gauntletmap;

import com.gauntletmap.GauntletMapConfig;
import com.gauntletmap.GauntletMapPlugin;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

public class GauntletMapPanel
extends PluginPanel {
    @Inject
    private GauntletMapConfig config;
    private BufferedImage hunllef;
    private BufferedImage player;
    private BufferedImage startRoom;
    private Map<Integer, String> tileTypeMap;
    private GauntletMapPlugin plugin;

    @Inject
    GauntletMapPanel(GauntletMapPlugin plugin) {
        this.setPlugin(plugin);
        this.createTileTypeMap();
        this.clearMapTiles();
    }

    public void clearMapTiles() {
        SwingUtilities.invokeLater(() -> {
            this.removeAll();
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            for (int y = 0; y <= 6; ++y) {
                for (int x = 0; x <= 6; ++x) {
                    c.gridx = x;
                    c.gridy = y;
                    int room = y * 7 + x + 1;
                    String path = "inactive" + this.getTileTypeMap().get(room);
                    BufferedImage tile = ImageUtil.loadImageResource(GauntletMapPlugin.class, (String)path);
                    this.add(new JLabel(new ImageIcon(tile)), c);
                }
            }
            this.revalidate();
            this.repaint();
        });
    }

    public void updateStartingTiles() {
        SwingUtilities.invokeLater(() -> {
            if (this.config.showDemiBosses()) {
                this.updatePanel(3, false, false, true);
                this.updatePanel(4, false, false, true);
                this.updatePanel(5, false, false, true);
                this.updatePanel(15, false, false, true);
                this.updatePanel(22, false, false, true);
                this.updatePanel(29, false, false, true);
                this.updatePanel(21, false, false, true);
                this.updatePanel(28, false, false, true);
                this.updatePanel(35, false, false, true);
                this.updatePanel(45, false, false, true);
                this.updatePanel(46, false, false, true);
                this.updatePanel(47, false, false, true);
            }
            this.updatePanel(25, false, true, false);
            this.updatePanel(this.plugin.getStartLocation(), true, false, false);
            this.revalidate();
            this.repaint();
        });
    }

    public void updatePlayerIcon(Integer previousRoom) {
        SwingUtilities.invokeLater(() -> {
            this.updatePanel(previousRoom, false, false, false);
            this.updatePanel(this.plugin.getCurrentRoom(), true, false, false);
            this.revalidate();
            this.repaint();
        });
    }

    public void addNewActiveTile(Integer newRoom) {
        SwingUtilities.invokeLater(() -> {
            this.updatePanel(newRoom, false, false, false);
            this.revalidate();
            this.repaint();
        });
    }

    private void updatePanel(Integer room, boolean playerIcon, boolean bossIcon, boolean demiIcon) {
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        Component toRemove = this.getComponent(room - 1);
        GridBagConstraints c = layout.getConstraints(toRemove);
        this.remove(toRemove);
        String type = "regular/";
        if (this.plugin.isCorrupted()) {
            type = "corrupted/";
        }
        if (playerIcon) {
            String path = type + "player" + this.tileTypeMap.get(room);
            if (room == this.plugin.getStartLocation()) {
                path = type + "player_start.png";
            }
            BufferedImage player = ImageUtil.loadImageResource(GauntletMapPlugin.class, (String)path);
            this.add(new JLabel(new ImageIcon(player)), c, room - 1);
            return;
        }
        if (bossIcon) {
            String path = type + "hunllef" + this.tileTypeMap.get(room);
            BufferedImage hunllef = ImageUtil.loadImageResource(GauntletMapPlugin.class, (String)path);
            this.add(new JLabel(new ImageIcon(hunllef)), c, room - 1);
            return;
        }
        if (room == this.plugin.getStartLocation()) {
            String path = type + "start_room.png";
            BufferedImage startRoom = ImageUtil.loadImageResource(GauntletMapPlugin.class, (String)path);
            this.add(new JLabel(new ImageIcon(startRoom)), c, room - 1);
            return;
        }
        if (this.plugin.isDemiBoss() && room == this.plugin.getDemiBossRoom()) {
            String path = "demiboss/" + this.plugin.getAttackStyle() + this.tileTypeMap.get(room);
            BufferedImage startRoom = ImageUtil.loadImageResource(GauntletMapPlugin.class, (String)path);
            this.add(new JLabel(new ImageIcon(startRoom)), c, room - 1);
            return;
        }
        if (this.config.showDemiBosses() && demiIcon) {
            String path = type + "demi" + this.getTileTypeMap().get(room);
            BufferedImage demiRoom = ImageUtil.loadImageResource(GauntletMapPlugin.class, (String)path);
            this.add(new JLabel(new ImageIcon(demiRoom)), c, room - 1);
            return;
        }
        String tile = this.plugin.isFirstLoad() ? "inactive" : "active";
        BufferedImage mapTile = ImageUtil.loadImageResource(GauntletMapPlugin.class, (String)(tile + this.getTileTypeMap().get(room)));
        this.add(new JLabel(new ImageIcon(mapTile)), c, room - 1);
    }

    private void createTileTypeMap() {
        TreeMap<Integer, String> tileTypeMap = new TreeMap<Integer, String>();
        for (int i = 1; i <= 49; ++i) {
            if (i == 1 || i == 7 || i == 43 || i == 49) {
                switch (i) {
                    case 1: {
                        tileTypeMap.put(i, "_top_left.png");
                        break;
                    }
                    case 7: {
                        tileTypeMap.put(i, "_top_right.png");
                        break;
                    }
                    case 43: {
                        tileTypeMap.put(i, "_bottom_left.png");
                        break;
                    }
                    case 49: {
                        tileTypeMap.put(i, "_bottom_right.png");
                    }
                }
                continue;
            }
            if (i % 7 == 1) {
                tileTypeMap.put(i, "_left.png");
                continue;
            }
            if (i % 7 == 0) {
                tileTypeMap.put(i, "_right.png");
                continue;
            }
            if (i > 1 && i < 7) {
                tileTypeMap.put(i, "_top.png");
                continue;
            }
            if (i > 43 && i < 49) {
                tileTypeMap.put(i, "_bottom.png");
                continue;
            }
            tileTypeMap.put(i, ".png");
        }
        this.setTileTypeMap(tileTypeMap);
    }

    public BufferedImage getHunllef() {
        return this.hunllef;
    }

    public void setHunllef(BufferedImage hunllef) {
        this.hunllef = hunllef;
    }

    public BufferedImage getPlayer() {
        return this.player;
    }

    public void setPlayer(BufferedImage player) {
        this.player = player;
    }

    public BufferedImage getStartRoom() {
        return this.startRoom;
    }

    public void setStartRoom(BufferedImage startRoom) {
        this.startRoom = startRoom;
    }

    public Map<Integer, String> getTileTypeMap() {
        return this.tileTypeMap;
    }

    public void setTileTypeMap(Map<Integer, String> tileTypeMap) {
        this.tileTypeMap = tileTypeMap;
    }

    public GauntletMapPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(GauntletMapPlugin plugin) {
        this.plugin = plugin;
    }
}

