/*
 * Decompiled with CFR 0.152.
 */
package io.github.rbbi.plugin;

import com.google.inject.Provides;
import io.github.rbbi.plugin.SeaweedSporeNotifierConfig;
import javax.inject.Inject;
import net.runelite.api.TileItem;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Seaweed Spore Notifier")
public class SeaweedSporeNotifierPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SeaweedSporeNotifierPlugin.class);
    @Inject
    private Notifier notifier;
    @Inject
    private SeaweedSporeNotifierConfig config;

    @Provides
    SeaweedSporeNotifierConfig provideConfig(ConfigManager configManager) {
        return (SeaweedSporeNotifierConfig)configManager.getConfig(SeaweedSporeNotifierConfig.class);
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        if (item.getId() == 21490) {
            int sporeQuantity = item.getQuantity();
            if (sporeQuantity < this.config.minQuantity()) {
                return;
            }
            boolean singleSpore = sporeQuantity == 1;
            this.notifier.notify(sporeQuantity + " seaweed spore" + (singleSpore ? " " : "s ") + (singleSpore ? "has" : "have") + " spawned!");
        }
    }
}

