/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.donteatit;

import com.google.inject.Provides;
import io.hydrox.donteatit.DontEatItConfig;
import io.hydrox.donteatit.DontEatItOverlay;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.ClientTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;

@PluginDescriptor(name="Don't eat it!", description="Make every item that has a Use option have it as left click", tags={"swap", "swapper", "menu", "entry", "menu entry swapper", "use", "drink", "accident"})
public class DontEatItPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private DontEatItOverlay overlay;
    @Inject
    private OverlayManager overlayManager;

    @Provides
    DontEatItConfig provideConfig(ConfigManager configManager) {
        return (DontEatItConfig)configManager.getConfig(DontEatItConfig.class);
    }

    public void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        MenuEntry entry2;
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen() || this.client.isKeyPressed(81)) {
            return;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int useIndex = -1;
        int topIndex = menuEntries.length - 1;
        for (int i = 0; i < topIndex; ++i) {
            if (!Text.removeTags((String)menuEntries[i].getOption()).equals("Use")) continue;
            useIndex = i;
            break;
        }
        if (useIndex == -1) {
            return;
        }
        MenuEntry entry1 = menuEntries[useIndex];
        menuEntries[useIndex] = entry2 = menuEntries[topIndex];
        menuEntries[topIndex] = entry1;
        this.client.setMenuEntries(menuEntries);
    }
}

