/*
 * Decompiled with CFR 0.152.
 */
package io.robrichardson.skillsorganizer;

import com.google.inject.Provides;
import io.robrichardson.skillsorganizer.SkillOrganizerData;
import io.robrichardson.skillsorganizer.SkillWidgetGroup;
import io.robrichardson.skillsorganizer.SkillsOrganizerConfig;
import java.awt.Color;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Skills Organizer")
public class SkillsOrganizerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SkillsOrganizerPlugin.class);
    private static final int SCRIPTID_STATS_SKILLTOTAL = 396;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private SkillsOrganizerConfig config;
    private SkillWidgetGroup[] groups = new SkillWidgetGroup[SkillOrganizerData.values().length];

    protected void startUp() throws Exception {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invoke(this::setupSkillBars);
        }
    }

    protected void shutDown() throws Exception {
        this.clientThread.invoke(this::resetSkillBars);
    }

    @Provides
    SkillsOrganizerConfig provideConfig(ConfigManager configManager) {
        return (SkillsOrganizerConfig)configManager.getConfig(SkillsOrganizerConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"SkillsOrganizer".equals(event.getGroup())) {
            return;
        }
        this.clientThread.invoke(this::setupSkillBars);
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 396) {
            this.setupSkillBars();
        }
    }

    private void setupSkillBars() {
        Widget skillsContainer = this.client.getWidget(WidgetInfo.SKILLS_CONTAINER);
        if (skillsContainer == null) {
            return;
        }
        for (Widget skillTile : skillsContainer.getStaticChildren()) {
            int idx = WidgetInfo.TO_CHILD((int)skillTile.getId()) - 1;
            SkillOrganizerData skillOrganizerData = SkillOrganizerData.get(idx);
            if (skillOrganizerData == null) continue;
            SkillsOrganizerConfig.SkillPositionOption skillPositionConfig = skillOrganizerData.getSkillPositionConfig().apply(this.config);
            SkillsOrganizerConfig.SkillVisibilityOption skillVisibilityOption = skillOrganizerData.getSkillVisibilityConfig().apply(this.config);
            skillTile.setXPositionMode(0);
            skillTile.setYPositionMode(0);
            skillTile.setOriginalX(skillPositionConfig.getX());
            skillTile.setOriginalY(skillPositionConfig.getY());
            skillTile.revalidate();
            SkillWidgetGroup widgetGroup = this.groups[idx];
            if (widgetGroup == null) {
                widgetGroup = this.buildWidgetGroup(skillTile);
            }
            Widget leftWidget = widgetGroup.getLeft();
            Widget rightWidget = widgetGroup.getRight();
            Widget darkenWidget = widgetGroup.getDarken();
            if (skillVisibilityOption == SkillsOrganizerConfig.SkillVisibilityOption.HIDE) {
                skillTile.setHidden(true);
                leftWidget.setHidden(true);
                rightWidget.setHidden(true);
                darkenWidget.setHidden(true);
                continue;
            }
            if (skillVisibilityOption == SkillsOrganizerConfig.SkillVisibilityOption.FADE) {
                skillTile.setHidden(false);
                leftWidget.setHidden(false);
                rightWidget.setHidden(false);
                darkenWidget.setHidden(true);
                continue;
            }
            if (skillVisibilityOption == SkillsOrganizerConfig.SkillVisibilityOption.DARK) {
                skillTile.setHidden(false);
                leftWidget.setHidden(true);
                rightWidget.setHidden(true);
                darkenWidget.setHidden(false);
                continue;
            }
            skillTile.setHidden(false);
            leftWidget.setHidden(true);
            rightWidget.setHidden(true);
            darkenWidget.setHidden(true);
        }
    }

    private SkillWidgetGroup buildWidgetGroup(Widget skillTile) {
        SkillWidgetGroup newGroup;
        int idx = WidgetInfo.TO_CHILD((int)skillTile.getId()) - 1;
        Widget left = skillTile.createChild(-1, 5);
        left.setSpriteId(174);
        left.setOriginalWidth(36);
        left.setOriginalHeight(36);
        left.setXPositionMode(0);
        left.setXPositionMode(0);
        left.setOriginalX(-2);
        left.setOriginalY(-2);
        left.setOpacity(90);
        left.setHidden(true);
        left.revalidate();
        Widget right = skillTile.createChild(-1, 5);
        right.setSpriteId(176);
        right.setOriginalWidth(36);
        right.setOriginalHeight(36);
        right.setXPositionMode(0);
        right.setXPositionMode(0);
        right.setOriginalX(28);
        right.setOriginalY(-2);
        right.setOpacity(90);
        right.setHidden(true);
        right.revalidate();
        Widget darken = skillTile.createChild(-1, 3);
        darken.setXPositionMode(1);
        darken.setYPositionMode(1);
        darken.setWidthMode(1);
        darken.setHeightMode(1);
        darken.setOriginalWidth(0);
        darken.setOriginalHeight(0);
        darken.setFilled(true);
        darken.setTextColor(Color.BLACK.getRGB());
        darken.setOpacity(90);
        darken.setHidden(true);
        darken.revalidate();
        this.groups[idx] = newGroup = new SkillWidgetGroup(left, right, darken);
        return newGroup;
    }

    private void resetSkillBars() {
        Widget skillsContainer = this.client.getWidget(WidgetInfo.SKILLS_CONTAINER);
        if (skillsContainer == null) {
            return;
        }
        for (Widget widget : skillsContainer.getStaticChildren()) {
            int idx = WidgetInfo.TO_CHILD((int)widget.getId()) - 1;
            SkillOrganizerData skillOrganizerData = SkillOrganizerData.get(idx);
            if (skillOrganizerData == null) continue;
            widget.setOriginalX(skillOrganizerData.getDefaultPosition().getX());
            widget.setXPositionMode(0);
            widget.setOriginalY(skillOrganizerData.getDefaultPosition().getY());
            widget.setYPositionMode(0);
            widget.revalidate();
            widget.setHidden(false);
        }
        for (SkillWidgetGroup skillWidgetGroup : this.groups) {
            if (skillWidgetGroup == null) continue;
            Widget parent = skillWidgetGroup.getLeft().getParent();
            Widget[] children = parent.getChildren();
            for (int i = 0; i < Objects.requireNonNull(children).length; ++i) {
                Widget child = children[i];
                if (!skillWidgetGroup.contains(child)) continue;
                children[i] = null;
            }
        }
        this.groups = new SkillWidgetGroup[SkillOrganizerData.values().length];
    }
}

