/*
 * Decompiled with CFR 0.152.
 */
package nl.alowaniak.runelite.musicreplacer;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.runelite.http.api.RuneLiteAPI;
import nl.alowaniak.runelite.musicreplacer.SearchResult;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class YouTubeSearcher {
    private static final Logger log = LoggerFactory.getLogger(YouTubeSearcher.class);
    @Inject
    private OkHttpClient http;
    @Inject
    @Named(value="musicReplacerExecutor")
    private ExecutorService executor;

    YouTubeSearcher() {
    }

    public void search(String term, Consumer<List<SearchResult>> resultCollector) {
        this.executor.submit(() -> resultCollector.accept(this.getSearchResults(term)));
    }

    private List<SearchResult> getSearchResults(String term) {
        List list;
        block9: {
            Response res = this.getSearchResponse(term);
            try {
                if (!res.isSuccessful()) {
                    throw new IOException(res.code() + ": " + res.message() + " " + res.body().string());
                }
                list = (List)RuneLiteAPI.GSON.fromJson(res.body().string(), SearchResult.LIST_TYPE.getType());
                if (res == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn("Something went wrong when searching for " + term, (Throwable)e);
                    return Collections.emptyList();
                }
            }
            res.close();
        }
        return list;
    }

    private Response getSearchResponse(String term) throws IOException {
        return this.http.newBuilder().readTimeout(1L, TimeUnit.MINUTES).build().newCall(new Request.Builder().url("https://alowan.nl/runelite-music-replacer/search/" + URLEncoder.encode(term, StandardCharsets.UTF_8.toString())).build()).execute();
    }
}

