/*
 * Decompiled with CFR 0.152.
 */
package nl.alowaniak.runelite.musicreplacer;

import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.VarClientIntChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.game.chatbox.ChatboxTextMenuInput;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import nl.alowaniak.runelite.musicreplacer.MusicPlayer;
import nl.alowaniak.runelite.musicreplacer.Preset;
import nl.alowaniak.runelite.musicreplacer.SearchResult;
import nl.alowaniak.runelite.musicreplacer.TrackOverride;
import nl.alowaniak.runelite.musicreplacer.Tracks;
import nl.alowaniak.runelite.musicreplacer.YouTubeSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class TracksOverridesUi {
    private static final Logger log = LoggerFactory.getLogger(TracksOverridesUi.class);
    public static final int PAGE_SIZE = 4;
    public static final int OVERRIDE_FONT = 496;
    public static final int NORMAL_FONT = 495;
    public static final int RESIZABLE_VIEWPORT_BOTTOM_LINE_MUSIC_TAB_ID = 10747946;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private TooltipManager tooltipManager;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private Tracks tracks;
    @Inject
    private YouTubeSearcher ytSearcher;
    private String lastPlayingTrack;
    private boolean overrideWidgetsOutdated = true;
    private final Runnable choosePresetForBulkOverride = () -> {
        try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/presets.json"));){
            ChatboxTextMenuInput input = this.chatboxPanelManager.openTextMenuInput("Which preset? (This will download ALL overridden tracks!)");
            List presets = (List)RuneLiteAPI.GSON.fromJson((Reader)reader, Preset.LIST_TYPE.getType());
            presets.forEach(preset -> input.option(preset.getName(), () -> this.tracks.bulkCreateOverride((Preset)preset)));
            input.build();
        }
        catch (IOException | NullPointerException ex) {
            log.warn("Something went wrong when reading presets.", (Throwable)ex);
        }
    };
    private final Runnable chooseDirectoryForBulkOverride = () -> {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        int status = fileChooser.showOpenDialog(this.client.getCanvas());
        if (status == 0) {
            this.tracks.bulkCreateOverride(fileChooser.getSelectedFile().toPath());
        }
    };

    TracksOverridesUi() {
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        Widget playingTrackWidget = this.client.getWidget(239, 9);
        if (playingTrackWidget == null) {
            return;
        }
        String playingTrack = playingTrackWidget.getText();
        if (!playingTrack.equals(this.lastPlayingTrack)) {
            this.lastPlayingTrack = playingTrack;
            this.updateCurrentlyPlayingWidget();
        }
        if (this.overrideWidgetsOutdated) {
            this.updateOverridesInTrackList();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        String key = configChanged.getKey();
        if ("musicreplacer".equals(configChanged.getGroup()) && key.startsWith("track_")) {
            this.overrideWidgetsOutdated = true;
            if (key.contains(this.lastPlayingTrack)) {
                this.updateCurrentlyPlayingWidget();
            }
        }
    }

    @Subscribe
    public void onVarClientIntChanged(VarClientIntChanged varClientIntChanged) {
        if (varClientIntChanged.getIndex() == 171 && this.isOnMusicTab()) {
            this.overrideWidgetsOutdated = true;
        }
    }

    private boolean isOnMusicTab() {
        return this.client.getVarcIntValue(171) == 13;
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        MenuEntry entry = event.getFirstEntry();
        if (entry == null) {
            return;
        }
        int widgetId = entry.getParam1();
        if (widgetId == WidgetInfo.MUSIC_TRACK_LIST.getId()) {
            String trackName = Text.removeTags((String)entry.getTarget());
            this.addMenuEntry("Override", entry).onClick(e -> this.chatboxPanelManager.openTextMenuInput("How would you like to override " + trackName + "?").option("With a local file.", () -> this.overrideByLocal(trackName)).option("From a youtube search.", () -> this.overrideBySearch(trackName)).build());
            if (this.tracks.getOverride(trackName) != null) {
                this.addMenuEntry("Remove override", entry).onClick(e -> this.tracks.removeOverride(trackName));
            }
        } else if (widgetId == WidgetInfo.FIXED_VIEWPORT_MUSIC_TAB.getId() || widgetId == WidgetInfo.RESIZABLE_VIEWPORT_MUSIC_TAB.getId() || widgetId == 10747946) {
            if (!this.tracks.overriddenTracks().isEmpty()) {
                this.addMenuEntry("Remove overrides", entry).onClick(e -> this.tracks.removeAllOverrides());
            }
            this.addMenuEntry("Override tracks", entry).onClick(e -> this.chatboxPanelManager.openTextMenuInput("How would you like to bulk override?").option("From preset", this.choosePresetForBulkOverride).option("From directory", () -> SwingUtilities.invokeLater(this.chooseDirectoryForBulkOverride)).build());
        }
    }

    private MenuEntry addMenuEntry(String option, MenuEntry entryForCopy) {
        return this.client.createMenuEntry(-1).setOption(option).setTarget(entryForCopy.getTarget()).setType(MenuAction.RUNELITE).setParam0(entryForCopy.getParam0()).setParam1(entryForCopy.getParam1()).setIdentifier(entryForCopy.getIdentifier());
    }

    private void overrideByLocal(String trackName) {
        SwingUtilities.invokeLater(() -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(0);
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || MusicPlayer.PLAYER_PER_EXT.keySet().stream().anyMatch(ext -> f.getName().endsWith((String)ext));
                }

                @Override
                public String getDescription() {
                    return "Supported audio files";
                }
            });
            int status = fileChooser.showOpenDialog(this.client.getCanvas());
            if (status == 0) {
                this.tracks.createOverride(trackName, fileChooser.getSelectedFile().toPath());
            }
        });
    }

    private void overrideBySearch(String trackName) {
        this.chatboxPanelManager.openTextInput("Enter your search criteria for " + trackName).value(trackName).onDone(s -> this.ytSearcher.search((String)s, hits -> this.paginateSearch(trackName, (List<SearchResult>)hits))).build();
    }

    private void paginateSearch(String trackName, List<SearchResult> hits) {
        ChatboxTextMenuInput chooser = this.chatboxPanelManager.openTextMenuInput("Choose which you want to use as override for " + trackName);
        int pageSize = 4 + (5 == hits.size() ? 1 : 0);
        hits.stream().limit(pageSize).forEach(hit -> chooser.option(hit.getName() + " " + Duration.ofSeconds(hit.getDuration()).toString().substring(2) + " " + hit.getUploader(), () -> this.tracks.createOverride(trackName, (SearchResult)hit)));
        List<SearchResult> remainingHits = hits.subList(Math.min(hits.size(), pageSize), hits.size());
        if (!remainingHits.isEmpty()) {
            chooser.option("Continue", () -> this.paginateSearch(trackName, remainingHits));
        }
        chooser.build();
    }

    private void updateOverridesInTrackList() {
        this.clientThread.invoke(() -> {
            Widget trackList = this.client.getWidget(WidgetInfo.MUSIC_TRACK_LIST);
            if (trackList == null) {
                return;
            }
            for (Widget e : trackList.getDynamicChildren()) {
                e.setFontId(this.tracks.overrideExists(e.getText()) ? 496 : 495);
                e.revalidate();
            }
        });
    }

    private void updateCurrentlyPlayingWidget() {
        this.clientThread.invoke(() -> {
            Widget trackPlayingWidget = this.client.getWidget(239, 9);
            if (trackPlayingWidget == null) {
                return;
            }
            trackPlayingWidget.setOnClickListener(new Object[]{e -> this.scrollToTrack(e.getSource().getText())});
            trackPlayingWidget.setHasListener(true);
            TrackOverride override = this.tracks.getOverride(trackPlayingWidget.getText());
            if (override != null) {
                trackPlayingWidget.setFontId(496);
                String origin = TracksOverridesUi.truncate(override.getOriginalPath(), 40);
                StringBuilder tooltipTxt = new StringBuilder("From: " + origin + "</br>");
                override.getAdditionalInfo().entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(String::length).thenComparing(String::compareTo))).forEach(e -> tooltipTxt.append((String)e.getKey()).append(": ").append((String)e.getValue()).append("</br>"));
                Tooltip tooltip = new Tooltip(tooltipTxt.toString());
                trackPlayingWidget.setOnMouseRepeatListener(new Object[]{e -> {
                    if (!this.tooltipManager.getTooltips().contains(tooltip)) {
                        this.tooltipManager.add(tooltip);
                    }
                }});
            } else {
                trackPlayingWidget.setOnMouseRepeatListener((Object[])null);
                trackPlayingWidget.setFontId(495);
            }
        });
    }

    private void scrollToTrack(String name) {
        Widget track = this.findTrackWidget(name);
        if (track == null) {
            return;
        }
        Widget scrollContainer = this.client.getWidget(WidgetInfo.MUSIC_TRACK_SCROLL_CONTAINER);
        if (scrollContainer == null) {
            return;
        }
        int centralY = track.getRelativeY() + track.getHeight() / 2;
        int newScroll = Ints.constrainToRange((int)(centralY - scrollContainer.getHeight() / 2), (int)0, (int)scrollContainer.getScrollHeight());
        this.client.runScript(new Object[]{72, WidgetInfo.MUSIC_TRACK_SCROLLBAR.getId(), WidgetInfo.MUSIC_TRACK_SCROLL_CONTAINER.getId(), newScroll});
    }

    private Widget findTrackWidget(String name) {
        Widget trackList = this.client.getWidget(WidgetInfo.MUSIC_TRACK_LIST);
        if (trackList == null) {
            return null;
        }
        return Stream.of(trackList.getDynamicChildren()).filter(w -> name.equals(w.getText())).findAny().orElse(null);
    }

    private void clearCurrentlyPlayingWidget() {
        this.clientThread.invoke(() -> {
            Widget trackPlayingWidget = this.client.getWidget(239, 9);
            if (trackPlayingWidget == null) {
                return;
            }
            trackPlayingWidget.setFontId(495);
            trackPlayingWidget.setOnClickListener((Object[])null);
            trackPlayingWidget.setOnMouseRepeatListener((Object[])null);
            trackPlayingWidget.setHasListener(false);
        });
    }

    public void shutdown() {
        this.overrideWidgetsOutdated = true;
        this.lastPlayingTrack = null;
        this.clientThread.invoke(() -> {
            Widget trackList = this.client.getWidget(WidgetInfo.MUSIC_TRACK_LIST);
            if (trackList == null) {
                return;
            }
            for (Widget e : trackList.getDynamicChildren()) {
                e.setFontId(495);
                e.revalidate();
            }
        });
        this.clearCurrentlyPlayingWidget();
    }

    private static String truncate(String s, int length) {
        return s.length() <= length ? s : s.substring(0, length / 2 - 2) + " .. " + s.substring(s.length() - (length / 2 - 2));
    }
}

