/*
 * Decompiled with CFR 0.152.
 */
package nl.alowaniak.runelite.musicreplacer;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.runelite.client.RuneLite;
import net.runelite.client.config.ConfigManager;
import net.runelite.http.api.RuneLiteAPI;
import nl.alowaniak.runelite.musicreplacer.MusicPlayer;
import nl.alowaniak.runelite.musicreplacer.MusicReplacerConfig;
import nl.alowaniak.runelite.musicreplacer.MusicReplacerPlugin;
import nl.alowaniak.runelite.musicreplacer.Preset;
import nl.alowaniak.runelite.musicreplacer.SearchResult;
import nl.alowaniak.runelite.musicreplacer.TrackOverride;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class Tracks {
    private static final Logger log = LoggerFactory.getLogger(Tracks.class);
    static final File MUSIC_OVERRIDES_DIR = new File(RuneLite.RUNELITE_DIR, "music-replacer");
    public static final String OVERRIDE_CONFIG_KEY_PREFIX = "track_";
    public static final String FULL_OVERRIDE_CONFIG_KEY_PREFIX = "musicreplacer.track_";
    @Inject
    private ConfigManager configMgr;
    @Inject
    private MusicReplacerConfig config;
    @Inject
    private MusicReplacerPlugin musicReplacer;
    @Inject
    @Named(value="musicReplacerExecutor")
    private ExecutorService executor;

    Tracks() {
        if (!MUSIC_OVERRIDES_DIR.exists() && !MUSIC_OVERRIDES_DIR.mkdirs()) {
            throw new IllegalStateException("Failed to create " + MUSIC_OVERRIDES_DIR);
        }
    }

    public boolean overrideExists(String name) {
        return this.configMgr.getConfiguration("musicreplacer", OVERRIDE_CONFIG_KEY_PREFIX + name) != null;
    }

    public List<String> overriddenTracks() {
        return this.configMgr.getConfigurationKeys("musicreplacer").stream().filter(e -> e.startsWith(FULL_OVERRIDE_CONFIG_KEY_PREFIX)).map(e -> e.replace(FULL_OVERRIDE_CONFIG_KEY_PREFIX, "")).collect(Collectors.toList());
    }

    public void bulkCreateOverride(Path dirPath) {
        this.executor.submit(() -> {
            this.musicReplacer.chatMsg("Overriding with tracks in " + dirPath + ".");
            try (Stream<Path> ls = Files.list(dirPath);){
                ls.map(e -> {
                    final class PathAndFilename {
                        private final Path path;
                        private final AtomicReference<Object> filename = new AtomicReference();

                        public PathAndFilename(Path path) {
                            this.path = path;
                        }

                        public Path getPath() {
                            return this.path;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof PathAndFilename)) {
                                return false;
                            }
                            PathAndFilename other = (PathAndFilename)o;
                            Path this$path = this.getPath();
                            Path other$path = other.getPath();
                            if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
                                return false;
                            }
                            String this$filename = this.getFilename();
                            String other$filename = other.getFilename();
                            return !(this$filename == null ? other$filename != null : !this$filename.equals(other$filename));
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Path $path = this.getPath();
                            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
                            String $filename = this.getFilename();
                            result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
                            return result;
                        }

                        public String toString() {
                            return "PathAndFilename(path=" + this.getPath() + ", filename=" + this.getFilename() + ")";
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public String getFilename() {
                            Object value = this.filename.get();
                            if (value == null) {
                                AtomicReference<Object> atomicReference = this.filename;
                                synchronized (atomicReference) {
                                    value = this.filename.get();
                                    if (value == null) {
                                        String actualValue = this.path.getFileName().toString().replaceAll("\\..+$", "");
                                        value = actualValue == null ? this.filename : actualValue;
                                        this.filename.set(value);
                                    }
                                }
                            }
                            return (String)(value == this.filename ? null : value);
                        }
                    }
                    return new PathAndFilename((Path)e);
                }).forEach(e -> {
                    if (!this.config.skipAlreadyOverriddenWhenBulkOverride() || !this.overrideExists(e.getFilename())) {
                        this.createOverride(e.getFilename(), e.getPath());
                    } else {
                        this.musicReplacer.chatMsg("Skipping " + e.getFilename() + ", already overridden.");
                    }
                });
            }
            catch (IOException e2) {
                log.warn("Error opening `" + dirPath + "` for bulk override.", (Throwable)e2);
            }
            this.musicReplacer.chatMsg("Done overriding.");
        });
    }

    public void createOverride(String name, Path path) {
        this.createOverride(new TrackOverride(name, path.toString(), true, (Map<String, String>)ImmutableMap.of()));
    }

    public void bulkCreateOverride(Preset preset) {
        this.musicReplacer.chatMsg("Downloading " + preset.getTracks().size() + " tracks, won't dl all if RL closes prematurely.", preset.getCredits());
        preset.getTracks().forEach((name, override) -> {
            if (!this.config.skipAlreadyOverriddenWhenBulkOverride() || !this.overrideExists((String)name)) {
                this.createOverride((String)name, (SearchResult)override);
            } else {
                this.musicReplacer.chatMsg("Skipping " + name + ", already overridden.");
            }
        });
        this.executor.submit(() -> this.musicReplacer.chatMsg("Finished downloading preset " + preset.getName() + ".", preset.getCredits()));
    }

    public void createOverride(String trackName, SearchResult hit) {
        this.executor.submit(() -> this.createOverride(new TrackOverride(trackName, hit.id, false, (Map<String, String>)ImmutableMap.of((Object)"Name", (Object)hit.getName(), (Object)"Duration", (Object)Duration.ofSeconds(hit.getDuration()).toString(), (Object)"Uploader", (Object)hit.getUploader()))));
    }

    private void createOverride(TrackOverride override) {
        Path overridePath = this.transfer(override);
        if (overridePath != null) {
            override.getPaths().filter(e -> !e.equals(overridePath)).forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    log.warn("Couldn't delete " + path, (Throwable)e);
                }
            });
            this.configMgr.setConfiguration("musicreplacer", OVERRIDE_CONFIG_KEY_PREFIX + override.getName(), RuneLiteAPI.GSON.toJson((Object)override));
            this.musicReplacer.chatMsg(override.isFromLocal() ? "Overridden " + override.getName() : "Overridden " + override.getName() + ", uploaded by " + override.getAdditionalInfo().get("Uploader"));
        } else {
            this.musicReplacer.chatMsg("Failed to override " + override.getName() + ", check the logs.");
        }
    }

    public TrackOverride getOverride(String name) {
        TrackOverride override = (TrackOverride)RuneLiteAPI.GSON.fromJson(this.configMgr.getConfiguration("musicreplacer", OVERRIDE_CONFIG_KEY_PREFIX + name), TrackOverride.class);
        if (override == null || override.getPaths().anyMatch(x$0 -> Files.exists(x$0, new LinkOption[0]))) {
            return override;
        }
        log.warn("Deleting: " + override + " because there was no override file for it.");
        this.configMgr.unsetConfiguration("musicreplacer", OVERRIDE_CONFIG_KEY_PREFIX + name);
        return null;
    }

    public void removeAllOverrides() {
        this.executor.submit(() -> this.overriddenTracks().forEach(this::removeOverride));
    }

    public void removeOverride(String name) {
        TrackOverride override = this.getOverride(name);
        if (override == null) {
            return;
        }
        this.configMgr.unsetConfiguration("musicreplacer", OVERRIDE_CONFIG_KEY_PREFIX + name);
        override.getPaths().forEach(overridePath -> {
            try {
                Files.deleteIfExists(overridePath);
            }
            catch (IOException e) {
                log.warn("Couldn't delete " + name, (Throwable)e);
            }
        });
    }

    private Path transfer(TrackOverride override) {
        return override.isFromLocal() ? this.transferLocal(override) : this.transferLink(override);
    }

    private Path transferLocal(TrackOverride override) {
        Path path = Paths.get(override.getOriginalPath(), new String[0]);
        Path targetPath = override.getPaths().filter(e -> this.extensionOf(path).equals(this.extensionOf((Path)e))).findFirst().orElse(null);
        if (targetPath == null) {
            log.warn("Can only load " + MusicPlayer.PLAYER_PER_EXT.keySet() + " files. " + override);
            return null;
        }
        try {
            Files.copy(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
            return targetPath;
        }
        catch (IOException e2) {
            log.warn("Something went wrong when copying " + override, (Throwable)e2);
            return null;
        }
    }

    private String extensionOf(Path p) {
        String fileName = p.getFileName().toString();
        return fileName.substring(fileName.lastIndexOf(46));
    }

    private Path transferLink(TrackOverride override) {
        Path path;
        block8: {
            Path targetPath = override.getPaths().findFirst().orElseThrow(IllegalStateException::new);
            String dlUrl = "https://alowan.nl/runelite-music-replacer/download/" + override.getOriginalPath() + "?ext=" + this.extensionOf(targetPath);
            InputStream is = new URL(dlUrl).openStream();
            try {
                Files.copy(is, targetPath, StandardCopyOption.REPLACE_EXISTING);
                path = targetPath;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn("Something went wrong when downloading for " + override, (Throwable)e);
                    return null;
                }
            }
            is.close();
        }
        return path;
    }
}

