/*
 * Decompiled with CFR 0.152.
 */
package nl.alowaniak.runelite.musicreplacer;

import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import nl.alowaniak.runelite.musicreplacer.MusicPlayer;
import nl.alowaniak.runelite.musicreplacer.Tracks;

final class TrackOverride {
    private final String name;
    private final String originalPath;
    private final boolean fromLocal;
    private final Map<String, String> additionalInfo;

    public Stream<Path> getPaths() {
        return MusicPlayer.PLAYER_PER_EXT.keySet().stream().map(e -> Tracks.MUSIC_OVERRIDES_DIR.toPath().resolve(this.name + e));
    }

    public TrackOverride(String name, String originalPath, boolean fromLocal, Map<String, String> additionalInfo) {
        this.name = name;
        this.originalPath = originalPath;
        this.fromLocal = fromLocal;
        this.additionalInfo = additionalInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public boolean isFromLocal() {
        return this.fromLocal;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrackOverride)) {
            return false;
        }
        TrackOverride other = (TrackOverride)o;
        if (this.isFromLocal() != other.isFromLocal()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$originalPath = this.getOriginalPath();
        String other$originalPath = other.getOriginalPath();
        if (this$originalPath == null ? other$originalPath != null : !this$originalPath.equals(other$originalPath)) {
            return false;
        }
        Map<String, String> this$additionalInfo = this.getAdditionalInfo();
        Map<String, String> other$additionalInfo = other.getAdditionalInfo();
        return !(this$additionalInfo == null ? other$additionalInfo != null : !((Object)this$additionalInfo).equals(other$additionalInfo));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFromLocal() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $originalPath = this.getOriginalPath();
        result = result * 59 + ($originalPath == null ? 43 : $originalPath.hashCode());
        Map<String, String> $additionalInfo = this.getAdditionalInfo();
        result = result * 59 + ($additionalInfo == null ? 43 : ((Object)$additionalInfo).hashCode());
        return result;
    }

    public String toString() {
        return "TrackOverride(name=" + this.getName() + ", originalPath=" + this.getOriginalPath() + ", fromLocal=" + this.isFromLocal() + ", additionalInfo=" + this.getAdditionalInfo() + ")";
    }
}

