/*
 * Decompiled with CFR 0.152.
 */
package nl.alowaniak.runelite.musicreplacer;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import joptsimple.internal.Strings;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.music.MusicConfig;
import net.runelite.client.plugins.music.MusicPlugin;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import nl.alowaniak.runelite.musicreplacer.MusicPlayer;
import nl.alowaniak.runelite.musicreplacer.MusicReplacerConfig;
import nl.alowaniak.runelite.musicreplacer.TrackOverride;
import nl.alowaniak.runelite.musicreplacer.Tracks;
import nl.alowaniak.runelite.musicreplacer.TracksOverridesUi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Music Replacer", description="Replace music tracks with presets (e.g. OSRSBeatz) or your own music", tags={"music", "replace", "override", "track", "song", "youtube", "beats", "osrsbeatz", "rs3"})
@PluginDependency(value=MusicPlugin.class)
public class MusicReplacerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MusicReplacerPlugin.class);
    public static final String MUSIC_REPLACER_API = "https://alowan.nl/runelite-music-replacer/";
    public static final String MUSIC_REPLACER_EXECUTOR = "musicReplacerExecutor";
    public static final int PLAYING_WIDGET_ID = 8;
    public static final int CURRENTLY_PLAYING_WIDGET_ID = 9;
    private static final int MUSIC_LOOP_STATE_VAR_ID = 4137;
    private static final double MAX_VOL = 255.0;
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    private ClientThread clientThread;
    @Inject
    private TooltipManager tooltipManager;
    @Inject
    private Tracks tracks;
    @Inject
    private TracksOverridesUi tracksOverridesUi;
    @Inject
    private MusicConfig musicConfig;
    @Inject
    private MusicReplacerConfig config;
    private MusicPlayer player;
    private String actualCurTrack;
    private boolean restoreActualCurTrack;
    private TrackOverride trackToPlay;
    private double fading;
    private double oldVolume = -1.0;

    public void configure(Binder binder) {
        binder.bind(ExecutorService.class).annotatedWith((Annotation)Names.named((String)MUSIC_REPLACER_EXECUTOR)).toInstance((Object)Executors.newSingleThreadExecutor());
    }

    protected void startUp() {
        this.eventBus.register((Object)this.tracksOverridesUi);
    }

    @Provides
    MusicReplacerConfig getConfig(ConfigManager configManager) {
        return (MusicReplacerConfig)configManager.getConfig(MusicReplacerConfig.class);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.stopPlaying();
        }
    }

    @Subscribe
    public void onClientTick(ClientTick tick) {
        Widget curTrackWidget = this.client.getWidget(239, 9);
        Widget playingWidget = this.client.getWidget(239, 8);
        if (curTrackWidget == null || playingWidget == null) {
            return;
        }
        String curTrack = curTrackWidget.getText();
        if (Strings.isNullOrEmpty((String)curTrack)) {
            return;
        }
        if (this.restoreActualCurTrack) {
            this.restoreActualCurTrack = false;
            curTrack = this.actualCurTrack;
            curTrackWidget.setText(curTrack);
            playingWidget.setFontId(495);
            playingWidget.setHasListener(false);
        } else if (this.config.playOverridesToEnd() && this.trackToPlay != null && !curTrack.equals(this.trackToPlay.getName())) {
            this.actualCurTrack = curTrack;
            playingWidget.setFontId(496);
            Tooltip tooltip = new Tooltip("Up next: " + this.actualCurTrack);
            playingWidget.setOnMouseRepeatListener(new Object[]{e -> {
                if (!this.tooltipManager.getTooltips().contains(tooltip)) {
                    this.tooltipManager.add(tooltip);
                }
            }});
            playingWidget.setOnClickListener(new Object[]{e -> {
                this.restoreActualCurTrack = true;
            }});
            playingWidget.setHasListener(true);
            curTrack = this.trackToPlay.getName();
            curTrackWidget.setText(curTrack);
            this.applyVolume();
        }
        TrackOverride newTrack = this.tracks.getOverride(curTrack);
        if (!Objects.equals(this.trackToPlay, newTrack)) {
            this.trackToPlay = newTrack;
            if (this.fading <= 0.0) {
                this.fading = 1.0;
            }
        }
        if (this.fading > 0.0) {
            this.applyVolume(this.fading -= 0.01);
            if (this.fading <= 0.0) {
                this.stopCurrentAndStartNew();
            }
        } else if (this.player != null) {
            boolean actualTrackIsBeingOverruled;
            double volume = (double)(this.musicConfig.getMusicVolume() - 1) / 255.0;
            boolean bl = actualTrackIsBeingOverruled = this.config.playOverridesToEnd() && this.actualCurTrack != null && this.trackToPlay != null && !this.actualCurTrack.equals(this.trackToPlay.getName());
            if (actualTrackIsBeingOverruled && (volume <= 0.0 || !this.player.isPlaying())) {
                this.restoreActualCurTrack = true;
            } else if (this.oldVolume <= 0.0 && volume > 0.0 || !this.player.isPlaying() && this.client.getVarbitValue(4137) == 1) {
                this.player.play();
            }
            this.applyVolume();
            this.oldVolume = volume;
        }
    }

    private void stopCurrentAndStartNew() {
        this.stopPlaying();
        if (this.trackToPlay != null) {
            try {
                this.player = this.trackToPlay.getPaths().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toUri).map(MusicPlayer::create).filter(Objects::nonNull).findFirst().orElse(null);
                if (this.player != null) {
                    this.player.play();
                } else {
                    this.chatMsg("Deleting " + this.trackToPlay + " override because no player could be made (no file or wrong format?).");
                    this.tracks.removeOverride(this.trackToPlay.getName());
                }
            }
            catch (OutOfMemoryError e) {
                log.warn("Out of memory when loading " + this.trackToPlay, (Throwable)e);
                this.trackToPlay = null;
            }
        }
        this.applyVolume();
    }

    private void applyVolume() {
        this.applyVolume(1.0);
    }

    private void applyVolume(double multiplier) {
        if (this.player == null) {
            int volume = (int)((double)(this.musicConfig.getMusicVolume() - 1) * multiplier);
            this.clientThread.invokeLater(() -> this.client.setMusicVolume(Ints.constrainToRange((int)volume, (int)0, (int)255)));
        } else {
            if (this.player.isPlaying()) {
                double volume = Doubles.constrainToRange((double)((double)(this.musicConfig.getMusicVolume() - 1) / 255.0 * multiplier), (double)0.0, (double)1.0);
                this.player.setVolume(volume);
            }
            this.clientThread.invokeLater(() -> this.client.setMusicVolume(0));
        }
    }

    public void stopPlaying() {
        this.fading = 0.0;
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
    }

    protected void shutDown() {
        this.eventBus.unregister((Object)this.tracksOverridesUi);
        this.tracksOverridesUi.shutdown();
        this.trackToPlay = null;
        this.stopPlaying();
        this.clientThread.invoke(() -> {
            this.applyVolume();
            Widget curTrackWidget = this.client.getWidget(239, 9);
            Widget playingWidget = this.client.getWidget(239, 8);
            if (curTrackWidget == null || playingWidget == null) {
                return;
            }
            if (!Strings.isNullOrEmpty((String)this.actualCurTrack)) {
                curTrackWidget.setText(this.actualCurTrack);
            }
            playingWidget.setFontId(495);
            playingWidget.setHasListener(false);
            playingWidget.setOnMouseRepeatListener((Object[])null);
            this.actualCurTrack = null;
        });
    }

    public void chatMsg(String ... msgs) {
        this.clientThread.invoke(() -> Arrays.stream(msgs).forEach(msg -> this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", msg, null)));
    }

    static {
        MusicPlayer.preloadNecessaries();
    }
}

