/*
 * Decompiled with CFR 0.152.
 */
package nl.alowaniak.runelite.musicreplacer;

import com.adonax.audiocue.AudioCue;
import com.google.common.collect.ImmutableMap;
import jaco.mp3.player.MP3Player;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.function.Function;
import javax.swing.SwingUtilities;
import org.slf4j.LoggerFactory;

public interface MusicPlayer {
    public static final ImmutableMap<String, Function<URI, MusicPlayer>> PLAYER_PER_EXT = ImmutableMap.of((Object)".mp3", JacoPlayer::new, (Object)".wav", x$0 -> new AudioCuePlayer((URI)x$0));

    public static void preloadNecessaries() {
        SwingUtilities.invokeLater(JacoPlayer.player::toString);
    }

    public static MusicPlayer create(URI media) {
        for (Map.Entry extAndPlayer : PLAYER_PER_EXT.entrySet()) {
            if (!media.getPath().endsWith((String)extAndPlayer.getKey())) continue;
            try {
                return (MusicPlayer)((Function)extAndPlayer.getValue()).apply(media);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(MusicPlayer.class).warn("Couldn't load player for " + media, (Throwable)e);
            }
        }
        return null;
    }

    public void play();

    public boolean isPlaying();

    public void setVolume(double var1);

    default public void close() {
    }

    public static class AudioCuePlayer
    implements MusicPlayer {
        private final File tempPlayFile = File.createTempFile("tmpJacoPlayfile", ".mp3");
        private final AudioCue audioCue;

        private AudioCuePlayer(URI media) {
            this.tempPlayFile.deleteOnExit();
            Files.copy(new File(media).toPath(), this.tempPlayFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.audioCue = AudioCue.makeStereoCue(this.tempPlayFile.toURL(), 1);
            this.audioCue.open();
        }

        @Override
        public void play() {
            if (this.audioCue.getIsActive(0)) {
                this.audioCue.releaseInstance(0);
            }
            this.audioCue.play();
        }

        @Override
        public boolean isPlaying() {
            return this.audioCue.getIsActive(0);
        }

        @Override
        public void setVolume(double volume) {
            this.audioCue.setVolume(0, volume);
        }

        @Override
        public void close() {
            this.tempPlayFile.delete();
            this.audioCue.close();
        }
    }

    public static class JacoPlayer
    implements MusicPlayer {
        public static final MP3Player player = new MP3Player();
        private final File tempPlayFile;

        public JacoPlayer(URI mediaFile) {
            player.getPlayList().clear();
            this.tempPlayFile = File.createTempFile("tmpJacoPlayfile", ".mp3");
            this.tempPlayFile.deleteOnExit();
            Files.copy(new File(mediaFile).toPath(), this.tempPlayFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            player.add(this.tempPlayFile);
        }

        @Override
        public void play() {
            player.play();
        }

        @Override
        public boolean isPlaying() {
            return player.isPlaying();
        }

        @Override
        public void setVolume(double volume) {
            int intVol = (int)(volume * 100.0);
            if (volume > 0.0 && intVol == 0) {
                intVol = 1;
            }
            player.setVolume(intVol);
        }

        @Override
        public void close() {
            player.stop();
            this.tempPlayFile.delete();
        }
    }
}

