/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.audiocue;

import com.adonax.audiocue.AudioCue;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class AudioMixer {
    private AudioCue[] trackCache;
    private AudioCue[] mixerTracks;
    private CopyOnWriteArrayList<AudioCue> trackManager = new CopyOnWriteArrayList();
    private volatile boolean trackCacheUpdated;
    private int trackCount;
    public final int bufferSize;
    public final int sdlByteBufferSize;
    public final int readBufferSize;
    private float[] audioData;
    private Mixer mixer;
    public final int threadPriority;
    private volatile boolean running;

    public int getTrackLength() {
        return this.trackCount;
    }

    public AudioMixer() {
        this(null, 8192, 10);
    }

    public AudioMixer(Mixer mixer, int bufferSize, int threadPriority) {
        this.bufferSize = bufferSize;
        this.readBufferSize = bufferSize * 2;
        this.sdlByteBufferSize = bufferSize * 4;
        this.mixer = mixer;
        this.threadPriority = threadPriority;
    }

    public void addTrack(AudioCue track) {
        this.trackManager.add(track);
    }

    public void removeTrack(AudioCue track) throws IllegalThreadStateException {
        this.trackManager.remove(track);
    }

    public void updateTracks() {
        int size = this.trackManager.size();
        AudioCue[] workCopyTracks = new AudioCue[size];
        for (int i = 0; i < size; ++i) {
            workCopyTracks[i] = this.trackManager.get(i);
        }
        this.trackCache = workCopyTracks;
        this.trackCacheUpdated = true;
        System.out.println("CoreMixer.updateTracks, new size:" + size);
    }

    public void start() throws IllegalStateException, LineUnavailableException {
        if (this.running) {
            throw new IllegalStateException("AudioMixer is already running!");
        }
        this.updateTracks();
        AudioMixerPlayer player = new AudioMixerPlayer(this.mixer, this.bufferSize);
        Thread t = new Thread(player);
        t.setPriority(this.threadPriority);
        t.start();
        this.running = true;
    }

    public void stop() throws IllegalStateException {
        if (!this.running) {
            throw new IllegalStateException("PFCoreMixer already stopped!");
        }
        this.running = false;
    }

    private float[] fillBufferFromTracks(float[] normalizedOut) {
        for (int n = 0; n < this.trackCount; ++n) {
            int i;
            if (this.mixerTracks[n].isRunning()) {
                try {
                    this.audioData = this.mixerTracks[n].readTrack();
                    for (i = 0; i < this.readBufferSize; ++i) {
                        int n2 = i;
                        normalizedOut[n2] = normalizedOut[n2] + this.audioData[i];
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (i = 0; i < this.readBufferSize; ++i) {
                if (normalizedOut[i] > 1.0f) {
                    normalizedOut[i] = 1.0f;
                    continue;
                }
                if (!(normalizedOut[i] < -1.0f)) continue;
                normalizedOut[i] = -1.0f;
            }
        }
        return normalizedOut;
    }

    private class AudioMixerPlayer
    implements Runnable {
        private SourceDataLine sdl;
        private float[] readBuffer;
        private byte[] audioBytes;

        AudioMixerPlayer(Mixer mixer, int bufferFrames) throws LineUnavailableException {
            this.audioBytes = new byte[AudioMixer.this.sdlByteBufferSize];
            this.sdl = AudioCue.getSourceDataLine(mixer, AudioCue.info);
            this.sdl.open(AudioCue.audioFormat, AudioMixer.this.sdlByteBufferSize);
            this.sdl.start();
        }

        @Override
        public void run() {
            while (AudioMixer.this.running) {
                if (AudioMixer.this.trackCacheUpdated) {
                    AudioMixer.this.trackCacheUpdated = false;
                    AudioMixer.this.mixerTracks = AudioMixer.this.trackCache;
                    AudioMixer.this.trackCount = AudioMixer.this.mixerTracks.length;
                }
                this.readBuffer = new float[AudioMixer.this.readBufferSize];
                this.readBuffer = AudioMixer.this.fillBufferFromTracks(this.readBuffer);
                this.audioBytes = AudioCue.fromBufferToAudioBytes(this.audioBytes, this.readBuffer);
                this.sdl.write(this.audioBytes, 0, AudioMixer.this.sdlByteBufferSize);
            }
            this.sdl.drain();
            this.sdl.close();
            this.sdl = null;
        }
    }
}

