/*
 * Decompiled with CFR 0.152.
 */
package com.adonax.audiocue;

import com.adonax.audiocue.AudioCueInstanceEvent;
import com.adonax.audiocue.AudioCueListener;
import com.adonax.audiocue.AudioMixer;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Function;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioCue {
    public static final AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
    public static final Line.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
    private final int VOLUME_STEPS = 1024;
    private final int SPEED_STEPS = 4096;
    private final int PAN_STEPS = 1024;
    private final int DEFAULT_BUFFER_FRAMES = 1024;
    private final LinkedBlockingDeque<AudioCueCursor> availables;
    private final float[] cue;
    private final int cueFrameLength;
    private final AudioCueCursor[] cursors;
    private final int polyphony;
    private volatile boolean playerRunning;
    private float[] readBuffer;
    private String name;
    private AudioMixer audioMixer;
    private CopyOnWriteArrayList<AudioCueListener> listeners;
    private Function<Float, Float> panL;
    private Function<Float, Float> panR;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addAudioCueListener(AudioCueListener listener) {
        this.listeners.add(listener);
    }

    public void removeAudioCueListener(AudioCueListener listener) {
        this.listeners.remove(listener);
    }

    public void setPanType(PanType panType) {
        this.panL = panType.left;
        this.panR = panType.right;
    }

    public static AudioCue makeStereoCue(float[] cue, String name, int polyphony) {
        return new AudioCue(cue, name, polyphony);
    }

    public static AudioCue makeStereoCue(URL url, int polyphony) throws UnsupportedAudioFileException, IOException {
        String urlName = url.getPath();
        int urlLen = urlName.length();
        String name = urlName.substring(urlName.lastIndexOf("/") + 1, urlLen);
        float[] cue = AudioCue.loadURL(url);
        return new AudioCue(cue, name, polyphony);
    }

    private AudioCue(float[] cue, String name, int polyphony) {
        this.cue = cue;
        this.cueFrameLength = cue.length / 2;
        this.polyphony = polyphony;
        this.name = name;
        this.availables = new LinkedBlockingDeque(polyphony);
        this.cursors = new AudioCueCursor[polyphony];
        for (int i = 0; i < polyphony; ++i) {
            this.cursors[i] = new AudioCueCursor(i);
            this.cursors[i].resetInstance();
            this.availables.add(this.cursors[i]);
        }
        this.setPanType(PanType.CENTER_LINEAR);
        this.listeners = new CopyOnWriteArrayList();
    }

    private static float[] loadURL(URL url) throws UnsupportedAudioFileException, IOException {
        int i;
        AudioInputStream ais = AudioSystem.getAudioInputStream(url);
        int framesCount = 0;
        if (ais.getFrameLength() > 0x3FFFFFFFL) {
            System.out.println("WARNING: Clip is too large to entirely fit!");
            framesCount = 0x3FFFFFFF;
        } else {
            framesCount = (int)ais.getFrameLength();
        }
        float[] temp = new float[framesCount * 2];
        long tempCountdown = temp.length;
        int bytesRead = 0;
        int clipIdx = 0;
        byte[] buffer = new byte[1024];
        while ((bytesRead = ais.read(buffer, 0, 1024)) != -1) {
            int bufferIdx = 0;
            int n = bytesRead >> 1;
            for (i = 0; i < n; ++i) {
                if (tempCountdown-- < 0L) continue;
                temp[clipIdx++] = buffer[bufferIdx++] & 0xFF | buffer[bufferIdx++] << 8;
            }
        }
        for (i = 0; i < temp.length; ++i) {
            temp[i] = temp[i] / 32767.0f;
        }
        return temp;
    }

    public void open() throws IllegalStateException, LineUnavailableException {
        this.open(null, 1024, 10);
    }

    public void open(int bufferFrames) throws IllegalStateException, LineUnavailableException {
        this.open(null, bufferFrames, 10);
    }

    public void open(Mixer mixer, int bufferFrames, int threadPriority) throws LineUnavailableException, IllegalStateException {
        if (this.playerRunning) {
            throw new IllegalStateException("Already open.");
        }
        AudioCuePlayer player = new AudioCuePlayer(mixer, bufferFrames);
        Thread t = new Thread(player);
        t.setPriority(threadPriority);
        this.playerRunning = true;
        t.start();
        this.broadcastOpenEvent(t.getPriority(), bufferFrames, this.name);
    }

    public void open(AudioMixer audioMixer) throws IllegalStateException {
        if (this.playerRunning) {
            throw new IllegalStateException("Already open.");
        }
        this.playerRunning = true;
        this.audioMixer = audioMixer;
        this.readBuffer = new float[audioMixer.bufferSize * 2];
        audioMixer.addTrack(this);
        audioMixer.updateTracks();
        this.broadcastOpenEvent(audioMixer.threadPriority, audioMixer.bufferSize, this.name);
    }

    public void close() throws IllegalStateException {
        if (!this.playerRunning) {
            throw new IllegalStateException("Already closed.");
        }
        if (this.audioMixer != null) {
            this.audioMixer.removeTrack(this);
            this.audioMixer.updateTracks();
            this.audioMixer = null;
        }
        this.playerRunning = false;
        this.broadcastCloseEvent(this.name);
    }

    public long getFrameLength() {
        return this.cueFrameLength;
    }

    public long getMicrosecondLength() {
        return (long)((double)this.cueFrameLength * 1000000.0 / (double)audioFormat.getFrameRate());
    }

    public int obtainInstance() {
        AudioCueCursor aci = this.availables.pollLast();
        if (aci == null) {
            return -1;
        }
        aci.isActive = true;
        this.broadcastCreateInstanceEvent(aci);
        return aci.hook;
    }

    public void releaseInstance(int instanceHook) {
        this.cursors[instanceHook].resetInstance();
        this.availables.offerFirst(this.cursors[instanceHook]);
        this.broadcastReleaseEvent(this.cursors[instanceHook]);
    }

    public int play() {
        return this.play(1.0, 0.0, 1.0, 0);
    }

    public int play(double volume) {
        return this.play(volume, 0.0, 1.0, 0);
    }

    public int play(double volume, double pan, double speed, int loop) {
        int idx = this.obtainInstance();
        if (idx < 0) {
            System.out.println("All available notes are playing.");
            return idx;
        }
        this.setVolume(idx, volume);
        this.setPan(idx, pan);
        this.setSpeed(idx, speed);
        this.setLooping(idx, loop);
        this.setRecycleWhenDone(idx, true);
        this.start(idx);
        return idx;
    }

    public void start(int instanceHook) throws IllegalStateException {
        if (!this.cursors[instanceHook].isActive || this.cursors[instanceHook].isPlaying) {
            throw new IllegalStateException("Illegal state, " + this.name + ", instance:" + instanceHook);
        }
        this.cursors[instanceHook].isPlaying = true;
        this.broadcastStartEvent(this.cursors[instanceHook]);
    }

    public void stop(int instanceHook) throws IllegalStateException {
        if (!this.cursors[instanceHook].isActive) {
            throw new IllegalStateException("Illegal state, " + this.name + ", instance:" + instanceHook);
        }
        this.cursors[instanceHook].isPlaying = false;
        this.broadcastStopEvent(this.cursors[instanceHook]);
        this.cursors[instanceHook].recycleWhenDone = false;
    }

    public void setFramePosition(int instanceHook, double frame) throws IllegalStateException {
        if (!this.cursors[instanceHook].isActive || this.cursors[instanceHook].isPlaying) {
            throw new IllegalStateException("Illegal state, " + this.name + ", instance:" + instanceHook);
        }
        this.cursors[instanceHook].idx = Math.max(0.0f, Math.min((float)(this.getFrameLength() - 1L), (float)frame));
    }

    public double getFramePosition(int instanceHook) {
        if (!this.cursors[instanceHook].isActive) {
            throw new IllegalStateException(this.name + " instance: " + instanceHook + " is inactive");
        }
        return this.cursors[instanceHook].idx;
    }

    public void setMillisecondPosition(int instanceHook, int milliseconds) {
        if (!this.cursors[instanceHook].isActive || this.cursors[instanceHook].isPlaying) {
            throw new IllegalStateException("Illegal state, " + this.name + ", instance:" + instanceHook);
        }
        float samples = audioFormat.getFrameRate() * (float)milliseconds / 1000.0f;
        this.cursors[instanceHook].idx = Math.max(0.0f, Math.min((float)(this.cueFrameLength - 1), samples));
    }

    public void setFractionalPosition(int instanceHook, double normal) {
        if (!this.cursors[instanceHook].isActive || this.cursors[instanceHook].isPlaying) {
            throw new IllegalStateException("Illegal state, " + this.name + ", instance:" + instanceHook);
        }
        this.cursors[instanceHook].idx = (float)((double)(this.cueFrameLength - 1) * Math.max(0.0, Math.min(1.0, normal)));
    }

    public void setVolume(int instanceHook, double volume) throws IllegalStateException {
        if (!this.cursors[instanceHook].isActive) {
            throw new IllegalStateException(this.name + " instance: " + instanceHook + " is inactive");
        }
        this.cursors[instanceHook].targetVolume = (float)Math.min(1.0, Math.max(0.0, volume));
        if (this.cursors[instanceHook].isPlaying) {
            this.cursors[instanceHook].targetVolumeIncr = (this.cursors[instanceHook].targetVolume - this.cursors[instanceHook].volume) / 1024.0f;
            this.cursors[instanceHook].targetVolumeSteps = 1024;
        } else {
            this.cursors[instanceHook].volume = this.cursors[instanceHook].targetVolume;
        }
    }

    public double getVolume(int instanceHook) throws IllegalStateException {
        if (!this.cursors[instanceHook].isActive) {
            throw new IllegalStateException(this.name + " instance: " + instanceHook + " is inactive");
        }
        return this.cursors[instanceHook].volume;
    }

    public void setPan(int instanceHook, double pan) throws IllegalStateException {
        if (!this.cursors[instanceHook].isActive) {
            throw new IllegalStateException(this.name + " instance: " + instanceHook + " is inactive");
        }
        this.cursors[instanceHook].targetPan = (float)Math.min(1.0, Math.max(-1.0, pan));
        if (this.cursors[instanceHook].isPlaying) {
            this.cursors[instanceHook].targetPanIncr = (this.cursors[instanceHook].targetPan - this.cursors[instanceHook].pan) / 1024.0f;
            this.cursors[instanceHook].targetPanSteps = 1024;
        } else {
            this.cursors[instanceHook].pan = this.cursors[instanceHook].targetPan;
        }
    }

    public double getPan(int instanceHook) throws IllegalStateException {
        if (!this.cursors[instanceHook].isActive) {
            throw new IllegalStateException(this.name + " instance: " + instanceHook + " is inactive");
        }
        return this.cursors[instanceHook].pan;
    }

    public void setSpeed(int instanceHook, double speed) throws IllegalStateException {
        if (!this.cursors[instanceHook].isActive) {
            throw new IllegalStateException(this.name + " instance: " + instanceHook + " is inactive");
        }
        this.cursors[instanceHook].targetSpeed = (float)Math.min(8.0, Math.max(0.125, speed));
        if (this.cursors[instanceHook].isPlaying) {
            this.cursors[instanceHook].targetSpeedIncr = (this.cursors[instanceHook].targetSpeed - this.cursors[instanceHook].speed) / 4096.0f;
            this.cursors[instanceHook].targetSpeedSteps = 4096;
        } else {
            this.cursors[instanceHook].speed = this.cursors[instanceHook].targetSpeed;
        }
    }

    public double getSpeed(int instanceHook) throws IllegalStateException {
        if (!this.cursors[instanceHook].isActive) {
            throw new IllegalStateException(this.name + " instance: " + instanceHook + " is inactive");
        }
        return this.cursors[instanceHook].speed;
    }

    public void setLooping(int instanceHook, int loops) throws IllegalStateException {
        if (!this.cursors[instanceHook].isActive) {
            throw new IllegalStateException(this.name + " instance: " + instanceHook + " is inactive");
        }
        this.cursors[instanceHook].loop = loops;
    }

    public void setRecycleWhenDone(int instanceHook, boolean recycleWhenDone) throws IllegalStateException {
        if (!this.cursors[instanceHook].isActive) {
            throw new IllegalStateException(this.name + " instance: " + instanceHook + " is inactive");
        }
        this.cursors[instanceHook].recycleWhenDone = recycleWhenDone;
    }

    public boolean getIsActive(int instanceHook) {
        return this.cursors[instanceHook].isActive;
    }

    public boolean getIsPlaying(int instanceHook) {
        return this.cursors[instanceHook].isPlaying;
    }

    private float[] fillBuffer(float[] readBuffer) {
        int bufferLength = readBuffer.length;
        for (int i = 0; i < bufferLength; ++i) {
            readBuffer[i] = 0.0f;
        }
        block1: for (int ci = 0; ci < this.polyphony; ++ci) {
            if (!this.cursors[ci].isPlaying) continue;
            AudioCueCursor acc = this.cursors[ci];
            float panFactorL = this.panL.apply(Float.valueOf(acc.pan)).floatValue();
            float panFactorR = this.panR.apply(Float.valueOf(acc.pan)).floatValue();
            for (int i = 0; i < bufferLength; i += 2) {
                if (acc.targetVolumeSteps-- > 0) {
                    acc.volume += acc.targetVolumeIncr;
                }
                if (acc.targetPanSteps-- > 0) {
                    acc.pan += acc.targetPanIncr;
                    panFactorL = this.panL.apply(Float.valueOf(acc.pan)).floatValue();
                    panFactorR = this.panR.apply(Float.valueOf(acc.pan)).floatValue();
                }
                float[] audioVals = new float[2];
                audioVals = this.readFractionalFrame(audioVals, acc.idx);
                int n = i;
                readBuffer[n] = readBuffer[n] + audioVals[0] * acc.volume * panFactorL;
                int n2 = i + 1;
                readBuffer[n2] = readBuffer[n2] + audioVals[1] * acc.volume * panFactorR;
                if (acc.targetSpeedSteps-- > 0) {
                    acc.speed += acc.targetSpeedIncr;
                }
                acc.idx += acc.speed;
                if (!(acc.idx >= (float)(this.cueFrameLength - 1))) continue;
                if (acc.loop == -1) {
                    acc.idx = 0.0f;
                    this.broadcastLoopEvent(acc);
                    continue;
                }
                if (acc.loop > 0) {
                    --acc.loop;
                    acc.idx = 0.0f;
                    this.broadcastLoopEvent(acc);
                    continue;
                }
                acc.isPlaying = false;
                this.broadcastStopEvent(acc);
                if (!acc.recycleWhenDone) continue block1;
                acc.resetInstance();
                this.availables.offerFirst(acc);
                this.broadcastReleaseEvent(acc);
                continue block1;
            }
        }
        return readBuffer;
    }

    private float[] readFractionalFrame(float[] audioVals, float idx) {
        int intIndex = (int)idx;
        int flatIndex = intIndex * 2;
        audioVals[0] = this.cue[flatIndex + 2] * (idx - (float)intIndex) + this.cue[flatIndex] * ((float)(intIndex + 1) - idx);
        audioVals[1] = this.cue[flatIndex + 3] * (idx - (float)intIndex) + this.cue[flatIndex + 1] * ((float)(intIndex + 1) - idx);
        return audioVals;
    }

    public static byte[] fromBufferToAudioBytes(byte[] audioBytes, float[] buffer) {
        int n = buffer.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            buffer[n2] = buffer[n2] * 32767.0f;
            audioBytes[i * 2] = (byte)buffer[i];
            audioBytes[i * 2 + 1] = (byte)((int)buffer[i] >> 8);
        }
        return audioBytes;
    }

    public static SourceDataLine getSourceDataLine(Mixer mixer, Line.Info info) throws LineUnavailableException {
        SourceDataLine sdl = mixer == null ? (SourceDataLine)AudioSystem.getLine(info) : (SourceDataLine)mixer.getLine(info);
        return sdl;
    }

    public boolean isRunning() {
        return this.playerRunning;
    }

    public void setRunning(boolean bool) {
        this.playerRunning = bool;
    }

    public float[] readTrack() throws IOException {
        return this.fillBuffer(this.readBuffer);
    }

    private void broadcastOpenEvent(int threadPriority, int bufferSize, String name) {
        for (AudioCueListener acl : this.listeners) {
            acl.audioCueOpened(System.currentTimeMillis(), threadPriority, bufferSize, this);
        }
    }

    private void broadcastCloseEvent(String name) {
        for (AudioCueListener acl : this.listeners) {
            acl.audioCueClosed(System.currentTimeMillis(), this);
        }
    }

    private void broadcastCreateInstanceEvent(AudioCueCursor acc) {
        for (AudioCueListener acl : this.listeners) {
            acl.instanceEventOccurred(new AudioCueInstanceEvent(AudioCueInstanceEvent.Type.OBTAIN_INSTANCE, this, acc.hook, 0.0));
        }
    }

    private void broadcastReleaseEvent(AudioCueCursor acc) {
        for (AudioCueListener acl : this.listeners) {
            acl.instanceEventOccurred(new AudioCueInstanceEvent(AudioCueInstanceEvent.Type.RELEASE_INSTANCE, this, acc.hook, acc.idx));
        }
    }

    private void broadcastStartEvent(AudioCueCursor acc) {
        for (AudioCueListener acl : this.listeners) {
            acl.instanceEventOccurred(new AudioCueInstanceEvent(AudioCueInstanceEvent.Type.START_INSTANCE, this, acc.hook, acc.idx));
        }
    }

    private void broadcastLoopEvent(AudioCueCursor acc) {
        for (AudioCueListener acl : this.listeners) {
            acl.instanceEventOccurred(new AudioCueInstanceEvent(AudioCueInstanceEvent.Type.LOOP, this, acc.hook, 0.0));
        }
    }

    private void broadcastStopEvent(AudioCueCursor acc) {
        for (AudioCueListener acl : this.listeners) {
            acl.instanceEventOccurred(new AudioCueInstanceEvent(AudioCueInstanceEvent.Type.STOP_INSTANCE, this, acc.hook, acc.idx));
        }
    }

    private class AudioCuePlayer
    implements Runnable {
        private SourceDataLine sdl;
        private final int sdlBufferSize;
        private byte[] audioBytes;

        AudioCuePlayer(Mixer mixer, int bufferFrames) throws LineUnavailableException {
            AudioCue.this.readBuffer = new float[bufferFrames * 2];
            this.sdlBufferSize = bufferFrames * 4;
            this.audioBytes = new byte[this.sdlBufferSize];
            this.sdl = AudioCue.getSourceDataLine(mixer, info);
            this.sdl.open(audioFormat, this.sdlBufferSize);
            this.sdl.start();
        }

        @Override
        public void run() {
            while (AudioCue.this.playerRunning) {
                AudioCue.this.readBuffer = AudioCue.this.fillBuffer(AudioCue.this.readBuffer);
                this.audioBytes = AudioCue.fromBufferToAudioBytes(this.audioBytes, AudioCue.this.readBuffer);
                this.sdl.write(this.audioBytes, 0, this.sdlBufferSize);
            }
            this.sdl.drain();
            this.sdl.close();
            this.sdl = null;
        }
    }

    private class AudioCueCursor {
        volatile boolean isPlaying;
        volatile boolean isActive;
        final int hook;
        float idx;
        float speed;
        float volume;
        float pan;
        int loop;
        boolean recycleWhenDone;
        float targetSpeed;
        float targetSpeedIncr;
        int targetSpeedSteps;
        float targetVolume;
        float targetVolumeIncr;
        int targetVolumeSteps;
        float targetPan;
        float targetPanIncr;
        int targetPanSteps;

        AudioCueCursor(int hook) {
            this.hook = hook;
        }

        void resetInstance() {
            this.isActive = false;
            this.isPlaying = false;
            this.idx = 0.0f;
            this.speed = 1.0f;
            this.volume = 0.0f;
            this.pan = 0.0f;
            this.loop = 0;
            this.recycleWhenDone = false;
            this.targetSpeedSteps = 0;
            this.targetVolumeSteps = 0;
            this.targetPanSteps = 0;
        }
    }

    public static enum PanType {
        CENTER_LINEAR(x -> Float.valueOf(Math.max(0.0f, Math.min(1.0f, 1.0f - x.floatValue()))), x -> Float.valueOf(Math.max(0.0f, Math.min(1.0f, 1.0f + x.floatValue())))),
        FULL_LINEAR(x -> Float.valueOf((1.0f + x.floatValue()) / 2.0f), x -> Float.valueOf(1.0f - (1.0f + x.floatValue()) / 2.0f)),
        CIRCULAR(x -> Float.valueOf((float)Math.cos(Math.PI * (double)(1.0f + x.floatValue()) / 4.0)), x -> Float.valueOf((float)Math.sin(Math.PI * (double)(1.0f + x.floatValue()) / 4.0)));

        private final Function<Float, Float> left;
        private final Function<Float, Float> right;

        private PanType(Function<Float, Float> left, Function<Float, Float> right) {
            this.left = left;
            this.right = right;
        }
    }
}

