/*
 * Decompiled with CFR 0.152.
 */
package com.mjhylkema.TeleportMaps.ui;

import com.mjhylkema.TeleportMaps.ui.MenuAction;
import com.mjhylkema.TeleportMaps.ui.UIComponentEventListener;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.ScriptEvent;
import net.runelite.api.widgets.Widget;

public abstract class UIComponent {
    private static final String BTN_NAME_FORMAT = "<col=ff9040>%s</col>";
    private Widget widget;
    private List<MenuAction> actions;
    private UIComponentEventListener hoverListener;
    private UIComponentEventListener leaveListener;

    public UIComponent(Widget widget) {
        this.widget = widget;
        this.widget.setOnOpListener(new Object[]{this::onActionSelected});
        this.widget.setOnMouseOverListener(new Object[]{this::onMouseHover});
        this.widget.setOnMouseLeaveListener(new Object[]{this::onMouseLeave});
        this.widget.setHasListener(true);
        this.actions = new ArrayList<MenuAction>();
    }

    public void addAction(String action, MenuAction callback) {
        this.widget.setAction(this.actions.size(), action);
        this.actions.add(callback);
    }

    protected void onActionSelected(ScriptEvent e) {
        if (this.actions.isEmpty()) {
            return;
        }
        MenuAction actionEvent = this.actions.get(e.getOp() - 1);
        actionEvent.onMenuAction();
    }

    protected void onMouseHover(ScriptEvent e) {
        if (this.hoverListener != null) {
            this.hoverListener.onComponentEvent(this);
        }
    }

    protected void onMouseLeave(ScriptEvent e) {
        if (this.leaveListener != null) {
            this.leaveListener.onComponentEvent(this);
        }
    }

    public void setOnHoverListener(UIComponentEventListener listener) {
        this.hoverListener = listener;
    }

    public void setOnLeaveListener(UIComponentEventListener listener) {
        this.leaveListener = listener;
    }

    public void setName(String name) {
        this.widget.setName(String.format(BTN_NAME_FORMAT, name));
    }

    public void setSize(int width, int height) {
        this.widget.setOriginalWidth(width);
        this.widget.setOriginalHeight(height);
    }

    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public void setX(int x) {
        this.widget.setOriginalX(x);
    }

    public void setY(int y) {
        this.widget.setOriginalY(y);
    }

    public int getX() {
        return this.widget.getOriginalX();
    }

    public int getY() {
        return this.widget.getOriginalY();
    }

    public void setVisibility(boolean visible) {
        this.widget.setHidden(!visible);
    }

    public Widget getWidget() {
        return this.widget;
    }

    public void setHoverListener(UIComponentEventListener hoverListener) {
        this.hoverListener = hoverListener;
    }

    public void setLeaveListener(UIComponentEventListener leaveListener) {
        this.leaveListener = leaveListener;
    }
}

