/*
 * Decompiled with CFR 0.152.
 */
package com.mjhylkema.TeleportMaps.components;

import com.mjhylkema.TeleportMaps.TeleportMapsPlugin;
import com.mjhylkema.TeleportMaps.components.BaseMap;
import com.mjhylkema.TeleportMaps.definition.TreeDefinition;
import com.mjhylkema.TeleportMaps.ui.Tree;
import com.mjhylkema.TeleportMaps.ui.UIButton;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;

public class SpiritTreeMap
extends BaseMap {
    private static final String DEF_FILE_TREES = "/SpiritTreeMap/TreeDefinitions.json";
    private static final int MAP_SPRITE_ID = -19000;
    private static final int MAP_SPRITE_WIDTH = 508;
    private static final int MAP_SPRITE_HEIGHT = 319;
    private static final int HOUSE_SPRITE_ID = -19001;
    private static final int HOUSE_SPRITE_WIDTH = 53;
    private static final int HOUSE_SPRITE_HEIGHT = 49;
    private static final int HOUSE_WIDGET_X = 36;
    private static final int HOUSE_WIDGET_Y = 241;
    private static final int DISABLED_TREE_SPRITE_ID = -19102;
    private static final int DISABLED_TREE_SPRITE_WIDTH = 19;
    private static final int DISABLED_TREE_SPRITE_HEIGHT = 27;
    private static final int SCRIPT_TRIGGER_KEY = 1437;
    private static final String TREE_LABEL_NAME_PATTERN = "<col=735a28>(.+)</col>: (<col=5f5f5f>)?(.+)";
    private static final String TRAVEL_ACTION = "Travel";
    private static final String EXAMINE_ACTION = "Examine";
    private static final int ADVENTURE_LOG_CONTAINER_BACKGROUND = 0;
    private static final int ADVENTURE_LOG_CONTAINER_TITLE = 1;
    private static final String MENU_TITLE = "Spirit Tree Locations";
    private TreeDefinition[] treeDefinitions;
    private HashMap<String, TreeDefinition> treeDefinitionsLookup;
    private HashMap<String, Tree> availableTrees;

    public SpiritTreeMap(TeleportMapsPlugin plugin) {
        super(plugin);
        this.loadDefinitions();
        this.buildTreeDefinitionLookup();
    }

    private void loadDefinitions() {
        this.treeDefinitions = this.plugin.loadDefinitionResource(TreeDefinition[].class, DEF_FILE_TREES);
    }

    private void buildTreeDefinitionLookup() {
        this.treeDefinitionsLookup = new HashMap();
        for (TreeDefinition treeDefinition : this.treeDefinitions) {
            this.treeDefinitionsLookup.put(treeDefinition.getName(), treeDefinition);
        }
    }

    @Override
    public void widgetLoaded(WidgetLoaded e) {
        if (e.getGroupId() == 187) {
            this.setAdventureLogWidgetsHidden(new int[]{0, 3, 2}, true);
            this.plugin.getClientThread().invokeLater(() -> {
                Widget adventureLogContainer = this.plugin.getClient().getWidget(WidgetInfo.ADVENTURE_LOG);
                if (adventureLogContainer == null || adventureLogContainer.getChild(1) == null || !adventureLogContainer.getChild(1).getText().equals(MENU_TITLE)) {
                    this.setAdventureLogWidgetsHidden(new int[]{0, 3, 2}, false);
                    return;
                }
                this.hideAdventureLogContainerChildren(adventureLogContainer);
                this.buildAvailableTreeList();
                this.createMapWidget(adventureLogContainer);
                this.createHouseWidget(adventureLogContainer);
                this.createTeleportWidgets(adventureLogContainer);
                this.setAdventureLogWidgetsHidden(new int[]{0}, false);
            });
        }
    }

    private void setAdventureLogWidgetsHidden(int[] childIds, boolean hidden) {
        this.setWidgetsHidden(187, childIds, hidden);
    }

    private void hideAdventureLogContainerChildren(Widget adventureLogContainer) {
        Widget title;
        Widget existingBackground = adventureLogContainer.getChild(0);
        if (existingBackground != null) {
            existingBackground.setHidden(true);
        }
        if ((title = adventureLogContainer.getChild(1)) != null) {
            title.setHidden(true);
        }
    }

    private void buildAvailableTreeList() {
        Widget[] labelWidgets;
        this.availableTrees = new HashMap();
        Pattern labelPattern = Pattern.compile(TREE_LABEL_NAME_PATTERN);
        Widget treeList = this.plugin.getClient().getWidget(187, 3);
        for (Widget child : labelWidgets = treeList.getDynamicChildren()) {
            String displayedName;
            Matcher matcher = labelPattern.matcher(child.getText());
            if (!matcher.matches()) continue;
            String shortcutKey = matcher.group(1);
            String disabledColor = matcher.group(2);
            String treeName = matcher.group(3);
            if (disabledColor != null) continue;
            if (treeName.contains("Your house")) {
                displayedName = treeName;
                treeName = "Your house";
            } else {
                displayedName = treeName;
            }
            TreeDefinition treeDefinition = this.treeDefinitionsLookup.get(treeName);
            if (treeDefinition == null) continue;
            this.availableTrees.put(treeName, new Tree(treeDefinition, child, shortcutKey, displayedName));
        }
    }

    private void createMapWidget(Widget container) {
        this.createSpriteWidget(container, 508, 319, 0, 0, -19000);
    }

    private void createHouseWidget(Widget container) {
        this.createSpriteWidget(container, 53, 49, 36, 241, -19001);
    }

    private void createTeleportWidgets(Widget container) {
        this.clearHotKeyLabels();
        for (TreeDefinition treeDefinition : this.treeDefinitions) {
            Widget treeWidget = container.createChild(-1, 5);
            UIButton treeButton = new UIButton(treeWidget);
            treeButton.setPosition(treeDefinition.getX(), treeDefinition.getY());
            if (this.isTreeUnlocked(treeDefinition.getName())) {
                Tree tree = this.availableTrees.get(treeDefinition.getName());
                treeButton.setSprites(treeDefinition.getSpriteEnabled(), treeDefinition.getSpriteHover());
                treeButton.setSize(treeDefinition.getWidth(), treeDefinition.getHeight());
                treeButton.setName(tree.getDisplayedName());
                treeButton.addAction(TRAVEL_ACTION, () -> this.triggerTeleport(tree));
                this.createHotKeyLabel(container, treeDefinition.getHotkey(), tree.getKeyShortcut());
            } else {
                treeButton.setSprites(-19102, -19102);
                treeButton.setSize(19, 27);
                treeButton.setName(treeDefinition.getName());
                treeButton.addAction(EXAMINE_ACTION, () -> this.triggerLockedMessage(treeDefinition));
            }
            treeWidget.revalidate();
        }
    }

    private boolean isTreeUnlocked(String treeName) {
        return this.availableTrees.containsKey(treeName);
    }

    private void triggerTeleport(Tree tree) {
        this.plugin.getClientThread().invokeLater(() -> this.plugin.getClient().runScript(new Object[]{1437, this.plugin.getClient().getWidget(0xBB0003).getId(), tree.getWidget().getIndex()}));
    }

    private void triggerLockedMessage(TreeDefinition treeDefinition) {
        this.plugin.getClientThread().invokeLater(() -> this.plugin.getClient().addChatMessage(ChatMessageType.GAMEMESSAGE, "", String.format("The Spirit Tree at %s is not available.", treeDefinition.getName()), null));
    }

    static class AdventureLog {
        static final int CONTAINER = 0;
        static final int EVENT_LISTENER_LIST = 1;
        static final int SCROLLBAR = 2;
        static final int LIST = 3;
        static final int CLOSE_BUTTON = 4;

        AdventureLog() {
        }
    }
}

