/*
 * Decompiled with CFR 0.152.
 */
package com.mjhylkema.TeleportMaps.components;

import com.mjhylkema.TeleportMaps.TeleportMapsPlugin;
import com.mjhylkema.TeleportMaps.components.BaseMap;
import com.mjhylkema.TeleportMaps.definition.MushtreeDefinition;
import com.mjhylkema.TeleportMaps.ui.Mushtree;
import com.mjhylkema.TeleportMaps.ui.UIButton;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.Keybind;

public class MushtreeMap
extends BaseMap {
    private static final String DEF_FILE_MUSHTREES = "/MushtreeMap/MushtreeDefinitions.json";
    private static final int MAP_SPRITE_ID = -19300;
    private static final int MAP_SPRITE_WIDTH = 467;
    private static final int MAP_SPRITE_HEIGHT = 311;
    private static final int MUSHTREE_SPRITE_ID = -19301;
    private static final int MUSHTREE_HIGHLIGHTED_SPRITE_ID = -19302;
    private static final int MUSHTREE_DISABLED_SPRITE_ID = -19303;
    private static final int CLOSE_BUTTON_SPRITE_ID = 537;
    private static final int CLOSE_BUTTON_WIDTH = 26;
    private static final int CLOSE_BUTTON_HEIGH = 23;
    private static final int CLOSE_BUTTON_X = 380;
    private static final int CLOSE_BUTTON_Y = 15;
    private static final int MUSHTREE_DIALOG_ID = 608;
    private static final String TRAVEL_ACTION = "Travel";
    private static final String MUSHTREE_LABEL_NAME_PATTERN = "<col=8f8f8f>([0-9])\\.</col> (.+)";
    private MushtreeDefinition[] mushtreeDefinitions;
    private HashMap<String, MushtreeDefinition> mushtreeDefinitionsLookup;
    private HashMap<String, Mushtree> availableMushtrees;

    public MushtreeMap(TeleportMapsPlugin plugin) {
        super(plugin);
        this.loadDefinitions();
        this.buildTreeDefinitionLookup();
    }

    private void loadDefinitions() {
        this.mushtreeDefinitions = this.plugin.loadDefinitionResource(MushtreeDefinition[].class, DEF_FILE_MUSHTREES);
    }

    private void buildTreeDefinitionLookup() {
        this.mushtreeDefinitionsLookup = new HashMap();
        for (MushtreeDefinition treeDefinition : this.mushtreeDefinitions) {
            this.mushtreeDefinitionsLookup.put(treeDefinition.getName(), treeDefinition);
        }
    }

    @Override
    public void widgetLoaded(WidgetLoaded e) {
        if (e.getGroupId() == 608) {
            this.setWidgetsHidden(608, new int[]{0}, true);
            this.plugin.getClientThread().invokeLater(() -> {
                Widget mushtreeInterfaceContainer;
                Widget mushtreeDialog = this.plugin.getClient().getWidget(608, 1);
                if (mushtreeDialog == null || mushtreeDialog.getChild(1) == null || !mushtreeDialog.getChild(1).getText().equals("Mycelium Transportation System")) {
                    this.setWidgetsHidden(608, new int[]{0}, false);
                }
                if ((mushtreeInterfaceContainer = this.plugin.getClient().getWidget(608, 0)) == null) {
                    return;
                }
                this.buildAvailableMushtreeList();
                this.hideInterfaceChildren(mushtreeInterfaceContainer);
                this.createMapWidget(mushtreeInterfaceContainer);
                this.createMushtreeWidgets(mushtreeInterfaceContainer);
                this.createEscapeButton(mushtreeInterfaceContainer);
                this.setWidgetsHidden(608, new int[]{0}, false);
            });
        }
    }

    private void hideInterfaceChildren(Widget mushtreeInterface) {
        Widget[] children = mushtreeInterface.getStaticChildren();
        mushtreeInterface.setOriginalHeight(20);
        Widget mushtreeDialog = children[0];
        mushtreeDialog.setHidden(true);
        Widget buttonParent = children[1];
        buttonParent.setHidden(true);
        mushtreeInterface.revalidate();
    }

    private void buildAvailableMushtreeList() {
        Widget[] mushtreeButtons;
        this.availableMushtrees = new HashMap();
        Pattern labelPattern = Pattern.compile(MUSHTREE_LABEL_NAME_PATTERN);
        Widget mushtreeList = this.plugin.getClient().getWidget(608, 2);
        for (Widget mushtree : mushtreeButtons = mushtreeList.getStaticChildren()) {
            MushtreeDefinition treeDefinition;
            Widget label = mushtree.getStaticChildren()[1];
            Matcher matcher = labelPattern.matcher(label.getText());
            if (!matcher.matches()) continue;
            char hotKey = Character.toUpperCase(matcher.group(1).charAt(0));
            String mushtreeName = matcher.group(2);
            if (mushtreeName.contains("Not yet found") || (treeDefinition = this.mushtreeDefinitionsLookup.get(mushtreeName)) == null) continue;
            this.availableMushtrees.put(mushtreeName, new Mushtree(treeDefinition, mushtree.getStaticChildren()[0], new Keybind((int)hotKey, 0)));
        }
    }

    private void createMapWidget(Widget mushtreeInterface) {
        this.createSpriteWidget(mushtreeInterface, 467, 311, 0, 0, -19300);
    }

    private void createMushtreeWidgets(Widget mushtreeInterface) {
        this.clearHotKeyLabels();
        for (MushtreeDefinition mushtreeDefinition : this.mushtreeDefinitions) {
            Widget mushtreeWidget = mushtreeInterface.createChild(-1, 5);
            UIButton mushtreeButton = new UIButton(mushtreeWidget);
            mushtreeButton.setPosition(mushtreeDefinition.getX(), mushtreeDefinition.getY());
            mushtreeButton.setSize(mushtreeDefinition.getWidth(), mushtreeDefinition.getHeight());
            mushtreeButton.setName(mushtreeDefinition.getName());
            if (this.isMushtreeAvailable(mushtreeDefinition.getName())) {
                Mushtree mushtree = this.availableMushtrees.get(mushtreeDefinition.getName());
                mushtreeButton.setSprites(-19301, -19302);
                mushtreeButton.addAction(TRAVEL_ACTION, () -> this.triggerButton(mushtree));
                mushtreeButton.getWidget().setOnKeyListener(new Object[]{e -> {
                    if (mushtree.getHotkey().getKeyCode() == e.getTypedKeyChar()) {
                        this.triggerButton(mushtree);
                    }
                }});
                this.createHotKeyLabel(mushtreeInterface, mushtreeDefinition.getHotkey(), mushtree.getHotkey().toString());
            } else {
                mushtreeButton.setSprites(-19303, -19303);
            }
            mushtreeWidget.revalidate();
        }
    }

    private void createEscapeButton(Widget mushtreeInterface) {
        Widget closeWidget = mushtreeInterface.createChild(-1, 5);
        UIButton closeButton = new UIButton(closeWidget);
        closeButton.setPosition(380, 15);
        closeButton.setSize(26, 23);
        closeButton.setSprites(537, 537);
        closeButton.addAction("Close", () -> this.triggerExit());
        closeWidget.revalidate();
    }

    private void triggerExit() {
        this.plugin.getClientThread().invoke(() -> {
            Widget mushtreeExit;
            Widget mushtreeDialog = this.plugin.getClient().getWidget(608, 1);
            Widget widget = mushtreeExit = mushtreeDialog != null ? mushtreeDialog.getChild(13) : null;
            if (mushtreeExit != null) {
                this.plugin.getClient().runScript(mushtreeExit.getOnOpListener());
            }
        });
    }

    private boolean isMushtreeAvailable(String mushtreeName) {
        return this.availableMushtrees.containsKey(mushtreeName);
    }

    private void triggerButton(Mushtree mushtree) {
        this.plugin.getClientThread().invokeLater(() -> {
            Widget mushtreeWidget = mushtree.getWidget();
            Object[] listener = mushtreeWidget.getOnKeyListener();
            if (listener == null) {
                return;
            }
            listener[1] = mushtree.getHotkey().getKeyCode();
            this.plugin.getClient().runScript(listener);
        });
    }
}

