/*
 * Decompiled with CFR 0.152.
 */
package com.mjhylkema.TeleportMaps.components;

import com.mjhylkema.TeleportMaps.TeleportMapsPlugin;
import com.mjhylkema.TeleportMaps.definition.HotKeyDefinition;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;

public abstract class BaseMap {
    protected static final int HOTKEY_LABEL_SPRITE_ID = -19002;
    protected static final int HOTKEY_LABEL_SPRITE_WIDTH = 20;
    protected static final int HOTKEY_LABEL_SPRITE_HEIGHT = 20;
    protected static final int HOTKEY_LABEL_COLOR = 3287045;
    protected TeleportMapsPlugin plugin;
    private List<Widget> activeHotkeyLabels;

    BaseMap(TeleportMapsPlugin plugin) {
        this.plugin = plugin;
        this.activeHotkeyLabels = new ArrayList<Widget>();
    }

    public abstract void widgetLoaded(WidgetLoaded var1);

    public void changeHotkeyLabelVisibility(boolean visible) {
        if (this.activeHotkeyLabels.size() == 0) {
            return;
        }
        this.plugin.getClientThread().invokeLater(() -> this.activeHotkeyLabels.forEach(label -> {
            label.setHidden(!visible);
            label.revalidate();
        }));
    }

    protected void addHotkeyLabel(Widget label) {
        this.activeHotkeyLabels.add(label);
    }

    protected void clearHotKeyLabels() {
        this.activeHotkeyLabels.clear();
    }

    protected Widget createSpriteWidget(Widget parent, int spriteWidth, int spriteHeight, int originalX, int originalY, int spriteId) {
        Widget widget = parent.createChild(-1, 5);
        widget.setOriginalWidth(spriteWidth);
        widget.setOriginalHeight(spriteHeight);
        widget.setOriginalX(originalX);
        widget.setOriginalY(originalY);
        widget.setSpriteId(spriteId);
        widget.revalidate();
        return widget;
    }

    protected void createHotKeyLabel(Widget container, HotKeyDefinition hotKeyDefinition, String hotKeyLabel) {
        boolean displayHotkeys = this.plugin.getConfig().displayHotkeys();
        Widget hotKeyWidget = this.createSpriteWidget(container, 20, 20, hotKeyDefinition.getX(), hotKeyDefinition.getY(), -19002);
        hotKeyWidget.setHidden(!displayHotkeys);
        this.addHotkeyLabel(hotKeyWidget);
        if (displayHotkeys) {
            hotKeyWidget.revalidate();
        }
        Widget hotKeyText = container.createChild(-1, 4);
        hotKeyText.setText(hotKeyLabel);
        hotKeyText.setFontId(497);
        hotKeyText.setTextColor(3287045);
        hotKeyText.setOriginalWidth(20);
        hotKeyText.setOriginalHeight(20);
        hotKeyText.setOriginalX(hotKeyDefinition.getX());
        hotKeyText.setOriginalY(hotKeyDefinition.getY() + 1);
        hotKeyText.setXTextAlignment(1);
        hotKeyText.setYTextAlignment(1);
        hotKeyText.setHidden(!displayHotkeys);
        this.addHotkeyLabel(hotKeyText);
        if (displayHotkeys) {
            hotKeyText.revalidate();
        }
    }

    protected void setWidgetsHidden(int groupID, int[] childIDs, boolean hidden) {
        for (int childId : childIDs) {
            Widget widget = this.plugin.getClient().getWidget(groupID, childId);
            if (widget == null) continue;
            widget.setHidden(hidden);
        }
    }
}

