/*
 * Decompiled with CFR 0.152.
 */
package com.mjhylkema.TeleportMaps;

import com.google.gson.Gson;
import com.google.inject.Provides;
import com.mjhylkema.TeleportMaps.TeleportMapsConfig;
import com.mjhylkema.TeleportMaps.components.BaseMap;
import com.mjhylkema.TeleportMaps.components.MushtreeMap;
import com.mjhylkema.TeleportMaps.components.SpiritTreeMap;
import com.mjhylkema.TeleportMaps.definition.SpriteDefinition;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.game.SpriteOverride;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Teleport Maps", configName="SpiritTreeMapPlugin", enabledByDefault=true)
public class TeleportMapsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TeleportMapsPlugin.class);
    private static final String DEF_FILE_SPRITES = "/SpriteDefinitions.json";
    @Inject
    private Gson gson;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Client client;
    @Inject
    private TeleportMapsConfig config;
    private List<BaseMap> mapComponents;

    protected void startUp() {
        SpriteOverride[] spriteDefinitions = this.loadDefinitionResource(SpriteDefinition[].class, DEF_FILE_SPRITES);
        this.spriteManager.addSpriteOverrides(spriteDefinitions);
        this.mapComponents = new ArrayList<BaseMap>();
        this.populateMaps();
    }

    public <T> T loadDefinitionResource(Class<T> classType, String resource) {
        InputStream resourceStream = classType.getResourceAsStream(resource);
        InputStreamReader definitionReader = new InputStreamReader(resourceStream);
        return (T)this.gson.fromJson((Reader)definitionReader, classType);
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded e) {
        this.mapComponents.forEach(baseMap -> baseMap.widgetLoaded(e));
    }

    @Provides
    TeleportMapsConfig provideConfig(ConfigManager configManager) {
        return (TeleportMapsConfig)configManager.getConfig(TeleportMapsConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        switch (e.getKey()) {
            case "displayHotkeys": {
                this.updateHotkeyLabels();
                break;
            }
            case "showSpiritTreeMap": 
            case "showMushtreeMap": {
                this.populateMaps();
                break;
            }
            default: {
                return;
            }
        }
    }

    private void updateHotkeyLabels() {
        boolean visible = this.config.displayHotkeys();
        this.mapComponents.forEach(baseMap -> baseMap.changeHotkeyLabelVisibility(visible));
    }

    private void populateMaps() {
        this.mapComponents.clear();
        if (this.config.showSpiritTreeMap()) {
            this.mapComponents.add(new SpiritTreeMap(this));
        }
        if (this.config.showMushtreeMap()) {
            this.mapComponents.add(new MushtreeMap(this));
        }
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public Client getClient() {
        return this.client;
    }

    public TeleportMapsConfig getConfig() {
        return this.config;
    }
}

