/*
 * Decompiled with CFR 0.152.
 */
package com.ItemRarity;

import com.ItemRarity.ItemRarityConfig;
import com.ItemRarity.ItemRarityOverlay;
import com.google.inject.Provides;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ItemRarity")
public class ItemRarityPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ItemRarityPlugin.class);
    @Inject
    private ItemRarityConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ItemRarityOverlay overlay;

    protected void startUp() throws Exception {
        log.info("ItemRarity started!");
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        log.info("ItemRarity stopped!");
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Provides
    ItemRarityConfig provideConfig(ConfigManager configManager) {
        return (ItemRarityConfig)configManager.getConfig(ItemRarityConfig.class);
    }

    boolean getUseStoreValue() {
        return this.config.getUseStoreValue();
    }

    boolean getUseGEValue() {
        return this.config.getUseGEValue();
    }

    boolean getUseHAValue() {
        return this.config.getUseHAValue();
    }

    boolean getUseStackCount() {
        return this.config.getUseStackCount();
    }

    Color getRarityColor(int itemPrice) {
        if (itemPrice < this.config.getCommonItemValue()) {
            return this.config.getCommonItemColor();
        }
        if (itemPrice < this.config.getUncommonItemValue()) {
            return this.config.getUncommonItemColor();
        }
        if (itemPrice < this.config.getRareItemValue()) {
            return this.config.getRareItemColor();
        }
        if (itemPrice < this.config.getEpicItemValue()) {
            return this.config.getEpicItemColor();
        }
        return this.config.getLegendaryItemColor();
    }
}

