/*
 * Decompiled with CFR 0.152.
 */
package com.ItemRarity;

import com.ItemRarity.ItemRarityPlugin;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import net.runelite.api.ItemComposition;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemRarityOverlay
extends WidgetItemOverlay {
    private static final Logger log = LoggerFactory.getLogger(ItemRarityOverlay.class);
    private static final int INVENTORY_SIZE = 28;
    private final ItemRarityPlugin plugin;
    private final ItemManager itemManager;

    @Inject
    private ItemRarityOverlay(ItemRarityPlugin plugin, ItemManager itemManager) {
        this.plugin = plugin;
        this.itemManager = itemManager;
        this.showOnEquipment();
        this.showOnInventory();
        this.showOnBank();
    }

    private int itemPrice(int itemId) {
        ItemComposition itemDef = this.itemManager.getItemComposition(itemId);
        int maxPrice = 0;
        int gePrice = this.itemManager.getItemPrice(itemId);
        int haPrice = itemDef.getHaPrice();
        int storePrice = itemDef.getPrice();
        if (this.plugin.getUseStoreValue()) {
            maxPrice = Integer.max(storePrice, maxPrice);
        }
        if (this.plugin.getUseGEValue()) {
            maxPrice = Integer.max(gePrice, maxPrice);
        }
        if (this.plugin.getUseHAValue()) {
            maxPrice = Integer.max(haPrice, maxPrice);
        }
        return maxPrice;
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        Color color;
        int price = this.itemPrice(itemId);
        if (this.plugin.getUseStackCount()) {
            price *= itemWidget.getQuantity();
        }
        if ((color = this.plugin.getRarityColor(price)) == null || color.getAlpha() == 0) {
            return;
        }
        Rectangle bounds = itemWidget.getCanvasBounds();
        BufferedImage outline = this.itemManager.getItemOutline(itemId, itemWidget.getQuantity(), color);
        graphics.drawImage((Image)outline, (int)bounds.getX(), (int)bounds.getY(), null);
    }
}

