/*
 * Decompiled with CFR 0.152.
 */
package com.ItemRarity;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="itemRarity")
public interface ItemRarityConfig
extends Config {
    @ConfigSection(position=5, name="Common", description="The color and price of Common Rarity")
    public static final String commonSection = "commonSection";
    @ConfigSection(position=6, name="Uncommon", description="The color and price of Uncommon Rarity")
    public static final String uncommonSection = "uncommonSection";
    @ConfigSection(position=7, name="Rare", description="The color and price of Rare Rarity")
    public static final String rareSection = "rareSection";
    @ConfigSection(position=8, name="Epic", description="The color and price of Epic Rarity")
    public static final String epicSection = "epicSection";
    @ConfigSection(position=9, name="Legendary", description="The color and price of Legendary Rarity")
    public static final String legendarySection = "legendarySection";

    @ConfigItem(keyName="useStorePrice", name="Use Store Price", description="Whether to use the Store price", position=1)
    default public boolean getUseStoreValue() {
        return false;
    }

    @ConfigItem(keyName="useGEPrice", name="Use GE Price", description="Whether to use the GE price", position=2)
    default public boolean getUseGEValue() {
        return true;
    }

    @ConfigItem(keyName="useHAPrice", name="Use HA Price", description="Whether to use the HA price", position=3)
    default public boolean getUseHAValue() {
        return true;
    }

    @ConfigItem(keyName="useStackCount", name="Use Stack Count", description="Whether to Calculate the rarity based on the number of items in the stack", position=4)
    default public boolean getUseStackCount() {
        return false;
    }

    @ConfigItem(keyName="commonItemValue", name="Price", description="Max Price of a Common Item", section="commonSection", position=1)
    default public int getCommonItemValue() {
        return 1000;
    }

    @Alpha
    @ConfigItem(keyName="commonItemColor", name="Highlight Color", description="Color of a Common Item", section="commonSection", position=2)
    default public Color getCommonItemColor() {
        return new Color(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @ConfigItem(keyName="uncommonItemValue", name="Price", description="Max Price of a Uncommon Item", section="uncommonSection", position=1)
    default public int getUncommonItemValue() {
        return 12500;
    }

    @Alpha
    @ConfigItem(keyName="uncommonItemColor", name="Highlight Color", description="Color of a Uncommon Item", section="uncommonSection", position=2)
    default public Color getUncommonItemColor() {
        return new Color(0.0f, 0.9411765f, 0.0f, 0.43137255f);
    }

    @ConfigItem(keyName="rareItemValue", name="Price", description="Max Price of a Rare Item", section="rareSection", position=1)
    default public int getRareItemValue() {
        return 125000;
    }

    @Alpha
    @ConfigItem(keyName="rareItemColor", name="Highlight Color", description="Color of a Rare Item", section="rareSection", position=2)
    default public Color getRareItemColor() {
        return new Color(0.0f, 0.39215687f, 0.9411765f, 0.7647059f);
    }

    @ConfigItem(keyName="epicItemValue", name="Price", description="Max Price of a Epic Item", section="epicSection", position=1)
    default public int getEpicItemValue() {
        return 1800000;
    }

    @Alpha
    @ConfigItem(keyName="epicItemColor", name="Highlight Color", description="Color of a Epic Item", section="epicSection", position=2)
    default public Color getEpicItemColor() {
        return new Color(0.627451f, 0.19607843f, 0.9411765f, 0.7647059f);
    }

    @ConfigItem(keyName="legendaryItemValue", name="Price", description="Max Price of a Legendary Item", section="legendarySection", position=1)
    default public int getLegendaryItemValue() {
        return Integer.MAX_VALUE;
    }

    @Alpha
    @ConfigItem(keyName="legendaryItemColor", name="Highlight Color", description="Color of a Legendary Item", section="legendarySection", position=2)
    default public Color getLegendaryItemColor() {
        return new Color(1.0f, 0.47058824f, 0.0f, 0.7647059f);
    }
}

