/*
 * Decompiled with CFR 0.152.
 */
package com.bloodshardnotifier;

import com.bloodshardnotifier.BloodShardNotifierConfig;
import com.google.inject.Provides;
import java.awt.Toolkit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.TileItem;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Blood Shard Notifier")
public class BloodShardNotifierPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BloodShardNotifierPlugin.class);
    @Inject
    private Client client;

    protected void startUp() throws Exception {
        log.info("Blood Shard Notifier started!");
    }

    protected void shutDown() throws Exception {
        log.info("Blood Shard Notifier stopped!");
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item = itemSpawned.getItem();
        if (item.getId() == 24777) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Provides
    BloodShardNotifierConfig provideConfig(ConfigManager configManager) {
        return (BloodShardNotifierConfig)configManager.getConfig(BloodShardNotifierConfig.class);
    }
}

