/*
 * Decompiled with CFR 0.152.
 */
package com.recentlyKilledHighlight;

import com.google.inject.Provides;
import com.recentlyKilledHighlight.RecentlyKilledHighlightConfig;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.game.NpcUtil;
import net.runelite.client.game.npcoverlay.HighlightedNpc;
import net.runelite.client.game.npcoverlay.NpcOverlayService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Recently Killed Highlight")
public class RecentlyKilledHighlightPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RecentlyKilledHighlightPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private RecentlyKilledHighlightConfig config;
    @Inject
    private NpcOverlayService npcOverlayService;
    @Inject
    private NpcUtil npcUtil;
    private final Map<NPC, HighlightedNpc> highlightedNpcs = new HashMap<NPC, HighlightedNpc>();
    private final Function<NPC, HighlightedNpc> isHighlighted = this.highlightedNpcs::get;
    private final ArrayDeque<NPC> killedNpcs = new ArrayDeque();
    private List<String> ignoreFilters = new ArrayList<String>();

    protected void startUp() throws Exception {
        log.info("RecentlyKilledHighlight started!");
        this.npcOverlayService.registerHighlighter(this.isHighlighted);
    }

    protected void shutDown() throws Exception {
        log.info("RecentlyKilledHighlight stopped!");
        this.npcOverlayService.unregisterHighlighter(this.isHighlighted);
        this.killedNpcs.clear();
        this.highlightedNpcs.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        String npcName = npc.getName();
        if (npcName == null) {
            return;
        }
        if (this.containsNpc(this.killedNpcs, npc)) {
            this.highlightedNpcs.put(npc, this.getHighlightedNpc(npc));
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        this.highlightedNpcs.remove(npc);
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        NPC npc = npcLootReceived.getNpc();
        String npcName = npc.getName();
        if (!this.containsNpc(this.killedNpcs, npc) && !this.nameIsIgnored(npcName)) {
            this.killedNpcs.push(npc);
            if (this.killedNpcs.size() > this.config.maxNpcs() && !this.config.noLimit()) {
                this.killedNpcs.removeLast();
            }
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        if (!(event.getSource() instanceof NPC)) {
            return;
        }
        if (!this.config.todoMode()) {
            return;
        }
        NPC sourceNpc = (NPC)event.getSource();
        NPC highlightedSourceNpc = this.findNpc(this.highlightedNpcs.keySet(), sourceNpc);
        if (event.getTarget() != this.client.getLocalPlayer() && highlightedSourceNpc == null) {
            if (!this.containsNpc(this.killedNpcs, sourceNpc)) {
                return;
            }
            if (sourceNpc.isDead()) {
                return;
            }
            this.highlightedNpcs.put(sourceNpc, this.getHighlightedNpc(sourceNpc));
            this.npcOverlayService.rebuild();
            return;
        }
        if (highlightedSourceNpc != null) {
            this.highlightedNpcs.remove(highlightedSourceNpc);
            this.npcOverlayService.rebuild();
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        MenuEntry menuEntry = event.getMenuEntry();
        NPC npc = menuEntry.getNpc();
        if (npc == null) {
            return;
        }
        Color color = null;
        if (this.highlightedNpcs.containsKey(npc) && this.config.highlightMenuNames() && !this.npcUtil.isDying(npc)) {
            color = this.config.highlightColor();
        }
        if (color != null) {
            String target = ColorUtil.prependColorTag((String)Text.removeTags((String)event.getTarget()), color);
            menuEntry.setTarget(target);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("recentlyKilledHighlight")) {
            return;
        }
        this.clientThread.invoke(this::rebuild);
    }

    @Provides
    RecentlyKilledHighlightConfig provideConfig(ConfigManager configManager) {
        return (RecentlyKilledHighlightConfig)configManager.getConfig(RecentlyKilledHighlightConfig.class);
    }

    private void rebuild() {
        this.ignoreFilters = this.getIgnoreFilters();
        this.highlightedNpcs.clear();
        if (this.client.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING) {
            return;
        }
        if (!this.config.noLimit()) {
            while (this.killedNpcs.size() > this.config.maxNpcs() && this.killedNpcs.size() > 0) {
                this.killedNpcs.removeLast();
            }
        }
        for (NPC npc : this.client.getNpcs()) {
            if (!this.containsNpc(this.killedNpcs, npc)) continue;
            if (this.nameIsIgnored(npc.getName())) {
                this.killedNpcs.removeIf(x -> npc.getIndex() == x.getIndex());
                continue;
            }
            if (npc.getInteracting() == this.client.getLocalPlayer() && this.config.todoMode()) continue;
            this.highlightedNpcs.put(npc, this.getHighlightedNpc(npc));
        }
        this.npcOverlayService.rebuild();
    }

    private HighlightedNpc getHighlightedNpc(NPC npc) {
        return HighlightedNpc.builder().npc(npc).highlightColor(this.config.highlightColor()).fillColor(this.config.fillColor()).hull(this.config.highlightHull()).tile(this.config.highlightTile()).outline(this.config.highlightOutline()).borderWidth((float)this.config.borderWidth()).outlineFeather(this.config.outlineFeather()).build();
    }

    private List<String> getIgnoreFilters() {
        String configNpcsString = this.config.npcsToIgnoreString();
        if (configNpcsString.isEmpty()) {
            return Collections.emptyList();
        }
        return Text.fromCSV((String)configNpcsString);
    }

    private boolean nameIsIgnored(String npcName) {
        if (npcName == null) {
            return false;
        }
        for (String configName : this.ignoreFilters) {
            if (!WildcardMatcher.matches((String)configName.trim(), (String)npcName)) continue;
            return true;
        }
        return false;
    }

    private boolean containsNpc(Collection<NPC> npcs, NPC npc) {
        return npcs.stream().anyMatch(collectionNPC -> collectionNPC.getIndex() == npc.getIndex());
    }

    private NPC findNpc(Collection<NPC> npcs, NPC npc) {
        return npcs.stream().filter(collectionNpc -> collectionNpc.getIndex() == npc.getIndex()).findFirst().orElse(null);
    }

    Map<NPC, HighlightedNpc> getHighlightedNpcs() {
        return this.highlightedNpcs;
    }
}

