/*
 * Decompiled with CFR 0.152.
 */
package com.hitsplattracker;

import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.Hitsplat;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Hitsplat Tracker")
public class HitsplatTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HitsplatTrackerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        Hitsplat hitsplat = hitsplatApplied.getHitsplat();
        if (!hitsplat.isMine()) {
            return;
        }
        Actor actor = hitsplatApplied.getActor();
        this.clientThread.invokeLater(() -> {
            int ratio = actor.getHealthRatio();
            if (actor instanceof NPC) {
                NPC npc = (NPC)actor;
                log.info("NPC name={}, id={}, index={} type={} amount={} ratio={}", new Object[]{npc.getName(), npc.getId(), npc.getIndex(), hitsplat.getHitsplatType(), hitsplat.getAmount(), ratio});
            } else if (actor == this.client.getLocalPlayer()) {
                log.info("SELF type={} amount={}, ratio={}", new Object[]{hitsplat.getHitsplatType(), hitsplat.getAmount(), ratio});
            } else if (actor instanceof Player) {
                log.info("PLAYER name={} type={} amount={}, ratio={}", new Object[]{actor.getName(), hitsplat.getHitsplatType(), hitsplat.getAmount(), ratio});
            }
        });
    }
}

