/*
 * Decompiled with CFR 0.152.
 */
package com.tymscar.onepassword;

import com.tymscar.onepassword.CommandRunner;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;

final class CredentialsManager
extends JFrame
implements ActionListener {
    private final Client client;
    private CommandRunner commandRunner = null;
    private String password;
    private String username;
    private String selectedAccountId = null;
    private ArrayList<String> AccountIds = new ArrayList();
    private JComboBox accountsComboBox;
    private JButton confirmButton;
    private JFrame popupFrame;

    @Inject
    CredentialsManager(Client client) {
        this.client = client;
    }

    private void parseIssue(String result) {
        this.commandRunner = null;
        if (result.contains("authorization") || result.contains("app is locked")) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "You are not logged into the 1Password CLI.", "Auth error", 1));
        } else if (result.contains("More than one item matches")) {
            SwingUtilities.invokeLater(() -> this.handleMultipleAccounts(result));
        } else {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, "There is no account with the url set to https://runescape.com", "", 0));
        }
    }

    private void handleMultipleAccounts(String commandOutput) {
        Pattern r = Pattern.compile("for the item \"(\\w+)\" in vault \\w+: (\\w+)");
        Matcher matches = r.matcher(commandOutput);
        ArrayList<String> accounts = new ArrayList<String>();
        this.AccountIds = new ArrayList();
        while (matches.find()) {
            accounts.add(matches.group(1));
            this.AccountIds.add(matches.group(2));
        }
        this.popupFrame = new JFrame("More than one account detected!");
        this.popupFrame.setLayout(new FlowLayout());
        this.accountsComboBox = new JComboBox<Object>(accounts.toArray());
        JLabel label = new JLabel("You have more than one account. Please select the entry name you want!");
        label.setAlignmentX(0.5f);
        label.setForeground(Color.white);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(label);
        p.add(this.accountsComboBox);
        this.confirmButton = new JButton("Login with this account!");
        this.confirmButton.setAlignmentX(0.5f);
        this.confirmButton.addActionListener(this);
        p.add(this.confirmButton);
        this.popupFrame.add(p);
        this.popupFrame.setSize(600, 200);
        this.popupFrame.setLocationRelativeTo(null);
        this.popupFrame.show();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.confirmButton) {
            int index = this.accountsComboBox.getSelectedIndex();
            this.selectedAccountId = this.AccountIds.get(index);
            this.popupFrame.dispatchEvent(new WindowEvent(this.popupFrame, 201));
            this.injectCredentials(this.selectedAccountId);
        }
    }

    private void consumeResult(String result) {
        if (result.startsWith("[ERROR]")) {
            this.parseIssue(result);
            return;
        }
        String[] retrievedCredentials = result.split(",");
        this.username = retrievedCredentials[0].trim();
        this.password = retrievedCredentials[1].trim();
        this.setPassword();
        this.setUsername();
        this.commandRunner = null;
    }

    private void setPassword() {
        if (this.password != null) {
            this.client.setPassword(this.password);
        }
    }

    private void setUsername() {
        if (this.username != null) {
            this.client.setUsername(this.username);
        }
    }

    void clearCredentials() {
        this.password = null;
        this.username = null;
        this.selectedAccountId = null;
    }

    void reset() {
        this.clearCredentials();
        this.commandRunner = null;
    }

    void injectCredentials(String accountId) {
        if (this.commandRunner == null) {
            this.commandRunner = new CommandRunner(accountId, this::consumeResult);
            this.commandRunner.start();
        } else {
            this.setPassword();
            this.setUsername();
        }
    }
}

