/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.utils.buffer;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.system.MemoryUtil;
import rs117.hd.HdPlugin;

public class GpuIntBuffer {
    private IntBuffer buffer;

    public GpuIntBuffer() {
        this(65536);
    }

    public GpuIntBuffer(int initialCapacity) {
        this.buffer = MemoryUtil.memAllocInt((int)initialCapacity);
    }

    public void destroy() {
        if (this.buffer != null) {
            MemoryUtil.memFree((Buffer)this.buffer);
        }
        this.buffer = null;
    }

    protected void finalize() {
        this.destroy();
    }

    public void put(int x, int y, int z) {
        this.buffer.put(x).put(y).put(z);
    }

    public void put(int x, int y, int z, int w) {
        this.buffer.put(x).put(y).put(z).put(w);
    }

    public void put(int[] ints) {
        this.buffer.put(ints);
    }

    public void put(IntBuffer buffer) {
        this.buffer.put(buffer);
    }

    public int position() {
        return this.buffer.position();
    }

    public void flip() {
        this.buffer.flip();
    }

    public GpuIntBuffer clear() {
        this.buffer.clear();
        return this;
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public GpuIntBuffer ensureCapacity(int size) {
        int position;
        int capacity = this.buffer.capacity();
        if (capacity - (position = this.buffer.position()) < size) {
            while ((capacity = (int)((float)capacity * HdPlugin.BUFFER_GROWTH_MULTIPLIER)) - position < size) {
            }
            IntBuffer newB = MemoryUtil.memAllocInt((int)capacity);
            this.buffer.flip();
            newB.put(this.buffer);
            MemoryUtil.memFree((Buffer)this.buffer);
            this.buffer = newB;
        }
        return this;
    }

    public IntBuffer getBuffer() {
        return this.buffer;
    }
}

