/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.utils;

import com.google.gson.Gson;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.swing.ImageIcon;
import lombok.NonNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.utils.FileWatcher;
import rs117.hd.utils.Props;

public class ResourcePath {
    private static final Logger log = LoggerFactory.getLogger(ResourcePath.class);
    public static ResourcePath RESOURCE_PATH = Props.getPathOrDefault("rlhd.resource-path", () -> null);
    private static final FileWatcher.UnregisterCallback NOOP = () -> {};
    @Nullable
    public final ResourcePath root;
    @Nullable
    public final String path;

    public static ResourcePath path(Path path) {
        return ResourcePath.path(path.toString());
    }

    public static ResourcePath path(String ... parts) {
        return new ResourcePath(parts);
    }

    public static ResourcePath path(Class<?> root, String ... parts) {
        return new ClassResourcePath(root, parts);
    }

    public static ResourcePath path(ClassLoader root, String ... parts) {
        return new ClassLoaderResourcePath(root, parts);
    }

    private ResourcePath(String ... parts) {
        this((ResourcePath)null, parts);
    }

    private ResourcePath(@Nonnull ResourcePath root) {
        this.root = root;
        this.path = null;
    }

    private ResourcePath(@Nullable ResourcePath root, String ... parts) {
        this.root = root;
        this.path = ResourcePath.normalize(parts);
    }

    public ResourcePath chroot() {
        return new ResourcePath(this);
    }

    public ResourcePath resolve(String ... parts) {
        return new ResourcePath(this.root, ResourcePath.normalize(this.path, parts));
    }

    public ResourcePath mkdirs() {
        this.toFile().getParentFile().mkdirs();
        return this;
    }

    public boolean exists() {
        if (this.root == null) {
            return this.toFile().exists();
        }
        return this.root.resolve(this.path).exists();
    }

    public String getFilename() {
        if (this.path == null) {
            return "";
        }
        int i = this.path.lastIndexOf("/");
        if (i != -1) {
            return this.path.substring(i + 1);
        }
        return this.path;
    }

    public String getExtension() {
        return this.getExtension(0);
    }

    public String getExtension(int nthLast) {
        String filename = this.getFilename();
        String extension = "";
        while (nthLast-- >= 0) {
            int i = filename.lastIndexOf(46);
            if (i == -1) {
                return nthLast >= 0 ? "" : filename;
            }
            extension = filename.substring(i + 1);
            filename = filename.substring(0, i);
        }
        return extension;
    }

    public ResourcePath setExtension(String extension) {
        if (this.path == null) {
            throw new IllegalStateException("Cannot set extension for root path: " + this);
        }
        Object path = this.path;
        int i = ((String)path).lastIndexOf(46);
        if (i != -1) {
            path = ((String)path).substring(0, i);
        }
        if (extension != null && !extension.isEmpty()) {
            path = (String)path + "." + extension;
        }
        return new ResourcePath(this.root, new String[]{path});
    }

    public boolean matches(@RegEx String posixPathRegex) {
        Pattern p = Pattern.compile(posixPathRegex);
        Matcher m = p.matcher(this.toPosixPath());
        return m.find();
    }

    public boolean equals(Object other) {
        return other instanceof ResourcePath && this.toAbsolute().toPosixPath().equals(((ResourcePath)other).toAbsolute().toPosixPath());
    }

    public String toString() {
        String path = this.toPosixPath();
        if (this.root != null) {
            path = ResourcePath.normalize(this.root.toPosixPath(), path.startsWith("/") ? path.substring(1) : path);
        }
        return path.length() == 0 ? "." : path;
    }

    public ResourcePath toAbsolute() {
        if (this.root != null) {
            Path rootPath = this.root.toPath().toAbsolutePath();
            Path path = this.toPath().toAbsolutePath();
            return new ResourcePath(this.root, rootPath.relativize(path).toString());
        }
        return ResourcePath.path(this.toPath().toAbsolutePath());
    }

    public String toPosixPath() {
        if (this.root != null) {
            return ResourcePath.normalize(this.root.toPosixPath(), new String[]{this.path});
        }
        return this.path;
    }

    public Path toPath() {
        if (this.root == null) {
            assert (this.path != null);
            return Paths.get(this.path, new String[0]);
        }
        Path basePath = this.root.toPath();
        if (this.path == null) {
            return basePath;
        }
        String relativePath = this.path.startsWith("/") ? this.path.substring(1) : this.path;
        return basePath.resolve(relativePath);
    }

    public File toFile() {
        if (!this.isFileSystemResource()) {
            throw new IllegalStateException("Not a file: " + this);
        }
        return this.toPath().toFile();
    }

    @NonNull
    public URL toURL() throws IOException {
        if (this.root == null) {
            String path = this.toPath().toString();
            return new URL("file:" + (String)(ResourcePath.isAbsolute(path) ? path : "./" + path));
        }
        URL rootURL = this.root.toURL();
        return new URL(rootURL, rootURL.getProtocol() + ":" + ResourcePath.normalize(rootURL.getPath(), new String[]{this.path}));
    }

    public BufferedReader toReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.toInputStream(), StandardCharsets.UTF_8));
    }

    public InputStream toInputStream() throws IOException {
        if (this.path == null) {
            throw new IllegalStateException("Cannot get InputStream for root path: " + this);
        }
        if (this.root != null) {
            String path = this.path;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            return this.root.resolve(path).toInputStream();
        }
        try {
            return Files.newInputStream(this.toPath(), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new IOException("Unable to load resource: " + this, ex);
        }
    }

    public FileOutputStream toOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.toFile());
    }

    public boolean isClassResource() {
        if (this.root != null) {
            return this.root.isClassResource();
        }
        return false;
    }

    public boolean isFileSystemResource() {
        try {
            return this.toURL().getProtocol().equals("file");
        }
        catch (IOException ex) {
            return false;
        }
    }

    public FileWatcher.UnregisterCallback watch(BiConsumer<ResourcePath, Boolean> changeHandler) {
        if (RESOURCE_PATH == null) {
            changeHandler.accept(this, true);
            return NOOP;
        }
        ResourcePath path = RESOURCE_PATH.chroot().resolve(this.toAbsolute().toPath().toString());
        changeHandler.accept(path, true);
        return FileWatcher.watchPath(path, p -> changeHandler.accept((ResourcePath)p, false));
    }

    public FileWatcher.UnregisterCallback watch(Consumer<ResourcePath> changeHandler) {
        return this.watch((ResourcePath path, Boolean first) -> changeHandler.accept((ResourcePath)path));
    }

    public FileWatcher.UnregisterCallback watch(@RegEx String filter, BiConsumer<ResourcePath, Boolean> changeHandler) {
        return this.watch((ResourcePath path, Boolean first) -> {
            if (path.matches(filter)) {
                changeHandler.accept((ResourcePath)path, (Boolean)first);
            }
        });
    }

    public FileWatcher.UnregisterCallback watch(@RegEx String filter, Consumer<ResourcePath> changeHandler) {
        return this.watch(filter, (ResourcePath path, Boolean first) -> changeHandler.accept((ResourcePath)path));
    }

    public String loadString() throws IOException {
        try (BufferedReader reader = this.toReader();){
            String string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public <T> T loadJson(Gson gson, Class<T> type) throws IOException {
        try (BufferedReader reader = this.toReader();){
            Object object = gson.fromJson((Reader)reader, type);
            return (T)object;
        }
    }

    public BufferedImage loadImage() throws IOException {
        try (InputStream is = this.toInputStream();){
            byte[] bytes = is.readAllBytes();
            ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(bytes));
            BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D g = bufferedImage.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            g.dispose();
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
    }

    public ByteBuffer loadByteBuffer() throws IOException {
        return ResourcePath.readInputStream(this.toInputStream(), BufferUtils::createByteBuffer, null);
    }

    public ByteBuffer loadByteBufferMalloc() throws IOException {
        return ResourcePath.readInputStream(this.toInputStream(), MemoryUtil::memAlloc, MemoryUtil::memRealloc);
    }

    public ResourcePath writeByteBuffer(ByteBuffer buffer) throws IOException {
        try (FileOutputStream os = this.toOutputStream();
             FileChannel channel = os.getChannel();){
            int bytesToWrite = buffer.remaining();
            int bytesWritten = channel.write(buffer);
            if (bytesWritten < bytesToWrite) {
                throw new IOException(String.format("Only %d out of %d bytes were successfully written to %s", bytesWritten, bytesToWrite, this));
            }
        }
        return this;
    }

    public ResourcePath writeString(String string) throws IOException {
        try (FileOutputStream os = this.toOutputStream();){
            ((OutputStream)os).write(string.getBytes(StandardCharsets.UTF_8));
        }
        return this;
    }

    private static ByteBuffer readInputStream(InputStream is, Function<Integer, ByteBuffer> alloc, @Nullable BiFunction<ByteBuffer, Integer, ByteBuffer> realloc) throws IOException {
        if (realloc == null) {
            realloc = (oldBuffer, newSize) -> {
                ByteBuffer newBuffer = (ByteBuffer)alloc.apply((Integer)newSize);
                newBuffer.put((ByteBuffer)oldBuffer);
                return newBuffer;
            };
        }
        try (ReadableByteChannel channel = Channels.newChannel(is);){
            ByteBuffer buffer = alloc.apply(is.available());
            channel.read(buffer);
            if (is.available() > buffer.remaining()) {
                int newSize2 = (buffer.position() + is.available()) * 2;
                int nearestPow2 = 2 << 31 - Integer.numberOfLeadingZeros(newSize2 - 1);
                buffer = realloc.apply(buffer, nearestPow2);
            }
            while (is.available() > 0) {
                if (buffer.remaining() != channel.read(buffer)) continue;
                buffer = realloc.apply(buffer, buffer.capacity() * 2);
            }
            channel.close();
            buffer.flip();
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    private static String normalize(String ... parts) {
        return ResourcePath.normalize(null, parts);
    }

    private static String normalize(@Nullable String workingDirectory, String[] parts) {
        Stack<String> resolvedParts = new Stack<String>();
        if (workingDirectory != null && workingDirectory.length() > 0 && !workingDirectory.equals(".")) {
            resolvedParts.addAll(Arrays.asList(ResourcePath.normalizeSlashes(workingDirectory).split("/")));
        }
        if (parts.length > 0) {
            parts[0] = ResourcePath.resolveTilde(parts[0]);
        }
        for (String part : parts) {
            if (part == null || part.length() == 0 || part.equals(".")) continue;
            if (ResourcePath.isAbsolute(part = ResourcePath.normalizeSlashes(part))) {
                resolvedParts.clear();
            }
            for (String normalizedPart : part.split("/")) {
                if (normalizedPart.equals("..") && resolvedParts.size() > 0 && !((String)resolvedParts.peek()).equals("..")) {
                    resolvedParts.pop();
                    continue;
                }
                resolvedParts.push(normalizedPart);
            }
        }
        return String.join((CharSequence)"/", resolvedParts);
    }

    private static String normalizeSlashes(String path) {
        if (Platform.get() == Platform.WINDOWS) {
            return path.replace("\\", "/");
        }
        return path;
    }

    private static String resolveTilde(String path) {
        if (path == null || !path.startsWith("~")) {
            return path;
        }
        int slashIndex = path.indexOf(47);
        String specifiedUser = path.substring(1, slashIndex == -1 ? path.length() : slashIndex);
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            throw new RuntimeException("Unable to resolve tilde path: " + path);
        }
        Path home = Paths.get(userHome, new String[0]);
        if (!specifiedUser.isEmpty()) {
            home = home.resolve("../" + specifiedUser);
        }
        if (slashIndex == -1) {
            return home.toString();
        }
        return home.resolve(path.substring(slashIndex + 1)).toString();
    }

    private static boolean isAbsolute(String path) {
        if (Platform.get() == Platform.WINDOWS) {
            path = path.replaceFirst("^\\w:", "");
        }
        return path.startsWith("/");
    }

    private static class ClassResourcePath
    extends ResourcePath {
        public final Class<?> root;

        public ClassResourcePath(@NonNull Class<?> root, String ... parts) {
            super(parts);
            if (root == null) {
                throw new NullPointerException("root is marked non-null but is null");
            }
            this.root = root;
        }

        @Override
        public ResourcePath resolve(String ... parts) {
            return new ClassResourcePath(this.root, ResourcePath.normalize(this.path, parts));
        }

        @Override
        public boolean exists() {
            assert (this.path != null);
            return this.root.getResource(this.path) != null;
        }

        @Override
        public String toString() {
            return super.toString() + " from class " + this.root.getName();
        }

        @Override
        public ResourcePath toAbsolute() {
            return ClassResourcePath.path(this.root, ResourcePath.normalize("/" + this.root.getPackage().getName().replace(".", "/"), this.path));
        }

        @Override
        public boolean isClassResource() {
            return true;
        }

        @Override
        public boolean isFileSystemResource() {
            URL url = this.root.getResource("/");
            if (url == null) {
                return false;
            }
            return url.getProtocol().equals("file");
        }

        @Override
        @NonNull
        public URL toURL() throws IOException {
            assert (this.path != null);
            URL url = this.root.getResource(this.path);
            if (url == null) {
                throw new IOException("No resource found for path " + this);
            }
            return url;
        }

        @Override
        public InputStream toInputStream() throws IOException {
            assert (this.path != null);
            if (RESOURCE_PATH != null) {
                ResourcePath path = null;
                try {
                    path = RESOURCE_PATH.chroot().resolve(this.toAbsolute().toPath().toString());
                    return path.toInputStream();
                }
                catch (IOException ex) {
                    throw new IOException("Failed to load resource from project resource path: " + path, ex);
                }
            }
            InputStream is = this.root.getResourceAsStream(this.path);
            if (is == null) {
                throw new IOException("Missing resource: " + this);
            }
            return is;
        }
    }

    private static class ClassLoaderResourcePath
    extends ResourcePath {
        public final ClassLoader root;

        public ClassLoaderResourcePath(ClassLoader root, String ... parts) {
            super(parts);
            this.root = root;
        }

        @Override
        public ResourcePath resolve(String ... parts) {
            return new ClassLoaderResourcePath(this.root, ResourcePath.normalize(this.path, parts));
        }

        @Override
        public boolean exists() {
            assert (this.path != null);
            return this.root.getResource(this.path) != null;
        }

        @Override
        public String toString() {
            return super.toString() + " from class loader " + this.root;
        }

        @Override
        public ResourcePath toAbsolute() {
            assert (this.path != null);
            return this.path.startsWith("/") ? this : ClassLoaderResourcePath.path(this.root, "/", this.path);
        }

        @Override
        public boolean isClassResource() {
            return true;
        }

        @Override
        public boolean isFileSystemResource() {
            URL url = this.root.getResource("/");
            if (url == null) {
                return false;
            }
            return url.getProtocol().equals("file");
        }

        @Override
        @NonNull
        public URL toURL() throws IOException {
            URL url = this.root.getResource(this.path);
            if (url == null) {
                throw new IOException("No resource found for path " + this);
            }
            return url;
        }

        @Override
        public InputStream toInputStream() throws IOException {
            InputStream is;
            assert (this.path != null);
            if (RESOURCE_PATH != null) {
                ResourcePath path = null;
                try {
                    path = RESOURCE_PATH.chroot().resolve(this.toAbsolute().toPath().toString());
                    return path.toInputStream();
                }
                catch (Exception ex) {
                    log.warn("Failed to load resource from project resource folder: {}", path, (Object)ex);
                }
            }
            if ((is = this.root.getResourceAsStream(this.path)) == null) {
                throw new IOException("Missing resource: " + this);
            }
            return is;
        }
    }
}

