/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.utils;

import java.util.HashSet;
import java.util.Random;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.data.environments.Area;
import rs117.hd.scene.ProceduralGenerator;
import rs117.hd.utils.AABB;
import rs117.hd.utils.ColorUtils;

@Singleton
public class HDUtils {
    private static final Logger log = LoggerFactory.getLogger(HDUtils.class);
    public static final long KiB = 1024L;
    public static final long MiB = 0x100000L;
    public static final long GiB = 0x40000000L;
    public static final Random rand = new Random();
    private static final float[] LIGHT_DIR_TILE = new float[]{0.70710677f, 0.70710677f, 0.0f};
    public static final float EPSILON = 1.1920929E-7f;
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float HALF_PI = 1.5707964f;
    public static final float QUARTER_PI = 1.5707964f;

    public static float[] add(float[] out, float[] a, float[] b) {
        for (int i = 0; i < out.length; ++i) {
            out[i] = a[i] + b[i];
        }
        return out;
    }

    public static float[] subtract(float[] out, float[] a, float[] b) {
        for (int i = 0; i < out.length; ++i) {
            out[i] = a[i] - b[i];
        }
        return out;
    }

    public static float[] cross(float[] out, float[] a, float[] b) {
        out[0] = a[1] * b[2] - a[2] * b[1];
        out[1] = a[2] * b[0] - a[0] * b[2];
        out[2] = a[0] * b[1] - a[1] * b[0];
        return out;
    }

    public static float[] abs(float[] out, float[] v) {
        for (int i = 0; i < out.length; ++i) {
            out[i] = Math.abs(v[i]);
        }
        return out;
    }

    public static float min(float ... v) {
        float min = v[0];
        for (int i = 1; i < v.length; ++i) {
            if (!(v[i] < min)) continue;
            min = v[i];
        }
        return min;
    }

    public static float max(float ... v) {
        float max = v[0];
        for (int i = 1; i < v.length; ++i) {
            if (!(v[i] > max)) continue;
            max = v[i];
        }
        return max;
    }

    public static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    public static float[] lerp(float[] vecA, float[] vecB, float t) {
        float[] out = new float[Math.min(vecA.length, vecB.length)];
        for (int i = 0; i < out.length; ++i) {
            out[i] = HDUtils.lerp(vecA[i], vecB[i], t);
        }
        return out;
    }

    static int[] lerp(int[] vecA, int[] vecB, float t) {
        int[] out = new int[Math.min(vecA.length, vecB.length)];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (int)HDUtils.lerp(vecA[i], vecB[i], t);
        }
        return out;
    }

    public static float hermite(float from, float to, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        return from * (1.0f - 3.0f * t2 + 2.0f * t3) + to * (3.0f * t2 - 2.0f * t3);
    }

    public static float[] hermite(float[] from, float[] to, float t) {
        float[] result = new float[from.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = HDUtils.hermite(from[i], to[i], t);
        }
        return result;
    }

    public static double fract(double x) {
        return HDUtils.mod(x, 1.0);
    }

    public static float fract(float x) {
        return HDUtils.mod(x, 1.0f);
    }

    public static double mod(double x, double modulus) {
        return x - Math.floor(x / modulus) * modulus;
    }

    public static float mod(float x, float modulus) {
        return (float)((double)x - Math.floor(x / modulus) * (double)modulus);
    }

    public static int mod(int x, int modulus) {
        return x - x / modulus * modulus;
    }

    public static float clamp(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }

    public static int clamp(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public static int vertexHash(int[] vPos) {
        StringBuilder s = new StringBuilder();
        for (int part : vPos) {
            s.append(part).append(",");
        }
        return s.toString().hashCode();
    }

    public static float[] calculateSurfaceNormals(float[] a, float[] b, float[] c) {
        HDUtils.subtract(b, a, b);
        HDUtils.subtract(c, a, c);
        float[] n = new float[3];
        return HDUtils.cross(n, b, c);
    }

    public static float dotLightDirectionTile(float x, float y, float z) {
        float length = x * x + y * y + z * z;
        if (length < 1.1920929E-7f) {
            return 0.0f;
        }
        return (x * LIGHT_DIR_TILE[0] + y * LIGHT_DIR_TILE[1]) / (float)Math.sqrt(length);
    }

    public static long ceilPow2(long x) {
        return (long)Math.pow(2.0, Math.ceil(Math.log(x) / Math.log(2.0)));
    }

    public static float[] sunAngles(float altitude, float azimuth) {
        return new float[]{(float)Math.toRadians(altitude), (float)Math.toRadians(azimuth)};
    }

    public static int convertWallObjectOrientation(int orientation) {
        switch (orientation) {
            case 1: {
                return 512;
            }
            case 2: {
                return 1024;
            }
            case 4: {
                return 1536;
            }
            default: {
                return 0;
            }
            case 16: {
                return 768;
            }
            case 32: {
                return 1280;
            }
            case 64: {
                return 1792;
            }
            case 128: 
        }
        return 256;
    }

    public static int getBakedOrientation(int config) {
        switch (config >> 6 & 3) {
            case 0: {
                return 1024;
            }
            case 1: {
                return 1536;
            }
            default: {
                return 0;
            }
            case 3: 
        }
        return 512;
    }

    public static HashSet<Integer> getSceneRegionIds(Scene scene) {
        HashSet<Integer> regionIds = new HashSet<Integer>();
        if (scene.isInstance()) {
            int[][][] chunks;
            int[][][] nArray = chunks = scene.getInstanceTemplateChunks();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[][] plane;
                int[][] nArray2 = plane = nArray[i];
                int n2 = nArray2.length;
                for (int j = 0; j < n2; ++j) {
                    int[] column;
                    for (int chunk : column = nArray2[j]) {
                        if (chunk == -1) continue;
                        int x = chunk >> 14 & 0x3FF;
                        int y = chunk >> 3 & 0x7FF;
                        regionIds.add(x >> 3 << 8 | y >> 3);
                    }
                }
            }
        } else {
            int baseX = scene.getBaseX();
            int baseY = scene.getBaseY();
            for (int x = 0; x < 104; x += 64) {
                for (int y = 0; y < 104; y += 64) {
                    regionIds.add(baseX + x >> 6 << 8 | baseY + y >> 6);
                }
            }
        }
        return regionIds;
    }

    public static WorldPoint getSceneBase(Scene scene, int plane) {
        int baseX = scene.getBaseX();
        int baseY = scene.getBaseY();
        if (scene.isInstance()) {
            int chunkX = 6;
            int chunkY = 6;
            int chunk = scene.getInstanceTemplateChunks()[plane][chunkX][chunkY];
            if (chunk == -1) {
                int[][] chunks = scene.getInstanceTemplateChunks()[plane];
                block0: for (chunkX = 0; chunkX < chunks.length; ++chunkX) {
                    for (chunkY = 0; chunkY < chunks[chunkX].length; ++chunkY) {
                        chunk = chunks[chunkX][chunkY];
                        if (chunk != -1) break block0;
                    }
                }
            }
            baseX = chunk >> 14 & 0x3FF;
            baseY = chunk >> 3 & 0x7FF;
            baseX -= chunkX;
            baseY -= chunkY;
            baseX <<= 3;
            baseY <<= 3;
        }
        return new WorldPoint(baseX, baseY, plane);
    }

    public static int[] cameraSpaceToWorldPoint(Client client, int relativeX, int relativeZ) {
        int localX = client.getCameraX2() + relativeX;
        int localY = client.getCameraZ2() + relativeZ;
        int plane = client.getPlane();
        return HDUtils.localToWorld(client.getScene(), localX, localY, plane);
    }

    public static int[] localToWorld(Scene scene, int localX, int localY, int plane) {
        int sceneX = localX / 128;
        int sceneY = localY / 128;
        if (scene.isInstance() && sceneX >= 0 && sceneY >= 0 && sceneX < 104 && sceneY < 104) {
            int chunkX = sceneX / 8;
            int chunkY = sceneY / 8;
            int templateChunk = scene.getInstanceTemplateChunks()[plane][chunkX][chunkY];
            int rotation = 4 - (templateChunk >> 1 & 3);
            int templateChunkY = (templateChunk >> 3 & 0x7FF) * 8;
            int templateChunkX = (templateChunk >> 14 & 0x3FF) * 8;
            int templateChunkPlane = templateChunk >> 24 & 3;
            int worldX = templateChunkX + (sceneX & 7);
            int worldY = templateChunkY + (sceneY & 7);
            int[] pos = new int[]{worldX, worldY, templateChunkPlane};
            chunkX = pos[0] & 0xFFFFFFF8;
            chunkY = pos[1] & 0xFFFFFFF8;
            int x = pos[0] & 7;
            int y = pos[1] & 7;
            switch (rotation) {
                case 1: {
                    pos[0] = chunkX + y;
                    pos[1] = chunkY + (7 - x);
                    break;
                }
                case 2: {
                    pos[0] = chunkX + (7 - x);
                    pos[1] = chunkY + (7 - y);
                    break;
                }
                case 3: {
                    pos[0] = chunkX + (7 - y);
                    pos[1] = chunkY + x;
                }
            }
            return pos;
        }
        return new int[]{scene.getBaseX() + sceneX, scene.getBaseY() + sceneY, plane};
    }

    public static int worldToRegionID(int[] worldPoint) {
        return HDUtils.worldToRegionID(worldPoint[0], worldPoint[1]);
    }

    public static int worldToRegionID(int worldX, int worldY) {
        return worldX >> 6 << 8 | worldY >> 6;
    }

    public static boolean is32Bit() {
        return System.getProperty("sun.arch.data.model", "Unknown").equals("32");
    }

    public static boolean sceneIntersects(Scene scene, Area area) {
        return HDUtils.sceneIntersects(scene, area.aabbs);
    }

    public static boolean sceneIntersects(Scene scene, AABB ... aabbs) {
        if (scene.isInstance()) {
            int[][][] templateChunks;
            int[][][] nArray = templateChunks = scene.getInstanceTemplateChunks();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[][] plane;
                int[][] nArray2 = plane = nArray[i];
                int n2 = nArray2.length;
                for (int j = 0; j < n2; ++j) {
                    int[] column;
                    for (int chunk : column = nArray2[j]) {
                        if (chunk == -1) continue;
                        int chunkX = chunk >> 14 & 0x3FF;
                        int chunkY = chunk >> 3 & 0x7FF;
                        int minX = chunkX * 8;
                        int minY = chunkY * 8;
                        int maxX = (chunkX + 1) * 8 - 1;
                        int maxY = (chunkY + 1) * 8 - 1;
                        for (AABB aabb : aabbs) {
                            if (!aabb.intersects(minX, minY, maxX, maxY)) continue;
                            return true;
                        }
                    }
                }
            }
        } else {
            int baseX = scene.getBaseX();
            int baseY = scene.getBaseX();
            AABB sceneAabb = new AABB(baseX, baseY, baseX + 104 - 1, baseY + 104 - 1);
            for (AABB aabb : aabbs) {
                if (!sceneAabb.intersects(aabb)) continue;
                return true;
            }
        }
        return false;
    }

    public static int[] getSouthWesternMostTileColor(Tile tile) {
        SceneTilePaint paint = tile.getSceneTilePaint();
        SceneTileModel model = tile.getSceneTileModel();
        if (paint != null) {
            return ColorUtils.unpackHslRaw(paint.getSwColor());
        }
        if (model != null) {
            int faceCount = tile.getSceneTileModel().getFaceX().length;
            int[] faceColorsA = model.getTriangleColorA();
            int[] faceColorsB = model.getTriangleColorB();
            int[] faceColorsC = model.getTriangleColorC();
            int hsl = 0;
            block0: for (int face = 0; face < faceCount; ++face) {
                if (ProceduralGenerator.isOverlayFace(tile, face)) continue;
                int[][] vertices = ProceduralGenerator.faceLocalVertices(tile, face);
                int[] faceColors = new int[]{faceColorsA[face], faceColorsB[face], faceColorsC[face]};
                for (int vertex = 0; vertex < 3; ++vertex) {
                    hsl = faceColors[vertex];
                    if (vertices[vertex][0] != 128 && vertices[vertex][1] != 128) break block0;
                }
            }
            return ColorUtils.unpackHslRaw(hsl);
        }
        return null;
    }
}

