/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.utils;

import java.awt.event.KeyEvent;
import javax.inject.Inject;
import net.runelite.api.events.CommandExecuted;
import net.runelite.client.config.Keybind;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.data.environments.Area;
import rs117.hd.overlays.FrameTimingsOverlay;
import rs117.hd.overlays.ShadowMapOverlay;
import rs117.hd.overlays.TileInfoOverlay;
import rs117.hd.utils.AABB;
import rs117.hd.utils.Props;

public class DeveloperTools
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(DeveloperTools.class);
    private static final Keybind KEY_TOGGLE_TILE_INFO = new Keybind(114, 128);
    private static final Keybind KEY_TOGGLE_FRAME_TIMINGS = new Keybind(115, 128);
    private static final Keybind KEY_TOGGLE_SHADOW_MAP_OVERLAY = new Keybind(116, 128);
    @Inject
    private EventBus eventBus;
    @Inject
    private KeyManager keyManager;
    @Inject
    private TileInfoOverlay tileInfoOverlay;
    @Inject
    private FrameTimingsOverlay frameTimingsOverlay;
    @Inject
    private ShadowMapOverlay shadowMapOverlay;
    private boolean tileInfoOverlayEnabled = false;
    private boolean frameTimingsOverlayEnabled = false;
    private boolean shadowMapOverlayEnabled = false;

    public void activate() {
        this.eventBus.register((Object)this);
        if (!Props.DEVELOPMENT) {
            return;
        }
        this.keyManager.registerKeyListener((KeyListener)this);
        this.tileInfoOverlay.setActive(this.tileInfoOverlayEnabled);
        this.frameTimingsOverlay.setActive(this.frameTimingsOverlayEnabled);
        this.shadowMapOverlay.setActive(this.shadowMapOverlayEnabled);
        for (Area area : Area.values()) {
            if (area == Area.ALL || area == Area.NONE) continue;
            for (AABB aabb : area.aabbs) {
                if (aabb.minX >= -128 && aabb.minY >= 1000 && aabb.maxX <= 5000 && aabb.maxY <= 13000) continue;
                throw new IllegalArgumentException("Your definition for the area " + area + " has an incorrect AABB: " + aabb);
            }
        }
    }

    public void deactivate() {
        this.eventBus.unregister((Object)this);
        this.keyManager.unregisterKeyListener((KeyListener)this);
        this.tileInfoOverlay.setActive(false);
        this.frameTimingsOverlay.setActive(false);
        this.shadowMapOverlay.setActive(false);
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        String action;
        if (!commandExecuted.getCommand().equalsIgnoreCase("117hd")) {
            return;
        }
        String[] args = commandExecuted.getArguments();
        if (args.length < 1) {
            return;
        }
        switch (action = args[0].toLowerCase()) {
            case "tileinfo": {
                this.tileInfoOverlayEnabled = !this.tileInfoOverlayEnabled;
                this.tileInfoOverlay.setActive(this.tileInfoOverlayEnabled);
                break;
            }
            case "timers": {
                this.frameTimingsOverlayEnabled = !this.frameTimingsOverlayEnabled;
                this.frameTimingsOverlay.setActive(this.frameTimingsOverlayEnabled);
                break;
            }
            case "shadowmap": {
                this.shadowMapOverlayEnabled = !this.shadowMapOverlayEnabled;
                this.shadowMapOverlay.setActive(this.shadowMapOverlayEnabled);
            }
        }
    }

    public void keyPressed(KeyEvent event) {
        if (KEY_TOGGLE_TILE_INFO.matches(event)) {
            event.consume();
            this.tileInfoOverlayEnabled = !this.tileInfoOverlayEnabled;
            this.tileInfoOverlay.setActive(this.tileInfoOverlayEnabled);
        }
        if (KEY_TOGGLE_FRAME_TIMINGS.matches(event)) {
            event.consume();
            this.frameTimingsOverlayEnabled = !this.frameTimingsOverlayEnabled;
            this.frameTimingsOverlay.setActive(this.frameTimingsOverlayEnabled);
        }
        if (KEY_TOGGLE_SHADOW_MAP_OVERLAY.matches(event)) {
            event.consume();
            this.shadowMapOverlayEnabled = !this.shadowMapOverlayEnabled;
            this.shadowMapOverlay.setActive(this.shadowMapOverlayEnabled);
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }
}

