/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.utils;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.runelite.api.coords.WorldPoint;
import rs117.hd.data.environments.Area;
import rs117.hd.utils.GsonUtils;

public class AABB {
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public AABB(int regionId) {
        this.minX = regionId >>> 8 << 6;
        this.minY = (regionId & 0xFF) << 6;
        this.maxX = this.minX + 64 - 1;
        this.maxY = this.minY + 64 - 1;
        this.minZ = Integer.MIN_VALUE;
        this.maxZ = Integer.MAX_VALUE;
    }

    public AABB(int x, int y) {
        this.minX = this.maxX = x;
        this.minY = this.maxY = y;
        this.minZ = Integer.MIN_VALUE;
        this.maxZ = Integer.MAX_VALUE;
    }

    public AABB(int x, int y, int z) {
        this.minX = this.maxX = x;
        this.minY = this.maxY = y;
        this.minZ = this.maxZ = z;
    }

    public AABB(int x1, int y1, int x2, int y2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Integer.MIN_VALUE;
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Integer.MAX_VALUE;
    }

    public AABB(int x1, int y1, int x2, int y2, int z1) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.minZ = this.maxZ = z1;
    }

    public AABB(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Math.max(z1, z2);
    }

    public static AABB[] regions(int ... regionIds) {
        return (AABB[])Arrays.stream(regionIds).mapToObj(AABB::new).toArray(AABB[]::new);
    }

    public static AABB regionBox(int fromRegionId, int toRegionId) {
        int temp;
        int x1 = fromRegionId >>> 8;
        int y1 = fromRegionId & 0xFF;
        int x2 = toRegionId >>> 8;
        int y2 = toRegionId & 0xFF;
        if (x1 > x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 > y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        return new AABB(x1 << 6, y1 << 6, (x2 + 1 << 6) - 1, (y2 + 1 << 6) - 1);
    }

    public AABB onPlane(int plane) {
        return new AABB(this.minX, this.minY, plane, this.maxX, this.maxY, plane);
    }

    public boolean hasZ() {
        return this.minZ != Integer.MIN_VALUE || this.maxZ != Integer.MAX_VALUE;
    }

    public boolean isPoint() {
        return this.minX == this.maxX && this.minY == this.maxY && (!this.hasZ() || this.minZ == this.maxZ);
    }

    public boolean isVolume() {
        return !this.isPoint();
    }

    public boolean contains(int ... worldXYZ) {
        return this.minX <= worldXYZ[0] && worldXYZ[0] <= this.maxX && this.minY <= worldXYZ[1] && worldXYZ[1] <= this.maxY && (worldXYZ.length < 3 || this.minZ <= worldXYZ[2] && worldXYZ[2] <= this.maxZ);
    }

    public boolean contains(WorldPoint location) {
        return this.contains(location.getX(), location.getY(), location.getPlane());
    }

    public boolean contains(AABB other) {
        return this.contains(other.minX, other.minY, other.minZ) && this.contains(other.maxX, other.maxY, other.maxZ);
    }

    public boolean intersects(int minX, int minY, int maxX, int maxY) {
        return minX < this.maxX && maxX > this.minX && minY < this.maxY && maxY > this.minY;
    }

    public boolean intersects(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        return minX < this.maxX && maxX > this.minX && minY < this.maxY && maxY > this.minY && minZ < this.maxZ && maxZ > this.minZ;
    }

    public boolean intersects(AABB other) {
        return this.intersects(other.minX, other.maxX, other.minY, other.maxY, other.minZ, other.maxZ);
    }

    public String toString() {
        if (this.hasZ()) {
            return String.format("AABB{min=(%d,%d,%d), max=(%d,%d,%d)}", this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
        return String.format("AABB{min=(%d,%d), max=(%d,%d)}", this.minX, this.minY, this.maxX, this.maxY);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AABB)) {
            return false;
        }
        AABB other = (AABB)obj;
        return other.minX == this.minX && other.maxX == this.maxX && other.minY == this.minY && other.maxY == this.maxY && other.minZ == this.minZ && other.maxZ == this.maxZ;
    }

    public static class JsonAdapter
    extends TypeAdapter<AABB[]> {
        private final Area.JsonAdapter areaAdapter = new Area.JsonAdapter();

        public AABB[] read(JsonReader in) throws IOException {
            in.beginArray();
            ArrayList<AABB> list = new ArrayList<AABB>();
            while (in.hasNext() && in.peek() != JsonToken.END_ARRAY) {
                if (in.peek() == JsonToken.NULL) {
                    in.skipValue();
                    continue;
                }
                if (in.peek() == JsonToken.NUMBER) {
                    list.add(new AABB(in.nextInt()));
                    continue;
                }
                if (in.peek() == JsonToken.STRING) {
                    Area area = this.areaAdapter.read(in);
                    Collections.addAll(list, area.aabbs);
                    continue;
                }
                in.beginArray();
                int[] ints = new int[6];
                int i = 0;
                block14: while (in.hasNext()) {
                    switch (in.peek()) {
                        case NUMBER: {
                            if (i >= ints.length) {
                                throw new IOException("Too many numbers in AABB entry (> " + ints.length + ") at " + GsonUtils.location(in));
                            }
                            ints[i++] = in.nextInt();
                        }
                        case END_ARRAY: {
                            continue block14;
                        }
                        case NULL: {
                            in.skipValue();
                            continue block14;
                        }
                    }
                    throw new IOException("Malformed AABB entry. Unexpected token: " + in.peek() + " at " + GsonUtils.location(in));
                }
                in.endArray();
                switch (i) {
                    case 1: {
                        list.add(new AABB(ints[0]));
                        break;
                    }
                    case 2: {
                        list.add(new AABB(ints[0], ints[1]));
                        break;
                    }
                    case 3: {
                        list.add(new AABB(ints[0], ints[1], ints[2]));
                        break;
                    }
                    case 4: {
                        list.add(new AABB(ints[0], ints[1], ints[2], ints[3]));
                        break;
                    }
                    case 5: {
                        list.add(new AABB(ints[0], ints[2], ints[1], ints[3], ints[4]));
                        break;
                    }
                    case 6: {
                        list.add(new AABB(ints[0], ints[1], ints[2], ints[3], ints[4], ints[5]));
                    }
                }
            }
            in.endArray();
            return list.toArray(new AABB[0]);
        }

        public void write(JsonWriter out, AABB[] aabbs) throws IOException {
            if (aabbs == null || aabbs.length == 0) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (AABB aabb : aabbs) {
                out.beginArray();
                out.value((long)aabb.minX);
                out.value((long)aabb.minY);
                if (aabb.hasZ()) {
                    out.value((long)aabb.minZ);
                }
                if (aabb.isVolume()) {
                    out.value((long)aabb.maxX);
                    out.value((long)aabb.maxY);
                    if (aabb.hasZ()) {
                        out.value((long)aabb.maxZ);
                    }
                }
                out.endArray();
            }
            out.endArray();
        }
    }
}

