/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.scene.lights;

import net.runelite.api.GraphicsObject;
import net.runelite.api.NPC;
import net.runelite.api.Projectile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.WorldPoint;
import rs117.hd.scene.lights.LightDefinition;
import rs117.hd.scene.lights.LightType;
import rs117.hd.scene.model_overrides.ModelOverride;
import rs117.hd.utils.HDUtils;

public class Light {
    public final float randomOffset = HDUtils.rand.nextFloat();
    public final LightDefinition def;
    public int radius;
    public float strength;
    public float[] color;
    public float animation = 0.5f;
    public float duration;
    public float fadeInDuration;
    public float currentFadeIn;
    public int impostorObjectId;
    public boolean visible = true;
    public WorldPoint worldPoint;
    public int x;
    public int y;
    public int z;
    public int plane;
    public int distanceSquared = 0;
    public boolean belowFloor = false;
    public boolean aboveFloor = false;
    public Projectile projectile;
    public NPC npc;
    public TileObject object;
    public GraphicsObject graphicsObject;
    public ModelOverride modelOverride = ModelOverride.NONE;

    public Light(LightDefinition def) {
        this.def = def;
        this.duration = def.duration / 1000.0f;
        this.fadeInDuration = (float)def.fadeInDuration / 1000.0f;
        this.color = def.color;
        this.radius = def.radius;
        this.strength = def.strength;
        this.plane = def.plane;
        if (def.type == LightType.PULSE) {
            this.animation = (float)Math.random();
        }
    }
}

