/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.scene.environments;

import com.google.gson.annotations.JsonAdapter;
import java.util.Objects;
import rs117.hd.data.environments.Area;
import rs117.hd.utils.ColorUtils;
import rs117.hd.utils.GsonUtils;
import rs117.hd.utils.HDUtils;

public class Environment {
    public static final Environment DEFAULT = new Environment().setKey("DEFAULT").setArea(Area.ALL).setFogColor(ColorUtils.rgb("#000000")).setWaterColor(ColorUtils.rgb("#66eaff")).setSunAngles(HDUtils.sunAngles(52.0f, 235.0f)).normalize();
    public static final Environment NONE = new Environment().setKey("NONE").setFogColor(ColorUtils.rgb("#ff00ff")).normalize();
    public static Environment OVERWORLD;
    public static Environment AUTUMN;
    public static Environment WINTER;
    public String key;
    @JsonAdapter(value=Area.JsonAdapter.class)
    public Area area = Area.NONE;
    public boolean isOverworld = false;
    public boolean isUnderwater = false;
    public boolean allowSkyOverride = true;
    public boolean lightningEffects = false;
    @JsonAdapter(value=ColorUtils.SrgbToLinearAdapter.class)
    public float[] ambientColor = ColorUtils.rgb("#ffffff");
    public float ambientStrength = 1.0f;
    @JsonAdapter(value=ColorUtils.SrgbToLinearAdapter.class)
    public float[] directionalColor = ColorUtils.rgb("#ffffff");
    public float directionalStrength = 0.25f;
    @JsonAdapter(value=ColorUtils.SrgbToLinearAdapter.class)
    public float[] waterColor;
    @JsonAdapter(value=ColorUtils.SrgbToLinearAdapter.class)
    public float[] waterCausticsColor;
    public float waterCausticsStrength = -1.0f;
    @JsonAdapter(value=ColorUtils.SrgbToLinearAdapter.class)
    public float[] underglowColor = ColorUtils.rgb("#000000");
    public float underglowStrength = 0.0f;
    @JsonAdapter(value=GsonUtils.DegreesToRadians.class)
    public float[] sunAngles;
    @JsonAdapter(value=ColorUtils.SrgbToLinearAdapter.class)
    public float[] fogColor;
    public float fogDepth = 25.0f;
    public int groundFogStart = -200;
    public int groundFogEnd = -500;
    public float groundFogOpacity = 0.0f;

    public Environment normalize() {
        if (this.area != Area.ALL && this.area != Area.NONE) {
            this.isOverworld = Area.OVERWORLD.intersects(this.area);
            if (!this.isOverworld && DEFAULT != null) {
                this.sunAngles = Objects.requireNonNullElse(this.sunAngles, Environment.DEFAULT.sunAngles);
                this.fogColor = Objects.requireNonNullElse(this.fogColor, Environment.DEFAULT.fogColor);
                this.waterColor = Objects.requireNonNullElse(this.waterColor, Environment.DEFAULT.waterColor);
            }
        }
        if (this.waterCausticsColor == null) {
            this.waterCausticsColor = this.directionalColor;
        }
        if (this.waterCausticsStrength == -1.0f) {
            this.waterCausticsStrength = this.directionalStrength;
        }
        return this;
    }

    public String toString() {
        if (this.key != null) {
            return this.key;
        }
        return this.area.name();
    }

    private Environment setKey(String key) {
        this.key = key;
        return this;
    }

    private Environment setArea(Area area) {
        this.area = area;
        return this;
    }

    private Environment setOverworld(boolean isOverworld) {
        this.isOverworld = isOverworld;
        return this;
    }

    private Environment setUnderwater(boolean isUnderwater) {
        this.isUnderwater = isUnderwater;
        return this;
    }

    private Environment setAllowSkyOverride(boolean allowSkyOverride) {
        this.allowSkyOverride = allowSkyOverride;
        return this;
    }

    private Environment setLightningEffects(boolean lightningEffects) {
        this.lightningEffects = lightningEffects;
        return this;
    }

    private Environment setAmbientColor(float[] ambientColor) {
        this.ambientColor = ambientColor;
        return this;
    }

    private Environment setAmbientStrength(float ambientStrength) {
        this.ambientStrength = ambientStrength;
        return this;
    }

    private Environment setDirectionalColor(float[] directionalColor) {
        this.directionalColor = directionalColor;
        return this;
    }

    private Environment setDirectionalStrength(float directionalStrength) {
        this.directionalStrength = directionalStrength;
        return this;
    }

    private Environment setWaterColor(float[] waterColor) {
        this.waterColor = waterColor;
        return this;
    }

    private Environment setWaterCausticsColor(float[] waterCausticsColor) {
        this.waterCausticsColor = waterCausticsColor;
        return this;
    }

    private Environment setWaterCausticsStrength(float waterCausticsStrength) {
        this.waterCausticsStrength = waterCausticsStrength;
        return this;
    }

    private Environment setUnderglowColor(float[] underglowColor) {
        this.underglowColor = underglowColor;
        return this;
    }

    private Environment setUnderglowStrength(float underglowStrength) {
        this.underglowStrength = underglowStrength;
        return this;
    }

    private Environment setSunAngles(float[] sunAngles) {
        this.sunAngles = sunAngles;
        return this;
    }

    private Environment setFogColor(float[] fogColor) {
        this.fogColor = fogColor;
        return this;
    }

    private Environment setFogDepth(float fogDepth) {
        this.fogDepth = fogDepth;
        return this;
    }

    private Environment setGroundFogStart(int groundFogStart) {
        this.groundFogStart = groundFogStart;
        return this;
    }

    private Environment setGroundFogEnd(int groundFogEnd) {
        this.groundFogEnd = groundFogEnd;
        return this;
    }

    private Environment setGroundFogOpacity(float groundFogOpacity) {
        this.groundFogOpacity = groundFogOpacity;
        return this;
    }
}

