/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.scene;

import com.google.common.base.Stopwatch;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.Model;
import net.runelite.api.Point;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.WallObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.HdPlugin;
import rs117.hd.HdPluginConfig;
import rs117.hd.data.WaterType;
import rs117.hd.data.environments.Area;
import rs117.hd.data.materials.GroundMaterial;
import rs117.hd.data.materials.Material;
import rs117.hd.data.materials.Overlay;
import rs117.hd.data.materials.Underlay;
import rs117.hd.data.materials.UvType;
import rs117.hd.model.ModelPusher;
import rs117.hd.scene.ModelOverrideManager;
import rs117.hd.scene.ProceduralGenerator;
import rs117.hd.scene.SceneContext;
import rs117.hd.scene.model_overrides.ModelOverride;
import rs117.hd.scene.model_overrides.ObjectType;
import rs117.hd.utils.HDUtils;

@Singleton
public class SceneUploader {
    private static final Logger log = LoggerFactory.getLogger(SceneUploader.class);
    public static final int SCENE_ID_MASK = 65535;
    public static final int EXCLUDED_FROM_SCENE_BUFFER = -1;
    private static final float[] UP_NORMAL = new float[]{0.0f, -1.0f, 0.0f};
    @Inject
    private Client client;
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    @Inject
    public ProceduralGenerator proceduralGenerator;
    @Inject
    private ModelPusher modelPusher;
    @Inject
    private ModelOverrideManager modelOverrideManager;

    public void upload(SceneContext sceneContext) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (int z = 0; z < 4; ++z) {
            for (int x = 0; x < 104; ++x) {
                for (int y = 0; y < 104; ++y) {
                    Tile tile = sceneContext.scene.getTiles()[z][x][y];
                    if (tile == null) continue;
                    this.upload(sceneContext, tile, x, y);
                }
            }
        }
        stopwatch.stop();
        log.debug("Scene upload time: {}, unique models: {}, size: {} MB", new Object[]{stopwatch, sceneContext.uniqueModels, String.format("%.2f", (double)(sceneContext.getVertexOffset() * 8 * 4 + sceneContext.getUvOffset() * 4 * 4) / 1000000.0)});
    }

    public void fillGaps(SceneContext sceneContext) {
        int sceneMin = 0;
        int sceneMax = 104;
        Tile[][][] extendedTiles = sceneContext.scene.getTiles();
        for (int tileZ = 0; tileZ < 4; ++tileZ) {
            for (int tileX = 0; tileX < 104; ++tileX) {
                for (int tileY = 0; tileY < 104; ++tileY) {
                    int vertexCount;
                    boolean fillGaps;
                    Tile tile = extendedTiles[tileZ][tileX][tileY];
                    SceneTileModel model = null;
                    int renderLevel = tileZ;
                    if (tile != null) {
                        renderLevel = tile.getRenderLevel();
                        SceneTilePaint paint = tile.getSceneTilePaint();
                        model = tile.getSceneTileModel();
                        if (model == null) {
                            boolean hasTilePaint;
                            boolean bl = hasTilePaint = paint != null && paint.getNeColor() != 12345678;
                            if (!hasTilePaint && (tile = tile.getBridge()) != null) {
                                renderLevel = tile.getRenderLevel();
                                paint = tile.getSceneTilePaint();
                                model = tile.getSceneTileModel();
                                boolean bl2 = hasTilePaint = paint != null && paint.getNeColor() != 12345678;
                            }
                            if (hasTilePaint) continue;
                        }
                    }
                    int[] worldPoint = sceneContext.sceneToWorld(tileX, tileY, tileZ);
                    boolean bl = fillGaps = tileZ == 0 && tileX > sceneMin && tileY > sceneMin && tileX < sceneMax - 1 && tileY < sceneMax - 1 && Area.OVERWORLD.containsPoint(worldPoint);
                    if (fillGaps) {
                        int tileRegionID = HDUtils.worldToRegionID(worldPoint);
                        int[] regions = this.client.getMapRegions();
                        fillGaps = false;
                        for (int region : regions) {
                            if (region != tileRegionID) continue;
                            fillGaps = true;
                            break;
                        }
                    }
                    if (!fillGaps) continue;
                    int vertexOffset = sceneContext.getVertexOffset();
                    int uvOffset = sceneContext.getUvOffset();
                    if (model == null) {
                        this.uploadBlackTile(sceneContext, tileX, tileY, renderLevel);
                        vertexCount = 6;
                    } else {
                        int[] uploadedTileModelData = this.uploadHDTileModelSurface(sceneContext, tile, model, true);
                        vertexCount = uploadedTileModelData[0];
                    }
                    if (vertexCount <= 0) continue;
                    sceneContext.staticUnorderedModelBuffer.ensureCapacity(8).getBuffer().put(vertexOffset).put(uvOffset).put(vertexCount / 3).put(sceneContext.staticVertexCount).put(0).put(tileX * 128).put(0).put(tileY * 128);
                    sceneContext.staticVertexCount += vertexCount;
                }
            }
        }
    }

    private void uploadModel(SceneContext sceneContext, Tile tile, long hash, Model model, int orientation, ObjectType objectType) {
        if (model.getUnskewedModel() != null) {
            model = model.getUnskewedModel();
        }
        if (model.getSceneId() == -1) {
            return;
        }
        int[] worldPos = sceneContext.localToWorld(tile.getLocalLocation(), tile.getPlane());
        ModelOverride modelOverride = this.modelOverrideManager.getOverride(hash, worldPos);
        int sceneId = modelOverride.hashCode() << 16 | sceneContext.id;
        if ((model.getSceneId() & 0xFFFF) == sceneContext.id) {
            if (model.getSceneId() != sceneId) {
                model.setSceneId(-1);
            }
            return;
        }
        int vertexOffset = sceneContext.getVertexOffset();
        int uvOffset = sceneContext.getUvOffset();
        if (modelOverride.hide) {
            vertexOffset = -1;
        } else {
            this.modelPusher.pushModel(sceneContext, tile, hash, model, modelOverride, objectType, orientation, false);
            if (sceneContext.modelPusherResults[1] == 0) {
                uvOffset = -1;
            }
        }
        model.setBufferOffset(vertexOffset);
        model.setUvBufferOffset(uvOffset);
        model.setSceneId(sceneId);
        ++sceneContext.uniqueModels;
    }

    private void upload(SceneContext sceneContext, @Nonnull Tile tile, int tileX, int tileY) {
        GameObject[] gameObjects;
        DecorativeObject decorativeObject;
        Renderable renderable;
        GroundObject groundObject;
        WallObject wallObject;
        SceneTileModel sceneTileModel;
        SceneTilePaint sceneTilePaint;
        Tile bridge = tile.getBridge();
        if (bridge != null) {
            this.upload(sceneContext, bridge, tileX, tileY);
        }
        if ((sceneTilePaint = tile.getSceneTilePaint()) != null) {
            int vertexOffset = sceneContext.getVertexOffset();
            int uvOffset = sceneContext.getUvOffset();
            int[] uploadedTilePaintData = this.upload(sceneContext, tile, sceneTilePaint);
            int vertexCount = uploadedTilePaintData[0];
            int uvCount = uploadedTilePaintData[1];
            int hasUnderwaterTerrain = uploadedTilePaintData[2];
            int[][][] tileHeights = sceneContext.scene.getTileHeights();
            if (hasUnderwaterTerrain == 1 && tileHeights[tile.getRenderLevel()][tileX][tileY] >= -16) {
                sceneContext.staticUnorderedModelBuffer.ensureCapacity(8).getBuffer().put(vertexOffset).put(uvOffset).put(2).put(sceneContext.staticVertexCount).put(0).put(tileX * 128).put(0).put(tileY * 128);
                sceneContext.staticVertexCount += 6;
                vertexCount -= 6;
                uvCount -= 6;
                vertexOffset += 6;
                uvOffset += 6;
            }
            if (uvCount <= 0) {
                uvOffset = -1;
            }
            sceneTilePaint.setBufferLen(vertexCount);
            sceneTilePaint.setBufferOffset(vertexOffset);
            sceneTilePaint.setUvBufferOffset(uvOffset);
        }
        if ((sceneTileModel = tile.getSceneTileModel()) != null) {
            sceneTileModel.setBufferOffset(sceneContext.getVertexOffset());
            sceneTileModel.setUvBufferOffset(sceneContext.getUvOffset());
            int[] uploadedTileModelData = this.upload(sceneContext, tile, sceneTileModel);
            int bufferLength = uploadedTileModelData[0];
            int uvBufferLength = uploadedTileModelData[1];
            int underwaterTerrain = uploadedTileModelData[2];
            if (uvBufferLength <= 0) {
                sceneTileModel.setUvBufferOffset(-1);
            }
            int packedBufferLength = bufferLength << 1 | underwaterTerrain;
            sceneTileModel.setBufferLen(packedBufferLength);
        }
        if ((wallObject = tile.getWallObject()) != null) {
            Renderable renderable2;
            Renderable renderable1 = wallObject.getRenderable1();
            if (renderable1 instanceof Model) {
                this.uploadModel(sceneContext, tile, wallObject.getHash(), (Model)renderable1, HDUtils.convertWallObjectOrientation(wallObject.getOrientationA()), ObjectType.WALL_OBJECT);
            }
            if ((renderable2 = wallObject.getRenderable2()) instanceof Model) {
                this.uploadModel(sceneContext, tile, wallObject.getHash(), (Model)renderable2, HDUtils.convertWallObjectOrientation(wallObject.getOrientationB()), ObjectType.WALL_OBJECT);
            }
        }
        if ((groundObject = tile.getGroundObject()) != null && (renderable = groundObject.getRenderable()) instanceof Model) {
            this.uploadModel(sceneContext, tile, groundObject.getHash(), (Model)renderable, HDUtils.getBakedOrientation(groundObject.getConfig()), ObjectType.GROUND_OBJECT);
        }
        if ((decorativeObject = tile.getDecorativeObject()) != null) {
            Renderable renderable2;
            Renderable renderable3 = decorativeObject.getRenderable();
            if (renderable3 instanceof Model) {
                this.uploadModel(sceneContext, tile, decorativeObject.getHash(), (Model)renderable3, HDUtils.getBakedOrientation(decorativeObject.getConfig()), ObjectType.DECORATIVE_OBJECT);
            }
            if ((renderable2 = decorativeObject.getRenderable2()) instanceof Model) {
                this.uploadModel(sceneContext, tile, decorativeObject.getHash(), (Model)renderable2, HDUtils.getBakedOrientation(decorativeObject.getConfig()), ObjectType.DECORATIVE_OBJECT);
            }
        }
        for (GameObject gameObject : gameObjects = tile.getGameObjects()) {
            Renderable renderable4;
            if (gameObject == null || !((renderable4 = gameObject.getRenderable()) instanceof Model)) continue;
            this.uploadModel(sceneContext, tile, gameObject.getHash(), (Model)gameObject.getRenderable(), HDUtils.getBakedOrientation(gameObject.getConfig()), ObjectType.GAME_OBJECT);
        }
    }

    private int[] upload(SceneContext sceneContext, Tile tile, SceneTilePaint sceneTilePaint) {
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int[] bufferLengths = this.uploadHDTilePaintUnderwater(sceneContext, tile, sceneTilePaint);
        bufferLength += bufferLengths[0];
        uvBufferLength += bufferLengths[1];
        underwaterTerrain += bufferLengths[2];
        bufferLengths = this.uploadHDTilePaintSurface(sceneContext, tile, sceneTilePaint);
        return new int[]{bufferLength += bufferLengths[0], uvBufferLength += bufferLengths[1], underwaterTerrain += bufferLengths[2]};
    }

    private int[] uploadHDTilePaintSurface(SceneContext sceneContext, Tile tile, SceneTilePaint sceneTilePaint) {
        Scene scene = sceneContext.scene;
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int tileZ = tile.getRenderLevel();
        boolean localX = false;
        boolean localY = false;
        int baseX = scene.getBaseX();
        int baseY = scene.getBaseY();
        int[][][] tileHeights = scene.getTileHeights();
        int swHeight = tileHeights[tileZ][tileX][tileY];
        int seHeight = tileHeights[tileZ][tileX + 1][tileY];
        int neHeight = tileHeights[tileZ][tileX + 1][tileY + 1];
        int nwHeight = tileHeights[tileZ][tileX][tileY + 1];
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int localSwVertexX = 0;
        int localSwVertexY = 0;
        int localSeVertexX = 128;
        int localSeVertexY = 0;
        int localNwVertexX = 0;
        int localNwVertexY = 128;
        int localNeVertexX = 128;
        int localNeVertexY = 128;
        int[] vertexKeys = ProceduralGenerator.tileVertexKeys(scene, tile);
        int swVertexKey = vertexKeys[0];
        int seVertexKey = vertexKeys[1];
        int nwVertexKey = vertexKeys[2];
        int neVertexKey = vertexKeys[3];
        if (sceneTilePaint.getNeColor() != 12345678) {
            int swColor = sceneTilePaint.getSwColor();
            int seColor = sceneTilePaint.getSeColor();
            int neColor = sceneTilePaint.getNeColor();
            int nwColor = sceneTilePaint.getNwColor();
            int tileTexture = sceneTilePaint.getTexture();
            boolean neVertexIsOverlay = false;
            boolean nwVertexIsOverlay = false;
            boolean seVertexIsOverlay = false;
            boolean swVertexIsOverlay = false;
            Material swMaterial = Material.NONE;
            Material seMaterial = Material.NONE;
            Material neMaterial = Material.NONE;
            Material nwMaterial = Material.NONE;
            float[] swNormals = UP_NORMAL;
            float[] seNormals = UP_NORMAL;
            float[] neNormals = UP_NORMAL;
            float[] nwNormals = UP_NORMAL;
            WaterType waterType = this.proceduralGenerator.tileWaterType(scene, tile, sceneTilePaint);
            if (waterType == WaterType.NONE) {
                swMaterial = Material.fromVanillaTexture(tileTexture);
                seMaterial = Material.fromVanillaTexture(tileTexture);
                neMaterial = Material.fromVanillaTexture(tileTexture);
                nwMaterial = Material.fromVanillaTexture(tileTexture);
                swNormals = sceneContext.vertexTerrainNormals.getOrDefault(swVertexKey, swNormals);
                seNormals = sceneContext.vertexTerrainNormals.getOrDefault(seVertexKey, seNormals);
                neNormals = sceneContext.vertexTerrainNormals.getOrDefault(neVertexKey, neNormals);
                nwNormals = sceneContext.vertexTerrainNormals.getOrDefault(nwVertexKey, nwNormals);
                if (this.plugin.configGroundBlending && !this.proceduralGenerator.useDefaultColor(scene, tile) && sceneTilePaint.getTexture() == -1) {
                    swColor = sceneContext.vertexTerrainColor.getOrDefault(swVertexKey, swColor);
                    seColor = sceneContext.vertexTerrainColor.getOrDefault(seVertexKey, seColor);
                    neColor = sceneContext.vertexTerrainColor.getOrDefault(neVertexKey, neColor);
                    nwColor = sceneContext.vertexTerrainColor.getOrDefault(nwVertexKey, nwColor);
                    if (this.plugin.configGroundTextures) {
                        swMaterial = sceneContext.vertexTerrainTexture.getOrDefault(swVertexKey, swMaterial);
                        seMaterial = sceneContext.vertexTerrainTexture.getOrDefault(seVertexKey, seMaterial);
                        neMaterial = sceneContext.vertexTerrainTexture.getOrDefault(neVertexKey, neMaterial);
                        nwMaterial = sceneContext.vertexTerrainTexture.getOrDefault(nwVertexKey, nwMaterial);
                    }
                } else {
                    GroundMaterial groundMaterial;
                    Overlay overlay = Overlay.getOverlay(scene, tile, this.plugin);
                    if (overlay != Overlay.NONE) {
                        groundMaterial = overlay.groundMaterial;
                        swColor = overlay.modifyColor(swColor);
                        seColor = overlay.modifyColor(seColor);
                        nwColor = overlay.modifyColor(nwColor);
                        neColor = overlay.modifyColor(neColor);
                    } else {
                        Underlay underlay = Underlay.getUnderlay(scene, tile, this.plugin);
                        groundMaterial = underlay.groundMaterial;
                        if (underlay != Underlay.NONE) {
                            swColor = underlay.modifyColor(swColor);
                            seColor = underlay.modifyColor(seColor);
                            nwColor = underlay.modifyColor(nwColor);
                            neColor = underlay.modifyColor(neColor);
                        }
                    }
                    if (this.plugin.configGroundTextures && groundMaterial != null) {
                        swMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX, baseY + tileY);
                        seMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + 1, baseY + tileY);
                        nwMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX, baseY + tileY + 1);
                        neMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + 1, baseY + tileY + 1);
                    }
                }
            } else {
                neColor = 127;
                nwColor = 127;
                seColor = 127;
                swColor = 127;
                if (sceneContext.vertexIsWater.containsKey(swVertexKey) && sceneContext.vertexIsLand.containsKey(swVertexKey)) {
                    swColor = 0;
                }
                if (sceneContext.vertexIsWater.containsKey(seVertexKey) && sceneContext.vertexIsLand.containsKey(seVertexKey)) {
                    seColor = 0;
                }
                if (sceneContext.vertexIsWater.containsKey(nwVertexKey) && sceneContext.vertexIsLand.containsKey(nwVertexKey)) {
                    nwColor = 0;
                }
                if (sceneContext.vertexIsWater.containsKey(neVertexKey) && sceneContext.vertexIsLand.containsKey(neVertexKey)) {
                    neColor = 0;
                }
            }
            if (sceneContext.vertexIsOverlay.containsKey(neVertexKey) && sceneContext.vertexIsUnderlay.containsKey(neVertexKey)) {
                neVertexIsOverlay = true;
            }
            if (sceneContext.vertexIsOverlay.containsKey(nwVertexKey) && sceneContext.vertexIsUnderlay.containsKey(nwVertexKey)) {
                nwVertexIsOverlay = true;
            }
            if (sceneContext.vertexIsOverlay.containsKey(seVertexKey) && sceneContext.vertexIsUnderlay.containsKey(seVertexKey)) {
                seVertexIsOverlay = true;
            }
            if (sceneContext.vertexIsOverlay.containsKey(swVertexKey) && sceneContext.vertexIsUnderlay.containsKey(swVertexKey)) {
                swVertexIsOverlay = true;
            }
            int swTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            int seTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            int nwTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            int neTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            sceneContext.stagingBufferNormals.ensureCapacity(24);
            sceneContext.stagingBufferNormals.put(neNormals[0], neNormals[2], neNormals[1], neTerrainData);
            sceneContext.stagingBufferNormals.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            sceneContext.stagingBufferNormals.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            sceneContext.stagingBufferNormals.put(swNormals[0], swNormals[2], swNormals[1], swTerrainData);
            sceneContext.stagingBufferNormals.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            sceneContext.stagingBufferNormals.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            sceneContext.stagingBufferVertices.ensureCapacity(24);
            sceneContext.stagingBufferVertices.put(localNeVertexX, neHeight, localNeVertexY, neColor);
            sceneContext.stagingBufferVertices.put(localNwVertexX, nwHeight, localNwVertexY, nwColor);
            sceneContext.stagingBufferVertices.put(localSeVertexX, seHeight, localSeVertexY, seColor);
            sceneContext.stagingBufferVertices.put(localSwVertexX, swHeight, localSwVertexY, swColor);
            sceneContext.stagingBufferVertices.put(localSeVertexX, seHeight, localSeVertexY, seColor);
            sceneContext.stagingBufferVertices.put(localNwVertexX, nwHeight, localNwVertexY, nwColor);
            bufferLength += 6;
            int packedMaterialDataSW = this.modelPusher.packMaterialData(swMaterial, tileTexture, ModelOverride.NONE, UvType.GEOMETRY, swVertexIsOverlay);
            int packedMaterialDataSE = this.modelPusher.packMaterialData(seMaterial, tileTexture, ModelOverride.NONE, UvType.GEOMETRY, seVertexIsOverlay);
            int packedMaterialDataNW = this.modelPusher.packMaterialData(nwMaterial, tileTexture, ModelOverride.NONE, UvType.GEOMETRY, nwVertexIsOverlay);
            int packedMaterialDataNE = this.modelPusher.packMaterialData(neMaterial, tileTexture, ModelOverride.NONE, UvType.GEOMETRY, neVertexIsOverlay);
            sceneContext.stagingBufferUvs.ensureCapacity(24);
            sceneContext.stagingBufferUvs.put(0.0f, 0.0f, 0.0f, packedMaterialDataNE);
            sceneContext.stagingBufferUvs.put(1.0f, 0.0f, 0.0f, packedMaterialDataNW);
            sceneContext.stagingBufferUvs.put(0.0f, 1.0f, 0.0f, packedMaterialDataSE);
            sceneContext.stagingBufferUvs.put(1.0f, 1.0f, 0.0f, packedMaterialDataSW);
            sceneContext.stagingBufferUvs.put(0.0f, 1.0f, 0.0f, packedMaterialDataSE);
            sceneContext.stagingBufferUvs.put(1.0f, 0.0f, 0.0f, packedMaterialDataNW);
            uvBufferLength += 6;
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    private int[] uploadHDTilePaintUnderwater(SceneContext sceneContext, Tile tile, SceneTilePaint sceneTilePaint) {
        Scene scene = sceneContext.scene;
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int tileZ = tile.getRenderLevel();
        int baseX = scene.getBaseX();
        int baseY = scene.getBaseY();
        if (baseX >= 2816 && baseX <= 2970 && baseY <= 5375 && baseY >= 5220) {
            return new int[]{0, 0, 0};
        }
        int[][][] tileHeights = scene.getTileHeights();
        int swHeight = tileHeights[tileZ][tileX][tileY];
        int seHeight = tileHeights[tileZ][tileX + 1][tileY];
        int neHeight = tileHeights[tileZ][tileX + 1][tileY + 1];
        int nwHeight = tileHeights[tileZ][tileX][tileY + 1];
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int localSwVertexX = 0;
        int localSwVertexY = 0;
        int localSeVertexX = 128;
        int localSeVertexY = 0;
        int localNwVertexX = 0;
        int localNwVertexY = 128;
        int localNeVertexX = 128;
        int localNeVertexY = 128;
        int[] vertexKeys = ProceduralGenerator.tileVertexKeys(scene, tile);
        int swVertexKey = vertexKeys[0];
        int seVertexKey = vertexKeys[1];
        int nwVertexKey = vertexKeys[2];
        int neVertexKey = vertexKeys[3];
        if (sceneContext.tileIsWater[tileZ][tileX][tileY]) {
            underwaterTerrain = 1;
            int swColor = 6676;
            int seColor = 6676;
            int neColor = 6676;
            int nwColor = 6676;
            int swDepth = sceneContext.vertexUnderwaterDepth.getOrDefault(swVertexKey, 0);
            int seDepth = sceneContext.vertexUnderwaterDepth.getOrDefault(seVertexKey, 0);
            int nwDepth = sceneContext.vertexUnderwaterDepth.getOrDefault(nwVertexKey, 0);
            int neDepth = sceneContext.vertexUnderwaterDepth.getOrDefault(neVertexKey, 0);
            float[] swNormals = sceneContext.vertexTerrainNormals.getOrDefault(swVertexKey, UP_NORMAL);
            float[] seNormals = sceneContext.vertexTerrainNormals.getOrDefault(seVertexKey, UP_NORMAL);
            float[] nwNormals = sceneContext.vertexTerrainNormals.getOrDefault(nwVertexKey, UP_NORMAL);
            float[] neNormals = sceneContext.vertexTerrainNormals.getOrDefault(neVertexKey, UP_NORMAL);
            Material swMaterial = Material.NONE;
            Material seMaterial = Material.NONE;
            Material nwMaterial = Material.NONE;
            Material neMaterial = Material.NONE;
            if (this.plugin.configGroundTextures) {
                GroundMaterial groundMaterial = GroundMaterial.UNDERWATER_GENERIC;
                swMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX, baseY + tileY);
                seMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + 1, baseY + tileY);
                nwMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX, baseY + tileY + 1);
                neMaterial = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + 1, baseY + tileY + 1);
            }
            WaterType waterType = this.proceduralGenerator.tileWaterType(scene, tile, sceneTilePaint);
            int swTerrainData = SceneUploader.packTerrainData(true, Math.max(1, swDepth), waterType, tileZ);
            int seTerrainData = SceneUploader.packTerrainData(true, Math.max(1, seDepth), waterType, tileZ);
            int nwTerrainData = SceneUploader.packTerrainData(true, Math.max(1, nwDepth), waterType, tileZ);
            int neTerrainData = SceneUploader.packTerrainData(true, Math.max(1, neDepth), waterType, tileZ);
            sceneContext.stagingBufferNormals.ensureCapacity(24);
            sceneContext.stagingBufferNormals.put(neNormals[0], neNormals[2], neNormals[1], neTerrainData);
            sceneContext.stagingBufferNormals.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            sceneContext.stagingBufferNormals.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            sceneContext.stagingBufferNormals.put(swNormals[0], swNormals[2], swNormals[1], swTerrainData);
            sceneContext.stagingBufferNormals.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            sceneContext.stagingBufferNormals.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            sceneContext.stagingBufferVertices.ensureCapacity(24);
            sceneContext.stagingBufferVertices.put(localNeVertexX, neHeight + neDepth, localNeVertexY, neColor);
            sceneContext.stagingBufferVertices.put(localNwVertexX, nwHeight + nwDepth, localNwVertexY, nwColor);
            sceneContext.stagingBufferVertices.put(localSeVertexX, seHeight + seDepth, localSeVertexY, seColor);
            sceneContext.stagingBufferVertices.put(localSwVertexX, swHeight + swDepth, localSwVertexY, swColor);
            sceneContext.stagingBufferVertices.put(localSeVertexX, seHeight + seDepth, localSeVertexY, seColor);
            sceneContext.stagingBufferVertices.put(localNwVertexX, nwHeight + nwDepth, localNwVertexY, nwColor);
            bufferLength += 6;
            int packedMaterialDataSW = this.modelPusher.packMaterialData(swMaterial, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
            int packedMaterialDataSE = this.modelPusher.packMaterialData(seMaterial, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
            int packedMaterialDataNW = this.modelPusher.packMaterialData(nwMaterial, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
            int packedMaterialDataNE = this.modelPusher.packMaterialData(neMaterial, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
            sceneContext.stagingBufferUvs.ensureCapacity(24);
            sceneContext.stagingBufferUvs.put(0.0f, 0.0f, 0.0f, packedMaterialDataNE);
            sceneContext.stagingBufferUvs.put(1.0f, 0.0f, 0.0f, packedMaterialDataNW);
            sceneContext.stagingBufferUvs.put(0.0f, 1.0f, 0.0f, packedMaterialDataSE);
            sceneContext.stagingBufferUvs.put(1.0f, 1.0f, 0.0f, packedMaterialDataSW);
            sceneContext.stagingBufferUvs.put(0.0f, 1.0f, 0.0f, packedMaterialDataSE);
            sceneContext.stagingBufferUvs.put(1.0f, 0.0f, 0.0f, packedMaterialDataNW);
            uvBufferLength += 6;
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    private int[] upload(SceneContext sceneContext, Tile tile, SceneTileModel sceneTileModel) {
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int[] bufferLengths = this.uploadHDTileModelSurface(sceneContext, tile, sceneTileModel, false);
        bufferLength += bufferLengths[0];
        uvBufferLength += bufferLengths[1];
        underwaterTerrain += bufferLengths[2];
        bufferLengths = this.uploadHDTileModelUnderwater(sceneContext, tile, sceneTileModel);
        assert (bufferLengths[0] == bufferLength || bufferLengths[0] == 0);
        return new int[]{bufferLength += bufferLengths[0], uvBufferLength += bufferLengths[1], underwaterTerrain += bufferLengths[2]};
    }

    private int[] uploadHDTileModelSurface(SceneContext sceneContext, Tile tile, SceneTileModel sceneTileModel, boolean fillGaps) {
        Scene scene = sceneContext.scene;
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int tileZ = tile.getRenderLevel();
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        if (sceneContext.skipTile[tileZ][tileX][tileY]) {
            return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
        }
        int[] faceColorA = sceneTileModel.getTriangleColorA();
        int[] faceColorB = sceneTileModel.getTriangleColorB();
        int[] faceColorC = sceneTileModel.getTriangleColorC();
        int[] faceTextures = sceneTileModel.getTriangleTextureId();
        int faceCount = sceneTileModel.getFaceX().length;
        int baseX = scene.getBaseX();
        int baseY = scene.getBaseY();
        for (int face = 0; face < faceCount; ++face) {
            boolean isHidden;
            int colorA = faceColorA[face];
            int colorB = faceColorB[face];
            int colorC = faceColorC[face];
            int[][] localVertices = ProceduralGenerator.faceLocalVertices(tile, face);
            int[] vertexKeys = ProceduralGenerator.faceVertexKeys(tile, face);
            int vertexKeyA = vertexKeys[0];
            int vertexKeyB = vertexKeys[1];
            int vertexKeyC = vertexKeys[2];
            boolean vertexAIsOverlay = false;
            boolean vertexBIsOverlay = false;
            boolean vertexCIsOverlay = false;
            int textureIndex = -1;
            Material materialA = Material.NONE;
            Material materialB = Material.NONE;
            Material materialC = Material.NONE;
            float[] normalsA = UP_NORMAL;
            float[] normalsB = UP_NORMAL;
            float[] normalsC = UP_NORMAL;
            WaterType waterType = WaterType.NONE;
            boolean bl = isHidden = colorA == 12345678;
            if (fillGaps) {
                if (!isHidden) continue;
                colorC = 0;
                colorB = 0;
                colorA = 0;
            } else {
                if (isHidden) continue;
                waterType = this.proceduralGenerator.faceWaterType(scene, tile, face, sceneTileModel);
                if (waterType == WaterType.NONE) {
                    if (faceTextures != null) {
                        textureIndex = faceTextures[face];
                        materialA = Material.fromVanillaTexture(textureIndex);
                        materialB = Material.fromVanillaTexture(textureIndex);
                        materialC = Material.fromVanillaTexture(textureIndex);
                    }
                    normalsA = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyA, normalsA);
                    normalsB = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyB, normalsB);
                    normalsC = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyC, normalsC);
                    if (!(!this.plugin.configGroundBlending || ProceduralGenerator.isOverlayFace(tile, face) && this.proceduralGenerator.useDefaultColor(scene, tile) || materialA != Material.NONE)) {
                        colorA = sceneContext.vertexTerrainColor.getOrDefault(vertexKeyA, colorA);
                        colorB = sceneContext.vertexTerrainColor.getOrDefault(vertexKeyB, colorB);
                        colorC = sceneContext.vertexTerrainColor.getOrDefault(vertexKeyC, colorC);
                        if (this.plugin.configGroundTextures) {
                            materialA = sceneContext.vertexTerrainTexture.getOrDefault(vertexKeyA, materialA);
                            materialB = sceneContext.vertexTerrainTexture.getOrDefault(vertexKeyB, materialB);
                            materialC = sceneContext.vertexTerrainTexture.getOrDefault(vertexKeyC, materialC);
                        }
                    } else {
                        GroundMaterial groundMaterial;
                        if (ProceduralGenerator.isOverlayFace(tile, face)) {
                            Overlay overlay = Overlay.getOverlay(scene, tile, this.plugin);
                            groundMaterial = overlay.groundMaterial;
                            colorA = overlay.modifyColor(colorA);
                            colorB = overlay.modifyColor(colorB);
                            colorC = overlay.modifyColor(colorC);
                        } else {
                            Underlay underlay = Underlay.getUnderlay(scene, tile, this.plugin);
                            groundMaterial = underlay.groundMaterial;
                            colorA = underlay.modifyColor(colorA);
                            colorB = underlay.modifyColor(colorB);
                            colorC = underlay.modifyColor(colorC);
                        }
                        if (this.plugin.configGroundTextures && groundMaterial != null) {
                            materialA = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + (int)Math.floor((float)localVertices[0][0] / 128.0f), baseY + tileY + (int)Math.floor((float)localVertices[0][1] / 128.0f));
                            materialB = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + (int)Math.floor((float)localVertices[1][0] / 128.0f), baseY + tileY + (int)Math.floor((float)localVertices[1][1] / 128.0f));
                            materialC = groundMaterial.getRandomMaterial(tileZ, baseX + tileX + (int)Math.floor((float)localVertices[2][0] / 128.0f), baseY + tileY + (int)Math.floor((float)localVertices[2][1] / 128.0f));
                        }
                    }
                } else {
                    colorC = 127;
                    colorB = 127;
                    colorA = 127;
                    if (sceneContext.vertexIsWater.containsKey(vertexKeyA) && sceneContext.vertexIsLand.containsKey(vertexKeyA)) {
                        colorA = 0;
                    }
                    if (sceneContext.vertexIsWater.containsKey(vertexKeyB) && sceneContext.vertexIsLand.containsKey(vertexKeyB)) {
                        colorB = 0;
                    }
                    if (sceneContext.vertexIsWater.containsKey(vertexKeyC) && sceneContext.vertexIsLand.containsKey(vertexKeyC)) {
                        colorC = 0;
                    }
                }
                if (sceneContext.vertexIsOverlay.containsKey(vertexKeyA) && sceneContext.vertexIsUnderlay.containsKey(vertexKeyA)) {
                    vertexAIsOverlay = true;
                }
                if (sceneContext.vertexIsOverlay.containsKey(vertexKeyB) && sceneContext.vertexIsUnderlay.containsKey(vertexKeyB)) {
                    vertexBIsOverlay = true;
                }
                if (sceneContext.vertexIsOverlay.containsKey(vertexKeyC) && sceneContext.vertexIsUnderlay.containsKey(vertexKeyC)) {
                    vertexCIsOverlay = true;
                }
            }
            int aTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            int bTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            int cTerrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            sceneContext.stagingBufferNormals.ensureCapacity(12);
            sceneContext.stagingBufferNormals.put(normalsA[0], normalsA[2], normalsA[1], aTerrainData);
            sceneContext.stagingBufferNormals.put(normalsB[0], normalsB[2], normalsB[1], bTerrainData);
            sceneContext.stagingBufferNormals.put(normalsC[0], normalsC[2], normalsC[1], cTerrainData);
            sceneContext.stagingBufferVertices.ensureCapacity(12);
            sceneContext.stagingBufferVertices.put(localVertices[0][0], localVertices[0][2], localVertices[0][1], colorA);
            sceneContext.stagingBufferVertices.put(localVertices[1][0], localVertices[1][2], localVertices[1][1], colorB);
            sceneContext.stagingBufferVertices.put(localVertices[2][0], localVertices[2][2], localVertices[2][1], colorC);
            bufferLength += 3;
            int packedMaterialDataA = this.modelPusher.packMaterialData(materialA, textureIndex, ModelOverride.NONE, UvType.GEOMETRY, vertexAIsOverlay);
            int packedMaterialDataB = this.modelPusher.packMaterialData(materialB, textureIndex, ModelOverride.NONE, UvType.GEOMETRY, vertexBIsOverlay);
            int packedMaterialDataC = this.modelPusher.packMaterialData(materialC, textureIndex, ModelOverride.NONE, UvType.GEOMETRY, vertexCIsOverlay);
            sceneContext.stagingBufferUvs.ensureCapacity(12);
            sceneContext.stagingBufferUvs.put(1.0f - (float)localVertices[0][0] / 128.0f, 1.0f - (float)localVertices[0][1] / 128.0f, 0.0f, packedMaterialDataA);
            sceneContext.stagingBufferUvs.put(1.0f - (float)localVertices[1][0] / 128.0f, 1.0f - (float)localVertices[1][1] / 128.0f, 0.0f, packedMaterialDataB);
            sceneContext.stagingBufferUvs.put(1.0f - (float)localVertices[2][0] / 128.0f, 1.0f - (float)localVertices[2][1] / 128.0f, 0.0f, packedMaterialDataC);
            uvBufferLength += 3;
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    private int[] uploadHDTileModelUnderwater(SceneContext sceneContext, Tile tile, SceneTileModel sceneTileModel) {
        Scene scene = sceneContext.scene;
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int tileZ = tile.getRenderLevel();
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        if (sceneContext.skipTile[tileZ][tileX][tileY]) {
            return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
        }
        int[] faceColorA = sceneTileModel.getTriangleColorA();
        int faceCount = sceneTileModel.getFaceX().length;
        int baseX = scene.getBaseX();
        int baseY = scene.getBaseY();
        if (baseX >= 2816 && baseX <= 2970 && baseY <= 5375 && baseY >= 5220) {
            return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
        }
        if (sceneContext.tileIsWater[tileZ][tileX][tileY]) {
            underwaterTerrain = 1;
            for (int face = 0; face < faceCount; ++face) {
                int colorA = 6676;
                int colorB = 6676;
                int colorC = 6676;
                if (faceColorA[face] == 12345678) continue;
                int[][] localVertices = ProceduralGenerator.faceLocalVertices(tile, face);
                Material materialA = Material.NONE;
                Material materialB = Material.NONE;
                Material materialC = Material.NONE;
                int[] vertexKeys = ProceduralGenerator.faceVertexKeys(tile, face);
                int vertexKeyA = vertexKeys[0];
                int vertexKeyB = vertexKeys[1];
                int vertexKeyC = vertexKeys[2];
                int depthA = sceneContext.vertexUnderwaterDepth.getOrDefault(vertexKeyA, 0);
                int depthB = sceneContext.vertexUnderwaterDepth.getOrDefault(vertexKeyB, 0);
                int depthC = sceneContext.vertexUnderwaterDepth.getOrDefault(vertexKeyC, 0);
                if (this.plugin.configGroundTextures) {
                    GroundMaterial groundMaterial = GroundMaterial.UNDERWATER_GENERIC;
                    int tileVertexX = Math.round((float)localVertices[0][0] / 128.0f) + tileX + baseX;
                    int tileVertexY = Math.round((float)localVertices[0][1] / 128.0f) + tileY + baseY;
                    materialA = groundMaterial.getRandomMaterial(tileZ, tileVertexX, tileVertexY);
                    tileVertexX = Math.round((float)localVertices[1][0] / 128.0f) + tileX + baseX;
                    tileVertexY = Math.round((float)localVertices[1][1] / 128.0f) + tileY + baseY;
                    materialB = groundMaterial.getRandomMaterial(tileZ, tileVertexX, tileVertexY);
                    tileVertexX = Math.round((float)localVertices[2][0] / 128.0f) + tileX + baseX;
                    tileVertexY = Math.round((float)localVertices[2][1] / 128.0f) + tileY + baseY;
                    materialC = groundMaterial.getRandomMaterial(tileZ, tileVertexX, tileVertexY);
                }
                float[] normalsA = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyA, UP_NORMAL);
                float[] normalsB = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyB, UP_NORMAL);
                float[] normalsC = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyC, UP_NORMAL);
                WaterType waterType = this.proceduralGenerator.faceWaterType(scene, tile, face, sceneTileModel);
                int aTerrainData = SceneUploader.packTerrainData(true, Math.max(1, depthA), waterType, tileZ);
                int bTerrainData = SceneUploader.packTerrainData(true, Math.max(1, depthB), waterType, tileZ);
                int cTerrainData = SceneUploader.packTerrainData(true, Math.max(1, depthC), waterType, tileZ);
                sceneContext.stagingBufferNormals.ensureCapacity(12);
                sceneContext.stagingBufferNormals.put(normalsA[0], normalsA[2], normalsA[1], aTerrainData);
                sceneContext.stagingBufferNormals.put(normalsB[0], normalsB[2], normalsB[1], bTerrainData);
                sceneContext.stagingBufferNormals.put(normalsC[0], normalsC[2], normalsC[1], cTerrainData);
                sceneContext.stagingBufferVertices.ensureCapacity(12);
                sceneContext.stagingBufferVertices.put(localVertices[0][0], localVertices[0][2] + depthA, localVertices[0][1], colorA);
                sceneContext.stagingBufferVertices.put(localVertices[1][0], localVertices[1][2] + depthB, localVertices[1][1], colorB);
                sceneContext.stagingBufferVertices.put(localVertices[2][0], localVertices[2][2] + depthC, localVertices[2][1], colorC);
                bufferLength += 3;
                int packedMaterialDataA = this.modelPusher.packMaterialData(materialA, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
                int packedMaterialDataB = this.modelPusher.packMaterialData(materialB, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
                int packedMaterialDataC = this.modelPusher.packMaterialData(materialC, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
                sceneContext.stagingBufferUvs.ensureCapacity(12);
                sceneContext.stagingBufferUvs.put(1.0f - (float)localVertices[0][0] / 128.0f, 1.0f - (float)localVertices[0][1] / 128.0f, 0.0f, packedMaterialDataA);
                sceneContext.stagingBufferUvs.put(1.0f - (float)localVertices[1][0] / 128.0f, 1.0f - (float)localVertices[1][1] / 128.0f, 0.0f, packedMaterialDataB);
                sceneContext.stagingBufferUvs.put(1.0f - (float)localVertices[2][0] / 128.0f, 1.0f - (float)localVertices[2][1] / 128.0f, 0.0f, packedMaterialDataC);
                uvBufferLength += 3;
            }
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    private void uploadBlackTile(SceneContext sceneContext, int tileX, int tileY, int tileZ) {
        Scene scene = sceneContext.scene;
        int color = 0;
        int fromX = 0;
        int fromY = 0;
        int toX = 128;
        int toY = 128;
        int[][][] tileHeights = scene.getTileHeights();
        int swHeight = tileHeights[tileZ][tileX][tileY];
        int seHeight = tileHeights[tileZ][tileX + 1][tileY];
        int neHeight = tileHeights[tileZ][tileX + 1][tileY + 1];
        int nwHeight = tileHeights[tileZ][tileX][tileY + 1];
        int terrainData = SceneUploader.packTerrainData(true, 0, WaterType.NONE, tileZ);
        sceneContext.stagingBufferNormals.ensureCapacity(24);
        sceneContext.stagingBufferNormals.put(0.0f, -1.0f, 0.0f, terrainData);
        sceneContext.stagingBufferNormals.put(0.0f, -1.0f, 0.0f, terrainData);
        sceneContext.stagingBufferNormals.put(0.0f, -1.0f, 0.0f, terrainData);
        sceneContext.stagingBufferNormals.put(0.0f, -1.0f, 0.0f, terrainData);
        sceneContext.stagingBufferNormals.put(0.0f, -1.0f, 0.0f, terrainData);
        sceneContext.stagingBufferNormals.put(0.0f, -1.0f, 0.0f, terrainData);
        sceneContext.stagingBufferVertices.ensureCapacity(24);
        sceneContext.stagingBufferVertices.put(toX, neHeight, toY, color);
        sceneContext.stagingBufferVertices.put(fromX, nwHeight, toY, color);
        sceneContext.stagingBufferVertices.put(toX, seHeight, fromY, color);
        sceneContext.stagingBufferVertices.put(fromX, swHeight, fromY, color);
        sceneContext.stagingBufferVertices.put(toX, seHeight, fromY, color);
        sceneContext.stagingBufferVertices.put(fromX, nwHeight, toY, color);
        int packedMaterialData = this.modelPusher.packMaterialData(Material.BLACK, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
        sceneContext.stagingBufferUvs.ensureCapacity(24);
        sceneContext.stagingBufferUvs.put(0.0f, 0.0f, 0.0f, packedMaterialData);
        sceneContext.stagingBufferUvs.put(1.0f, 0.0f, 0.0f, packedMaterialData);
        sceneContext.stagingBufferUvs.put(0.0f, 1.0f, 0.0f, packedMaterialData);
        sceneContext.stagingBufferUvs.put(1.0f, 1.0f, 0.0f, packedMaterialData);
        sceneContext.stagingBufferUvs.put(0.0f, 1.0f, 0.0f, packedMaterialData);
        sceneContext.stagingBufferUvs.put(1.0f, 0.0f, 0.0f, packedMaterialData);
    }

    public static int packTerrainData(boolean isTerrain, int waterDepth, WaterType waterType, int plane) {
        int terrainData = waterDepth << 8 | waterType.ordinal() << 3 | plane << 1 | (isTerrain ? 1 : 0);
        assert ((terrainData & 0xFF000000) == 0) : "Only the lower 24 bits are usable, since we pass this into shaders as a float";
        return terrainData;
    }
}

