/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.scene;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.runelite.api.Projectile;
import net.runelite.api.Scene;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import rs117.hd.data.environments.Area;
import rs117.hd.data.materials.Material;
import rs117.hd.scene.environments.Environment;
import rs117.hd.scene.lights.Light;
import rs117.hd.utils.AABB;
import rs117.hd.utils.HDUtils;
import rs117.hd.utils.buffer.GpuFloatBuffer;
import rs117.hd.utils.buffer.GpuIntBuffer;

public class SceneContext {
    public final int id = HDUtils.rand.nextInt() & 0xFFFF;
    public final Scene scene;
    public final HashSet<Integer> regionIds;
    public int staticVertexCount = 0;
    public GpuIntBuffer staticUnorderedModelBuffer;
    public GpuIntBuffer stagingBufferVertices;
    public GpuFloatBuffer stagingBufferUvs;
    public GpuFloatBuffer stagingBufferNormals;
    public int uniqueModels;
    public Map<Integer, Integer> vertexTerrainColor;
    public Map<Integer, Material> vertexTerrainTexture;
    public Map<Integer, float[]> vertexTerrainNormals;
    public HashMap<Integer, Boolean> highPriorityColor;
    public boolean[][][] tileIsWater;
    public Map<Integer, Boolean> vertexIsWater;
    public Map<Integer, Boolean> vertexIsLand;
    public Map<Integer, Boolean> vertexIsOverlay;
    public Map<Integer, Boolean> vertexIsUnderlay;
    public boolean[][][] skipTile;
    public Map<Integer, Integer> vertexUnderwaterDepth;
    public int[][][] underwaterDepthLevels;
    public final ArrayList<Light> lights = new ArrayList();
    public final HashSet<Projectile> projectiles = new HashSet();
    public final ArrayList<Environment> environments = new ArrayList();
    public final int[] modelFaceVertices = new int[12];
    public final float[] modelFaceNormals = new float[12];
    public final int[] modelPusherResults = new int[2];

    public SceneContext(Scene scene, boolean reuseBuffers, @Nullable SceneContext previous) {
        this.scene = scene;
        this.regionIds = HDUtils.getSceneRegionIds(scene);
        if (previous == null) {
            this.staticUnorderedModelBuffer = new GpuIntBuffer();
            this.stagingBufferVertices = new GpuIntBuffer();
            this.stagingBufferUvs = new GpuFloatBuffer();
            this.stagingBufferNormals = new GpuFloatBuffer();
        } else if (reuseBuffers) {
            this.staticUnorderedModelBuffer = previous.staticUnorderedModelBuffer.clear();
            this.stagingBufferVertices = previous.stagingBufferVertices.clear();
            this.stagingBufferUvs = previous.stagingBufferUvs.clear();
            this.stagingBufferNormals = previous.stagingBufferNormals.clear();
            previous.staticUnorderedModelBuffer = null;
            previous.stagingBufferVertices = null;
            previous.stagingBufferUvs = null;
            previous.stagingBufferNormals = null;
        } else {
            this.staticUnorderedModelBuffer = new GpuIntBuffer(previous.staticUnorderedModelBuffer.capacity());
            this.stagingBufferVertices = new GpuIntBuffer(previous.stagingBufferVertices.capacity());
            this.stagingBufferUvs = new GpuFloatBuffer(previous.stagingBufferUvs.capacity());
            this.stagingBufferNormals = new GpuFloatBuffer(previous.stagingBufferNormals.capacity());
        }
    }

    public synchronized void destroy() {
        if (this.staticUnorderedModelBuffer != null) {
            this.staticUnorderedModelBuffer.destroy();
        }
        this.staticUnorderedModelBuffer = null;
        if (this.stagingBufferVertices != null) {
            this.stagingBufferVertices.destroy();
        }
        this.stagingBufferVertices = null;
        if (this.stagingBufferUvs != null) {
            this.stagingBufferUvs.destroy();
        }
        this.stagingBufferUvs = null;
        if (this.stagingBufferNormals != null) {
            this.stagingBufferNormals.destroy();
        }
        this.stagingBufferNormals = null;
    }

    public int getVertexOffset() {
        return this.stagingBufferVertices.position() / 4;
    }

    public int getUvOffset() {
        return this.stagingBufferUvs.position() / 4;
    }

    public int[] localToWorld(LocalPoint localPoint, int plane) {
        return HDUtils.localToWorld(this.scene, localPoint.getX(), localPoint.getY(), plane);
    }

    public int[] localToWorld(int localX, int localY, int plane) {
        return HDUtils.localToWorld(this.scene, localX, localY, plane);
    }

    public int[] sceneToWorld(int sceneX, int sceneY, int plane) {
        return HDUtils.localToWorld(this.scene, sceneX * 128, sceneY * 128, plane);
    }

    public Collection<LocalPoint> worldInstanceToLocals(WorldPoint worldPoint) {
        return WorldPoint.toLocalInstance((Scene)this.scene, (WorldPoint)worldPoint).stream().map(this::worldToLocal).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public LocalPoint worldToLocal(WorldPoint worldPoint) {
        return new LocalPoint((worldPoint.getX() - this.scene.getBaseX()) * 128, (worldPoint.getY() - this.scene.getBaseY()) * 128);
    }

    public boolean intersects(Area area) {
        return this.intersects(area.aabbs);
    }

    public boolean intersects(AABB ... aabbs) {
        return HDUtils.sceneIntersects(this.scene, aabbs);
    }
}

