/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.scene;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.callback.ClientThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.HdPlugin;
import rs117.hd.model.ModelPusher;
import rs117.hd.scene.model_overrides.ModelOverride;
import rs117.hd.utils.AABB;
import rs117.hd.utils.FileWatcher;
import rs117.hd.utils.ModelHash;
import rs117.hd.utils.Props;
import rs117.hd.utils.ResourcePath;

@Singleton
public class ModelOverrideManager {
    private static final Logger log = LoggerFactory.getLogger(ModelOverrideManager.class);
    private static final ResourcePath MODEL_OVERRIDES_PATH = Props.getPathOrDefault("rlhd.model-overrides-path", () -> ResourcePath.path(ModelOverrideManager.class, "model_overrides.json"));
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private HdPlugin plugin;
    @Inject
    private ModelPusher modelPusher;
    private final HashMap<Long, ModelOverride> modelOverrides = new HashMap();
    private FileWatcher.UnregisterCallback fileWatcher;

    public void startUp() {
        this.fileWatcher = MODEL_OVERRIDES_PATH.watch((path, first) -> {
            this.modelOverrides.clear();
            try {
                ModelOverride[] entries = path.loadJson(this.plugin.getGson(), ModelOverride[].class);
                if (entries == null) {
                    throw new IOException("Empty or invalid: " + path);
                }
                for (ModelOverride override : entries) {
                    try {
                        override.normalize();
                    }
                    catch (IllegalStateException ex) {
                        log.error("Invalid model override '{}': {}", (Object)override.description, (Object)ex.getMessage());
                        continue;
                    }
                    this.addOverride(override);
                    if (override.hideInAreas.length <= 0) continue;
                    ModelOverride hider = override.copy();
                    hider.hide = true;
                    hider.areas = override.hideInAreas;
                    this.addOverride(hider);
                }
                log.debug("Loaded {} model overrides", (Object)this.modelOverrides.size());
            }
            catch (IOException ex) {
                log.error("Failed to load model overrides:", (Throwable)ex);
            }
            if (!first.booleanValue()) {
                this.clientThread.invoke(() -> {
                    this.modelPusher.clearModelCache();
                    if (this.client.getGameState() == GameState.LOGGED_IN) {
                        this.client.setGameState(GameState.LOADING);
                    }
                });
            }
        });
    }

    public void shutDown() {
        if (this.fileWatcher != null) {
            this.fileWatcher.unregister();
        }
        this.fileWatcher = null;
        this.modelOverrides.clear();
    }

    public void reload() {
        this.shutDown();
        this.startUp();
    }

    private void addOverride(ModelOverride override) {
        if (override.seasonalTheme != null && override.seasonalTheme != this.plugin.configSeasonalTheme) {
            return;
        }
        for (int npcId : override.npcIds) {
            this.addEntry(1, npcId, override);
        }
        for (int objectId : override.objectIds) {
            this.addEntry(2, objectId, override);
        }
    }

    private void addEntry(int type, int id, ModelOverride entry) {
        long uuid = ModelHash.packUuid(id, type);
        ModelOverride current = this.modelOverrides.get(uuid);
        if (current != null && !Objects.equals((Object)current.seasonalTheme, (Object)entry.seasonalTheme)) {
            if (current.seasonalTheme != null) {
                return;
            }
            current = null;
        }
        boolean isDuplicate = false;
        if (entry.areas.length == 0) {
            boolean bl = isDuplicate = current != null && !current.isDummy;
            if (current != null && current.areaOverrides != null && !current.areaOverrides.isEmpty()) {
                Map<AABB, ModelOverride> areaOverrides = current.areaOverrides;
                current = entry.copy();
                current.areaOverrides = areaOverrides;
            } else {
                current = entry;
            }
            this.modelOverrides.put(uuid, current);
        } else {
            if (current == null) {
                current = ModelOverride.NONE;
            }
            if (current.areaOverrides == null) {
                current = current.copy();
                current.areaOverrides = new HashMap<AABB, ModelOverride>();
                this.modelOverrides.put(uuid, current);
            }
            for (AABB area : entry.areas) {
                current.areaOverrides.put(area, entry);
            }
        }
        if (isDuplicate && Props.DEVELOPMENT) {
            if (entry.hideInAreas.length > 0) {
                System.err.printf("Replacing ID %d from '%s' with hideInAreas-override '%s'. This is likely a mistake...\n", id, current.description, entry.description);
            } else {
                System.err.printf("Replacing ID %d from '%s' with '%s'. The first-mentioned override should be removed.\n", id, current.description, entry.description);
            }
        }
    }

    @NonNull
    public ModelOverride getOverride(long hash, int[] worldPos) {
        ModelOverride override = this.modelOverrides.get(ModelHash.getUuid(this.client, hash));
        if (override == null) {
            return ModelOverride.NONE;
        }
        if (override.areaOverrides != null) {
            for (Map.Entry<AABB, ModelOverride> entry : override.areaOverrides.entrySet()) {
                if (!entry.getKey().contains(worldPos)) continue;
                return entry.getValue();
            }
        }
        return override;
    }
}

