/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.scene;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Actor;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.DynamicObject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.GraphicsObject;
import net.runelite.api.GroundObject;
import net.runelite.api.NPC;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Projectile;
import net.runelite.api.Renderable;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.entityhider.EntityHiderConfig;
import net.runelite.client.plugins.entityhider.EntityHiderPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.HdPlugin;
import rs117.hd.HdPluginConfig;
import rs117.hd.config.MaxDynamicLights;
import rs117.hd.scene.ModelOverrideManager;
import rs117.hd.scene.SceneContext;
import rs117.hd.scene.lights.Alignment;
import rs117.hd.scene.lights.Light;
import rs117.hd.scene.lights.LightDefinition;
import rs117.hd.scene.lights.LightType;
import rs117.hd.utils.HDUtils;
import rs117.hd.utils.ModelHash;
import rs117.hd.utils.Props;
import rs117.hd.utils.ResourcePath;

@Singleton
public class LightManager {
    private static final Logger log = LoggerFactory.getLogger(LightManager.class);
    private static final ResourcePath LIGHTS_PATH = Props.getPathOrDefault("rlhd.lights-path", () -> ResourcePath.path(LightManager.class, "lights.json"));
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    @Inject
    private ModelOverrideManager modelOverrideManager;
    @Inject
    private EntityHiderPlugin entityHiderPlugin;
    public final ArrayList<Light> WORLD_LIGHTS = new ArrayList();
    public final ListMultimap<Integer, LightDefinition> NPC_LIGHTS = ArrayListMultimap.create();
    public final ListMultimap<Integer, LightDefinition> OBJECT_LIGHTS = ArrayListMultimap.create();
    public final ListMultimap<Integer, LightDefinition> PROJECTILE_LIGHTS = ArrayListMultimap.create();
    public final ListMultimap<Integer, LightDefinition> GRAPHICS_OBJECT_LIGHTS = ArrayListMultimap.create();
    boolean configChanged = false;
    private EntityHiderConfig entityHiderConfig;

    public void loadConfig(Gson gson, ResourcePath path, boolean firstRun) {
        try {
            LightDefinition[] lights;
            try {
                lights = path.loadJson(gson, LightDefinition[].class);
                if (lights == null) {
                    log.warn("Skipping empty lights.json");
                    return;
                }
            }
            catch (IOException ex) {
                log.error("Failed to load lights", (Throwable)ex);
                return;
            }
            this.WORLD_LIGHTS.clear();
            this.NPC_LIGHTS.clear();
            this.OBJECT_LIGHTS.clear();
            this.PROJECTILE_LIGHTS.clear();
            this.GRAPHICS_OBJECT_LIGHTS.clear();
            for (LightDefinition lightDef : lights) {
                if (lightDef.worldX != null && lightDef.worldY != null) {
                    Light light = new Light(lightDef);
                    light.worldPoint = new WorldPoint(lightDef.worldX.intValue(), lightDef.worldY.intValue(), lightDef.plane);
                    this.WORLD_LIGHTS.add(light);
                }
                lightDef.npcIds.forEach(id -> this.NPC_LIGHTS.put(id, (Object)lightDef));
                lightDef.objectIds.forEach(id -> this.OBJECT_LIGHTS.put(id, (Object)lightDef));
                lightDef.projectileIds.forEach(id -> this.PROJECTILE_LIGHTS.put(id, (Object)lightDef));
                lightDef.graphicsObjectIds.forEach(id -> this.GRAPHICS_OBJECT_LIGHTS.put(id, (Object)lightDef));
            }
            log.debug("Loaded {} lights", (Object)lights.length);
            this.configChanged = !firstRun;
        }
        catch (Exception ex) {
            log.error("Failed to parse light configuration", (Throwable)ex);
        }
    }

    public void startUp() {
        this.entityHiderConfig = (EntityHiderConfig)this.configManager.getConfig(EntityHiderConfig.class);
        LIGHTS_PATH.watch((path, first) -> this.loadConfig(this.plugin.getGson(), (ResourcePath)path, (boolean)first));
        this.eventBus.register((Object)this);
    }

    public void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    public void update(SceneContext sceneContext) {
        assert (this.client.isClientThread());
        if (this.client.getGameState() != GameState.LOGGED_IN || this.config.maxDynamicLights() == MaxDynamicLights.NONE) {
            return;
        }
        if (this.configChanged) {
            this.configChanged = false;
            this.loadSceneLights(sceneContext, null);
            this.client.getNpcs().forEach(npc -> this.addNpcLights(sceneContext, (NPC)npc));
        }
        Tile[][][] tiles = sceneContext.scene.getTiles();
        int[][][] tileHeights = sceneContext.scene.getTileHeights();
        Iterator<Light> lightIterator = sceneContext.lights.iterator();
        while (lightIterator.hasNext()) {
            Tile lightTile;
            Tile aboveTile;
            Light light2 = lightIterator.next();
            light2.distanceSquared = Integer.MAX_VALUE;
            if (light2.object != null) {
                ObjectComposition def;
                light2.visible = true;
                if (light2.impostorObjectId != 0 && (def = this.client.getObjectDefinition(light2.object.getId())).getImpostorIds() != null) {
                    ObjectComposition impostor = def.getImpostor();
                    boolean bl = light2.visible = impostor != null && impostor.getId() == light2.impostorObjectId;
                }
                if (light2.visible && !light2.def.animationIds.isEmpty()) {
                    GameObject gameObject;
                    Renderable renderable;
                    light2.visible = false;
                    if (light2.object instanceof GameObject && (renderable = (gameObject = (GameObject)light2.object).getRenderable()) instanceof DynamicObject) {
                        Animation animation = ((DynamicObject)renderable).getAnimation();
                        light2.visible = animation != null && light2.def.animationIds.contains(animation.getId());
                    }
                }
            } else if (light2.projectile != null) {
                if (light2.projectile.getRemainingCycles() <= 0) {
                    lightIterator.remove();
                    sceneContext.projectiles.remove(light2.projectile);
                    continue;
                }
                light2.x = (int)light2.projectile.getX();
                light2.y = (int)light2.projectile.getY();
                light2.z = (int)light2.projectile.getZ() - light2.def.height;
                light2.visible = this.projectileLightVisible();
                if (light2.visible && !light2.def.animationIds.isEmpty()) {
                    Animation animation = light2.projectile.getAnimation();
                    light2.visible = animation != null && light2.def.animationIds.contains(animation.getId());
                }
            } else if (light2.graphicsObject != null) {
                if (light2.graphicsObject.finished()) {
                    lightIterator.remove();
                    continue;
                }
                light2.x = light2.graphicsObject.getLocation().getX();
                light2.y = light2.graphicsObject.getLocation().getY();
                light2.z = light2.graphicsObject.getZ() - light2.def.height;
                light2.visible = true;
                if (!light2.def.animationIds.isEmpty()) {
                    Animation animation = light2.projectile.getAnimation();
                    light2.visible = animation != null && light2.def.animationIds.contains(animation.getId());
                }
            } else if (light2.npc != null) {
                int plane;
                if (light2.npc != this.client.getCachedNPCs()[light2.npc.getIndex()]) {
                    lightIterator.remove();
                    continue;
                }
                light2.x = light2.npc.getLocalLocation().getX();
                light2.y = light2.npc.getLocalLocation().getY();
                if (light2.def.alignment == Alignment.NORTH || light2.def.alignment == Alignment.NORTHEAST || light2.def.alignment == Alignment.NORTHWEST) {
                    light2.y += 64;
                }
                if (light2.def.alignment == Alignment.SOUTH || light2.def.alignment == Alignment.SOUTHEAST || light2.def.alignment == Alignment.SOUTHWEST) {
                    light2.y -= 64;
                }
                if (light2.def.alignment == Alignment.EAST || light2.def.alignment == Alignment.SOUTHEAST || light2.def.alignment == Alignment.NORTHEAST) {
                    light2.x += 64;
                }
                if (light2.def.alignment == Alignment.WEST || light2.def.alignment == Alignment.SOUTHWEST || light2.def.alignment == Alignment.NORTHWEST) {
                    light2.x -= 64;
                }
                light2.plane = plane = this.client.getPlane();
                int npcTileX = light2.npc.getLocalLocation().getSceneX();
                int npcTileY = light2.npc.getLocalLocation().getSceneY();
                if (npcTileX < 0 || npcTileY < 0 || npcTileX >= 104 || npcTileY >= 104) {
                    light2.visible = false;
                } else {
                    if (tiles[plane][npcTileX][npcTileY] != null && tiles[plane][npcTileX][npcTileY].getBridge() != null) {
                        ++plane;
                    }
                    float lerpX = (float)(light2.x % 128) / 128.0f;
                    float lerpY = (float)(light2.y % 128) / 128.0f;
                    int baseTileX = (int)Math.floor((float)light2.x / 128.0f);
                    int baseTileY = (int)Math.floor((float)light2.y / 128.0f);
                    float heightNorth = HDUtils.lerp(tileHeights[plane][baseTileX][baseTileY + 1], tileHeights[plane][baseTileX + 1][baseTileY + 1], lerpX);
                    float heightSouth = HDUtils.lerp(tileHeights[plane][baseTileX][baseTileY], tileHeights[plane][baseTileX + 1][baseTileY], lerpX);
                    float tileHeight = HDUtils.lerp(heightSouth, heightNorth, lerpY);
                    light2.z = (int)tileHeight - 1 - light2.def.height;
                    light2.visible = this.npcLightVisible(light2.npc);
                    if (light2.visible && !light2.def.animationIds.isEmpty()) {
                        int animationId = light2.npc.getAnimation();
                        light2.visible = light2.def.animationIds.contains(animationId);
                    }
                }
            }
            if (light2.def.type == LightType.FLICKER) {
                double t = (float)Math.PI * 2 * (HDUtils.mod(this.plugin.elapsedTime, 60.0f) / 60.0f + light2.randomOffset);
                float flicker = (float)(Math.pow(Math.cos(11.0 * t), 3.0) + Math.pow(Math.cos(17.0 * t), 6.0) + Math.pow(Math.cos(23.0 * t), 2.0) + Math.pow(Math.cos(31.0 * t), 6.0) + Math.pow(Math.cos(71.0 * t), 4.0) + Math.pow(Math.cos(151.0 * t), 6.0) / 2.0) / 4.335f;
                float maxFlicker = 1.0f + light2.def.range / 100.0f;
                float minFlicker = 1.0f - light2.def.range / 100.0f;
                flicker = minFlicker + (maxFlicker - minFlicker) * flicker;
                light2.strength = light2.def.strength * flicker;
                light2.radius = (int)((float)light2.def.radius * 1.5f);
            } else if (light2.def.type == LightType.PULSE) {
                light2.animation = HDUtils.fract(light2.animation + this.plugin.deltaClientTime / light2.duration);
                float output = 1.0f - 2.0f * Math.abs(light2.animation - 0.5f);
                float range = light2.def.range / 100.0f;
                float fullRange = range * 2.0f;
                float multiplier = 1.0f - range + output * fullRange;
                light2.radius = (int)((float)light2.def.radius * multiplier);
                light2.strength = light2.def.strength * multiplier;
            } else {
                light2.strength = light2.def.strength;
                light2.radius = light2.def.radius;
                light2.color = light2.def.color;
            }
            if (light2.fadeInDuration > 0.0f) {
                light2.strength *= Math.min(light2.currentFadeIn / light2.fadeInDuration, 1.0f);
                light2.currentFadeIn += this.plugin.deltaClientTime;
            }
            int distX = this.plugin.cameraFocalPoint[0] - light2.x;
            int distY = this.plugin.cameraFocalPoint[1] - light2.y;
            light2.distanceSquared = distX * distX + distY * distY + light2.z * light2.z;
            int tileX = (int)Math.floor((float)light2.x / 128.0f);
            int tileY = (int)Math.floor((float)light2.y / 128.0f);
            light2.belowFloor = false;
            light2.aboveFloor = false;
            if (tileX >= 104 || tileY >= 104 || tileX < 0 || tileY < 0 || light2.plane < 0) continue;
            Tile tile = aboveTile = light2.plane < 3 ? tiles[light2.plane + 1][tileX][tileY] : null;
            if (aboveTile != null && (aboveTile.getSceneTilePaint() != null || aboveTile.getSceneTileModel() != null)) {
                light2.belowFloor = true;
            }
            if ((lightTile = tiles[light2.plane][tileX][tileY]) == null || lightTile.getSceneTilePaint() == null && lightTile.getSceneTileModel() == null) continue;
            light2.aboveFloor = true;
        }
        sceneContext.lights.sort(Comparator.comparingInt(light -> light.distanceSquared));
    }

    private boolean npcLightVisible(NPC npc) {
        try {
            if (npc.getModel() == null) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        if (this.pluginManager.isPluginEnabled((Plugin)this.entityHiderPlugin)) {
            boolean isPet = npc.getComposition().isFollower();
            if (this.client.getFollower() != null && this.client.getFollower().getIndex() == npc.getIndex()) {
                return true;
            }
            if (this.entityHiderConfig.hideNPCs() && !isPet) {
                return false;
            }
            if (this.entityHiderConfig.hidePets() && isPet) {
                return false;
            }
        }
        return this.plugin.configNpcLights;
    }

    private boolean projectileLightVisible() {
        if (this.pluginManager.isPluginEnabled((Plugin)this.entityHiderPlugin) && this.entityHiderConfig.hideProjectiles()) {
            return false;
        }
        return this.plugin.configProjectileLights;
    }

    public void loadSceneLights(SceneContext sceneContext, @Nullable SceneContext oldSceneContext) {
        assert (this.client.isClientThread());
        ArrayList<Light> lightsToKeep = new ArrayList<Light>();
        if (oldSceneContext != null) {
            for (Light light : oldSceneContext.lights) {
                if (light.npc == null && light.projectile == null) continue;
                lightsToKeep.add(light);
            }
        }
        sceneContext.lights.clear();
        sceneContext.lights.addAll(lightsToKeep);
        sceneContext.projectiles.clear();
        for (Light l : lightsToKeep) {
            if (l.projectile == null) continue;
            sceneContext.projectiles.add(l.projectile);
        }
        for (Light light : this.WORLD_LIGHTS) {
            assert (light.worldPoint != null);
            if (!sceneContext.regionIds.contains(light.worldPoint.getRegionID())) continue;
            sceneContext.lights.add(light);
            this.updateWorldLightPosition(sceneContext, light);
        }
        Iterator<Light> iterator = sceneContext.scene.getTiles();
        int n = ((Iterator<Light>)iterator).length;
        for (int i = 0; i < n; ++i) {
            Iterator<Light> plane;
            Iterator<Light> iterator2 = plane = iterator[i];
            int n2 = ((Iterator<Light>)iterator2).length;
            for (int j = 0; j < n2; ++j) {
                Iterator<Light> column;
                for (Iterator<Light> tile : column = iterator2[j]) {
                    GroundObject groundObject;
                    WallObject wallObject;
                    if (tile == null) continue;
                    DecorativeObject decorativeObject = tile.getDecorativeObject();
                    if (decorativeObject != null && decorativeObject.getRenderable() != null) {
                        this.addObjectLight(sceneContext, (TileObject)decorativeObject, tile.getRenderLevel());
                    }
                    if ((wallObject = tile.getWallObject()) != null && wallObject.getRenderable1() != null) {
                        int orientation = HDUtils.convertWallObjectOrientation(wallObject.getOrientationA());
                        this.addObjectLight(sceneContext, (TileObject)wallObject, tile.getRenderLevel(), 1, 1, orientation);
                    }
                    if ((groundObject = tile.getGroundObject()) != null && groundObject.getRenderable() != null) {
                        this.addObjectLight(sceneContext, (TileObject)groundObject, tile.getRenderLevel());
                    }
                    for (GameObject gameObject : tile.getGameObjects()) {
                        if (gameObject == null || gameObject.getRenderable() instanceof Actor) continue;
                        this.addObjectLight(sceneContext, (TileObject)gameObject, tile.getRenderLevel(), gameObject.sizeX(), gameObject.sizeY(), gameObject.getOrientation());
                    }
                }
            }
        }
    }

    public ArrayList<Light> getVisibleLights(int maxLights) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        ArrayList<Light> visibleLights = new ArrayList<Light>();
        if (sceneContext == null) {
            return visibleLights;
        }
        int maxDistanceSquared = this.plugin.getDrawDistance() * 128;
        maxDistanceSquared *= maxDistanceSquared;
        for (Light light : sceneContext.lights) {
            if (light.distanceSquared > maxDistanceSquared) break;
            if (!light.visible || light.modelOverride.hide || !light.def.visibleFromOtherPlanes && (light.plane < this.client.getPlane() && light.belowFloor || light.plane > this.client.getPlane() && light.aboveFloor)) continue;
            visibleLights.add(light);
            if (visibleLights.size() < maxLights) continue;
            break;
        }
        return visibleLights;
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved projectileMoved) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        Projectile projectile = projectileMoved.getProjectile();
        if (!sceneContext.projectiles.add(projectile)) {
            return;
        }
        for (LightDefinition lightDef : this.PROJECTILE_LIGHTS.get((Object)projectile.getId())) {
            Light light = new Light(lightDef);
            light.projectile = projectile;
            light.x = (int)projectile.getX();
            light.y = (int)projectile.getY();
            light.z = (int)projectile.getZ();
            light.plane = projectile.getFloor();
            if (light.fadeInDuration < 0.0f) {
                light.fadeInDuration = 0.3f;
            }
            light.visible = this.projectileLightVisible();
            sceneContext.lights.add(light);
        }
    }

    private void addNpcLights(SceneContext sceneContext, NPC npc) {
        if (sceneContext == null) {
            return;
        }
        for (LightDefinition lightDef : this.NPC_LIGHTS.get((Object)npc.getId())) {
            if (sceneContext.lights.stream().anyMatch(x -> x.npc == npc)) continue;
            Light light = new Light(lightDef);
            light.plane = -1;
            light.npc = npc;
            light.visible = false;
            light.modelOverride = this.modelOverrideManager.getOverride(ModelHash.packUuid(npc.getId(), 1), sceneContext.localToWorld(npc.getLocalLocation(), this.client.getPlane()));
            sceneContext.lights.add(light);
        }
    }

    public void removeNpcLight(SceneContext sceneContext, NPC npc) {
        if (sceneContext != null) {
            sceneContext.lights.removeIf(light -> light.npc == npc);
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        this.addNpcLights(this.plugin.getSceneContext(), npcSpawned.getNpc());
    }

    @Subscribe
    public void onNpcChanged(NpcChanged npcChanged) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        this.removeNpcLight(sceneContext, npcChanged.getNpc());
        this.addNpcLights(sceneContext, npcChanged.getNpc());
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        this.removeNpcLight(this.plugin.getSceneContext(), npcDespawned.getNpc());
    }

    private void addObjectLight(SceneContext sceneContext, TileObject tileObject, int plane) {
        this.addObjectLight(sceneContext, tileObject, plane, 1, 1, -1);
    }

    private void addObjectLight(SceneContext sceneContext, TileObject tileObject, int plane, int sizeX, int sizeY, int orientation) {
        ObjectComposition def;
        int id = tileObject.getId();
        if (tileObject instanceof GameObject && (def = this.client.getObjectDefinition(id)).getImpostorIds() != null) {
            for (int impostorId : def.getImpostorIds()) {
                this.addObjectLight(sceneContext, tileObject, impostorId, plane, sizeX, sizeY, orientation);
            }
            return;
        }
        this.addObjectLight(sceneContext, tileObject, tileObject.getId(), plane, sizeX, sizeY, orientation);
    }

    private void addObjectLight(SceneContext sceneContext, TileObject tileObject, int objectId, int plane, int sizeX, int sizeY, int orientation) {
        for (LightDefinition lightDef : this.OBJECT_LIGHTS.get((Object)objectId)) {
            if (tileObject.getPlane() <= -1) continue;
            long hash = this.tileObjectHash(tileObject);
            boolean isDuplicate = sceneContext.lights.stream().anyMatch(light -> {
                boolean sameObject = light.object == tileObject || hash == this.tileObjectHash(light.object);
                boolean sameLight = light.def == lightDef;
                return sameObject && sameLight;
            });
            if (isDuplicate) continue;
            int localPlane = tileObject.getPlane();
            Light light2 = new Light(lightDef);
            light2.plane = localPlane;
            if (objectId != tileObject.getId()) {
                light2.impostorObjectId = objectId;
                light2.visible = false;
            }
            LocalPoint localPoint = tileObject.getLocalLocation();
            int lightX = localPoint.getX();
            int lightY = localPoint.getY();
            int localSizeX = sizeX * 128;
            int localSizeY = sizeY * 128;
            if (orientation != -1 && light2.def.alignment != Alignment.CENTER) {
                float radius = (float)localSizeX / 2.0f;
                if (!light2.def.alignment.radial) {
                    radius = (float)Math.sqrt(localSizeX * localSizeX + localSizeX * localSizeX) / 2.0f;
                }
                if (!light2.def.alignment.relative) {
                    orientation = 0;
                }
                orientation += light2.def.alignment.orientation;
                float sine = (float)Perspective.SINE[orientation %= 2048] / 65536.0f;
                float cosine = (float)Perspective.COSINE[orientation] / 65536.0f;
                int offsetX = (int)(radius * sine);
                int offsetY = (int)(radius * (cosine /= (float)localSizeX / (float)localSizeY));
                lightX += offsetX;
                lightY += offsetY;
            }
            float tileX = (float)lightX / 128.0f;
            float tileY = (float)lightY / 128.0f;
            float lerpX = (float)(lightX % 128) / 128.0f;
            float lerpY = (float)(lightY % 128) / 128.0f;
            int tileMinX = (int)Math.floor(tileX);
            int tileMinY = (int)Math.floor(tileY);
            int tileMaxX = tileMinX + 1;
            int tileMaxY = tileMinY + 1;
            tileMinX = HDUtils.clamp(tileMinX, 0, 103);
            tileMinY = HDUtils.clamp(tileMinY, 0, 103);
            tileMaxX = HDUtils.clamp(tileMaxX, 0, 103);
            tileMaxY = HDUtils.clamp(tileMaxY, 0, 103);
            int[][][] tileHeights = sceneContext.scene.getTileHeights();
            float heightNorth = HDUtils.lerp(tileHeights[plane][tileMinX][tileMaxY], tileHeights[plane][tileMaxX][tileMaxY], lerpX);
            float heightSouth = HDUtils.lerp(tileHeights[plane][tileMinX][tileMinY], tileHeights[plane][tileMaxX][tileMinY], lerpX);
            float tileHeight = HDUtils.lerp(heightSouth, heightNorth, lerpY);
            light2.x = lightX;
            light2.y = lightY;
            light2.z = (int)tileHeight - light2.def.height - 1;
            light2.object = tileObject;
            light2.modelOverride = this.modelOverrideManager.getOverride(ModelHash.packUuid(objectId, 2), sceneContext.localToWorld(light2.x, light2.y, light2.plane));
            sceneContext.lights.add(light2);
        }
    }

    private void removeObjectLight(TileObject tileObject) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        LocalPoint localLocation = tileObject.getLocalLocation();
        sceneContext.lights.removeIf(light -> light.object == tileObject && light.x == localLocation.getX() && light.y == localLocation.getY() && light.plane == tileObject.getPlane());
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated graphicsObjectCreated) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        GraphicsObject graphicsObject = graphicsObjectCreated.getGraphicsObject();
        for (LightDefinition lightDef : this.GRAPHICS_OBJECT_LIGHTS.get((Object)graphicsObject.getId())) {
            Light light = new Light(lightDef);
            light.graphicsObject = graphicsObject;
            LocalPoint lp = graphicsObject.getLocation();
            light.x = lp.getX();
            light.y = lp.getY();
            light.z = graphicsObject.getZ();
            light.plane = graphicsObject.getLevel();
            if (light.fadeInDuration < 0.0f) {
                light.fadeInDuration = 0.3f;
            }
            light.modelOverride = this.modelOverrideManager.getOverride(ModelHash.packUuid(graphicsObject.getId(), 2), sceneContext.localToWorld(light.x, light.y, light.plane));
            sceneContext.lights.add(light);
        }
    }

    private long tileObjectHash(@Nullable TileObject tileObject) {
        if (tileObject == null) {
            return 0L;
        }
        LocalPoint local = tileObject.getLocalLocation();
        long hash = local.getX();
        hash = hash * 31L + (long)local.getY();
        hash = hash * 31L + (long)tileObject.getPlane();
        hash = hash * 31L + (long)tileObject.getId();
        return hash;
    }

    private void updateWorldLightPosition(SceneContext sceneContext, Light light) {
        assert (light.worldPoint != null);
        Optional<LocalPoint> firstLocalPoint = sceneContext.worldInstanceToLocals(light.worldPoint).stream().findFirst();
        if (firstLocalPoint.isEmpty()) {
            return;
        }
        LocalPoint local = firstLocalPoint.get();
        light.x = local.getX() + 64;
        light.y = local.getY() + 64;
        if (local.isInScene()) {
            light.z = sceneContext.scene.getTileHeights()[light.plane][local.getSceneX()][local.getSceneY()] - light.def.height - 1;
        }
        if (light.def.alignment == Alignment.NORTH || light.def.alignment == Alignment.NORTHEAST || light.def.alignment == Alignment.NORTHWEST) {
            light.y += 64;
        }
        if (light.def.alignment == Alignment.EAST || light.def.alignment == Alignment.NORTHEAST || light.def.alignment == Alignment.SOUTHEAST) {
            light.x += 64;
        }
        if (light.def.alignment == Alignment.SOUTH || light.def.alignment == Alignment.SOUTHEAST || light.def.alignment == Alignment.SOUTHWEST) {
            light.y -= 64;
        }
        if (light.def.alignment == Alignment.WEST || light.def.alignment == Alignment.NORTHWEST || light.def.alignment == Alignment.SOUTHWEST) {
            light.x -= 64;
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned gameObjectSpawned) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        GameObject gameObject = gameObjectSpawned.getGameObject();
        this.addObjectLight(sceneContext, (TileObject)gameObject, gameObjectSpawned.getTile().getRenderLevel(), gameObject.sizeX(), gameObject.sizeY(), gameObject.getOrientation());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned gameObjectDespawned) {
        this.removeObjectLight((TileObject)gameObjectDespawned.getGameObject());
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned wallObjectSpawned) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        WallObject wallObject = wallObjectSpawned.getWallObject();
        this.addObjectLight(sceneContext, (TileObject)wallObject, wallObjectSpawned.getTile().getRenderLevel(), 1, 1, wallObject.getOrientationA());
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned wallObjectDespawned) {
        this.removeObjectLight((TileObject)wallObjectDespawned.getWallObject());
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned decorativeObjectSpawned) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        this.addObjectLight(sceneContext, (TileObject)decorativeObjectSpawned.getDecorativeObject(), decorativeObjectSpawned.getTile().getRenderLevel());
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned decorativeObjectDespawned) {
        this.removeObjectLight((TileObject)decorativeObjectDespawned.getDecorativeObject());
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned groundObjectSpawned) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        this.addObjectLight(sceneContext, (TileObject)groundObjectSpawned.getGroundObject(), groundObjectSpawned.getTile().getRenderLevel());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned groundObjectDespawned) {
        this.removeObjectLight((TileObject)groundObjectDespawned.getGroundObject());
    }
}

