/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.scene;

import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.callback.ClientThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.HdPlugin;
import rs117.hd.HdPluginConfig;
import rs117.hd.config.DefaultSkyColor;
import rs117.hd.scene.SceneContext;
import rs117.hd.scene.environments.Environment;
import rs117.hd.utils.AABB;
import rs117.hd.utils.FileWatcher;
import rs117.hd.utils.HDUtils;
import rs117.hd.utils.Props;
import rs117.hd.utils.ResourcePath;

@Singleton
public class EnvironmentManager {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentManager.class);
    private static final ResourcePath ENVIRONMENTS_PATH = Props.getPathOrDefault("rlhd.environments-path", () -> ResourcePath.path(EnvironmentManager.class, "environments.json"));
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    private static final float TRANSITION_DURATION = 3.0f;
    private static final int SKIP_TRANSITION_DISTANCE = 41;
    private boolean transitionComplete = true;
    private float transitionStartTime = 0.0f;
    private int[] previousPosition = new int[3];
    private float[] startFogColor = new float[]{0.0f, 0.0f, 0.0f};
    public float[] currentFogColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] targetFogColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] startWaterColor = new float[]{0.0f, 0.0f, 0.0f};
    public float[] currentWaterColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] targetWaterColor = new float[]{0.0f, 0.0f, 0.0f};
    private float startFogDepth = 0.0f;
    public float currentFogDepth = 0.0f;
    private float targetFogDepth = 0.0f;
    private float startAmbientStrength = 0.0f;
    public float currentAmbientStrength = 0.0f;
    private float targetAmbientStrength = 0.0f;
    private float[] startAmbientColor = new float[]{0.0f, 0.0f, 0.0f};
    public float[] currentAmbientColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] targetAmbientColor = new float[]{0.0f, 0.0f, 0.0f};
    private float startDirectionalStrength = 0.0f;
    public float currentDirectionalStrength = 0.0f;
    private float targetDirectionalStrength = 0.0f;
    private float[] startUnderwaterCausticsColor = new float[]{0.0f, 0.0f, 0.0f};
    public float[] currentUnderwaterCausticsColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] targetUnderwaterCausticsColor = new float[]{0.0f, 0.0f, 0.0f};
    private float startUnderwaterCausticsStrength = 1.0f;
    public float currentUnderwaterCausticsStrength = 1.0f;
    private float targetUnderwaterCausticsStrength = 1.0f;
    private float[] startDirectionalColor = new float[]{0.0f, 0.0f, 0.0f};
    public float[] currentDirectionalColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] targetDirectionalColor = new float[]{0.0f, 0.0f, 0.0f};
    private float startUnderglowStrength = 0.0f;
    public float currentUnderglowStrength = 0.0f;
    private float targetUnderglowStrength = 0.0f;
    private float[] startUnderglowColor = new float[]{0.0f, 0.0f, 0.0f};
    public float[] currentUnderglowColor = new float[]{0.0f, 0.0f, 0.0f};
    private float[] targetUnderglowColor = new float[]{0.0f, 0.0f, 0.0f};
    private float startGroundFogStart = 0.0f;
    public float currentGroundFogStart = 0.0f;
    private float targetGroundFogStart = 0.0f;
    private float startGroundFogEnd = 0.0f;
    public float currentGroundFogEnd = 0.0f;
    private float targetGroundFogEnd = 0.0f;
    private float startGroundFogOpacity = 0.0f;
    public float currentGroundFogOpacity = 0.0f;
    private float targetGroundFogOpacity = 0.0f;
    private final float[] startSunAngles = new float[]{0.0f, 0.0f};
    public final float[] currentSunAngles = new float[]{0.0f, 0.0f};
    private final float[] targetSunAngles = new float[]{0.0f, 0.0f};
    private boolean lightningEnabled = false;
    private boolean forceNextTransition = false;
    private Environment[] environments;
    private FileWatcher.UnregisterCallback fileWatcher;
    @Nonnull
    private Environment currentEnvironment = Environment.NONE;
    private static final float[] LIGHTNING_COLOR = new float[]{0.25f, 0.25f, 0.25f};
    private static final float NEW_LIGHTNING_BRIGHTNESS = 7.0f;
    private static final float LIGHTNING_FADE_SPEED = 80.0f;
    private static final float MIN_LIGHTNING_INTERVAL = 5.5f;
    private static final float MAX_LIGHTNING_INTERVAL = 17.0f;
    private static final float QUICK_LIGHTNING_CHANCE = 0.5f;
    private static final float MIN_QUICK_LIGHTNING_INTERVAL = 0.04f;
    private static final float MAX_QUICK_LIGHTNING_INTERVAL = 0.15f;
    private float lightningBrightness = 0.0f;
    private double nextLightningTime = -1.0;

    public void startUp() {
        this.fileWatcher = ENVIRONMENTS_PATH.watch((path, first) -> {
            try {
                this.environments = path.loadJson(this.plugin.getGson(), Environment[].class);
                if (this.environments == null) {
                    throw new IOException("Empty or invalid: " + path);
                }
                log.debug("Loaded {} environments", (Object)this.environments.length);
                HashMap<String, Environment> map = new HashMap<String, Environment>();
                for (Environment env : this.environments) {
                    if (env.key == null) continue;
                    map.put(env.key, env);
                }
                Environment.OVERWORLD = map.getOrDefault("OVERWORLD", Environment.DEFAULT);
                Environment.AUTUMN = map.getOrDefault("AUTUMN", Environment.DEFAULT);
                Environment.WINTER = map.getOrDefault("WINTER", Environment.DEFAULT);
                for (Environment env : this.environments) {
                    env.normalize();
                }
                this.clientThread.invoke(() -> {
                    if (this.client.getGameState().getState() >= GameState.LOGGED_IN.getState() && this.plugin.getSceneContext() != null) {
                        this.loadSceneEnvironments(this.plugin.getSceneContext());
                    }
                });
            }
            catch (IOException ex) {
                log.error("Failed to load environments:", (Throwable)ex);
            }
        });
    }

    public void shutDown() {
        if (this.fileWatcher != null) {
            this.fileWatcher.unregister();
        }
        this.fileWatcher = null;
        this.environments = null;
        this.reset();
    }

    public void reset() {
        this.currentEnvironment = Environment.NONE;
        this.forceNextTransition = false;
    }

    public void triggerTransition() {
        this.forceNextTransition = true;
    }

    public void update(SceneContext sceneContext) {
        assert (this.client.isClientThread());
        int[] focalPoint = sceneContext.localToWorld(this.plugin.cameraFocalPoint[0], this.plugin.cameraFocalPoint[1], this.client.getPlane());
        int tileChange = Math.max(Math.abs(focalPoint[0] - this.previousPosition[0]), Math.abs(focalPoint[1] - this.previousPosition[1]));
        this.previousPosition = focalPoint;
        boolean skipTransition = tileChange >= 41;
        for (Environment environment : sceneContext.environments) {
            if (!environment.area.containsPoint(focalPoint)) continue;
            this.changeEnvironment(environment, skipTransition);
            break;
        }
        this.updateTargetSkyColor();
        if (this.transitionComplete) {
            this.currentFogColor = this.targetFogColor;
            this.currentWaterColor = this.targetWaterColor;
        } else {
            float t = HDUtils.clamp((this.plugin.elapsedTime - this.transitionStartTime) / 3.0f, 0.0f, 1.0f);
            if (t >= 1.0f) {
                this.transitionComplete = true;
            }
            this.currentFogColor = HDUtils.hermite(this.startFogColor, this.targetFogColor, t);
            this.currentWaterColor = HDUtils.hermite(this.startWaterColor, this.targetWaterColor, t);
            this.currentFogDepth = HDUtils.hermite(this.startFogDepth, this.targetFogDepth, t);
            this.currentAmbientStrength = HDUtils.hermite(this.startAmbientStrength, this.targetAmbientStrength, t);
            this.currentAmbientColor = HDUtils.hermite(this.startAmbientColor, this.targetAmbientColor, t);
            this.currentDirectionalStrength = HDUtils.hermite(this.startDirectionalStrength, this.targetDirectionalStrength, t);
            this.currentDirectionalColor = HDUtils.hermite(this.startDirectionalColor, this.targetDirectionalColor, t);
            this.currentUnderglowStrength = HDUtils.hermite(this.startUnderglowStrength, this.targetUnderglowStrength, t);
            this.currentUnderglowColor = HDUtils.hermite(this.startUnderglowColor, this.targetUnderglowColor, t);
            this.currentGroundFogStart = HDUtils.hermite(this.startGroundFogStart, this.targetGroundFogStart, t);
            this.currentGroundFogEnd = HDUtils.hermite(this.startGroundFogEnd, this.targetGroundFogEnd, t);
            this.currentGroundFogOpacity = HDUtils.hermite(this.startGroundFogOpacity, this.targetGroundFogOpacity, t);
            for (int i = 0; i < 2; ++i) {
                this.currentSunAngles[i] = HDUtils.hermite(this.startSunAngles[i], this.targetSunAngles[i], t);
            }
            this.currentUnderwaterCausticsColor = HDUtils.hermite(this.startUnderwaterCausticsColor, this.targetUnderwaterCausticsColor, t);
            this.currentUnderwaterCausticsStrength = HDUtils.hermite(this.startUnderwaterCausticsStrength, this.targetUnderwaterCausticsStrength, t);
        }
        this.updateLightning();
    }

    private void changeEnvironment(Environment newEnvironment, boolean skipTransition) {
        if (this.currentEnvironment == newEnvironment && !this.forceNextTransition) {
            return;
        }
        if (this.currentEnvironment == Environment.NONE) {
            skipTransition = true;
        } else if (this.forceNextTransition) {
            this.forceNextTransition = false;
            skipTransition = false;
        }
        log.debug("changing environment from {} to {} (instant: {})", new Object[]{this.currentEnvironment, newEnvironment, skipTransition});
        this.currentEnvironment = newEnvironment;
        this.transitionComplete = false;
        this.transitionStartTime = this.plugin.elapsedTime - (skipTransition ? 3.0f : 0.0f);
        this.startFogColor = this.currentFogColor;
        this.startWaterColor = this.currentWaterColor;
        this.startFogDepth = this.currentFogDepth;
        this.startAmbientStrength = this.currentAmbientStrength;
        this.startAmbientColor = this.currentAmbientColor;
        this.startDirectionalStrength = this.currentDirectionalStrength;
        this.startDirectionalColor = this.currentDirectionalColor;
        this.startUnderglowStrength = this.currentUnderglowStrength;
        this.startUnderglowColor = this.currentUnderglowColor;
        this.startGroundFogStart = this.currentGroundFogStart;
        this.startGroundFogEnd = this.currentGroundFogEnd;
        this.startGroundFogOpacity = this.currentGroundFogOpacity;
        this.startUnderwaterCausticsColor = this.currentUnderwaterCausticsColor;
        this.startUnderwaterCausticsStrength = this.currentUnderwaterCausticsStrength;
        for (int i = 0; i < 2; ++i) {
            this.startSunAngles[i] = HDUtils.mod(this.currentSunAngles[i], (float)Math.PI * 2);
        }
        this.updateTargetSkyColor();
        Environment env = this.getCurrentEnvironment();
        this.targetFogDepth = env.fogDepth;
        this.targetGroundFogStart = env.groundFogStart;
        this.targetGroundFogEnd = env.groundFogEnd;
        this.targetGroundFogOpacity = env.groundFogOpacity;
        this.lightningEnabled = env.lightningEffects;
        Environment overworldEnv = this.getOverworldEnvironment();
        float[] sunAngles = env.sunAngles;
        if (sunAngles == null) {
            sunAngles = overworldEnv.sunAngles;
        }
        System.arraycopy(sunAngles, 0, this.targetSunAngles, 0, 2);
        if (!this.config.atmosphericLighting()) {
            env = overworldEnv;
        }
        this.targetAmbientStrength = env.ambientStrength;
        this.targetAmbientColor = env.ambientColor;
        this.targetDirectionalStrength = env.directionalStrength;
        this.targetDirectionalColor = env.directionalColor;
        this.targetUnderglowStrength = env.underglowStrength;
        this.targetUnderglowColor = env.underglowColor;
        this.targetUnderwaterCausticsColor = env.waterCausticsColor;
        this.targetUnderwaterCausticsStrength = env.waterCausticsStrength;
        for (int i = 0; i < 2; ++i) {
            float diff = this.startSunAngles[i] - this.targetSunAngles[i];
            if (!(Math.abs(diff) > (float)Math.PI)) continue;
            int n = i;
            this.targetSunAngles[n] = this.targetSunAngles[n] + (float)Math.PI * 2 * Math.signum(diff);
        }
    }

    public void updateTargetSkyColor() {
        Environment env = this.getCurrentEnvironment();
        if (env.fogColor == null || env.allowSkyOverride && this.config.overrideSky()) {
            DefaultSkyColor sky = this.config.defaultSkyColor();
            this.targetFogColor = sky.getRgb(this.client);
            if (sky == DefaultSkyColor.OSRS) {
                sky = DefaultSkyColor.DEFAULT;
            }
            this.targetWaterColor = sky.getRgb(this.client);
        } else {
            this.targetWaterColor = env.fogColor;
            this.targetFogColor = env.fogColor;
        }
        if (env.waterColor != null) {
            this.targetWaterColor = env.waterColor;
        } else if (this.config.decoupleSkyAndWaterColor()) {
            this.targetWaterColor = DefaultSkyColor.DEFAULT.getRgb(this.client);
        }
    }

    public void loadSceneEnvironments(SceneContext sceneContext) {
        log.debug("Adding environments for scene with regions: {}", sceneContext.regionIds);
        AABB[] regions = (AABB[])sceneContext.regionIds.stream().map(AABB::new).toArray(AABB[]::new);
        sceneContext.environments.clear();
        block0: for (Environment environment : this.environments) {
            for (AABB region : regions) {
                for (AABB aabb : environment.area.getAabbs()) {
                    if (!region.intersects(aabb)) continue;
                    log.debug("Added environment: {}", (Object)environment);
                    sceneContext.environments.add(environment);
                    continue block0;
                }
            }
        }
        sceneContext.environments.add(Environment.DEFAULT);
    }

    void updateLightning() {
        if (this.lightningBrightness > 0.0f) {
            float brightnessChange = this.plugin.deltaTime * 80.0f;
            this.lightningBrightness = Math.max(this.lightningBrightness - brightnessChange, 0.0f);
        }
        if (this.nextLightningTime == -1.0) {
            this.generateNextLightningTime();
            return;
        }
        if ((double)this.plugin.elapsedTime > this.nextLightningTime) {
            this.lightningBrightness = 7.0f;
            this.generateNextLightningTime();
        }
        if (this.lightningEnabled && this.config.flashingEffects()) {
            float t = HDUtils.clamp(this.lightningBrightness, 0.0f, 1.0f);
            this.currentFogColor = HDUtils.lerp(this.currentFogColor, LIGHTNING_COLOR, t);
            this.currentWaterColor = HDUtils.lerp(this.currentWaterColor, LIGHTNING_COLOR, t);
        } else {
            this.lightningBrightness = 0.0f;
        }
    }

    void generateNextLightningTime() {
        this.nextLightningTime = this.plugin.elapsedTime;
        this.nextLightningTime = Math.random() <= 0.5 ? (this.nextLightningTime += (double)HDUtils.lerp(0.04f, 0.15f, HDUtils.rand.nextFloat())) : (this.nextLightningTime += (double)HDUtils.lerp(5.5f, 17.0f, HDUtils.rand.nextFloat()));
    }

    private Environment getCurrentEnvironment() {
        if (this.currentEnvironment == Environment.OVERWORLD) {
            return this.getOverworldEnvironment();
        }
        return this.currentEnvironment;
    }

    private Environment getOverworldEnvironment() {
        switch (this.plugin.configSeasonalTheme) {
            case AUTUMN: {
                return Environment.AUTUMN;
            }
            case WINTER: {
                return Environment.WINTER;
            }
        }
        return Environment.OVERWORLD;
    }

    public boolean isUnderwater() {
        return this.currentEnvironment.isUnderwater;
    }

    public float getLightningBrightness() {
        return this.lightningBrightness;
    }
}

