/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.overlays;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.apache.commons.lang3.tuple.Pair;
import rs117.hd.HdPlugin;
import rs117.hd.data.materials.Material;
import rs117.hd.data.materials.Underlay;
import rs117.hd.scene.SceneContext;
import rs117.hd.utils.HDUtils;
import rs117.hd.utils.ModelHash;

@Singleton
public class TileInfoOverlay
extends Overlay {
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private HdPlugin plugin;
    private Point mousePos;
    private boolean ctrlPressed;

    public TileInfoOverlay() {
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    public void setActive(boolean activate) {
        if (activate) {
            this.overlayManager.add((Overlay)this);
        } else {
            this.overlayManager.remove((Overlay)this);
        }
    }

    public Dimension render(Graphics2D g) {
        boolean shouldDraw;
        Tile tile;
        int y;
        int x;
        int isBridge;
        int plane;
        int z;
        this.ctrlPressed = this.client.isKeyPressed(82);
        this.mousePos = this.client.getMouseCanvasPosition();
        if (this.mousePos != null && this.mousePos.getX() == -1 && this.mousePos.getY() == -1) {
            return null;
        }
        g.setFont(FontManager.getRunescapeFont());
        g.setStroke(new BasicStroke(1.0f, 0, 1));
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        for (z = plane = this.ctrlPressed ? 3 : this.client.getPlane(); z >= 0; --z) {
            for (isBridge = 1; isBridge >= 0; --isBridge) {
                for (x = 0; x < 104; ++x) {
                    for (y = 0; y < 104; ++y) {
                        tile = tiles[z][x][y];
                        boolean bl = shouldDraw = tile != null && (isBridge == 0 || tile.getBridge() != null);
                        if (!shouldDraw || !this.drawTileInfo(g, scene, tile)) continue;
                        return null;
                    }
                }
            }
        }
        this.ctrlPressed = true;
        for (z = plane; z >= 0; --z) {
            for (isBridge = 1; isBridge >= 0; --isBridge) {
                for (x = 0; x < 104; ++x) {
                    for (y = 0; y < 104; ++y) {
                        tile = tiles[z][x][y];
                        boolean bl = shouldDraw = tile != null && (isBridge == 0 || tile.getBridge() != null);
                        if (!shouldDraw || !this.drawTileInfo(g, scene, tile)) continue;
                        return null;
                    }
                }
            }
        }
        return null;
    }

    private boolean drawTileInfo(Graphics2D g, Scene scene, Tile tile) {
        boolean infoDrawn = false;
        if (tile != null) {
            Polygon poly;
            Rectangle rect = null;
            Tile bridge = tile.getBridge();
            if (bridge != null && (poly = TileInfoOverlay.getCanvasTilePoly(this.client, scene, bridge)) != null && poly.contains(this.mousePos.getX(), this.mousePos.getY()) && (rect = this.drawTileInfo(g, bridge, poly, null)) != null) {
                infoDrawn = true;
            }
            if ((poly = TileInfoOverlay.getCanvasTilePoly(this.client, scene, tile)) != null && poly.contains(this.mousePos.getX(), this.mousePos.getY()) && (rect = this.drawTileInfo(g, tile, poly, rect)) != null) {
                infoDrawn = true;
            }
        }
        return infoDrawn;
    }

    /*
     * WARNING - void declaration
     */
    private Rectangle drawTileInfo(Graphics2D g, Tile tile, Polygon poly, Rectangle dodgeRect) {
        GameObject[] gameObjects;
        WallObject wallObject;
        SceneTilePaint paint = tile.getSceneTilePaint();
        SceneTileModel model = tile.getSceneTileModel();
        if (!this.ctrlPressed && (paint == null || paint.getNeColor() == 12345678 && tile.getBridge() == null) && model == null) {
            return null;
        }
        Rectangle2D polyBounds = poly.getBounds2D();
        Point tileCenter = new Point((int)polyBounds.getCenterX(), (int)polyBounds.getCenterY());
        ArrayList<Object> lines = new ArrayList<Object>();
        if (tile.getBridge() != null) {
            lines.add("Bridge");
        }
        int tileX = tile.getSceneLocation().getX();
        int tileY = tile.getSceneLocation().getY();
        int plane = tile.getRenderLevel();
        lines.add("Scene point: " + tileX + ", " + tileY + ", " + plane);
        int[] worldPoint = null;
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext != null) {
            worldPoint = sceneContext.sceneToWorld(tileX, tileY, plane);
        }
        if (worldPoint != null) {
            lines.add("World point: " + Arrays.toString(worldPoint));
            lines.add("Region ID: " + HDUtils.worldToRegionID(worldPoint));
        }
        Scene scene = this.client.getScene();
        short overlayId = scene.getOverlayIds()[plane][tileX][tileY];
        rs117.hd.data.materials.Overlay overlay = rs117.hd.data.materials.Overlay.getOverlayBeforeReplacements(scene, tile);
        rs117.hd.data.materials.Overlay replacementOverlay = overlay.resolveReplacements(scene, tile, this.plugin);
        if (replacementOverlay != overlay) {
            lines.add(String.format("Overlay: %s -> %s (%d)", overlay.name(), replacementOverlay.name(), overlayId));
        } else {
            lines.add(String.format("Overlay: %s (%d)", overlay.name(), overlayId));
        }
        short underlayId = scene.getUnderlayIds()[plane][tileX][tileY];
        Underlay underlay = Underlay.getUnderlayBeforeReplacements(scene, tile);
        Underlay replacementUnderlay = underlay.resolveReplacements(scene, tile, this.plugin);
        if (replacementUnderlay != underlay) {
            lines.add(String.format("Underlay: %s -> %s (%d)", underlay.name(), replacementUnderlay.name(), underlayId));
        } else {
            lines.add(String.format("Underlay: %s (%d)", underlay.name(), underlayId));
        }
        Color polyColor = Color.LIGHT_GRAY;
        if (paint != null) {
            polyColor = Color.CYAN;
            lines.add("Tile type: Paint");
            Material material = Material.fromVanillaTexture(paint.getTexture());
            lines.add(String.format("Material: %s (%d)", material.name(), paint.getTexture()));
            lines.add("JagexHSL: packed (h, s, l)");
            lines.add("NW: " + TileInfoOverlay.hslString(paint.getNwColor()));
            lines.add("NE: " + TileInfoOverlay.hslString(paint.getNeColor()));
            lines.add("SE: " + TileInfoOverlay.hslString(paint.getSeColor()));
            lines.add("SW: " + TileInfoOverlay.hslString(paint.getSwColor()));
        } else if (model != null) {
            polyColor = Color.ORANGE;
            lines.add("Tile type: Model");
            lines.add(String.format("Face count: %d", model.getFaceX().length));
            HashSet<String> uniqueMaterials = new HashSet<String>();
            int numChars = 0;
            if (model.getTriangleTextureId() != null) {
                void var27_32;
                int[] nArray = model.getTriangleTextureId();
                int n = nArray.length;
                boolean bl = false;
                while (var27_32 < n) {
                    int texture = nArray[var27_32];
                    String material = String.format("%s (%d)", Material.fromVanillaTexture(texture).name(), texture);
                    boolean unique = uniqueMaterials.add(material);
                    if (unique) {
                        numChars += material.length();
                    }
                    ++var27_32;
                }
            }
            ArrayList materials = new ArrayList(uniqueMaterials);
            Collections.sort(materials);
            if (materials.size() <= 1 || numChars < 26) {
                StringBuilder sb = new StringBuilder("Materials: { ");
                if (materials.size() == 0) {
                    sb.append("null");
                } else {
                    String string = "";
                    for (String m : materials) {
                        void var27_34;
                        sb.append((String)var27_34).append(m);
                        String string2 = ", ";
                    }
                }
                sb.append(" }");
                lines.add(sb.toString());
            } else {
                Iterator iter = materials.iterator();
                lines.add("Materials: { " + (String)iter.next() + ",");
                while (iter.hasNext()) {
                    lines.add("\t  " + (String)iter.next() + (iter.hasNext() ? "," : " }"));
                }
            }
            lines.add("JagexHSL: packed (h, s, l)");
            int[] CA = model.getTriangleColorA();
            int[] nArray = model.getTriangleColorB();
            int[] CC = model.getTriangleColorC();
            for (int face = 0; face < model.getFaceX().length; ++face) {
                int a = CA[face];
                int b = nArray[face];
                int c = CC[face];
                if (a == b && b == c) {
                    lines.add(face + ": " + TileInfoOverlay.hslString(a));
                    continue;
                }
                lines.add(face + ": [ " + TileInfoOverlay.hslString(a) + ", " + TileInfoOverlay.hslString(b) + ", " + TileInfoOverlay.hslString(c) + " ]");
            }
        }
        GroundObject groundObject = tile.getGroundObject();
        if (groundObject != null) {
            lines.add(String.format("Ground Object: ID=%d x=%d y=%d ori=%d", groundObject.getId(), ModelHash.getSceneX(groundObject.getHash()), ModelHash.getSceneY(groundObject.getHash()), HDUtils.getBakedOrientation(groundObject.getConfig())));
        }
        if ((wallObject = tile.getWallObject()) != null) {
            lines.add(String.format("Wall Object: ID=%d x=%d y=%d bakedOri=%d oriA=%d oriB=%d", wallObject.getId(), ModelHash.getSceneX(wallObject.getHash()), ModelHash.getSceneY(wallObject.getHash()), HDUtils.getBakedOrientation(wallObject.getConfig()), wallObject.getOrientationA(), wallObject.getOrientationB()));
        }
        if ((gameObjects = tile.getGameObjects()).length > 0) {
            int counter = 0;
            for (GameObject gameObject : gameObjects) {
                if (gameObject == null) continue;
                ++counter;
                int id = gameObject.getId();
                String type = "Unknown";
                Object extra = "";
                switch (ModelHash.getType(gameObject.getHash())) {
                    case 0: {
                        type = "Player";
                        break;
                    }
                    case 1: {
                        type = "NPC";
                        id = this.client.getCachedNPCs()[id].getId();
                        break;
                    }
                    case 2: {
                        ObjectComposition impostor;
                        type = "Object";
                        ObjectComposition def = this.client.getObjectDefinition(id);
                        if (def.getImpostorIds() == null || (impostor = def.getImpostor()) == null) break;
                        extra = (String)extra + String.format("\u2937 : Impostor ID=%d name=%s", impostor.getId(), impostor.getName());
                        break;
                    }
                    case 3: {
                        type = "Item";
                    }
                }
                int height = -1;
                Renderable renderable = gameObject.getRenderable();
                if (renderable != null) {
                    height = renderable.getModelHeight();
                }
                lines.add(String.format("%s: ID=%d ori=%d height=%d", type, id, gameObject.getModelOrientation(), height));
                if (((String)extra).isEmpty()) continue;
                ++counter;
                lines.add(extra);
            }
            if (counter > 0) {
                lines.add(lines.size() - counter, "Game objects: ");
            }
        }
        int padding = 4;
        int n = padding * 2;
        FontMetrics fm = g.getFontMetrics();
        int lineHeight = fm.getHeight();
        int totalHeight = lineHeight * lines.size() + padding * 3;
        int space = fm.charWidth(':');
        int indent = fm.stringWidth("{ ");
        int leftWidth = 0;
        int rightWidth = 0;
        Function<String, Pair> splitter = line -> {
            int i = line.indexOf(":");
            String left = line;
            String right = "";
            if (left.startsWith("\t")) {
                right = left;
                left = "";
            } else if (i != -1) {
                left = line.substring(0, i);
                right = line.substring(i + 1);
            }
            return Pair.of((Object)left, (Object)right);
        };
        for (String string : lines) {
            Pair pair = splitter.apply(string);
            if (((String)pair.getRight()).length() == 0) {
                int halfWidth = fm.stringWidth((String)pair.getLeft()) / 2;
                leftWidth = Math.max(leftWidth, halfWidth);
                rightWidth = Math.max(rightWidth, halfWidth);
                continue;
            }
            leftWidth = Math.max(leftWidth, fm.stringWidth((String)pair.getLeft()));
            rightWidth = Math.max(rightWidth, fm.stringWidth((String)pair.getRight()));
        }
        int totalWidth = leftWidth + rightWidth + space + n * 2;
        Rectangle rectangle = new Rectangle(tileCenter.getX() - totalWidth / 2, tileCenter.getY() - totalHeight - padding, totalWidth, totalHeight);
        if (dodgeRect != null && dodgeRect.intersects(rectangle)) {
            rectangle.y = dodgeRect.y - rectangle.height - padding;
        }
        if (tile.getBridge() != null) {
            polyColor = Color.MAGENTA;
        }
        g.setColor(polyColor);
        g.drawPolygon(poly);
        g.setColor(new Color(0, 0, 0, 150));
        g.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int offsetY = 0;
        for (String string : lines) {
            Pair pair = splitter.apply(string);
            Point p = ((String)pair.getRight()).length() == 0 ? new Point(rectangle.x + rectangle.width / 2 - fm.stringWidth((String)pair.getLeft()) / 2, rectangle.y + padding + offsetY) : new Point(rectangle.x + n + leftWidth - fm.stringWidth((String)pair.getLeft()) + (((String)pair.getRight()).startsWith("\t") ? indent : 0), rectangle.y + padding + (offsetY += lineHeight));
            OverlayUtil.renderTextLocation((Graphics2D)g, (Point)p, (String)string, (Color)Color.WHITE);
        }
        return rectangle;
    }

    public static Polygon getCanvasTilePoly(@Nonnull Client client, Scene scene, Tile tile) {
        LocalPoint lp = tile.getLocalLocation();
        int plane = tile.getRenderLevel();
        if (!lp.isInScene()) {
            return null;
        }
        int swX = lp.getX() - 64;
        int swY = lp.getY() - 64;
        int neX = lp.getX() + 64;
        int neY = lp.getY() + 64;
        int swHeight = TileInfoOverlay.getHeight(scene, swX, swY, plane);
        int nwHeight = TileInfoOverlay.getHeight(scene, neX, swY, plane);
        int neHeight = TileInfoOverlay.getHeight(scene, neX, neY, plane);
        int seHeight = TileInfoOverlay.getHeight(scene, swX, neY, plane);
        Point p1 = TileInfoOverlay.localToCanvas(client, swX, swY, swHeight);
        Point p2 = TileInfoOverlay.localToCanvas(client, neX, swY, nwHeight);
        Point p3 = TileInfoOverlay.localToCanvas(client, neX, neY, neHeight);
        Point p4 = TileInfoOverlay.localToCanvas(client, swX, neY, seHeight);
        if (p1 == null || p2 == null || p3 == null || p4 == null) {
            return null;
        }
        Polygon poly = new Polygon();
        poly.addPoint(p1.getX(), p1.getY());
        poly.addPoint(p2.getX(), p2.getY());
        poly.addPoint(p3.getX(), p3.getY());
        poly.addPoint(p4.getX(), p4.getY());
        return poly;
    }

    private static int getHeight(Scene scene, int localX, int localY, int plane) {
        int sceneX = localX >> 7;
        int sceneY = localY >> 7;
        if (sceneX < 0 || sceneY < 0 || sceneX >= 104 || sceneY >= 104) {
            return 0;
        }
        int[][][] tileHeights = scene.getTileHeights();
        int x = localX & 0x7F;
        int y = localY & 0x7F;
        int var8 = x * tileHeights[plane][sceneX + 1][sceneY] + (128 - x) * tileHeights[plane][sceneX][sceneY] >> 7;
        int var9 = tileHeights[plane][sceneX][sceneY + 1] * (128 - x) + x * tileHeights[plane][sceneX + 1][sceneY + 1] >> 7;
        return (128 - y) * var8 + y * var9 >> 7;
    }

    private static Point localToCanvas(@Nonnull Client client, int x, int y, int z) {
        x -= client.getCameraX();
        y -= client.getCameraY();
        z -= client.getCameraZ();
        int cameraPitch = client.getCameraPitch();
        int cameraYaw = client.getCameraYaw();
        int pitchSin = Perspective.SINE[cameraPitch];
        int pitchCos = Perspective.COSINE[cameraPitch];
        int yawSin = Perspective.SINE[cameraYaw];
        int yawCos = Perspective.COSINE[cameraYaw];
        int x1 = x * yawCos + y * yawSin >> 16;
        int y1 = y * yawCos - x * yawSin >> 16;
        int y2 = z * pitchCos - y1 * pitchSin >> 16;
        int z1 = y1 * pitchCos + z * pitchSin >> 16;
        if (z1 >= 50) {
            int scale = client.getScale();
            int pointX = client.getViewportWidth() / 2 + x1 * scale / z1;
            int pointY = client.getViewportHeight() / 2 + y2 * scale / z1;
            return new Point(pointX + client.getViewportXOffset(), pointY + client.getViewportYOffset());
        }
        return null;
    }

    private static String hslString(int color) {
        if (color == 12345678) {
            return "HIDDEN";
        }
        return color + " (" + (color >> 10 & 0x3F) + ", " + (color >> 7 & 7) + ", " + (color & 0x7F) + ")";
    }
}

