/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.overlays;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayDeque;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import rs117.hd.HdPlugin;
import rs117.hd.overlays.FrameTimer;
import rs117.hd.overlays.FrameTimings;
import rs117.hd.overlays.Timer;

@Singleton
public class FrameTimingsOverlay
extends OverlayPanel
implements FrameTimer.Listener {
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private FrameTimer frameTimer;
    private final ArrayDeque<FrameTimings> frames = new ArrayDeque();

    @Inject
    public FrameTimingsOverlay(HdPlugin plugin) {
        super((Plugin)plugin);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.panelComponent.setPreferredSize(new Dimension(215, 200));
    }

    public void setActive(boolean activate) {
        if (activate) {
            this.frameTimer.addTimingsListener(this);
            this.overlayManager.add((Overlay)this);
        } else {
            this.frameTimer.removeTimingsListener(this);
            this.overlayManager.remove((Overlay)this);
            this.frames.clear();
        }
    }

    @Override
    public void onFrameCompletion(FrameTimings timings) {
        long now = System.nanoTime();
        while (this.frames.size() > 0 && !((double)(now - this.frames.peekFirst().frameTimestamp) < 3.0E9)) {
            this.frames.removeFirst();
        }
        this.frames.addLast(timings);
    }

    public Dimension render(Graphics2D g) {
        long[] timings = this.getAverageTimings();
        if (timings.length != Timer.values().length) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Waiting for data...").build());
        } else {
            long cpuTime = timings[Timer.DRAW_SCENE.ordinal()];
            this.addTiming("CPU", cpuTime, true);
            for (Timer t : Timer.values()) {
                if (t.isGpuTimer) continue;
                this.addTiming(t, timings);
            }
            long gpuTime = timings[Timer.UPLOAD_GEOMETRY.ordinal()] + timings[Timer.UPLOAD_UI.ordinal()] + timings[Timer.COMPUTE.ordinal()] + timings[Timer.RENDER_SHADOWS.ordinal()] + timings[Timer.RENDER_SCENE.ordinal()] + timings[Timer.RENDER_UI.ordinal()];
            this.addTiming("GPU", gpuTime, true);
            for (Timer t : Timer.values()) {
                if (!t.isGpuTimer) continue;
                this.addTiming(t, timings);
            }
            this.panelComponent.getChildren().add(LineComponent.builder().leftFont(FontManager.getRunescapeBoldFont()).left("Max Frame Rate:").rightFont(FontManager.getRunescapeBoldFont()).right(String.format("%.1f FPS", 1.0 / ((double)Math.max(cpuTime, gpuTime) / 1.0E9))).build());
        }
        return super.render(g);
    }

    private long[] getAverageTimings() {
        if (this.frames.size() == 0) {
            return new long[0];
        }
        long[] timers = new long[Timer.values().length];
        for (FrameTimings frame : this.frames) {
            for (int i = 0; i < frame.timers.length; ++i) {
                int n = i;
                timers[n] = timers[n] + frame.timers[i];
            }
        }
        int i = 0;
        while (i < timers.length) {
            int n = i++;
            timers[n] = timers[n] / (long)this.frames.size();
        }
        return timers;
    }

    private void addTiming(Timer timer, long[] timings) {
        this.addTiming(timer.name, timings[timer.ordinal()], false);
    }

    private void addTiming(String name, long nanos, boolean bold) {
        if (nanos == 0L) {
            return;
        }
        String formatted = (double)nanos < 3000.0 && (double)nanos > -100000.0 ? "~0 ms" : String.format("%.3f ms", (double)nanos / 1000000.0);
        Font font = bold ? FontManager.getRunescapeBoldFont() : FontManager.getRunescapeFont();
        this.panelComponent.getChildren().add(LineComponent.builder().left(name + ":").leftFont(font).right(formatted).rightFont(font).build());
    }
}

