/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.overlays;

import java.util.ArrayDeque;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.callback.ClientThread;
import org.lwjgl.opengl.GL33C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.HdPlugin;
import rs117.hd.overlays.FrameTimings;
import rs117.hd.overlays.Timer;

@Singleton
public class FrameTimer {
    private static final Logger log = LoggerFactory.getLogger(FrameTimer.class);
    @Inject
    private ClientThread clientThread;
    @Inject
    private HdPlugin plugin;
    private final int numTimers = Timer.values().length;
    private final int numGpuTimers = (int)Arrays.stream(Timer.values()).filter(t -> t.isGpuTimer).count();
    private final boolean[] activeTimers = new boolean[this.numTimers];
    private final long[] timings = new long[this.numTimers];
    private final int[] gpuQueries = new int[this.numTimers * 2];
    private final ArrayDeque<Listener> listeners = new ArrayDeque();
    private boolean isInactive = true;
    private long cumulativeError = 0L;

    private void initialize() {
        this.clientThread.invokeLater(() -> {
            int[] queryNames = new int[this.numGpuTimers * 2];
            GL33C.glGenQueries((int[])queryNames);
            int queryIndex = 0;
            for (Timer timer : Timer.values()) {
                if (!timer.isGpuTimer) continue;
                for (int j = 0; j < 2; ++j) {
                    this.gpuQueries[timer.ordinal() * 2 + j] = queryNames[queryIndex++];
                }
            }
            this.isInactive = false;
            this.plugin.enableDetailedTimers = true;
        });
    }

    private void destroy() {
        this.clientThread.invokeLater(() -> {
            this.isInactive = true;
            this.plugin.enableDetailedTimers = false;
            GL33C.glDeleteQueries((int[])this.gpuQueries);
            Arrays.fill(this.gpuQueries, 0);
            this.reset();
        });
    }

    public void addTimingsListener(Listener listener) {
        if (this.listeners.size() == 0) {
            this.initialize();
        }
        this.listeners.add(listener);
    }

    public void removeTimingsListener(Listener listener) {
        this.listeners.remove(listener);
        if (this.listeners.size() == 0) {
            this.destroy();
        }
    }

    public void removeAllListeners() {
        this.listeners.clear();
        this.destroy();
    }

    private void reset() {
        Arrays.fill(this.timings, 0L);
        Arrays.fill(this.activeTimers, false);
    }

    public void begin(Timer timer) {
        if (this.isInactive) {
            return;
        }
        if (timer.isGpuTimer) {
            if (this.activeTimers[timer.ordinal()]) {
                throw new UnsupportedOperationException("Cumulative GPU timing isn't supported");
            }
            GL33C.glQueryCounter((int)this.gpuQueries[timer.ordinal() * 2], (int)36392);
        } else if (!this.activeTimers[timer.ordinal()]) {
            int n = timer.ordinal();
            this.timings[n] = this.timings[n] - (System.nanoTime() - this.cumulativeError);
        }
        this.activeTimers[timer.ordinal()] = true;
    }

    public void end(Timer timer) {
        if (this.isInactive || !this.activeTimers[timer.ordinal()]) {
            return;
        }
        if (timer.isGpuTimer) {
            GL33C.glQueryCounter((int)this.gpuQueries[timer.ordinal() * 2 + 1], (int)36392);
        } else {
            this.cumulativeError += 17L;
            int n = timer.ordinal();
            this.timings[n] = this.timings[n] + (System.nanoTime() - this.cumulativeError);
            this.activeTimers[timer.ordinal()] = false;
        }
    }

    public void endFrameAndReset() {
        if (this.isInactive) {
            return;
        }
        long frameEnd = System.nanoTime();
        int[] available = new int[]{0};
        for (Timer timer : Timer.values()) {
            int i = timer.ordinal();
            if (timer.isGpuTimer) {
                if (!this.activeTimers[i]) continue;
                for (int j = 0; j < 2; ++j) {
                    while (available[0] == 0) {
                        GL33C.glGetQueryObjectiv((int)this.gpuQueries[i * 2 + j], (int)34919, (int[])available);
                    }
                    int n = i;
                    this.timings[n] = this.timings[n] + ((long)j * 2L - 1L) * GL33C.glGetQueryObjectui64((int)this.gpuQueries[i * 2 + j], (int)34918);
                }
                continue;
            }
            if (!this.activeTimers[i]) continue;
            log.warn("Timer {} was never ended", (Object)timer);
            int n = i;
            this.timings[n] = this.timings[n] + frameEnd;
        }
        FrameTimings frameTimings = new FrameTimings(frameEnd, this.timings);
        for (Listener listener : this.listeners) {
            listener.onFrameCompletion(frameTimings);
        }
        this.reset();
    }

    @FunctionalInterface
    public static interface Listener {
        public void onFrameCompletion(FrameTimings var1);
    }
}

