/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.opengl.shader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.utils.ResourcePath;

public class Template {
    private static final Logger log = LoggerFactory.getLogger(Template.class);
    private final List<IncludeLoader> loaders = new ArrayList<IncludeLoader>();
    IncludeType includeType = IncludeType.UNKNOWN;
    final Stack<Integer> includeStack = new Stack();
    final ArrayList<String> includeList = new ArrayList();

    public Template copy() {
        Template clone = new Template();
        clone.loaders.addAll(this.loaders);
        return clone;
    }

    public String process(String str) throws IOException {
        StringBuilder sb = new StringBuilder();
        int lineCount = 0;
        for (String line : str.split("\r?\n")) {
            int currentIndex;
            ++lineCount;
            String trimmed = line.trim();
            if (trimmed.startsWith("#include ")) {
                currentIndex = this.includeStack.peek();
                String currentFile = this.includeList.get(currentIndex);
                String includeFile = trimmed.substring(9);
                int includeIndex = this.includeList.size();
                this.includeList.add(includeFile);
                this.includeStack.push(includeIndex);
                String includeContents = this.loadInternal(includeFile);
                this.includeStack.pop();
                switch (this.includeType) {
                    case GLSL: {
                        if (includeContents.trim().startsWith("#version ")) {
                            sb.append(includeContents);
                            break;
                        }
                        sb.append("#line 1 ").append(includeIndex).append("\n").append(includeContents).append("#line ").append(lineCount + 1).append(" ").append(currentIndex).append("\n");
                        break;
                    }
                    case C: {
                        sb.append("#line 1 \"").append(includeFile).append("\"\n").append(includeContents).append("#line ").append(lineCount + 1).append(" \"").append(currentFile).append("\"\n");
                        break;
                    }
                    default: {
                        sb.append(includeContents);
                        break;
                    }
                }
                continue;
            }
            if (trimmed.startsWith("#pragma once")) {
                currentIndex = this.includeList.size() - 1;
                String currentInclude = this.includeList.get(currentIndex);
                if (this.includeList.indexOf(currentInclude) == currentIndex) continue;
                sb.append("// Already included\n");
                break;
            }
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    private String loadInternal(String path) throws IOException {
        for (IncludeLoader loader : this.loaders) {
            String value = loader.load(path);
            if (value == null) continue;
            return this.process(value);
        }
        return "";
    }

    public String load(String filename) throws IOException {
        this.includeList.clear();
        this.includeList.add(filename);
        this.includeStack.add(0);
        switch (ResourcePath.path(filename).getExtension().toLowerCase()) {
            case "glsl": {
                this.includeType = IncludeType.GLSL;
                break;
            }
            case "c": 
            case "h": 
            case "cl": {
                this.includeType = IncludeType.C;
                break;
            }
            default: {
                this.includeType = IncludeType.UNKNOWN;
            }
        }
        return this.loadInternal(filename);
    }

    public Template addIncludeLoader(IncludeLoader resolver) {
        this.loaders.add(resolver);
        return this;
    }

    public Template addIncludePath(Class<?> clazz) {
        return this.addIncludePath(ResourcePath.path(clazz, new String[0]));
    }

    public Template addIncludePath(ResourcePath includePath) {
        return this.addIncludeLoader(path -> {
            ResourcePath resolved = includePath.resolve(path);
            if (resolved.exists()) {
                return resolved.loadString();
            }
            return null;
        });
    }

    public Template addInclude(String identifier, String value) {
        return this.addIncludeLoader(key -> key.equals(identifier) ? value : null);
    }

    public Template define(String identifier, String value) {
        return this.addIncludeLoader(key -> key.equals(identifier) ? String.format("#define %s %s", identifier, value) : null);
    }

    public Template define(String identifier, boolean value) {
        return this.addIncludeLoader(key -> key.equals(identifier) ? String.format("#define %s %d", identifier, value ? 1 : 0) : null);
    }

    public Template define(String identifier, int value) {
        return this.addIncludeLoader(key -> key.equals(identifier) ? String.format("#define %s %d", identifier, value) : null);
    }

    public Template define(String identifier, double value) {
        return this.addIncludeLoader(key -> key.equals(identifier) ? String.format("#define %s %f", identifier, value) : null);
    }

    public Template define(String identifier, Enum<?> enumValue) {
        return this.addIncludeLoader(key -> key.equals(identifier) ? String.format("#define %s %d", identifier, enumValue.ordinal()) : null);
    }

    public Template define(String identifier, Supplier<String> supplier) {
        return this.addIncludeLoader(key -> key.equals(identifier) ? (String)supplier.get() : null);
    }

    static enum IncludeType {
        GLSL,
        C,
        UNKNOWN;

    }

    @FunctionalInterface
    public static interface IncludeLoader {
        public String load(String var1) throws IOException;
    }
}

